/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.sbml.SbmlDiagramType_L2;
import biouml.plugins.sbml.SbmlModelReader;
import biouml.standard.type.Base;
import biouml.standard.type.Compartment;
import biouml.standard.type.KineticLaw;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import biouml.standard.type.Unit;
import com.developmentontheedge.beans.DynamicProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.math.model.AstFunctionDeclaration;
import ru.biosoft.math.model.Parser;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.model.PredefinedFunction;
import ru.biosoft.math.model.UndeclaredFunction;
import ru.biosoft.math.model.Utils;
import ru.biosoft.math.model.VariableResolver;
import ru.biosoft.math.xml.MathMLParser;
import ru.biosoft.util.DPSUtils;
import ru.biosoft.util.XmlUtil;

public class SbmlModelReader_21
extends SbmlModelReader {
    protected MathMLParser mathMLParser = new MathMLParser();
    protected Map<String, MetaIdInfo> metaIds;

    public SbmlModelReader_21() {
        this.log = Logger.getLogger(SbmlModelReader_21.class.getName());
        this.metaIds = new HashMap<String, MetaIdInfo>();
    }

    protected Diagram readDiagram(Element model, DataCollection origin) throws Exception {
        this.replacements = this.createReplacements(model);
        this.mathMLParser.setReplacements(this.replacements);
        Diagram result = super.readDiagram(model, origin);
        result.getAttributes().add(DPSUtils.createTransient((String)"metaIds", Map.class, this.metaIds));
        return result;
    }

    @Override
    protected DiagramType getDiagramType(Element modelElement) {
        return new SbmlDiagramType_L2();
    }

    @Override
    public String getId(Element element) {
        String wrongLetters = ": .,;|()[]{}+-*/%^!~&|$'\"<>";
        char[] data = element.getAttribute("id").toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (wrongLetters.indexOf(data[i]) < 0) continue;
            data[i] = 95;
        }
        return new String(data);
    }

    @Override
    public String getTitle(Element element) {
        return element.getAttribute("name");
    }

    @Override
    protected boolean isValid(String elementName, Object element, String name) {
        if (elementName.equals("listOfCompartments")) {
            return this.validateList(element, "compartment", name);
        }
        if (elementName.equals("listOfSpecies")) {
            return this.validateList(element, "species", name);
        }
        if (elementName.equals("listOfReactions")) {
            return this.validateList(element, "reaction", name);
        }
        if (elementName.equals("listOfParameters")) {
            return this.validateList(element, "parameter", name);
        }
        if (elementName.equals("listOfReactants")) {
            return this.validateList(element, "speciesReference", name);
        }
        if (elementName.equals("listOfProducts")) {
            return this.validateList(element, "speciesReference", name);
        }
        if (elementName.equals("listOfModifiers")) {
            return this.validateList(element, "modifierSpeciesReference", name);
        }
        if (elementName.equals("listOfUnitDefinitions")) {
            return this.validateList(element, "unitDefinition", name);
        }
        if (elementName.equals("listOfRules")) {
            return element instanceof Element;
        }
        if (elementName.equals("initialAmount")) {
            return element instanceof Element && ((Element)element).hasAttribute("initialAmount");
        }
        if (elementName.equals("value")) {
            return element instanceof Element && ((Element)element).hasAttribute("value");
        }
        return true;
    }

    @Override
    public void readModelAttributes(Element element, Diagram diagram) {
        try {
            if (element.hasAttribute("id")) {
                diagram.getAttributes().add(DPSUtils.createTransient((String)"id", String.class, (Object)element.getAttribute("id")));
            }
            if (element.hasAttribute("metaid")) {
                diagram.getAttributes().add(DPSUtils.createTransient((String)"metaid", String.class, (Object)element.getAttribute("metaid")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public biouml.model.Compartment readCompartment(Element element, String compartmentId, String parentId, String compartmentName) throws Exception {
        biouml.model.Compartment compartment = super.readCompartment(element, compartmentId, parentId, compartmentName);
        if (compartment == null) {
            return null;
        }
        int dimension = this.readInt(element, "spatialDimensions", 3, "ERROR_INVALID_SPATIAL_DIMENSION", compartment.getName());
        ((Compartment)compartment.getKernel()).setSpatialDimension(dimension);
        ((VariableRole)compartment.getRole(VariableRole.class)).setConstant(!"false".equals(element.getAttribute("constant")));
        return compartment;
    }

    @Override
    public Node readSpecie(Element element, String speciesId, String speciesName) throws Exception {
        Node species = super.readSpecie(element, speciesId, speciesName);
        if (species == null) {
            return null;
        }
        VariableRole var = (VariableRole)species.getRole(VariableRole.class);
        if (element.hasAttribute("hasOnlySubstanceUnits")) {
            boolean hasOnlySubstanceUnits = Boolean.parseBoolean(element.getAttribute("hasOnlySubstanceUnits"));
            var.setQuantityType(hasOnlySubstanceUnits ? 0 : 1);
        }
        double initialValue = 0.0;
        int initialType = var.getQuantityType();
        if (element.hasAttribute("initialAmount") && element.hasAttribute("initialConcentration")) {
            this.error("ERROR_AMOUNT_AND_CONCENTRATION", new String[]{this.modelName, speciesId});
        } else if (element.hasAttribute("initialAmount")) {
            initialValue = this.readDouble(element, "initialAmount", 0.0, "ERROR_SPECIE_AMOUNT", speciesId);
            initialType = 0;
        } else if (element.hasAttribute("initialConcentration")) {
            initialValue = this.readDouble(element, "initialConcentration", 0.0, "ERROR_SPECIE_CONCENTRATION", speciesId);
            initialType = 1;
        }
        var.setInitialValue(initialValue);
        var.setInitialQuantityType(initialType);
        var.setOutputQuantityType(initialType);
        var.setConstant("true".equals(element.getAttribute("constant")));
        String units = element.getAttribute("substanceUnits");
        if (!units.isEmpty()) {
            if (!this.emodel.getUnits().containsKey(units)) {
                this.emodel.addUnit(new Unit(null, units));
            }
            var.setUnits(units);
        }
        return species;
    }

    @Override
    public Variable readParameter(Element element, String parameterId, Node reaction) throws Exception {
        Variable parameter = super.readParameter(element, parameterId, reaction);
        MetaIdInfo metaidInfo = this.readMetaId(element, parameter.getName(), Variable.class, null);
        parameter.getAttributes().add(new DynamicProperty("metaid", MetaIdInfo.class, (Object)metaidInfo));
        parameter.setConstant(!"false".equals(element.getAttribute("constant")));
        return parameter;
    }

    @Override
    protected void validateReaction(Node reaction) {
        Reaction r = (Reaction)reaction.getKernel();
        if (!StreamEx.of((Object[])r.getSpecieReferences()).anyMatch(sr -> sr.isReactantOrProduct())) {
            this.error("ERROR_INVALID_REACTION", new String[]{this.modelName, r.getName()});
        }
    }

    @Override
    protected void readStoichiometry(Element element, SpecieReference reference, Node reaction) {
        String stoichiometry = "1";
        if (element.hasAttribute("stoichiometry")) {
            stoichiometry = element.getAttribute("stoichiometry");
        } else {
            String s;
            Element stoichiometryElement = this.getElement(element, "stoichiometryMath");
            if (stoichiometryElement != null && (s = this.readMath(stoichiometryElement, (DiagramElement)reaction)) != null) {
                stoichiometry = s;
            }
        }
        reference.setStoichiometry(stoichiometry);
    }

    @Override
    protected void readKineticLawFormula(Element element, Node reaction, KineticLaw kineticLaw) {
        Element math = this.getElement(element, "math");
        if (math != null) {
            kineticLaw.setFormula(this.readMath(math, (DiagramElement)reaction));
        }
    }

    @Override
    protected void readModifiers(Element element, String reactionName, List<SbmlModelReader.SpecieRefenceInfo> specieReferences) {
        Element modifierList = this.getElement(element, "listOfModifiers");
        if (!this.isValid("listOfModifiers", modifierList, reactionName)) {
            return;
        }
        NodeList list = modifierList.getElementsByTagName("modifierSpeciesReference");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            String specieId = "";
            try {
                Element specieRef = (Element)list.item(i);
                specieId = (String)this.sbmlNameToBioUML.get(this.getSpecieAttribute(specieRef));
                specieReferences.add(new SbmlModelReader.SpecieRefenceInfo(specieId, "modifier", specieRef));
                continue;
            }
            catch (Throwable t) {
                this.error("ERROR_MODIFIER_PROCESSING", new String[]{this.modelName, reactionName, specieId, t.getMessage()});
            }
        }
    }

    @Override
    public Node readRule(Element ruleElement, int i) {
        String id = this.getBriefId(ruleElement, "biouml:nodeInfo");
        if (id.isEmpty()) {
            id = ruleElement.getAttribute("metaid");
        }
        if (id.isEmpty()) {
            id = "rule_" + i;
        }
        Stub stub = new Stub((DataCollection)this.diagram, id, "math-equation");
        Node node = new Node((DataCollection)this.diagram, (Base)stub);
        Element annotationElement = this.getElement(ruleElement, "annotation");
        if (annotationElement != null) {
            this.readBioUMLAnnotation(annotationElement, (DiagramElement)node, "biouml:nodeInfo");
        }
        try {
            String expression = this.readMath(ruleElement, (DiagramElement)node);
            Equation equation = null;
            if ("algebraicRule".equals(ruleElement.getNodeName())) {
                equation = new Equation((DiagramElement)node, "algebraic", "unknown", expression);
            } else {
                String var;
                if (!ruleElement.hasAttribute("variable")) {
                    this.error("ERROR_VARIABLE_ATTRIBUTE_ABSENT", new String[]{this.modelName});
                }
                if (!(var = ruleElement.getAttribute("variable")).isEmpty()) {
                    var = this.variableResolver.getVariableName(var);
                    if (!this.emodel.containsVariable(var = this.normalize(var))) {
                        this.error("ERROR_VARIABLE_UNKNOWN", new String[]{this.modelName, var});
                    }
                    String type = "assignmentRule".equals(ruleElement.getNodeName()) ? "scalar" : "rate";
                    equation = new Equation((DiagramElement)node, type, var, expression);
                }
            }
            node.setRole((Role)equation);
            this.diagram.put((DiagramElement)node);
            return node;
        }
        catch (Throwable t) {
            this.error("ERROR_RULE_PROCESSING", new String[]{this.modelName, t.getMessage()});
            return null;
        }
    }

    @Override
    protected void readFunctionDefinitionList(Element model) {
        Element funcDefList = this.getElement(model, "listOfFunctionDefinitions");
        if (funcDefList == null) {
            return;
        }
        HashMap<String, Element> functions = new HashMap<String, Element>();
        HashSet<String> alreadyRead = new HashSet<String>();
        for (Element element : XmlUtil.elements((Element)funcDefList, (String)"functionDefinition")) {
            String functionName = this.normalize(this.getId(element));
            functions.put(functionName, element);
        }
        for (Map.Entry entry : functions.entrySet()) {
            Element funcDefElement = (Element)entry.getValue();
            String funcName = (String)entry.getKey();
            if (alreadyRead.contains(funcName)) continue;
            try {
                this.readFunctionDefinition(funcDefElement, functions, alreadyRead);
            }
            catch (Throwable t) {
                this.error("ERROR_FUNCTION_DECLARATION_PROCESSING", new String[]{this.modelName, this.getId(funcDefElement), t.getMessage()});
            }
        }
    }

    @Override
    public Node readFunctionDefinition(Element funcDefElement, Map<String, Element> functions, Set<String> alreadyRead) throws Exception {
        String nodeName = this.normalize(this.getCompleteId(funcDefElement, "biouml:nodeInfo"));
        String functionName = this.normalize(this.getId(funcDefElement));
        if (functionName.isEmpty()) {
            this.error("ERROR_UNDEFINED_FUNCTION_PROCESSING", new String[]{this.modelName});
            return null;
        }
        if (nodeName.isEmpty()) {
            nodeName = functionName;
        }
        Set innerFunctions = this.mathMLParser.getFunctions(funcDefElement);
        for (String innerFuncName : innerFunctions) {
            if (this.emodel.getFunction(innerFuncName) != null) continue;
            try {
                Element innerFuncDefElement = functions.get(innerFuncName);
                this.readFunctionDefinition(innerFuncDefElement, functions, alreadyRead);
            }
            catch (Throwable t) {
                this.error("ERROR_FUNCTION_DECLARATION_PROCESSING", new String[]{this.modelName, innerFuncName, t.getMessage()});
            }
        }
        Stub stub = new Stub((DataCollection)this.diagram, nodeName, "math-function");
        Node node = new Node((DataCollection)this.diagram, (Base)stub);
        Element annotationElement = this.getElement(funcDefElement, "annotation");
        if (annotationElement != null) {
            this.readBioUMLAnnotation(annotationElement, (DiagramElement)node, "biouml:nodeInfo");
        }
        Function function = new Function((DiagramElement)node);
        function.setName(functionName, false);
        this.mathMLParser.setLambdaFunctionName(functionName);
        alreadyRead.add(functionName);
        function.setFormula(this.readMath(funcDefElement, (DiagramElement)node));
        ParserContext context = this.mathMLParser.getContext();
        if (context != this.emodel) {
            this.setEModelAsParserContext(false);
            context = this.mathMLParser.getContext();
        }
        if (context.getFunction(functionName) == null) {
            context.declareFunction((ru.biosoft.math.model.Function)new UndeclaredFunction(functionName, 7));
        }
        node.setRole((Role)function);
        ((EModel)this.diagram.getRole(EModel.class)).declareFunction((ru.biosoft.math.model.Function)((AstFunctionDeclaration)this.mathMLParser.getStartNode().jjtGetChild(0)));
        this.diagram.put((DiagramElement)node);
        return node;
    }

    @Override
    protected void readEventList(Element model) {
        Element eventList = this.getElement(model, "listOfEvents");
        if (eventList == null) {
            return;
        }
        NodeList list = eventList.getElementsByTagName("event");
        for (int i = 0; i < list.getLength(); ++i) {
            this.readEvent((Element)list.item(i), i);
        }
    }

    @Override
    public Node readEvent(Element eventElement, int i) {
        try {
            Element annotationElement;
            String id = this.getBriefId(eventElement, "biouml:nodeInfo");
            if (id.isEmpty()) {
                id = eventElement.getAttribute("metaid");
            }
            if (id.isEmpty()) {
                id = "event_" + (i + 1);
            }
            Node node = new Node((DataCollection)this.diagram, (Base)new Stub((DataCollection)this.diagram, id, "math-event"));
            Event event = new Event((DiagramElement)node);
            node.setRole((Role)event);
            ArrayList<MetaIdInfo> metaIdInfos = new ArrayList<MetaIdInfo>();
            MetaIdInfo metaIdInfo = this.readMetaId(eventElement, node.getName(), Node.class, null);
            if (metaIdInfo != null) {
                metaIdInfos.add(metaIdInfo);
            }
            if ((annotationElement = this.getElement(eventElement, "annotation")) != null) {
                this.readBioUMLAnnotation(annotationElement, (DiagramElement)node, "biouml:nodeInfo");
            }
            String delay = null;
            Element delayElement = this.getElement(eventElement, "delay");
            if (delayElement != null) {
                delay = this.readMath(delayElement, (DiagramElement)node);
            }
            if (delay != null) {
                metaIdInfo = this.readMetaId(delayElement, node.getName(), Node.class, "delay");
                if (metaIdInfo != null) {
                    metaIdInfos.add(metaIdInfo);
                }
                event.setDelay(delay);
            }
            String trigger = null;
            Element triggerElement = this.getElement(eventElement, "trigger");
            if (triggerElement == null) {
                this.error("ERROR_TRIGGER_ELEMENT_ABSENT", new String[]{this.modelName});
            } else {
                trigger = this.readMath(triggerElement, (DiagramElement)node);
            }
            if (trigger != null) {
                metaIdInfo = this.readMetaId(triggerElement, node.getName(), Node.class, "trigger");
                if (metaIdInfo != null) {
                    metaIdInfos.add(metaIdInfo);
                }
                event.setTrigger(trigger);
            }
            event.setTimeUnits(eventElement.getAttribute("timeUnits"));
            this.readAssignmentList(eventElement, event, metaIdInfos);
            int metaIdsCount = metaIdInfos.size();
            if (metaIdsCount != 0) {
                node.getAttributes().add(DPSUtils.createTransient((String)"metaid", List.class, metaIdInfos));
            }
            this.diagram.put((DiagramElement)node);
            return node;
        }
        catch (Throwable t) {
            this.error("ERROR_EVENT_PROCESSING", new String[]{this.modelName, t.getMessage()});
            return null;
        }
    }

    @Override
    public Node readInitialAssignment(Element initialAssignmentsElement, int i) {
        String id = this.getBriefId(initialAssignmentsElement, "biouml:nodeInfo");
        if (id.isEmpty()) {
            id = initialAssignmentsElement.getAttribute("metaid");
        }
        if (id.isEmpty()) {
            id = "initialAssignment_" + i;
        }
        Node node = new Node((DataCollection)this.diagram, (Base)new Stub((DataCollection)this.diagram, id, "math-equation"));
        Element annotationElement = this.getElement(initialAssignmentsElement, "annotation");
        if (annotationElement != null) {
            this.readBioUMLAnnotation(annotationElement, (DiagramElement)node, "biouml:nodeInfo");
        }
        try {
            String var;
            String expression = this.readMath(initialAssignmentsElement, (DiagramElement)node);
            if (!initialAssignmentsElement.hasAttribute("symbol")) {
                this.error("ERROR_VARIABLE_ATTRIBUTE_ABSENT", new String[]{this.modelName});
            }
            if (!(var = initialAssignmentsElement.getAttribute("symbol")).isEmpty()) {
                if (!(this.emodel.containsVariable(var = this.variableResolver.getVariableName(var)) || this.specieMap.containsKey(var) || this.compartmentMap.containsKey(var))) {
                    this.error("ERROR_VARIABLE_UNKNOWN", new String[]{this.modelName, var});
                }
                node.setRole((Role)new Equation((DiagramElement)node, "initial assignment", var, expression));
                this.diagram.put((DiagramElement)node);
            }
            return node;
        }
        catch (Throwable t) {
            this.error("ERROR_INITIAL_ASSIGNMENT_PROCESSING", new String[]{this.modelName, t.getMessage()});
            return null;
        }
    }

    protected void readAssignmentList(Element eventElement, Event event, List<MetaIdInfo> metaIdInfos) {
        event.clearAssignments(false);
        Element assignmentList = this.getElement(eventElement, "listOfEventAssignments");
        if (assignmentList == null) {
            return;
        }
        NodeList list = assignmentList.getElementsByTagName("eventAssignment");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            try {
                Element assignElement = (Element)list.item(i);
                Stub stub = new Stub(null, "assignment_" + (i + 1));
                Node node = new Node((DataCollection)this.diagram, (Base)stub);
                if (!assignElement.hasAttribute("variable")) {
                    this.error("ERROR_EVENT_ASSIGNMENT_PROCESSING", new String[]{this.modelName});
                } else {
                    String var = assignElement.getAttribute("variable");
                    if (!var.isEmpty()) {
                        var = this.variableResolver.getVariableName(var);
                        String math = this.readMath(assignElement, (DiagramElement)node);
                        event.addEventAssignment(new Assignment(var, math), false);
                    }
                }
                MetaIdInfo metaId = this.readMetaId(assignElement, event.getDiagramElement().getName(), Node.class, "eventAssignment", i);
                if (metaId == null) continue;
                metaIdInfos.add(metaId);
                continue;
            }
            catch (Throwable t) {
                this.error("ERROR_EVENT_PROCESSING", new String[]{this.modelName, t.getMessage()});
            }
        }
    }

    protected String readMath(Element element, DiagramElement de) {
        String name = de == null ? "-" : de.getName();
        Element math = null;
        if (element.getTagName().equals("math")) {
            math = element;
        } else {
            math = this.getElement(element, "math");
            if (math == null) {
                this.error("ERROR_MATH_MISSING", new String[]{this.modelName, name});
                return "";
            }
        }
        try {
            if (this.mathMLParser.getContext() != this.emodel) {
                this.setEModelAsParserContext(true);
            }
            this.variableResolver.diagramElement = de;
            int status = this.mathMLParser.parse(math);
            if (status > 0) {
                this.error("ERROR_MATHML_PARSING", new String[]{this.modelName, name, Utils.formatErrors((Parser)this.mathMLParser)});
            }
            if (status < 4) {
                return this.linearFormatter.format(this.mathMLParser.getStartNode())[1];
            }
        }
        catch (Throwable t) {
            this.error("ERROR_MATHML_PARSING", new String[]{this.modelName, name, t.getMessage()});
        }
        return "";
    }

    private void setEModelAsParserContext(boolean declareVars) {
        this.mathMLParser.setContext((ParserContext)this.emodel);
        this.mathMLParser.declareCSymbol("http://www.sbml.org/sbml/symbols/delay", (ru.biosoft.math.model.Function)new PredefinedFunction("delay", 7, 2));
        this.mathMLParser.declareCSymbol("http://www.sbml.org/sbml/symbols/rateOf", (ru.biosoft.math.model.Function)new PredefinedFunction("rateOf", 7, 1));
        this.mathMLParser.declareCSymbol((ru.biosoft.math.model.Function)new PredefinedFunction("delay", 7, 2));
        this.mathMLParser.declareCSymbol("time");
        this.mathMLParser.declareCSymbol("http://www.sbml.org/sbml/symbols/time", "time");
        this.mathMLParser.declareCSymbol("http://www.sbml.org/sbml/symbols/avogadro", "avogadro", 6.02214179E23);
        this.mathMLParser.setDeclareUndefinedVariables(declareVars);
        this.mathMLParser.setVariableResolver((VariableResolver)this.variableResolver);
    }

    public MetaIdInfo readMetaId(Element element, String name, Class<?> type, String property) {
        return this.readMetaId(element, name, type, property, -1);
    }

    public MetaIdInfo readMetaId(Element element, String nodeName, Class<?> type, String property, int i) {
        String metaId = element.getAttribute("metaid");
        if (metaId == null || metaId.isEmpty()) {
            return null;
        }
        MetaIdInfo result = new MetaIdInfo(metaId, nodeName, property, i, type);
        this.metaIds.put(metaId, result);
        return result;
    }

    public static class MetaIdInfo {
        String id;
        String nodeName;
        int index;
        String property;
        Class<?> clazz;

        public MetaIdInfo(String id, String nodeName, String property, Class<?> type) {
            this.id = id;
            this.nodeName = nodeName;
            this.property = property;
            this.clazz = type;
        }

        public MetaIdInfo(String id, String nodeName, String property, int index, Class<?> type) {
            this.id = id;
            this.nodeName = nodeName;
            this.property = property;
            this.index = index;
            this.clazz = type;
        }

        public String getObjectName() {
            return this.nodeName;
        }

        public String getProperty() {
            return this.property;
        }

        public int getIndex() {
            return this.index;
        }

        public Class<?> getOjectClass() {
            return this.clazz;
        }

        public String getId() {
            return this.id;
        }
    }
}

