/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Compartment;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.sbml.SbmlDiagramType_L1;
import biouml.plugins.sbml.SbmlEModel;
import biouml.plugins.sbml.SbmlModelReader_11;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.math.model.Utils;

public class SbmlModelReader_12
extends SbmlModelReader_11 {
    public SbmlModelReader_12() {
        this.log = Logger.getLogger(SbmlModelReader_12.class.getName());
    }

    protected DiagramType getDiagramType() {
        return new SbmlDiagramType_L1();
    }

    @Override
    protected boolean isValid(String elementName, Object element, String name) {
        if (elementName.equals("listOfUnitDefinitions")) {
            return this.validateList(element, "unitDefinition", name);
        }
        if (elementName.equals("listOfCompartments")) {
            return this.validateList(element, "compartment", name);
        }
        if (elementName.equals("listOfSpecies")) {
            return this.validateList(element, "species", name);
        }
        if (elementName.equals("listOfReactions")) {
            return this.validateList(element, "reaction", name);
        }
        if (elementName.equals("listOfRules") && element instanceof Element) {
            return true;
        }
        if (elementName.equals("listOfParameters")) {
            NodeList list;
            return element instanceof Element && (list = ((Element)element).getElementsByTagName("parameter")) != null && list.getLength() > 0;
        }
        if (elementName.equals("listOfReactants")) {
            return this.validateList(element, "speciesReference", "ERROR_REACTANT_LIST_MISSING", "ERROR_REACTANT_LIST_EMPTY", name);
        }
        if (elementName.equals("listOfProducts")) {
            return this.validateList(element, "speciesReference", "ERROR_PRODUCT_LIST_MISSING", "ERROR_PRODUCT_LIST_EMPTY", name);
        }
        if (elementName.equals("initialAmount")) {
            if (element instanceof Element && ((Element)element).hasAttribute("initialAmount")) {
                return true;
            }
            this.error("ERROR_SPECIE_AMOUNT_NOT_SPECIFIED", new String[]{this.modelName, name});
            return false;
        }
        return true;
    }

    @Override
    public NodeList getSpecieElement(Element specieList) {
        return specieList.getElementsByTagName("species");
    }

    @Override
    protected NodeList getSpecieReference(Element list) {
        return list.getElementsByTagName("speciesReference");
    }

    @Override
    protected String getSpecieAttribute(Element specieRef) {
        return specieRef.getAttribute("species");
    }

    @Override
    public Node readRule(Element ruleElement, int i) {
        try {
            if (!ruleElement.hasAttribute("formula")) {
                this.error("ERROR_RULE_FORMULA_ABSENT", new String[]{this.modelName});
                return null;
            }
            String comment = ruleElement.getAttribute("comment");
            String formula = ruleElement.getAttribute("formula");
            if (ruleElement.getNodeName().equals("algebraicRule")) {
                ruleElement.setAttribute("type", "algebraic");
            }
            if (!ruleElement.hasAttribute("type")) {
                ruleElement.setAttribute("type", "scalar");
                this.error("ERROR_RULE_TYPE_ABSENT", new String[]{this.modelName});
            } else {
                ruleElement.setAttribute("type", ruleElement.getAttribute("type"));
            }
            String variableName = "";
            if (ruleElement.getNodeName().equals("speciesConcentrationRule")) {
                variableName = this.getSpecieAttribute(ruleElement);
                if (!this.specieMap.containsKey(variableName)) {
                    this.error("ERROR_SPECIE_VARIABLE_UNKNOWN", new String[]{this.modelName, variableName});
                }
            } else if (ruleElement.getNodeName().equals("compartmentVolumeRule")) {
                variableName = ruleElement.getAttribute("compartment");
                if (!this.compartmentMap.containsKey(variableName)) {
                    this.error("ERROR_COMPARTMENT_VARIABLE_UNKNOWN", new String[]{this.modelName});
                }
            } else if (ruleElement.getNodeName().equals("parameterRule")) {
                variableName = ruleElement.getAttribute("name");
                if (!this.emodel.containsVariable(variableName)) {
                    this.error("ERROR_PARAMETER_VARIABLE_UNKNOWN", new String[]{this.modelName});
                } else {
                    this.emodel.getVariable(variableName).setConstant(false);
                }
            }
            Stub stub = new Stub(null, "rule_" + i);
            Node node = new Node((DataCollection)this.diagram, (Base)stub);
            String expression = this.readMath(formula, (DiagramElement)node);
            this.checkForCompartments(null, variableName, formula, "algebraic".equals(ruleElement.getAttribute("type")));
            this.variableResolver.diagramElement = this.diagram;
            if (!variableName.equals("")) {
                variableName = this.variableResolver.getVariableName(variableName);
            }
            Equation equation = new Equation((DiagramElement)node, ruleElement.getAttribute("type"), variableName, expression);
            node.setRole((Role)equation);
            node.setComment(comment);
            this.diagram.put((DiagramElement)node);
            return node;
        }
        catch (Throwable t) {
            this.error("ERROR_RULE_PROCESSING", new String[]{this.modelName, t.getMessage()});
            return null;
        }
    }

    private void checkForCompartments(Node de, String variableName, String formula, boolean algebraic) {
        if (algebraic) {
            ((StreamEx)Utils.variables((ru.biosoft.math.model.Node)this.getAst(formula, (DiagramElement)de)).map(arg_0 -> ((SbmlEModel)this.emodel).getVariable(arg_0)).select(VariableRole.class).map(role -> (Compartment)this.compartmentMap.get(role.getDiagramElement().getCompleteNameInDiagram())).nonNull()).map(DiagramElement::getRole).select(VariableRole.class).forEach(role -> role.setConstant(false));
        } else if (this.compartmentMap.containsKey(variableName) && ((Compartment)this.compartmentMap.get(variableName)).getRole() instanceof VariableRole) {
            ((VariableRole)((Compartment)this.compartmentMap.get(variableName)).getRole(VariableRole.class)).setConstant(false);
        }
    }
}

