/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Compartment;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.sbml.SbmlDiagramType_L1;
import biouml.plugins.sbml.SbmlModelReader;
import biouml.standard.type.Base;
import biouml.standard.type.KineticLaw;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import biouml.standard.type.Unit;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.DefaultParserContext;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.model.Utils;
import ru.biosoft.math.model.VariableResolver;
import ru.biosoft.math.parser.Parser;

public class SbmlModelReader_11
extends SbmlModelReader {
    protected Parser parser = new Parser();
    protected DefaultParserContext parserContext = new DefaultParserContext();

    public SbmlModelReader_11() {
        this.log = Logger.getLogger(SbmlModelReader_11.class.getName());
    }

    @Override
    protected DiagramType getDiagramType(Element modelElement) {
        return new SbmlDiagramType_L1();
    }

    @Override
    public String getId(Element element) {
        return element.getAttribute("name");
    }

    @Override
    public String getTitle(Element element) {
        return element.getAttribute("name");
    }

    @Override
    public NodeList getSpecieElement(Element specieList) {
        return specieList.getElementsByTagName("specie");
    }

    @Override
    protected NodeList getSpecieReference(Element list) {
        return list.getElementsByTagName("specieReference");
    }

    @Override
    protected String getSpecieAttribute(Element specieRef) {
        return specieRef.getAttribute("specie");
    }

    @Override
    protected boolean isValid(String elementName, Object element, String name) {
        if (elementName.equals("listOfUnitDefinitions")) {
            return this.validateList(element, "unitDefinition", name);
        }
        if (elementName.equals("listOfCompartments")) {
            return this.validateList(element, "compartment", "ERROR_COMPARTMENT_LIST_MISSING", "ERROR_COMPARTMENT_LIST_EMPTY", name);
        }
        if (elementName.equals("listOfSpecies")) {
            return this.validateList(element, "specie", "ERROR_SPECIE_LIST_MISSING", "ERROR_SPECIE_LIST_EMPTY", name);
        }
        if (elementName.equals("listOfReactions")) {
            return this.validateList(element, "reaction", "ERROR_REACTION_LIST_MISSING", "ERROR_REACTION_LIST_EMPTY", name);
        }
        if (elementName.equals("listOfRules")) {
            return true;
        }
        if (elementName.equals("listOfParameters")) {
            NodeList list;
            return element instanceof Element && (list = ((Element)element).getElementsByTagName("parameter")) != null && list.getLength() > 0;
        }
        if (elementName.equals("listOfReactants")) {
            return this.validateList(element, "specieReference", "ERROR_REACTANT_LIST_MISSING", "ERROR_REACTANT_LIST_EMPTY", name);
        }
        if (elementName.equals("listOfProducts")) {
            return this.validateList(element, "specieReference", "ERROR_PRODUCT_LIST_MISSING", "ERROR_PRODUCT_LIST_EMPTY", name);
        }
        if (elementName.equals("initialAmount")) {
            if (element instanceof Element && ((Element)element).hasAttribute("initialAmount")) {
                return true;
            }
            this.error("ERROR_SPECIE_AMOUNT_NOT_SPECIFIED", new String[]{this.modelName, name});
            return false;
        }
        if (elementName.equals("value")) {
            if (element instanceof Element && ((Element)element).hasAttribute("value")) {
                return true;
            }
            this.error("ERROR_PARAMETER_VALUE_NOT_SPECIFIED", new String[]{this.modelName, name});
            return false;
        }
        return true;
    }

    @Override
    public Node readSpecie(Element element, String specieId, String specieName) throws Exception {
        Node species = super.readSpecie(element, specieId, specieName);
        if (species == null) {
            return species;
        }
        VariableRole var = (VariableRole)species.getRole(VariableRole.class);
        if (this.isValid("initialAmount", element, specieId)) {
            String initialAmount = element.getAttribute("initialAmount");
            initialAmount = initialAmount.replace(',', '.');
            try {
                var.setInitialValue(Double.parseDouble(initialAmount));
            }
            catch (Throwable t) {
                this.error("ERROR_SPECIE_AMOUNT", new String[]{this.modelName, specieId, initialAmount, t.toString()});
            }
        }
        var.setInitialQuantityType(0);
        var.setOutputQuantityType(0);
        var.setQuantityType(1);
        String units = element.getAttribute("units");
        if (!units.isEmpty()) {
            if (!this.emodel.getUnits().containsKey(units)) {
                this.emodel.addUnit(new Unit(null, units));
            }
            var.setUnits(units);
        } else {
            var.setUnits("substance");
        }
        return species;
    }

    @Override
    public Compartment readCompartment(Element element, String compartmentId, String parentId, String compartmentName) throws Exception {
        Compartment compartment = super.readCompartment(element, compartmentId, parentId, compartmentName);
        if (compartment != null) {
            VariableRole var = (VariableRole)compartment.getRole(VariableRole.class);
            if (element.hasAttribute("constant")) {
                var.setConstant("true".equals(element.getAttribute("constant")));
            } else {
                var.setConstant(true);
            }
        }
        return compartment;
    }

    protected boolean validateList(Object element, String tag, String errorMissing, String errorEmpty, String name) {
        boolean status = true;
        String error = errorMissing;
        if (element instanceof Element) {
            return this.validateList(((Element)element).getElementsByTagName(tag), null, errorEmpty, errorEmpty, name);
        }
        if (element instanceof NodeList) {
            if (((NodeList)element).getLength() < 1) {
                status = false;
                error = errorEmpty;
            }
        } else {
            status = false;
        }
        if (!status) {
            if (name == null) {
                this.error(error, new String[]{this.diagram.getName()});
            } else {
                this.error(error, new String[]{this.diagram.getName(), name});
            }
        }
        return status;
    }

    @Override
    public Node readInitialAssignment(Element initiaAssignment, int i) {
        return null;
    }

    @Override
    protected void validateReaction(Node reaction) {
    }

    @Override
    protected void readKineticLawFormula(Element kineticLawElement, Node reaction, KineticLaw law) {
        if (!kineticLawElement.hasAttribute("formula")) {
            this.warn("WARNING_FORMULA_ABSENTS", new String[]{this.modelName, reaction.getName()});
        } else {
            String formula = null;
            try {
                formula = kineticLawElement.getAttribute("formula");
                law.setFormula(this.readMath(formula, (DiagramElement)reaction));
            }
            catch (Throwable t) {
                this.error("ERROR_FORMULA_PARSING", new String[]{this.modelName, reaction.getName(), t.getMessage()});
            }
        }
    }

    @Override
    protected void readStoichiometry(Element element, SpecieReference reference, Node reaction) {
        int stoichiometry = 1;
        if (element.hasAttribute("stoichiometry")) {
            String s = element.getAttribute("stoichiometry");
            try {
                stoichiometry = Integer.parseInt(s);
            }
            catch (Throwable t) {
                this.error("ERROR_STOICHIOMETRY", new String[]{this.modelName, reference.getOrigin().getName(), reference.getName(), s, t.toString()});
            }
        }
        if (stoichiometry == 0) {
            reference.setRole("modifier");
            reference.setStoichiometry("0");
            return;
        }
        int denominator = 1;
        if (element.hasAttribute("denominator")) {
            String s = element.getAttribute("denominator");
            try {
                denominator = Integer.parseInt(s);
            }
            catch (Throwable t) {
                this.error("ERROR_DENOMINATOR", new String[]{this.modelName, reference.getOrigin().getName(), reference.getName(), s, t.toString()});
            }
        }
        if (denominator == 1) {
            reference.setStoichiometry("" + stoichiometry);
        } else {
            reference.setStoichiometry("" + stoichiometry + "/" + denominator);
        }
    }

    @Override
    public Node readRule(Element ruleElement, int i) {
        try {
            if (!ruleElement.hasAttribute("formula")) {
                this.error("ERROR_RULE_FORMULA_ABSENT", new String[]{this.modelName});
                return null;
            }
            String comment = ruleElement.getAttribute("comment");
            String formula = ruleElement.getAttribute("formula");
            if (ruleElement.getNodeName().equals("algebraicRule")) {
                ruleElement.setAttribute("type", "algebraic");
            }
            if (!ruleElement.hasAttribute("type")) {
                this.error("ERROR_RULE_TYPE_ABSENT", new String[]{this.modelName});
            }
            String variableName = "";
            if (ruleElement.getNodeName().equals("specieConcentrationRule")) {
                variableName = this.getSpecieAttribute(ruleElement);
                if (!this.specieMap.containsKey(variableName)) {
                    this.error("ERROR_SPECIE_VARIABLE_UNKNOWN", new String[]{this.modelName, variableName});
                }
            } else if (ruleElement.getNodeName().equals("compartmentVolumeRule")) {
                variableName = ruleElement.getAttribute("compartment");
                if (!this.compartmentMap.containsKey(variableName)) {
                    this.error("ERROR_COMPARTMENT_VARIABLE_UNKNOWN", new String[]{this.modelName});
                }
            } else if (ruleElement.getNodeName().equals("parameterRule") && !this.emodel.containsVariable(variableName = ruleElement.getAttribute("name"))) {
                this.error("ERROR_PARAMETER_VARIABLE_UNKNOWN", new String[]{this.modelName});
            }
            this.variableResolver.diagramElement = this.diagram;
            if (!variableName.equals("")) {
                variableName = this.variableResolver.getVariableName(variableName);
            }
            Stub stub = new Stub(null, "rule_" + i);
            Node node = new Node((DataCollection)this.diagram, (Base)stub);
            String expression = this.readMath(formula, (DiagramElement)node);
            Equation equation = new Equation((DiagramElement)node, ruleElement.getAttribute("type"), variableName, expression);
            node.setRole((Role)equation);
            node.setComment(comment);
            this.diagram.put((DiagramElement)node);
            return node;
        }
        catch (Throwable t) {
            this.error("ERROR_RULE_PROCESSING", new String[]{this.modelName, t.getMessage()});
            return null;
        }
    }

    protected void initParser() {
        this.parser.setContext((ParserContext)this.parserContext);
        this.parser.setDeclareUndefinedVariables(false);
        this.parser.setVariableResolver((VariableResolver)this.variableResolver);
        this.parserContext.removeConstant("avogadro");
        this.parserContext.declareFunctionNameSubstitution("acos", "arccos");
        this.parserContext.declareFunctionNameSubstitution("asin", "arcsin");
        this.parserContext.declareFunctionNameSubstitution("atan", "arctan");
        this.parserContext.declareFunctionNameSubstitution("log10", "log");
        this.parserContext.declareFunctionNameSubstitution("log", "ln");
        this.parserContext.declareFunctionNameSubstitution("pow", "^");
        this.parserContext.declareFunctionNameSubstitution("ceil", "ceiling");
        this.parserContext.declareFunctionNameSubstitution("factorial", "factorial");
    }

    protected AstStart getAst(String formula, DiagramElement de) {
        String name;
        String string = name = de == null ? "-" : de.getName();
        if (formula == null) {
            this.error("ERROR_FORMULA_MISSING", new String[]{this.modelName, name});
            return null;
        }
        try {
            if (this.parser.getContext() != this.parserContext) {
                this.initParser();
            }
            this.parserContext.setParentContext((ParserContext)this.emodel);
            this.variableResolver.diagramElement = de;
            int status = this.parser.parse(formula);
            if (status > 0) {
                this.error("ERROR_FORMULA_PARSING", new String[]{this.modelName, name, Utils.formatErrors((ru.biosoft.math.model.Parser)this.parser)});
            }
            if (status < 4) {
                return this.parser.getStartNode();
            }
        }
        catch (Throwable t) {
            this.error("ERROR_MATH_PARSING", new String[]{this.modelName, name, t.getMessage()});
        }
        return null;
    }

    protected String readMath(String formula, DiagramElement de) {
        String name = de == null ? "-" : de.getName();
        AstStart start = this.getAst(formula, de);
        if (start == null) {
            return null;
        }
        try {
            return this.linearFormatter.format(this.parser.getStartNode())[1];
        }
        catch (Throwable t) {
            this.error("ERROR_MATH_PARSING", new String[]{this.modelName, name, t.getMessage()});
            return null;
        }
    }
}

