/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.util.DiagramXmlReader;
import biouml.model.xml.XmlDiagramType;
import biouml.plugins.sbml.SbmlDiagramType;
import biouml.plugins.sbml.SbmlDiagramViewBuilder;
import biouml.plugins.sbml.SbmlEModel;
import biouml.plugins.sbml.SbmlSupport;
import biouml.plugins.sbml.SbmlTypeMapper;
import biouml.plugins.sbml.extensions.SbmlAnnotationRegistry;
import biouml.plugins.sbml.extensions.SbmlExtension;
import biouml.standard.type.Base;
import biouml.standard.type.BaseUnit;
import biouml.standard.type.Compartment;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.KineticLaw;
import biouml.standard.type.Reaction;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Unit;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.Option;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graph.Layouter;
import ru.biosoft.graph.PathLayouterWrapper;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.View;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.VariableResolver;
import ru.biosoft.util.XmlStream;
import ru.biosoft.util.XmlUtil;

public abstract class SbmlModelReader
extends SbmlSupport {
    protected Map<String, biouml.model.Compartment> compartmentMap;
    protected Map<String, Node> specieMap;
    protected Map<String, String> sbmlNameToBioUML;
    protected SbmlVariableResolver variableResolver = new SbmlVariableResolver();
    protected LinearFormatter linearFormatter = new LinearFormatter();
    protected List<SbmlExtensionHelper> annotationsExtensions = null;
    protected Map<String, SbmlExtension> additionalAnnotationsExtensions = null;
    protected Map<String, String> replacements;
    int layerDeltaX = 70;
    int layerDeltaY = 70;
    public static Set<String> parserConstants = new HashSet<String>(){
        {
            this.add("function");
            this.add("diff");
            this.add("piecewise");
            this.add("xor");
        }
    };

    public SbmlModelReader() {
        this.log = Logger.getLogger(SbmlModelReader.class.getName());
    }

    protected DiagramType getDiagramType(Element modelElement) {
        String notation;
        Element xmlDiagramType;
        Element modelAnnotation = this.getElement(modelElement, "annotation");
        if (modelAnnotation != null && (xmlDiagramType = this.getElement(modelAnnotation, "xmlDiagramType")) != null && (notation = xmlDiagramType.getAttribute("notation")) != null && !"".equals(notation)) {
            XmlDiagramType type;
            XmlDiagramType xmlDiagramType2 = type = notation.indexOf(47) == -1 ? XmlDiagramType.getTypeObject((String)notation) : (XmlDiagramType)CollectionFactory.getDataElement((String)notation);
            if (type != null) {
                return type;
            }
        }
        return new SbmlDiagramType();
    }

    public Diagram read(Document document, String name, DataCollection<?> origin) throws Exception {
        this.modelName = name;
        this.diagram = null;
        this.compartmentMap = new HashMap<String, biouml.model.Compartment>();
        this.specieMap = new SpecificalHashMap();
        this.sbmlNameToBioUML = new HashMap<String, String>();
        Element root = document.getDocumentElement();
        Element model = this.getElement(root, "model");
        if (model != null) {
            this.diagram = this.readDiagram(model, origin);
        } else {
            this.error("ERROR_SBML_PROCESSING", new String[]{this.modelName});
        }
        if (this.shouldLayout) {
            this.layout((biouml.model.Compartment)this.diagram);
        }
        return this.diagram;
    }

    public String readNotes(Element element) {
        return (element = this.getElement(element, "notes")) != null ? this.readXhtml(element) : null;
    }

    protected abstract boolean isValid(String var1, Object var2, String var3);

    protected void validateReaction(Node reaction) {
    }

    public abstract String getTitle(Element var1);

    public abstract Node readRule(Element var1, int var2);

    public abstract Node readInitialAssignment(Element var1, int var2);

    public NodeList getSpecieElement(Element specieList) {
        return specieList.getElementsByTagName("species");
    }

    protected NodeList getSpecieReference(Element list) {
        return list.getElementsByTagName("speciesReference");
    }

    protected String getSpecieAttribute(Element specieRef) {
        return specieRef.getAttribute("species");
    }

    protected void readModifiers(Element element, String reactionName, List<SpecieRefenceInfo> specieReferences) {
    }

    public abstract String getId(Element var1);

    protected abstract void readStoichiometry(Element var1, SpecieReference var2, Node var3);

    protected abstract void readKineticLawFormula(Element var1, Node var2, KineticLaw var3);

    protected void readFunctionDefinitionList(Element model) {
    }

    public Node readFunctionDefinition(Element funcDefElement, Map<String, Element> functions, Set<String> alreadyRead) throws Exception {
        return null;
    }

    protected void readEventList(Element element) {
    }

    public Node readEvent(Element eventElement, int i) {
        return null;
    }

    protected void readModelAttributes(Element element, Diagram diagram) {
    }

    protected void readCompartmentTypeList(Element model) {
    }

    protected void readSpecieTypeList(Element model) {
    }

    protected void readInitialAssignmentsList(Element model) {
        Element initialAssignmentList = this.getElement(model, "listOfInitialAssignments");
        if (initialAssignmentList == null) {
            return;
        }
        if (!this.isValid("listOfInitialAssignments", initialAssignmentList, null)) {
            return;
        }
        NodeList list = initialAssignmentList.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            try {
                if (list.item(i).getNodeType() != 1) continue;
                this.readInitialAssignment((Element)list.item(i), i);
                continue;
            }
            catch (Throwable t) {
                this.error("ERROR_RULE_PROCESSING", new String[]{this.modelName, t.getMessage()});
            }
        }
    }

    protected void readConstraints(Element model) {
    }

    protected void readIds(Element element, Set<String> result) {
        for (Element child : XmlStream.elements((Element)element)) {
            if (child.hasAttribute("id")) {
                result.add(child.getAttribute("id"));
            }
            this.readIds(child, result);
        }
    }

    protected Diagram readDiagram(Element element, DataCollection<?> origin) throws Exception {
        this.compartmentMap = new HashMap<String, biouml.model.Compartment>();
        this.specieMap = new SpecificalHashMap();
        this.sbmlNameToBioUML = new HashMap<String, String>();
        this.replacements = this.createReplacements(element);
        this.diagram = this.createDiagram(element, origin);
        this.diagram.setNotificationEnabled(false);
        this.emodel = (SbmlEModel)this.diagram.getRole(SbmlEModel.class);
        this.emodel.setNotificationEnabled(false);
        this.readPathLayouter(element, this.diagram);
        String title = element.getAttribute("name");
        if (!title.isEmpty()) {
            this.diagram.setTitle(title);
        }
        this.log.finer("Reading SBML model : " + this.modelName + ".");
        this.readDiagramElements(element);
        Element annotationElement = this.getElement(element, "annotation");
        if (annotationElement != null) {
            this.readBioUMLAnnotation(annotationElement, this.diagram);
            this.readAnnotation(annotationElement, (DiagramElement)this.diagram);
        }
        this.diagram.setNotificationEnabled(true);
        this.emodel.setNotificationEnabled(true);
        this.diagram.setNodeViewBuilders();
        return this.diagram;
    }

    protected void readDiagramElements(Element element) {
        this.readFunctionDefinitionList(element);
        this.readUnitList(element);
        this.readCompartmentTypeList(element);
        this.readCompartmentList(element);
        this.readSpecieTypeList(element);
        this.readParameterList(element, null);
        this.readSpecieList(element);
        this.readReactionList(element);
        this.readRuleList(element);
        this.readEventList(element);
        this.readInitialAssignmentsList(element);
        this.readConstraints(element);
        this.readModelAttributes(element, this.diagram);
    }

    protected Diagram createDiagram(Element element, DataCollection<?> origin) throws Exception {
        DiagramType diagramType = this.getDiagramType(element);
        if (this.modelName == null || this.modelName.isEmpty()) {
            this.modelName = this.getBriefId(element, "biouml:diagramInfo");
        }
        DiagramInfo diagramInfo = new DiagramInfo(this.modelName);
        diagramInfo.setDescription(this.readNotes(element));
        return diagramType.createDiagram(origin, diagramInfo.getName(), (Base)diagramInfo);
    }

    private void readPathLayouter(Element annotationElement, Diagram diagram) {
        NodeList list = annotationElement.getElementsByTagName("propertyRef");
        for (int i = 0; i < list.getLength(); ++i) {
            Element el = (Element)list.item(i);
            if (!el.getAttribute("name").equals("pathLayouter")) continue;
            try {
                String className = el.getAttribute("type");
                if (className.isEmpty()) continue;
                Class clazz = ClassLoading.loadClass((String)className);
                Layouter layouter = (Layouter)clazz.newInstance();
                diagram.getViewOptions().setPathLayouterWrapper(new PathLayouterWrapper(layouter));
                continue;
            }
            catch (Exception e) {
                this.error("Error reading diagram path layouter", new String[]{this.modelName, e.getMessage()});
            }
        }
    }

    public void readUnitList(Element model) {
        Element unitDefinitionList = this.getElement(model, "listOfUnitDefinitions");
        if (!this.isValid("listOfUnitDefinitions", unitDefinitionList, null)) {
            return;
        }
        NodeList list = unitDefinitionList.getElementsByTagName("unitDefinition");
        for (int i = 0; i < list.getLength(); ++i) {
            String unitId = "";
            try {
                Element element = (Element)list.item(i);
                unitId = this.getId(element);
                this.emodel.addUnit(this.readUnitDefinition(element, unitId, this.getTitle(element)));
                continue;
            }
            catch (Throwable t) {
                this.error("ERROR_UNIT_DEFINITION_PROCESSING", new String[]{this.modelName, unitId, t.getMessage()});
            }
        }
    }

    protected boolean validateList(Object element, String tag, String name) {
        if (element instanceof Element) {
            return this.validateList(((Element)element).getElementsByTagName(tag), null, name);
        }
        return element instanceof NodeList && ((NodeList)element).item(0) != null;
    }

    protected double convertUnit(String unitName, double value) {
        return value;
    }

    public String getCompleteId(Element element, String expectedBioUMLInfo) {
        Element nodeInfoElement;
        Element annotationElement = this.getElement(element, "annotation");
        if (annotationElement == null) {
            return this.getId(element);
        }
        Element bioumlElement = this.getElement(annotationElement, "biouml:BIOUML");
        if (bioumlElement == null) {
            bioumlElement = annotationElement;
        }
        if ((nodeInfoElement = this.getElement(bioumlElement, expectedBioUMLInfo)) == null) {
            return this.getId(element);
        }
        String fullName = nodeInfoElement.getAttribute("completeName");
        if (fullName.isEmpty()) {
            fullName = this.getFullNameById(this.getId(element));
        }
        fullName = SbmlModelReader.castFullName(fullName);
        return fullName;
    }

    protected String getBriefId(Element element, String expectedBioUMLInfo) {
        return SbmlModelReader.getBriefName(this.getCompleteId(element, expectedBioUMLInfo));
    }

    public String getFullNameById(String id) {
        String input = id;
        StringBuilder result = new StringBuilder();
        Diagram dc = this.diagram;
        boolean continueSearch = true;
        block0: while (continueSearch) {
            continueSearch = false;
            for (Object obj : dc) {
                String cName;
                if (!(obj instanceof biouml.model.Compartment) || !input.startsWith(SbmlModelReader.castStringToSId(cName = ((biouml.model.Compartment)obj).getName()) + "_")) continue;
                result.append(cName).append('.');
                input = input.substring(cName.length() + 1);
                dc = (biouml.model.Compartment)obj;
                continueSearch = true;
                continue block0;
            }
        }
        result.append(input);
        return result.toString();
    }

    protected void readCompartmentList(Element model) {
        Element compartmentList = this.getElement(model, "listOfCompartments");
        if (!this.isValid("listOfCompartments", compartmentList, null)) {
            return;
        }
        NodeList list = compartmentList.getElementsByTagName("compartment");
        Map nameToCompartment = XmlStream.elements((NodeList)list).toMap(this::getId, e -> e);
        Map nameToParent = XmlStream.elements((NodeList)list).mapToEntry(this::getId, e -> e.getAttribute("outside")).toCustomMap(LinkedHashMap::new);
        List<String> compartments = this.topoSort(nameToParent);
        for (String id : compartments) {
            String compartmentId = "";
            try {
                biouml.model.Compartment compartment;
                Element element = (Element)nameToCompartment.get(id);
                compartmentId = this.getCompleteId(element, "biouml:compartmentInfo");
                String compartmentTitle = this.getTitle(element);
                if (compartmentTitle.isEmpty()) {
                    compartmentTitle = compartmentId;
                }
                if ((compartment = this.readCompartment(element, compartmentId, SbmlModelReader.getParentId(compartmentId), compartmentTitle)) == null) continue;
                this.sbmlNameToBioUML.put(this.getId(element), compartment.getCompleteNameInDiagram());
            }
            catch (Throwable t) {
                this.error("ERROR_COMPARTMENT_PROCESSING", new String[]{this.modelName, compartmentId, t.getMessage()});
            }
        }
    }

    private List<String> topoSort(Map<String, String> nameToParent) {
        ArrayList<String> compartments = new ArrayList<String>(nameToParent.keySet());
        boolean changed = true;
        int iter = 100;
        while (changed) {
            changed = false;
            if (iter-- == 0) {
                this.error("ERROR_COMPARTMENT_REORDERING", new String[]{this.modelName});
            }
            for (int i = 0; i < compartments.size() - 1; ++i) {
                int j = compartments.indexOf(nameToParent.get(compartments.get(i)));
                if (j <= i) continue;
                Collections.swap(compartments, i, j);
                changed = true;
                --i;
            }
        }
        return compartments;
    }

    public static String getParentId(String fullName) {
        int ind = fullName.lastIndexOf(".");
        return ind != -1 ? fullName.substring(0, ind) : null;
    }

    public biouml.model.Compartment readCompartment(Element element, String compartmentCompleteId, String parentId, String compartmentTitle) throws Exception {
        Element annotationElement;
        if (this.isDefaultCompartment(element) || this.diagram.getName().equals(compartmentCompleteId)) {
            this.compartmentMap.put(this.diagram.getName(), (biouml.model.Compartment)this.diagram);
            this.compartmentMap.put(compartmentCompleteId, (biouml.model.Compartment)this.diagram);
            this.sbmlNameToBioUML.put(this.getId(element), this.diagram.getName());
            return null;
        }
        biouml.model.Compartment compartment = null;
        Diagram parent = this.diagram;
        if (parentId != null && this.compartmentMap.containsKey(parentId)) {
            parent = (DataCollection)this.compartmentMap.get(parentId);
        } else if (element.hasAttribute("outside")) {
            String outside = element.getAttribute("outside");
            if (this.compartmentMap.containsKey(outside)) {
                parent = (DataCollection)this.compartmentMap.get(outside);
            } else {
                this.error("ERROR_COMPARTMENT_OUTSIDE", new String[]{this.modelName, compartmentCompleteId, outside});
            }
        }
        String compartmentId = SbmlModelReader.getBriefName(compartmentCompleteId);
        Compartment kernel = new Compartment(null, compartmentId);
        compartment = new biouml.model.Compartment((DataCollection)parent, compartmentId, (Base)kernel);
        compartment.setTitle(compartmentTitle);
        parent.put((DataElement)compartment);
        this.compartmentMap.put(compartmentCompleteId, compartment);
        double initialValue = 1.0;
        if (element.hasAttribute("size")) {
            initialValue = this.readDouble(element, "size", "Error during compartment size parsing: " + compartmentCompleteId, 1.0);
        } else if (element.hasAttribute("volume")) {
            initialValue = this.readDouble(element, "volume", "Error during compartment volume parsing: " + compartmentCompleteId, 1.0);
        }
        VariableRole var = new VariableRole((DiagramElement)compartment, initialValue);
        String notes = this.readNotes(element);
        if (notes != null) {
            var.setComment(notes);
        }
        compartment.setRole((Role)var);
        this.emodel.put((Variable)var);
        String units = element.getAttribute("units");
        if (!units.isEmpty()) {
            var.setUnits(units);
        }
        if ((annotationElement = this.getElement(element, "annotation")) != null) {
            Element bioumlElement = this.getElement(annotationElement, "biouml:BIOUML");
            if (bioumlElement != null) {
                this.readVariable((Variable)var, bioumlElement);
            }
            this.readBioUMLAnnotation(annotationElement, (DiagramElement)compartment, "biouml:compartmentInfo");
            this.readAnnotation(annotationElement, (DiagramElement)compartment);
        }
        return compartment;
    }

    private boolean isDefaultCompartment(Element element) {
        Element annotationElement = this.getElement(element, "annotation");
        if (annotationElement == null) {
            return false;
        }
        Element bioumlElement = this.getElement(annotationElement, "biouml:BIOUML");
        if (bioumlElement == null) {
            return false;
        }
        Element compartmentInfoElement = this.getElement(bioumlElement, "biouml:compartmentInfo");
        if (compartmentInfoElement == null) {
            return false;
        }
        String attr = compartmentInfoElement.getAttribute("isDefault");
        return !attr.isEmpty() && attr.equals("true");
    }

    protected void readSpecieList(Element model) {
        Element speciesList = this.getElement(model, "listOfSpecies");
        if (!this.isValid("listOfSpecies", speciesList, null) || speciesList == null) {
            return;
        }
        for (Element element : XmlStream.elements((NodeList)this.getSpecieElement(speciesList))) {
            String specieId = "";
            try {
                specieId = this.getBriefId(element, "biouml:nodeInfo");
                Node node = this.readSpecie(element, specieId, this.getTitle(element));
                this.sbmlNameToBioUML.put(this.getId(element), node.getCompleteNameInDiagram());
            }
            catch (Throwable t) {
                this.error("ERROR_SPECIE_PROCESSING", new String[]{this.modelName, specieId, t.getMessage()});
            }
        }
    }

    public Node readSpecie(Element element, String specieId, String specieName) throws Exception {
        if ("_in_empty_set".equals(specieId) || "_out_empty_set".equals(specieId)) {
            return null;
        }
        if (specieName == null || specieName.trim().length() == 0) {
            specieName = specieId;
        }
        Node specie = null;
        Diagram parent = this.diagram;
        if (!element.hasAttribute("compartment")) {
            this.error("ERROR_SPECIE_COMPARTMENT_NOT_SPECIFIED", new String[]{this.modelName, specieId, parent.getName()});
        } else {
            parent = this.compartmentMap.get(this.sbmlNameToBioUML.get(element.getAttribute("compartment")));
            if (parent == null) {
                parent = this.compartmentMap.get(element.getAttribute("compartment"));
            }
            if (parent == null) {
                this.error("ERROR_SPECIE_COMPARTMENT_NOT_FOUND", new String[]{this.modelName, specieId, element.getAttribute("compartment"), this.diagram.getName()});
                parent = this.diagram;
            }
        }
        Specie kernel = new Specie(null, specieId);
        kernel.setTitle(specieName);
        specie = new Node((DataCollection)parent, (Base)kernel);
        specie.setTitle(specieName);
        this.specieMap.put(specie.getCompleteNameInDiagram(), specie);
        VariableRole var = new VariableRole((DiagramElement)specie, 0.0);
        String notes = this.readNotes(element);
        if (notes != null) {
            var.setComment(notes);
        }
        specie.setRole((Role)var);
        this.emodel.put((Variable)var);
        parent.put((DiagramElement)specie);
        if (element.hasAttribute("boundaryCondition")) {
            var.setBoundaryCondition("true".equals(element.getAttribute("boundaryCondition")));
        }
        if (element.hasAttribute("charge")) {
            String charge = element.getAttribute("charge");
            try {
                kernel.setCharge(Integer.parseInt(charge));
            }
            catch (Throwable t) {
                this.error("ERROR_SPECIE_CHARGE", new String[]{this.modelName, specieId, charge, t.toString()});
            }
        }
        this.readBioUMLAnnotation(element, specie);
        return specie;
    }

    private void readBioUMLAnnotation(Element element, Node node) throws Exception {
        String type;
        boolean needTypeFind = true;
        Specie kernel = (Specie)node.getKernel();
        Element annotationElement = this.getElement(element, "annotation");
        if (annotationElement != null) {
            Element nodeInfoElement = null;
            Element specieInfoElement = null;
            Element bioumlElement = this.getElement(annotationElement, "biouml:BIOUML");
            if (bioumlElement != null) {
                nodeInfoElement = this.getElement(bioumlElement, "biouml:nodeInfo");
                specieInfoElement = this.getElement(bioumlElement, "biouml:specieInfo");
                this.readVariable((Variable)node.getRole(VariableRole.class), bioumlElement);
            } else {
                nodeInfoElement = this.getElement(annotationElement, "biouml:nodeInfo");
                specieInfoElement = this.getElement(annotationElement, "biouml:specieInfo");
            }
            if (nodeInfoElement != null) {
                this.shouldLayout = false;
                DiagramXmlReader.readNodeInfo((Element)nodeInfoElement, (Node)node, (String)this.diagram.getName());
            }
            if (specieInfoElement != null && specieInfoElement.hasAttribute("type")) {
                kernel.setType(specieInfoElement.getAttribute("type"));
                DynamicPropertySet dps = DiagramXmlReader.readDPS((Element)specieInfoElement, null);
                for (DynamicProperty dp : dps) {
                    kernel.getAttributes().add(dp);
                }
                needTypeFind = false;
            }
            this.readAnnotation(annotationElement, (DiagramElement)node);
        }
        if (needTypeFind && (type = SbmlTypeMapper.getInstance().getSpecieType(kernel)) != null) {
            kernel.setType(type);
        }
    }

    public void readVariable(Variable variable, Element element) {
        Element varInfoElement = this.getElement(element, "biouml:variableInfo");
        if (varInfoElement == null) {
            return;
        }
        if (varInfoElement.hasAttribute("comment")) {
            variable.setComment(varInfoElement.getAttribute("comment"));
        }
    }

    protected void readParameterList(Element parent, Node reaction) {
        Element parameterList = this.getElement(parent, "listOfParameters");
        if (!this.isValid("listOfParameters", parameterList, null)) {
            return;
        }
        for (Element element : XmlUtil.elements((Element)parameterList, (String)"parameter")) {
            String parameterId = this.getId(element);
            try {
                this.readParameter(element, parameterId, reaction);
            }
            catch (Throwable t) {
                if (reaction == null) {
                    this.error("ERROR_GLOBAL_PARAMETER_PROCESSING", new String[]{this.modelName, parameterId, t.getMessage()});
                    continue;
                }
                this.error("ERROR_REACTION_PARAMETER_PROCESSING", new String[]{this.modelName, parameterId, reaction.getName(), t.getMessage()});
            }
        }
    }

    public Variable readParameter(Element element, String parameterId, Node reaction) throws Exception {
        Element bioumlElement;
        Element annotationElement;
        String units;
        String baseId = parameterId;
        if (reaction != null) {
            parameterId = reaction.getName() + "_" + parameterId;
        }
        parameterId = this.normalize(parameterId);
        Variable parameter = new Variable(parameterId, (EModel)this.emodel, this.emodel.getVariables());
        if (reaction != null) {
            parameter.getAttributes().add(new DynamicProperty("baseId", String.class, (Object)baseId));
        }
        this.emodel.put(parameter);
        String notes = this.readNotes(element);
        if (notes != null) {
            parameter.setComment(notes);
        }
        if (this.isValid("value", element, parameterId)) {
            String value = element.getAttribute("value");
            try {
                parameter.setInitialValue(SbmlModelReader.parseSBMLDoubleValue(value.replace(',', '.')));
            }
            catch (Throwable t) {
                this.error("ERROR_PARAMETER_VALUE", new String[]{this.modelName, parameterId, value, t.toString()});
            }
        }
        if (!(units = element.getAttribute("units")).isEmpty()) {
            if (!this.emodel.getUnits().containsKey(units)) {
                this.emodel.addUnit(new Unit(null, units));
            }
            parameter.setUnits(units);
        }
        if (element.hasAttribute("name")) {
            parameter.setTitle(element.getAttribute("name"));
        }
        if ((annotationElement = this.getElement(element, "annotation")) != null && (bioumlElement = this.getElement(annotationElement, "biouml:BIOUML")) != null) {
            this.readVariable(parameter, bioumlElement);
        }
        return parameter;
    }

    protected void readReactionList(Element model) {
        Element reactionList = this.getElement(model, "listOfReactions");
        if (!this.isValid("listOfReactions", reactionList, null) || reactionList == null) {
            return;
        }
        for (Element element : XmlUtil.elements((Element)reactionList, (String)"reaction")) {
            String reactionId = "";
            try {
                reactionId = this.getBriefId(element, "biouml:nodeInfo");
                this.readReaction(element, reactionId, this.getTitle(element));
            }
            catch (Throwable t) {
                this.error("ERROR_REACTION_PROCESSING", new String[]{this.modelName, reactionId, t.getMessage()});
            }
        }
    }

    public Node readReaction(Element element, String reactionId, String reactionName) throws Exception {
        Reaction kernel = new Reaction(null, reactionId);
        kernel.setTitle(reactionName);
        ArrayList<SpecieRefenceInfo> specieReferences = new ArrayList<SpecieRefenceInfo>();
        this.readReactants(element, reactionId, specieReferences);
        this.readProducts(element, reactionId, specieReferences);
        this.readModifiers(element, reactionId, specieReferences);
        Diagram parent = null;
        for (SpecieRefenceInfo si : specieReferences) {
            Node n = this.specieMap.get(si.id);
            biouml.model.Compartment c = n.getCompartment();
            if (parent == null) {
                parent = c;
                continue;
            }
            if (parent == c) continue;
            parent = this.diagram;
            break;
        }
        if (parent == null) {
            parent = this.diagram;
        }
        Node reaction = new Node((DataCollection)parent, reactionId, (Base)kernel);
        kernel.setParent((Option)reaction);
        String notes = this.readNotes(element);
        if (notes != null) {
            reaction.setComment(notes);
        }
        if (element.hasAttribute("reversible")) {
            kernel.setReversible("true".equals(element.getAttribute("reversible")));
        } else {
            kernel.setReversible(true);
        }
        if (element.hasAttribute("fast")) {
            kernel.setFast("true".equals(element.getAttribute("fast")));
        }
        for (SpecieRefenceInfo si : specieReferences) {
            try {
                this.readSpecieReference(reaction, si.element, si.id, si.type);
            }
            catch (Exception e) {
                this.error("ERROR_SPECIE_PROCESSING", new String[]{this.modelName, reactionName, si.id, e.getMessage()});
            }
        }
        this.readKineticLaw(element, reaction);
        Element annotationElement = this.getElement(element, "annotation");
        if (annotationElement != null) {
            Element reactionInfoElement;
            this.readBioUMLAnnotation(annotationElement, (DiagramElement)reaction, "biouml:nodeInfo");
            Element bioumlElement = this.getElement(annotationElement, "biouml:BIOUML");
            if (bioumlElement != null && (reactionInfoElement = this.getElement(bioumlElement, "biouml:reactionInfo")) != null) {
                for (DynamicProperty dp : DiagramXmlReader.readDPS((Element)reactionInfoElement, null)) {
                    kernel.getAttributes().add(dp);
                }
            }
            this.readAnnotation(annotationElement, (DiagramElement)reaction);
        }
        this.validateReaction(reaction);
        parent.put((DiagramElement)reaction);
        return reaction;
    }

    protected void readReactants(Element element, String reactionName, List<SpecieRefenceInfo> specieReferences) {
        Element reactantList = this.getElement(element, "listOfReactants");
        if (!this.isValid("listOfReactants", reactantList, reactionName)) {
            return;
        }
        for (Element specieRef : XmlUtil.elements((NodeList)this.getSpecieReference(reactantList))) {
            String specieId = "";
            try {
                specieId = this.sbmlNameToBioUML.get(this.getSpecieAttribute(specieRef));
                specieReferences.add(new SpecieRefenceInfo(specieId, "reactant", specieRef));
            }
            catch (Throwable t) {
                this.error("ERROR_REACTANT_PROCESSING", new String[]{this.modelName, reactionName, specieId, t.getMessage()});
            }
        }
    }

    protected void readProducts(Element element, String reactionName, List<SpecieRefenceInfo> specieReferences) {
        Element productList = this.getElement(element, "listOfProducts");
        if (!this.isValid("listOfProducts", productList, reactionName)) {
            return;
        }
        for (Element specieRef : XmlUtil.elements((NodeList)this.getSpecieReference(productList))) {
            String specieId = "";
            try {
                specieId = this.sbmlNameToBioUML.get(this.getSpecieAttribute(specieRef));
                specieReferences.add(new SpecieRefenceInfo(specieId, "product", specieRef));
            }
            catch (Throwable t) {
                this.error("ERROR_PRODUCT_PROCESSING", new String[]{this.modelName, reactionName, specieId, t.getMessage()});
            }
        }
    }

    protected String createSpecieReferenceId(Element element, Reaction reaction, Node specie, String role) {
        String id = SpecieReference.generateSpecieReferenceName((String)reaction.getName(), (String)specie.getName(), (String)role);
        Diagram d = Diagram.getDiagram((DiagramElement)specie);
        return DefaultSemanticController.generateUniqueName((biouml.model.Compartment)d, (String)id);
    }

    protected Edge readSpecieReference(Node reactionNode, Element element, String specieId, String role) throws Exception {
        String stoichiometry;
        SpecieReference ref;
        String nodeName = SbmlModelReader.getBriefName(specieId);
        if (nodeName.equals("_in_empty_set") || nodeName.equals("_out_empty_set")) {
            return null;
        }
        Node specieNode = this.specieMap.get(specieId);
        if (specieNode == null) {
            this.error("ERROR_SPECIE_REFERENCE_INVALID", new String[]{this.modelName, reactionNode.getName(), specieId});
            return null;
        }
        String fullName = specieNode.getCompleteNameInDiagram();
        Reaction reactionKernel = (Reaction)reactionNode.getKernel();
        String id = "";
        Element annotationElement = this.getElement(element, "annotation");
        if (annotationElement != null) {
            id = this.readEdgeName(annotationElement, "biouml:edgeInfo");
        }
        if (id.isEmpty()) {
            id = this.createSpecieReferenceId(element, reactionKernel, specieNode, role);
        }
        if (reactionKernel.contains(id) && !role.equals("modifier")) {
            ref = reactionKernel.get(id);
            stoichiometry = ref.getStoichiometry();
            if (!stoichiometry.startsWith("-")) {
                stoichiometry = "+" + stoichiometry;
            }
        } else {
            Edge edge;
            SpecieReference ref2 = new SpecieReference((DataCollection)reactionKernel, id, role);
            ref2.setSpecie(fullName);
            if (!role.equals("modifier")) {
                this.readStoichiometry(element, ref2, reactionNode);
            }
            reactionKernel.put(ref2);
            String notes = this.readNotes(element);
            if (notes != null) {
                ref2.setComment(notes);
            }
            Edge edge2 = edge = role.equals("product") ? new Edge(id, (Base)ref2, reactionNode, specieNode) : new Edge(id, (Base)ref2, specieNode, reactionNode);
            if (ref2.isReactantOrProduct()) {
                VariableRole var = (VariableRole)specieNode.getRole(VariableRole.class);
                Equation equation = new Equation((DiagramElement)edge, "rate", var.getName());
                equation.setFast(reactionKernel.isFast());
                edge.setRole((Role)equation);
            }
            if (annotationElement != null) {
                this.readBioUMLAnnotation(annotationElement, (DiagramElement)edge, "biouml:edgeInfo");
                this.readAnnotation(annotationElement, (DiagramElement)edge);
            }
            ref2.setTitle(edge.getTitle());
            edge.save();
            return edge;
        }
        this.readStoichiometry(element, ref, reactionNode);
        ref.setStoichiometry(ref.getStoichiometry() + stoichiometry);
        return null;
    }

    public void setShouldLayout(boolean shouldLayout) {
        this.shouldLayout = shouldLayout;
    }

    protected void readKineticLaw(Element element, Node reaction) {
        Element kineticLawElement;
        Reaction reactionKernel = (Reaction)reaction.getKernel();
        KineticLaw kineticLaw = new KineticLaw(reactionKernel);
        reactionKernel.setKineticLaw(kineticLaw);
        String notes = this.readNotes(element);
        if (notes != null) {
            kineticLaw.setComment(notes);
        }
        if ((kineticLawElement = this.getElement(element, "kineticLaw")) != null) {
            this.readLocalParameterList(kineticLawElement, reaction);
            this.readKineticLawFormula(kineticLawElement, reaction, kineticLaw);
            if (kineticLawElement.hasAttribute("timeUnits")) {
                kineticLaw.setTimeUnits(kineticLawElement.getAttribute("timeUnits"));
            }
            if (kineticLawElement.hasAttribute("substanceUnits")) {
                kineticLaw.setSubstanceUnits(kineticLawElement.getAttribute("substanceUnits"));
            }
        }
        String varName = this.getRateVariableName(reaction.getName());
        this.emodel.put(new Variable(varName, (EModel)this.emodel, this.emodel.getVariables()));
        Equation rule = new Equation((DiagramElement)reaction, "scalar", varName);
        rule.setFast(reactionKernel.isFast());
        reaction.setRole((Role)rule);
    }

    protected void readLocalParameterList(Element parent, Node reaction) {
        Element parameterList = this.getElement(parent, "listOfParameters");
        if (!this.isValid("listOfParameters", parameterList, null) || parameterList == null) {
            return;
        }
        for (Element element : XmlUtil.elements((Element)parameterList, (String)"parameter")) {
            String parameterId = this.getId(element);
            try {
                this.readParameter(element, parameterId, reaction);
            }
            catch (Throwable t) {
                if (reaction == null) {
                    this.error("ERROR_GLOBAL_PARAMETER_PROCESSING", new String[]{this.modelName, parameterId, t.getMessage()});
                    continue;
                }
                this.error("ERROR_REACTION_PARAMETER_PROCESSING", new String[]{this.modelName, parameterId, reaction.getName(), t.getMessage()});
            }
        }
    }

    public void addExtension(String namespace, SbmlExtension extension) {
        if (this.additionalAnnotationsExtensions == null) {
            this.additionalAnnotationsExtensions = new HashMap<String, SbmlExtension>();
        }
        this.additionalAnnotationsExtensions.put(namespace, extension);
    }

    private void readBioUMLAnnotation(Element annotationElement, Diagram diagram) {
        Element viewOptionsElement = null;
        Element bioumlElement = this.getElement(annotationElement, "biouml:BIOUML");
        if (bioumlElement != null) {
            Element simulationElement;
            Element plotsElement = this.getElement(bioumlElement, "biouml:plotInfo");
            if (plotsElement != null) {
                DiagramXmlReader.readPlotsInfo((Element)plotsElement, (Diagram)diagram, (Map)this.newPaths);
            }
            if ((simulationElement = this.getElement(bioumlElement, "biouml:simulationInfo")) != null) {
                DiagramXmlReader.readSimulationOptions((Element)simulationElement, (Diagram)diagram);
            }
            viewOptionsElement = this.getElement(bioumlElement, "biouml:viewOptions");
            Element dbInfo = this.getElement(bioumlElement, "biouml:dbInfo");
            if (dbInfo != null) {
                String species;
                String converter;
                String referenceType;
                String bioHub = dbInfo.getAttribute("bioHub");
                if (!bioHub.isEmpty()) {
                    diagram.getAttributes().add(new DynamicProperty("bioHub", String.class, (Object)bioHub));
                }
                if (!(referenceType = dbInfo.getAttribute("referenceType")).isEmpty()) {
                    diagram.getAttributes().add(new DynamicProperty("referenceType", String.class, (Object)referenceType));
                }
                if (!(converter = dbInfo.getAttribute("converter")).isEmpty()) {
                    diagram.getAttributes().add(new DynamicProperty("converter", String.class, (Object)converter));
                }
                if (!(species = dbInfo.getAttribute("species")).isEmpty()) {
                    diagram.getAttributes().add(new DynamicProperty("species", String.class, (Object)species));
                }
            }
        } else {
            viewOptionsElement = this.getElement(annotationElement, "biouml:viewOptions");
        }
        if (viewOptionsElement != null) {
            DiagramViewOptions viewOptions = diagram.getViewOptions();
            viewOptions.setNotificationEnabled(false);
            viewOptions.setDependencyEdges(Boolean.parseBoolean(viewOptionsElement.getAttribute("dependencyEdges")));
            viewOptions.setAutoLayout(Boolean.parseBoolean(viewOptionsElement.getAttribute("autoLayout")));
            viewOptions.setNotificationEnabled(true);
        }
    }

    protected void readAnnotation(Element element, DiagramElement diagramElement) throws Exception {
        if (this.annotationsExtensions == null) {
            this.annotationsExtensions = new ArrayList<SbmlExtensionHelper>();
            List<SbmlAnnotationRegistry.SbmlAnnotationInfo> annotations = SbmlAnnotationRegistry.getAnnotations();
            if (annotations == null) {
                return;
            }
            for (SbmlAnnotationRegistry.SbmlAnnotationInfo sbmlAnnotationInfo : annotations) {
                SbmlExtension se = sbmlAnnotationInfo.create();
                se.setSbmlModelReader(this);
                this.annotationsExtensions.add(new SbmlExtensionHelper(se, sbmlAnnotationInfo.getNamespace(), sbmlAnnotationInfo.getPriority()));
            }
            if (this.additionalAnnotationsExtensions != null) {
                for (Map.Entry entry : this.additionalAnnotationsExtensions.entrySet()) {
                    this.annotationsExtensions.add(new SbmlExtensionHelper((SbmlExtension)entry.getValue(), (String)entry.getKey(), 100));
                }
            }
            Collections.sort(this.annotationsExtensions, Comparator.comparingInt(h -> h.priority));
        }
        for (Element child : XmlUtil.elements((Element)element)) {
            for (SbmlExtensionHelper ex : this.annotationsExtensions) {
                if (!child.getNodeName().startsWith(ex.namespace)) continue;
                ex.extension.readElement(child, diagramElement, this.diagram);
            }
        }
    }

    protected void readRuleList(Element model) {
        Element ruleList = this.getElement(model, "listOfRules");
        if (ruleList == null || !this.isValid("listOfRules", ruleList, null)) {
            return;
        }
        NodeList list = ruleList.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            try {
                if (list.item(i).getNodeType() != 1) continue;
                this.readRule((Element)list.item(i), i);
                continue;
            }
            catch (Throwable t) {
                this.error("ERROR_RULE_PROCESSING", new String[]{this.modelName, t.getMessage()});
            }
        }
    }

    @Override
    protected boolean parseAsSpecie(String token, StringBuffer result) {
        if (this.specieMap.containsKey(token)) {
            result.append("$" + token);
            return true;
        }
        return false;
    }

    @Override
    protected boolean parseAsCompartment(String token, StringBuffer result) {
        if (this.compartmentMap.containsKey(token)) {
            result.append("$" + token);
            return true;
        }
        return false;
    }

    @Override
    protected boolean parseAsParameter(String token, StringBuffer result, Node reaction) {
        String name;
        EModel model = (EModel)this.diagram.getRole(EModel.class);
        if (model.containsVariable(name = reaction.getName() + "_" + token)) {
            result.append(name);
            return true;
        }
        if (model.containsVariable(token)) {
            result.append(token);
            return true;
        }
        return false;
    }

    public void layout(biouml.model.Compartment compartment) {
        this.diagram.setNotificationEnabled(false);
        this.layout(compartment, 0, 0);
        this.diagram.setNotificationEnabled(true);
    }

    public void layout(biouml.model.Compartment compartment, int x, int y) {
        int nX;
        Rectangle rect = new Rectangle(x, y, 1, 1);
        for (DiagramElement de : compartment) {
            if (!(de instanceof biouml.model.Compartment)) continue;
            biouml.model.Compartment comp = (biouml.model.Compartment)de;
            this.layout(comp, x, y);
            Rectangle r = new Rectangle(comp.getLocation().x, comp.getLocation().y, comp.getShapeSize().width, comp.getShapeSize().height);
            rect = rect.union(r);
            x = rect.x + rect.width + this.layerDeltaX;
        }
        SbmlDiagramViewBuilder diagramViewBuilder = new SbmlDiagramViewBuilder();
        DiagramViewOptions viewOptions = diagramViewBuilder.createDefaultDiagramViewOptions();
        Graphics2D graphics = ApplicationUtils.getGraphics();
        int nodeWidth = 10;
        int nodeHeight = 10;
        ArrayList<DiagramElement> species = new ArrayList<DiagramElement>();
        for (DiagramElement de : compartment) {
            if (!this.isSpecie(de)) continue;
            species.add(de);
            CompositeView view = diagramViewBuilder.createNodeView((Node)de, viewOptions, graphics);
            de.setView((View)view);
            Rectangle bounds = view.getBounds();
            nodeWidth = Math.max(nodeWidth, bounds.width);
            nodeHeight = Math.max(nodeHeight, bounds.height);
        }
        int n = species.size();
        int nY = n / (nX = Math.max((int)Math.sqrt(n) + 1, rect.width / (nodeWidth + this.layerDeltaX)));
        if (nY * nX != n) {
            ++nY;
        }
        for (int k = 0; k < nY && n > 0; ++k) {
            y = rect.y + rect.height + (this.layerDeltaY + nodeHeight) * k;
            for (int m = 0; m < nX && m + nX * k < n; ++m) {
                Node node = (Node)species.get(m + nX * k);
                Rectangle bounds = node.getView().getBounds();
                x = rect.x + (nodeWidth + this.layerDeltaX) * m;
                node.setLocation(x += (nodeWidth - bounds.width) / 2, y);
                node.getView().setLocation(x, y);
            }
        }
        for (DiagramElement de : compartment) {
            if (!this.isReaction(de)) continue;
            diagramViewBuilder.locateReaction((Node)de, viewOptions, graphics);
        }
        x = rect.x;
        y = rect.y;
        int width = this.layerDeltaX;
        int height = this.layerDeltaY;
        if (n > 0) {
            int dx = (nodeWidth + this.layerDeltaX) * nX - nodeWidth;
            int dy = (nodeHeight + this.layerDeltaY) * nY;
            width += dx;
            height += dy - nodeHeight;
        }
        if (rect.width > 1) {
            width += rect.width;
            height += rect.height;
        }
        compartment.setLocation(x, y);
        if (compartment instanceof SubDiagram) {
            width = Math.max(width, 296);
            height = Math.max(height, 140);
        }
        compartment.setShapeSize(new Dimension(width, height));
    }

    public boolean isSpecie(DiagramElement de) {
        return de instanceof Node && !(de instanceof biouml.model.Compartment) && de.getKernel() != null && !de.getKernel().getType().equals("reaction");
    }

    public boolean isReaction(DiagramElement de) {
        return de instanceof Node && de.getKernel() instanceof Reaction;
    }

    public String getRateVariableName(String reactionID) {
        return "$$rate_" + reactionID;
    }

    public Unit readUnitDefinition(Element element, String unitId, String unitTitle) throws Exception {
        Unit unit = new Unit(null, unitId);
        unit.setTitle(unitTitle);
        Element unitDefinitionList = this.getElement(element, "listOfUnits");
        if (unitDefinitionList == null) {
            return unit;
        }
        NodeList list = unitDefinitionList.getElementsByTagName("unit");
        ArrayList<BaseUnit> baseUnitsList = new ArrayList<BaseUnit>();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            String baseUnitId = "";
            try {
                Element baseUnitElement = (Element)list.item(i);
                baseUnitId = this.getId(baseUnitElement);
                BaseUnit baseUnit = new BaseUnit();
                baseUnit.setUnitId(unitId);
                if (baseUnitElement.hasAttribute("kind")) {
                    baseUnit.setType(baseUnitElement.getAttribute("kind"));
                }
                if (baseUnitElement.hasAttribute("scale")) {
                    baseUnit.setScale(Integer.parseInt(baseUnitElement.getAttribute("scale")));
                }
                if (baseUnitElement.hasAttribute("exponent")) {
                    baseUnit.setExponent(Integer.parseInt(baseUnitElement.getAttribute("exponent")));
                }
                if (baseUnitElement.hasAttribute("multiplier")) {
                    baseUnit.setMultiplier(Double.parseDouble(baseUnitElement.getAttribute("multiplier")));
                }
                baseUnitsList.add(baseUnit);
                continue;
            }
            catch (Throwable t) {
                this.error("ERROR_UNIT_PROCESSING", new String[]{this.modelName, baseUnitId, t.getMessage()});
            }
        }
        if (baseUnitsList.size() > 0) {
            unit.setBaseUnits(baseUnitsList.toArray(new BaseUnit[baseUnitsList.size()]));
        }
        return unit;
    }

    protected Map<String, String> createReplacements(Element element) {
        HashSet<String> ids = new HashSet<String>();
        this.readIds(element, ids);
        HashMap<String, String> result = new HashMap<String, String>();
        for (String id : ids) {
            if (!this.isForbidden(id)) continue;
            String newId = SbmlModelReader.generateName(id, "_", parserConstants, ids);
            result.put(id, newId);
        }
        return result;
    }

    protected String checkReplacement(String id) {
        String result = this.replacements.get(id);
        return result == null ? id : result;
    }

    private boolean isForbidden(String name) {
        return parserConstants.contains(name);
    }

    protected String normalize(String name) {
        if (this.emodel.containsConstant(name)) {
            return name + "_CONFLICTS_WITH_CONSTANT_";
        }
        if (name.equals("time")) {
            return "_CONFLICTS_WITH_TIME_";
        }
        return this.checkReplacement(name);
    }

    public static String generateName(String baseName, String suffix, Set<String> forbidden, Set<String> existing) {
        String name = baseName;
        while (forbidden.contains(name) || existing.contains(name)) {
            name = name + suffix;
        }
        return name;
    }

    protected static class SpecieRefenceInfo {
        String id;
        String type;
        Element element;

        public SpecieRefenceInfo(String id, String referenceType, Element element) {
            this.id = id;
            this.type = referenceType;
            this.element = element;
        }
    }

    public static class SpecificalHashMap
    extends HashMap {
        @Override
        public boolean containsKey(Object key) {
            boolean result = super.containsKey(key);
            if (!result) {
                for (Object obj : this.keySet()) {
                    if (!obj.toString().endsWith("/" + key.toString())) continue;
                    return true;
                }
            }
            return result;
        }

        @Override
        public Object get(Object key) {
            Object result = super.get(key);
            if (result == null) {
                for (Object obj : this.keySet()) {
                    if (!obj.toString().endsWith("/" + key.toString())) continue;
                    return super.get(obj);
                }
            }
            return result;
        }
    }

    class SbmlVariableResolver
    implements VariableResolver {
        protected DiagramElement diagramElement;

        SbmlVariableResolver() {
        }

        public String getVariableName(String variableTitle) {
            String vName;
            String name;
            if (variableTitle.equals("time")) {
                return variableTitle;
            }
            if (this.diagramElement instanceof Node && this.diagramElement.getKernel() != null && this.diagramElement.getKernel().getType().equals("reaction") && SbmlModelReader.this.emodel.containsVariable(name = this.diagramElement.getName() + "_" + variableTitle)) {
                return SbmlModelReader.this.emodel.getVariable(name).getName();
            }
            String fullName = SbmlModelReader.this.sbmlNameToBioUML.get(variableTitle);
            if (fullName == null) {
                fullName = variableTitle;
            }
            if (!(vName = fullName).equals(variableTitle)) {
                String cName = "$\"" + vName + "\"";
                if (SbmlModelReader.this.emodel.containsVariable(cName)) {
                    return SbmlModelReader.this.emodel.getVariable(cName).getName();
                }
            } else {
                vName = SbmlSupport.getBriefName(vName);
            }
            if (SbmlModelReader.this.specieMap.containsKey(fullName)) {
                return ((VariableRole)SbmlModelReader.this.specieMap.get(fullName).getRole(VariableRole.class)).getName();
            }
            if (SbmlModelReader.this.compartmentMap.containsKey(fullName)) {
                return ((VariableRole)SbmlModelReader.this.compartmentMap.get(fullName).getRole(VariableRole.class)).getName();
            }
            if (SbmlModelReader.this.emodel.containsVariable(fullName)) {
                return SbmlModelReader.this.emodel.getVariable(fullName).getName();
            }
            String rateVariableName = SbmlModelReader.this.getRateVariableName(vName);
            if (SbmlModelReader.this.emodel.containsVariable(rateVariableName)) {
                return SbmlModelReader.this.emodel.getVariable(rateVariableName).getName();
            }
            return null;
        }

        public String resolveVariable(String variableName) {
            return variableName;
        }
    }

    public static class SbmlExtensionHelper {
        protected SbmlExtension extension;
        protected String namespace;
        protected Integer priority;

        public SbmlExtensionHelper(SbmlExtension extension, String namespace, Integer priority) {
            this.extension = extension;
            this.namespace = namespace;
            this.priority = priority;
        }
    }
}

