/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Diagram;
import biouml.model.DiagramType;
import biouml.plugins.sbgn.SbgnDiagramType;
import biouml.plugins.sbml.MessageBundle;
import biouml.plugins.sbml.SbmlDiagramType;
import biouml.plugins.sbml.SbmlDiagramType_L1;
import biouml.plugins.sbml.SbmlDiagramType_L2;
import biouml.plugins.sbml.SbmlDiagramType_L2v2;
import biouml.plugins.sbml.SbmlDiagramType_L2v3;
import biouml.plugins.sbml.SbmlDiagramType_L2v4;
import biouml.plugins.sbml.SbmlDiagramType_L3v1;
import biouml.plugins.sbml.SbmlDiagramType_L3v2;
import biouml.plugins.sbml.SbmlModelReader;
import biouml.plugins.sbml.SbmlModelReader_11;
import biouml.plugins.sbml.SbmlModelReader_12;
import biouml.plugins.sbml.SbmlModelReader_21;
import biouml.plugins.sbml.SbmlModelReader_22;
import biouml.plugins.sbml.SbmlModelReader_23;
import biouml.plugins.sbml.SbmlModelReader_24;
import biouml.plugins.sbml.SbmlModelReader_25;
import biouml.plugins.sbml.SbmlModelReader_31;
import biouml.plugins.sbml.SbmlModelReader_32;
import biouml.plugins.sbml.SbmlModelWriter;
import biouml.plugins.sbml.SbmlModelWriter_11;
import biouml.plugins.sbml.SbmlModelWriter_21;
import biouml.plugins.sbml.SbmlModelWriter_22;
import biouml.plugins.sbml.SbmlModelWriter_23;
import biouml.plugins.sbml.SbmlModelWriter_24;
import biouml.plugins.sbml.SbmlModelWriter_31;
import biouml.plugins.sbml.SbmlModelWriter_32;
import biouml.plugins.sbml.composite.SbmlCompositeDiagramType;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.exception.InternalException;
import ru.biosoft.util.ApplicationUtils;

public class SbmlModelFactory {
    protected static final Logger log = Logger.getLogger(SbmlModelFactory.class.getName());

    public static SbmlModelReader getReader(Document document) {
        Element root = document.getDocumentElement();
        String level = root.getAttribute("level");
        String version = root.getAttribute("version");
        SbmlModelReader reader = null;
        if ("1".equals(level)) {
            reader = "1".equals(version) ? new SbmlModelReader_11() : new SbmlModelReader_12();
        } else if ("2".equals(level)) {
            if ("1".equals(version)) {
                reader = new SbmlModelReader_21();
            } else if ("2".equals(version)) {
                reader = new SbmlModelReader_22();
            } else if ("3".equals(version)) {
                reader = new SbmlModelReader_23();
            } else if ("4".equals(version)) {
                reader = new SbmlModelReader_24();
            } else if ("5".equals(version)) {
                reader = new SbmlModelReader_25();
            }
        } else if ("3".equals(level)) {
            if ("1".equals(version)) {
                reader = new SbmlModelReader_31();
            } else if ("2".equals(version)) {
                reader = new SbmlModelReader_32();
            }
        }
        return reader;
    }

    private static void showError(Document doc, String name) {
        Element root = doc.getDocumentElement();
        String level = root.getAttribute("level");
        String version = root.getAttribute("version");
        MessageBundle.error(log, "ERROR_READ_UNKNOWN_LEVEL_VERSION", new String[]{name, level, version});
    }

    public static Diagram readDiagram(Document document, String name, DataCollection origin, String diagramName, Map<String, String> newPaths) throws Exception {
        SbmlModelReader reader = SbmlModelFactory.getReader(document);
        if (reader == null) {
            SbmlModelFactory.showError(document, name);
            return null;
        }
        String dname = diagramName != null ? diagramName : name;
        reader.setNewPaths(newPaths);
        return reader.read(document, dname, origin);
    }

    public static Diagram readDiagram(File file, DataCollection origin, String diagramName) throws Exception {
        String name = ApplicationUtils.getFileNameWithoutExtension((String)file.getName());
        return SbmlModelFactory.readDiagram(file, name, origin, diagramName);
    }

    public static Diagram readDiagram(File file, DataCollection origin, String diagramName, Map<String, String> newPaths) throws Exception {
        String name = ApplicationUtils.getFileNameWithoutExtension((String)file.getName());
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        return SbmlModelFactory.readDiagram(document, name, origin, diagramName, newPaths);
    }

    public static Diagram readDiagram(String filePath, boolean layout) throws Exception {
        File f = new File(filePath);
        String name = ApplicationUtils.getFileNameWithoutExtension((String)f.getName());
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
        SbmlModelReader reader = SbmlModelFactory.getReader(document);
        reader.setShouldLayout(layout);
        return reader.read(document, name, null);
    }

    public static Diagram readDiagram(File file, String name, DataCollection origin, String diagramName) throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        return SbmlModelFactory.readDiagram(document, name, origin, diagramName, null);
    }

    public static Document createDOM(Diagram diagram) throws Exception {
        return SbmlModelFactory.createDOM(diagram, null);
    }

    public static Document createDOM(Diagram diagram, SbmlModelWriter writer) throws Exception {
        if (diagram == null) {
            MessageBundle.error(log, "ERROR_DIAGRAM_NULL", new String[0]);
            throw new NullPointerException(MessageBundle.resources.getResourceString("ERROR_DIAGRAM_NULL"));
        }
        if (writer == null) {
            writer = SbmlModelFactory.getWriter(diagram);
        }
        return writer.createDOM(diagram);
    }

    public static void writeDiagram(File file, Diagram sourceDiagram) throws Exception {
        SbmlModelFactory.writeDiagram(file, sourceDiagram, null);
    }

    public static void writeDiagram(File file, Diagram sourceDiagram, SbmlModelWriter writer) throws Exception {
        Document document = SbmlModelFactory.createDOM(sourceDiagram, writer);
        if (document != null) {
            SbmlModelFactory.writeDiagram(file, document);
        }
    }

    public static void writeDiagram(File file, Document document) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(document);
        try (FileOutputStream os = new FileOutputStream(file);){
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
    }

    @Nonnull
    public static SbmlModelWriter getWriter(Diagram diagram) {
        SbmlModelWriter writer = null;
        DiagramType type = diagram.getType();
        if (type instanceof SbmlDiagramType_L3v2 || type instanceof SbmlCompositeDiagramType || type instanceof SbgnDiagramType) {
            writer = new SbmlModelWriter_32();
        } else if (type instanceof SbmlDiagramType_L3v1) {
            writer = new SbmlModelWriter_31();
        } else if (type instanceof SbmlDiagramType_L2v4) {
            writer = new SbmlModelWriter_24();
        } else if (type instanceof SbmlDiagramType_L2v3) {
            writer = new SbmlModelWriter_23();
        } else if (type instanceof SbmlDiagramType_L2v2) {
            writer = new SbmlModelWriter_22();
        } else if (type instanceof SbmlDiagramType_L2) {
            writer = new SbmlModelWriter_21();
        } else if (type instanceof SbmlDiagramType) {
            writer = new SbmlModelWriter_32();
        } else if (type instanceof SbmlDiagramType_L1) {
            writer = new SbmlModelWriter_11();
        }
        if (writer == null) {
            throw new InternalException("Unsupported diagram type passed to SbmlModelFactory: " + diagram.getType() + " (diagram: " + diagram.getCompletePath() + ")");
        }
        return writer;
    }
}

