/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Diagram;
import biouml.model.DiagramImporter;
import biouml.model.Module;
import biouml.plugins.sbml.MessageBundle;
import biouml.plugins.sbml.SbmlConstants;
import biouml.plugins.sbml.SbmlModelFactory;
import biouml.plugins.sbml.converters.SBGNConverterNew;
import biouml.standard.type.DiagramInfo;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.FolderCollection;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.util.bean.BeanInfoEx2;

public class SbmlImporter
extends DiagramImporter {
    protected static final Logger log = Logger.getLogger(SbmlImporter.class.getName());
    private SbmlImportProperties properties;

    protected int getAcceptPriority() {
        return 11;
    }

    public int accept(DataCollection parent, File file) {
        if (DataCollectionUtils.isAcceptable((DataCollection)parent, Diagram.class)) {
            return file == null ? this.getAcceptPriority() : this.accept(file);
        }
        if (!(parent instanceof Module || parent instanceof Diagram || parent.getName().equalsIgnoreCase("Diagrams") && parent.isMutable())) {
            return 0;
        }
        Module module = Module.optModule((DataElement)parent);
        if (module == null) {
            return 0;
        }
        if (!this.moduleType.isInstance(module.getType())) {
            return 0;
        }
        return file == null ? this.getAcceptPriority() : this.accept(file);
    }

    public int accept(File file) {
        try {
            String header = ApplicationUtils.readAsString((File)file, (int)2000);
            int iXml = header.indexOf("<?xml");
            if (iXml == -1) {
                return 0;
            }
            if (!header.substring(iXml, iXml + 100 > header.length() ? header.length() : iXml + 100).matches("(\\s)*<\\?xml(\\s)*version(\\s)*=(.|\\s)*")) {
                return 0;
            }
            int start = header.indexOf("<sbml");
            int end = header.indexOf(">", start);
            if (start == -1 || end == -1) {
                return 0;
            }
            String str = header.substring(start, end);
            if (SbmlImporter.checkSBMLVersion(str, log)) {
                return this.getAcceptPriority();
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "accept error :", t);
        }
        return 0;
    }

    public static boolean checkSBMLVersion(String str, Logger logger) {
        int level = SbmlImporter.getAttrValue(str, " level");
        int version = SbmlImporter.getAttrValue(str, " version");
        String format = "L" + level + "V" + version;
        List<String> formats = Arrays.asList(SbmlConstants.SBML_SUPPORTED_FORMATS);
        if (formats.contains(format)) {
            logger.info("Autodetect, SBML level " + level + " version " + version);
            return true;
        }
        return false;
    }

    protected static int getAttrValue(String str, String attr) {
        int ind = str.indexOf(attr);
        if (ind != -1 && (ind = str.indexOf("\"", ind + attr.length())) != -1 && (ind = (str = str.substring(ind + 1).trim()).indexOf("\"")) != -1) {
            return Integer.parseInt(str.substring(0, ind));
        }
        return -1;
    }

    public DataElement doImport(@Nonnull DataCollection parent, @Nonnull File file, String diagramName, FunctionJobControl jobControl, Logger log) throws Exception {
        DataCollection actualParent = null;
        if ((parent = DataCollectionUtils.fetchPrimaryCollection((DataCollection)parent, (int)4)) instanceof FolderCollection && parent.isAcceptable(Diagram.class)) {
            actualParent = parent;
        } else {
            Module module;
            Module module2 = module = parent instanceof Module ? (Module)parent : Module.optModule((DataElement)parent);
            if (module != null) {
                actualParent = (DataCollection)module.get("Diagrams");
            }
        }
        if (jobControl == null) {
            return this.doImport(actualParent, file, diagramName);
        }
        jobControl.functionStarted();
        DataElement de = this.doImport(actualParent, file, diagramName);
        if (jobControl.getStatus() != 4 && jobControl.getStatus() != 5) {
            jobControl.setPreparedness(100);
            jobControl.functionFinished();
        }
        return de;
    }

    public DataElement doImport(Module module, File file, String diagramName) throws Exception {
        DataCollection origin = (DataCollection)module.get("Diagrams");
        return this.doImport(origin, file, diagramName);
    }

    protected DataElement doImport(DataCollection<?> origin, File file, String diagramName) throws Exception {
        if (this.properties != null) {
            diagramName = this.properties.getDiagramName();
        }
        Diagram diagram = SbmlModelFactory.readDiagram(file, origin, diagramName, this.newPaths);
        Object sbgnDiagramObj = diagram.getAttributes().getValue("sbgn_diagram");
        Diagram sbgnDiagram = null;
        if (sbgnDiagramObj instanceof Diagram) {
            sbgnDiagram = (Diagram)sbgnDiagramObj;
            ((DiagramInfo)sbgnDiagram.getKernel()).setDatabaseReferences(((DiagramInfo)diagram.getKernel()).getDatabaseReferences());
            ((DiagramInfo)sbgnDiagram.getKernel()).setLiteratureReferences(((DiagramInfo)diagram.getKernel()).getLiteratureReferences());
        } else {
            sbgnDiagram = SBGNConverterNew.convert(diagram);
        }
        sbgnDiagram.getAttributes().add(new DynamicProperty("baseDiagramType", String.class, (Object)diagram.getType().getClass().getName()));
        diagram = sbgnDiagram;
        diagram.getViewOptions().setAutoLayout(this.properties == null || this.properties.enableAutoLayout);
        origin.put((DataElement)diagram);
        return diagram;
    }

    public SbmlImportProperties getProperties(DataCollection parent, File file, String elementName) {
        this.properties = new SbmlImportProperties(elementName);
        return this.properties;
    }

    protected boolean isComposite(Diagram diagram) {
        Object packageNames = diagram.getAttributes().getValue("Packages");
        return packageNames instanceof String[] && StreamEx.of((Object[])((String[])packageNames)).has((Object)"comp");
    }

    public static class SbmlImportPropertiesBeanInfo
    extends BeanInfoEx2<SbmlImportProperties> {
        public SbmlImportPropertiesBeanInfo() {
            super(SbmlImportProperties.class, MessageBundle.class.getName());
        }

        public void initProperties() throws Exception {
            this.add("diagramName");
            this.add("enableAutoLayout");
        }
    }

    @PropertyName(value="Import properties")
    @PropertyDescription(value="Import properties.")
    public static class SbmlImportProperties
    extends Option {
        protected boolean enableAutoLayout = true;
        protected String diagramName;

        public SbmlImportProperties(String name) {
            this.diagramName = name;
        }

        @PropertyName(value="Enable Autolayout")
        @PropertyDescription(value="Enable automatic edges layout. Is not recommended for large diagrams.")
        public boolean isEnableAutoLayout() {
            return this.enableAutoLayout;
        }

        public void setEnableAutoLayout(boolean enableAutoLayout) {
            this.enableAutoLayout = enableAutoLayout;
        }

        @PropertyName(value="Diagram name")
        @PropertyDescription(value="Diagram name.")
        public String getDiagramName() {
            return this.diagramName;
        }

        public void setDiagramName(String diagramName) {
            this.diagramName = diagramName;
        }
    }
}

