/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Diagram;
import biouml.model.DiagramContainer;
import biouml.model.DiagramExporter;
import biouml.model.DiagramType;
import biouml.plugins.sbgn.SbgnCompositeDiagramType;
import biouml.plugins.sbgn.SbgnDiagramType;
import biouml.plugins.sbgn.SbgnDiagramTypeConverter;
import biouml.plugins.sbml.SbmlDiagramType;
import biouml.plugins.sbml.SbmlDiagramType_L2;
import biouml.plugins.sbml.SbmlDiagramType_L2v2;
import biouml.plugins.sbml.SbmlDiagramType_L2v3;
import biouml.plugins.sbml.SbmlDiagramType_L2v4;
import biouml.plugins.sbml.SbmlDiagramType_L3v1;
import biouml.plugins.sbml.SbmlDiagramType_L3v2;
import biouml.plugins.sbml.SbmlModelFactory;
import biouml.plugins.sbml.SbmlModelWriter;
import biouml.plugins.sbml.SbmlUtil;
import biouml.plugins.sbml.converters.SBGNConverterNew;
import biouml.plugins.sbml.converters.SbmlConverter;
import biouml.standard.diagram.CompositeDiagramType;
import biouml.standard.diagram.CompositeModelPreprocessor;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.MathDiagramType;
import biouml.standard.diagram.PathwaySimulationDiagramType;
import biouml.standard.state.State;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.util.bean.BeanInfoEx2;
import ru.biosoft.workbench.editors.GenericComboBoxEditor;

public class SbmlExporter
extends DiagramExporter {
    protected SbmlExportProperties properties = null;
    protected Map<String, String> newPaths;

    public boolean accept(Diagram diagram) {
        DiagramType diagramType = diagram.getType();
        return diagramType instanceof SbmlDiagramType || diagramType instanceof SbgnDiagramType || diagramType instanceof PathwaySimulationDiagramType || diagramType instanceof CompositeDiagramType;
    }

    public void doExport(@Nonnull Diagram diagram, @Nonnull File file) throws Exception {
        Class<SbmlDiagramType_L3v2> type;
        State st;
        String stName;
        DiagramType diagramType = diagram.getType();
        if (this.properties != null && !(stName = this.properties.getCurrentState()).equals("<default>") && (st = diagram.getState(stName)) != null) {
            diagram.setStateEditingMode(st);
        }
        Diagram diagramToExport = diagram;
        if (MathDiagramType.class.isAssignableFrom(diagramType.getClass()) || CompositeDiagramType.class.isAssignableFrom(diagramType.getClass())) {
            diagramToExport = new SbgnDiagramTypeConverter().convert(diagramToExport, SbgnCompositeDiagramType.class);
            diagramType = diagramToExport.getType();
        }
        if (diagramType instanceof SbgnCompositeDiagramType) {
            if (this.properties != null) {
                if (this.properties.transformToPlain) {
                    diagramToExport = new CompositeModelPreprocessor().preprocess(diagramToExport, null, diagramToExport.getName());
                } else if (this.properties.inlineModels) {
                    diagramToExport = diagramToExport.clone(diagramToExport.getOrigin(), diagramToExport.getName());
                    SbmlUtil.inlineModelDefinitions(diagramToExport);
                }
            }
            diagramToExport.removeAllStates();
            Diagram sbmlDiagram = SBGNConverterNew.restore(diagramToExport);
            if (this.properties != null && this.properties.isSaveBioUMLAnnotation()) {
                sbmlDiagram.getAttributes().add(new DynamicProperty("sbgn_diagram", Diagram.class, (Object)diagramToExport));
            } else {
                this.removeSBGN(sbmlDiagram);
            }
            SbmlModelWriter writer = SbmlModelFactory.getWriter(sbmlDiagram);
            writer.setNewPaths(this.newPaths);
            writer.setWriteBioUMLAnnotation(this.properties.isSaveBioUMLAnnotation());
            SbmlModelFactory.writeDiagram(file, sbmlDiagram, writer);
            return;
        }
        Class clazz = type = this.properties != null ? this.properties.getDiagramType() : SbmlDiagramType_L3v2.class;
        if (this.properties != null && this.properties.isSaveBioUMLAnnotation()) {
            if (diagramType instanceof SbgnDiagramType) {
                diagramToExport = new SBGNConverterNew().restoreSBML(diagramToExport, (DiagramType)type.newInstance());
                diagramToExport.getAttributes().add(new DynamicProperty("sbgn_diagram", Diagram.class, (Object)diagram));
            } else if (diagramType instanceof SbmlDiagramType) {
                SBGNConverterNew converter = new SBGNConverterNew();
                Diagram sbgnDiagram = converter.convert(diagramToExport, null);
                converter.appendPorts(diagram, sbgnDiagram);
                diagramToExport.getAttributes().add(new DynamicProperty("sbgn_diagram", Diagram.class, (Object)sbgnDiagram));
            } else if (!diagramType.getClass().equals(type)) {
                diagramToExport = diagram.clone(diagram.getOrigin(), diagram.getName());
                diagramToExport.removeAllStates();
                diagramToExport = new SbmlConverter().convert(diagramToExport, type);
            }
        } else if (diagram.getType() instanceof SbmlDiagramType) {
            diagramToExport = diagramType.getClass().equals(type) ? diagram : new SbmlConverter().convert(diagram, type);
        } else if (diagram.getType() instanceof SbgnDiagramType) {
            diagramToExport = SBGNConverterNew.restore(diagram);
            if (!diagramToExport.getType().getClass().equals(type)) {
                diagramToExport = new SbmlConverter().convert(diagramToExport, type);
            }
        } else {
            diagramToExport = diagram.clone(diagram.getOrigin(), diagram.getName());
            diagramToExport.removeAllStates();
            new SbmlConverter().convert(diagramToExport, type);
        }
        SbmlModelWriter writer = SbmlModelFactory.getWriter(diagramToExport);
        writer.setNewPaths(this.newPaths);
        if (this.properties != null) {
            writer.setWriteBioUMLAnnotation(this.properties.isSaveBioUMLAnnotation());
        }
        SbmlModelFactory.writeDiagram(file, diagramToExport, writer);
        diagram.restore();
    }

    protected void removeSBGN(Diagram diagram) {
        for (DiagramContainer node : diagram.stream(DiagramContainer.class)) {
            Diagram innerDiagram = node.getDiagram();
            innerDiagram.getAttributes().remove("sbgn_diagram");
            innerDiagram.removeAllStates();
            this.removeSBGN(innerDiagram);
        }
    }

    public boolean init(String format, String suffix) {
        return true;
    }

    public Object getProperties(DataElement de, File file) {
        this.properties = new SbmlExportProperties((Diagram)de);
        return this.properties;
    }

    public void setNewPaths(Map<String, String> newPaths) {
        this.newPaths = newPaths;
    }

    public static class LevelEditor
    extends GenericComboBoxEditor {
        protected Object[] getAvailableValues() {
            return ((SbmlExportProperties)((Object)this.getBean())).getPossibleLevels();
        }
    }

    public static class MethodEditor
    extends GenericComboBoxEditor {
        protected Object[] getAvailableValues() {
            return ((SbmlExportProperties)((Object)this.getBean())).getPossibleStates();
        }
    }

    public static class SbmlExportPropertiesBeanInfo
    extends BeanInfoEx2<SbmlExportProperties> {
        public SbmlExportPropertiesBeanInfo() {
            super(SbmlExportProperties.class);
        }

        public void initProperties() throws Exception {
            this.add("level", LevelEditor.class);
            this.add("currentState");
            this.add("saveBioUMLAnnotation");
            this.addHidden("transformToPlain", "isNotComposite");
            this.addHidden("inlineModels", "isNotComposite");
        }
    }

    @PropertyName(value="Export properties")
    @PropertyDescription(value="Export properties.")
    public static class SbmlExportProperties
    extends Option {
        public static final String NO_STATE = "<default>";
        private static final LinkedHashMap<String, Class<? extends SbmlDiagramType>> nameToType = new LinkedHashMap();
        protected boolean transformToPlain = false;
        protected boolean saveBioUMLAnnotation = true;
        protected boolean useSbgnNotation = true;
        protected String[] possibleStates;
        protected String currentState;
        protected String level = "level 3 version 2";
        protected boolean isNotComposite;
        protected boolean inlineModels;

        public SbmlExportProperties(Diagram diagram) {
            List states = diagram.getStateNames();
            states.add(NO_STATE);
            this.possibleStates = states.toArray(new String[states.size()]);
            this.currentState = this.possibleStates[0];
            this.isNotComposite = !DiagramUtility.isComposite((Diagram)diagram);
        }

        public Object[] getPossibleLevels() {
            return nameToType.keySet().toArray();
        }

        public Class<? extends SbmlDiagramType> getDiagramType() {
            return nameToType.get(this.level);
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        @PropertyName(value="Transform to plain")
        @PropertyDescription(value="Transform composite model to plain before export.")
        public boolean isTransformToPlain() {
            return this.transformToPlain;
        }

        public void setTransformToPlain(boolean transformToPlain) {
            boolean oldValue = this.transformToPlain;
            this.transformToPlain = transformToPlain;
            if (transformToPlain) {
                this.inlineModels = false;
            }
            this.firePropertyChange("transformToPlain", oldValue, transformToPlain);
        }

        @PropertyName(value="BioUML annotation")
        @PropertyDescription(value="Save BioUML annotation.")
        public boolean isSaveBioUMLAnnotation() {
            return this.saveBioUMLAnnotation;
        }

        public void setSaveBioUMLAnnotation(boolean saveBioUMLAnnotation) {
            boolean oldValue = this.saveBioUMLAnnotation;
            this.saveBioUMLAnnotation = saveBioUMLAnnotation;
            this.firePropertyChange("saveBioUMLAnnotation", oldValue, saveBioUMLAnnotation);
        }

        @PropertyName(value="Inline submodels")
        @PropertyDescription(value="Include all external submodels as model definitions.")
        public boolean isInlineModels() {
            return this.inlineModels;
        }

        public void setInlineModels(boolean inlineModels) {
            boolean oldValue = this.inlineModels;
            this.inlineModels = inlineModels;
            if (inlineModels) {
                this.transformToPlain = false;
            }
            this.firePropertyChange("transformToPlain", oldValue, this.transformToPlain);
        }

        public String[] getPossibleStates() {
            return this.possibleStates;
        }

        @PropertyName(value="State")
        @PropertyDescription(value="State of diagram to export.")
        public String getCurrentState() {
            return this.currentState;
        }

        public void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        public boolean isNotComposite() {
            return this.isNotComposite;
        }

        static {
            nameToType.put("level 3 version 2", SbmlDiagramType_L3v2.class);
            nameToType.put("level 3 version 1", SbmlDiagramType_L3v1.class);
            nameToType.put("level 2 version 4", SbmlDiagramType_L2v4.class);
            nameToType.put("level 2 version 3", SbmlDiagramType_L2v3.class);
            nameToType.put("level 2 version 2", SbmlDiagramType_L2v2.class);
            nameToType.put("level 2 version 1", SbmlDiagramType_L2.class);
        }
    }
}

