/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Diagram;
import biouml.model.DiagramViewOptions;
import biouml.plugins.sbgn.SbgnDiagramType;
import biouml.plugins.sbml.SbmlModelFactory;
import biouml.plugins.sbml.converters.SBGNConverterNew;
import biouml.standard.type.DiagramInfo;
import com.developmentontheedge.beans.DynamicProperty;
import java.beans.PropertyDescriptor;
import java.io.File;
import ru.biosoft.access.AbstractFileTransformer;
import ru.biosoft.access.FileDataElement;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.generic.PriorityTransformer;
import ru.biosoft.graph.PathLayouterWrapper;
import ru.biosoft.util.bean.StaticDescriptor;

public class SbmlDiagramTransformer
extends AbstractFileTransformer<Diagram>
implements PriorityTransformer {
    public static final String BASE_DIAGRAM_TYPE = "baseDiagramType";
    protected static final PropertyDescriptor BASE_DIAGRAM_TYPE_PD = StaticDescriptor.createReadOnly((String)"baseDiagramType");

    public Class<Diagram> getOutputType() {
        return Diagram.class;
    }

    public Diagram getDiagramToWrite(Diagram diagram) throws Exception {
        if (diagram.getType() instanceof SbgnDiagramType) {
            Diagram sbmlDiagram = SBGNConverterNew.restore(diagram);
            sbmlDiagram.getAttributes().add(new DynamicProperty("sbgn_diagram", Diagram.class, (Object)diagram));
            return sbmlDiagram;
        }
        return diagram;
    }

    public int getInputPriority(Class<? extends DataElement> inputClass, DataElement de) {
        if (FileDataElement.class.isAssignableFrom(inputClass) && de instanceof Diagram && ((Diagram)de).getType() instanceof SbgnDiagramType) {
            return 12;
        }
        return 0;
    }

    public Diagram load(File input, String name, DataCollection<Diagram> origin) throws Exception {
        Diagram diagram = SbmlModelFactory.readDiagram(input, name, origin, null);
        Object sbgnDiagramObj = diagram.getAttributes().getValue("sbgn_diagram");
        if (!(sbgnDiagramObj instanceof Diagram)) {
            sbgnDiagramObj = SBGNConverterNew.convert(diagram);
        }
        Diagram sbgnDiagram = (Diagram)sbgnDiagramObj;
        this.copyProperties(diagram, sbgnDiagram);
        sbgnDiagram.getAttributes().add(new DynamicProperty(BASE_DIAGRAM_TYPE_PD, String.class, (Object)diagram.getType().getClass().getName()));
        return sbgnDiagram;
    }

    private void copyProperties(Diagram sbmlDiagram, Diagram sbgnDiagram) {
        ((DiagramInfo)sbgnDiagram.getKernel()).setDatabaseReferences(((DiagramInfo)sbmlDiagram.getKernel()).getDatabaseReferences());
        ((DiagramInfo)sbgnDiagram.getKernel()).setLiteratureReferences(((DiagramInfo)sbmlDiagram.getKernel()).getLiteratureReferences());
        DiagramViewOptions viewOptions = sbgnDiagram.getViewOptions();
        boolean notificationEnabled = viewOptions.isNotificationEnabled();
        viewOptions.setNotificationEnabled(false);
        viewOptions.setDependencyEdges(sbmlDiagram.getViewOptions().isDependencyEdges());
        viewOptions.setAutoLayout(sbmlDiagram.getViewOptions().isAutoLayout());
        if (sbmlDiagram.getViewOptions().isAutoLayout() && sbmlDiagram.getViewOptions().getPathLayouter() != null) {
            viewOptions.setPathLayouterWrapper(new PathLayouterWrapper(sbmlDiagram.getViewOptions().getPathLayouter()));
        }
        viewOptions.setNotificationEnabled(notificationEnabled);
        DynamicProperty dp = sbmlDiagram.getAttributes().getProperty("metaIds");
        if (dp != null) {
            sbgnDiagram.getAttributes().add(dp);
        }
        if ((dp = sbmlDiagram.getAttributes().getProperty("Antimony text")) != null) {
            sbgnDiagram.getAttributes().add(dp);
        }
        if ((dp = sbmlDiagram.getAttributes().getProperty("Antimony version")) != null) {
            sbgnDiagram.getAttributes().add(dp);
        }
        if ((dp = sbmlDiagram.getAttributes().getProperty("pfUser")) != null) {
            sbgnDiagram.getAttributes().add(dp);
        }
        if ((dp = sbmlDiagram.getAttributes().getProperty("autoscale")) != null) {
            sbgnDiagram.getAttributes().add(dp);
        }
        if ((dp = sbmlDiagram.getAttributes().getProperty("bioHub")) != null) {
            sbgnDiagram.getAttributes().add(dp);
        }
        if ((dp = sbmlDiagram.getAttributes().getProperty("referenceType")) != null) {
            sbgnDiagram.getAttributes().add(dp);
        }
        if ((dp = sbmlDiagram.getAttributes().getProperty("converter")) != null) {
            sbgnDiagram.getAttributes().add(dp);
        }
        if ((dp = sbmlDiagram.getAttributes().getProperty("species")) != null) {
            sbgnDiagram.getAttributes().add(dp);
        }
    }

    public void save(File output, Diagram element) throws Exception {
        SbmlModelFactory.writeDiagram(output, this.getDiagramToWrite(element));
    }

    public int getOutputPriority(String name) {
        return name.endsWith(".sbml") ? 2 : 0;
    }
}

