/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.sbml.MessageBundle;
import biouml.plugins.sbml.SbmlSemanticController;
import biouml.standard.type.Base;
import biouml.standard.type.Compartment;
import biouml.standard.type.Specie;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import ru.biosoft.access.core.DataCollection;

public class CreateDiagramElementDialog
extends OkCancelDialog {
    protected static final Logger log = Logger.getLogger(CreateDiagramElementDialog.class.getName());
    protected Diagram diagram;
    protected biouml.model.Compartment parent;
    protected Class<?> type;
    protected MessageBundle resources;
    protected JTextField nameField;
    protected JComboBox<String> specieType;
    protected Node node;

    public CreateDiagramElementDialog(JFrame frame, Diagram diagram, biouml.model.Compartment parent, Class<?> type) {
        super(frame, "");
        this.diagram = diagram;
        this.parent = parent;
        this.type = type;
        this.resources = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
        this.setTitle(this.resources.getResourceString("DIAGRAM_ELEMENT_TITLE"));
        JPanel content = new JPanel(new GridBagLayout());
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContent(content);
        String nameLabel = this.isSpecie() ? this.resources.getResourceString("DIAGRAM_ELEMENT_SPECIE_NAME") : this.resources.getResourceString("DIAGRAM_ELEMENT_COMPARTMENT_NAME");
        content.add((Component)new JLabel(nameLabel), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.nameField = new JTextField(20);
        content.add((Component)this.nameField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        if (this.isSpecie()) {
            content.add((Component)new JLabel(this.resources.getResourceString("DIAGRAM_ELEMENT_SPECIE_TYPE")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.specieType = new JComboBox<String>((String[])this.resources.getObject("SPECIE_TYPES"));
            content.add(this.specieType, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        }
        this.okButton.setEnabled(false);
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String name = CreateDiagramElementDialog.this.nameField.getText();
                CreateDiagramElementDialog.this.okButton.setEnabled(name != null && name.length() > 0);
            }
        });
    }

    public Node getNode() {
        return this.node;
    }

    protected boolean isSpecie() {
        return this.type.equals(Specie.class);
    }

    protected void okPressed() {
        this.node = this.createDiagramElement();
        if (this.node != null) {
            super.okPressed();
        }
    }

    protected Node createDiagramElement() {
        biouml.model.Compartment node = null;
        String name = SbmlSemanticController.validateSName(this.nameField.getText());
        if (SbmlSemanticController.isReservedKeyWord(name)) {
            String title = this.resources.getString("DIAGRAM_ELEMENT_ERROR_TITLE");
            String message = this.resources.getString("DIAGRAM_ELEMENT_RESERVED");
            message = MessageFormat.format(message, name);
            JOptionPane.showMessageDialog((Component)((Object)this), message, title, 0);
            return null;
        }
        Object obj = SbmlSemanticController.resolveName(this.diagram, name);
        if (obj != null) {
            String title = this.resources.getString("DIAGRAM_ELEMENT_ERROR_TITLE");
            String message = this.resources.getString("DIAGRAM_ELEMENT_DUPLICATED");
            String type = obj.getClass().getName();
            type = type.substring(type.lastIndexOf(".") + 1);
            message = MessageFormat.format(message, name, type);
            JOptionPane.showMessageDialog((Component)((Object)this), message, title, 0);
            return null;
        }
        try {
            if (!this.isSpecie()) {
                node = new biouml.model.Compartment((DataCollection)this.parent, (Base)new Compartment(null, name));
                VariableRole var = new VariableRole((DiagramElement)node);
                node.setRole((Role)var);
            } else {
                Specie specie = new Specie(null, name, (String)this.specieType.getSelectedItem());
                node = new Node((DataCollection)this.parent, (Base)specie);
                VariableRole var = new VariableRole((DiagramElement)node, 0.0);
                node.setRole((Role)var);
            }
        }
        catch (Throwable t) {
            String title = this.resources.getString("DIAGRAM_ELEMENT_ERROR_TITLE");
            String message = this.resources.getString("DIAGRAM_ELEMENT_ERROR");
            message = MessageFormat.format(message, name, t.getMessage());
            JOptionPane.showMessageDialog((Component)((Object)this), message, title, 0);
            log.log(Level.SEVERE, message, t);
        }
        return node;
    }
}

