/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.web;

import biouml.model.Diagram;
import biouml.model.dynamics.plot.Curve;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.model.dynamics.plot.PlotVariable;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.plugins.simulation.ResultPlotPane;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.SimulationEngineWrapper;
import biouml.plugins.simulation.document.InputParameter;
import biouml.plugins.simulation.document.InteractiveSimulation;
import biouml.plugins.simulation.web.SimulationJobControl;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.simulation.SimulationResult;
import biouml.standard.simulation.StochasticSimulationResult;
import com.developmentontheedge.log.PatternFormatter;
import com.developmentontheedge.log.WriterHandler;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.json.JSONArray;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.security.SecurityManager;
import ru.biosoft.server.JSONUtils;
import ru.biosoft.server.servlets.webservices.BiosoftWebRequest;
import ru.biosoft.server.servlets.webservices.JSONResponse;
import ru.biosoft.server.servlets.webservices.WebException;
import ru.biosoft.server.servlets.webservices.WebServicesServlet;
import ru.biosoft.server.servlets.webservices.WebSession;
import ru.biosoft.server.servlets.webservices.providers.WebBeanProvider;
import ru.biosoft.server.servlets.webservices.providers.WebJSONProviderSupport;
import ru.biosoft.util.DPSUtils;
import ru.biosoft.util.Util;

public class SimulationProvider
extends WebJSONProviderSupport {
    private boolean logInitialized = false;
    private static ConcurrentHashMap<String, SimulationJobControl> logToJC;
    private static ConcurrentHashMap<String, StringBuffer> buffers;

    public void process(BiosoftWebRequest arguments, JSONResponse response) throws Exception {
        switch (arguments.getAction()) {
            case "simulate": {
                this.simulateDiagram((Diagram)arguments.getDataElement(Diagram.class), arguments.getJSONArray("engine"), response);
                return;
            }
            case "status": {
                SimulationProvider.sendSimulationStatus(arguments.getString("de"), response);
                return;
            }
            case "stop": {
                SimulationProvider.stopSimulation(arguments.getString("de"), response);
                return;
            }
            case "result": {
                SimulationProvider.sendSimulationResult(arguments.getString("de"), response);
                return;
            }
            case "save_options": {
                this.saveSimulatorOptions((Diagram)arguments.getDataElement(Diagram.class), arguments.getString("engineBean"), response);
                return;
            }
            case "save_result": {
                this.saveSimulationResult(arguments.getDataElementPath("de"), arguments.getString("jobID"), response);
                return;
            }
            case "simulation_document_create": {
                SimulationProvider.createSimulationDocument((Diagram)arguments.getDataElement(Diagram.class), response);
                return;
            }
            case "simulation_document_plot": {
                SimulationProvider.sendSimulationPlot(arguments.getString("de"), response);
                return;
            }
            case "parameters_reset": {
                this.resetSimulationParameters(arguments.getString("de"), Arrays.asList(arguments.getStrings("jsonrows")), response);
                return;
            }
            case "parameters_increase": {
                this.increaseSimulationParameters(arguments.getString("de"), Arrays.asList(arguments.getStrings("jsonrows")), response);
                return;
            }
            case "parameters_decrease": {
                this.decreaseSimulationParameters(arguments.getString("de"), Arrays.asList(arguments.getStrings("jsonrows")), response);
                return;
            }
            case "simulation_document_update": {
                SimulationProvider.updateSimulation(arguments.getString("de"), response);
                return;
            }
            case "save_to_diagram": {
                this.saveParametersToDiagram(arguments.getString("de"), response);
                return;
            }
        }
        throw new WebException("EX_QUERY_PARAM_INVALID_VALUE", new Object[]{"action"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLogging() {
        if (this.logInitialized) {
            return;
        }
        SimulationProvider simulationProvider = this;
        synchronized (simulationProvider) {
            if (this.logInitialized) {
                return;
            }
            logToJC = new ConcurrentHashMap();
            buffers = new ConcurrentHashMap();
            SessionWriter writer = new SessionWriter();
            WriterHandler webLogHandler = new WriterHandler((Writer)writer, (Formatter)new PatternFormatter("%4$s - %5$s%n"));
            webLogHandler.setLevel(Level.ALL);
            String[] categoryNames = new String[]{"biouml.plugins.simulation"};
            for (int i = 0; i < categoryNames.length; ++i) {
                Logger cat = Logger.getLogger(categoryNames[i]);
                cat.addHandler((Handler)webLogHandler);
            }
            this.logInitialized = true;
        }
    }

    private void simulateDiagram(Diagram diagram, JSONArray jsonParams, JSONResponse response) throws Exception {
        this.initLogging();
        WebServicesServlet.getSessionCache().setObjectChanged(diagram.getCompletePath().toString(), (Object)diagram);
        SimulationEngineWrapper simulationEngineWrapper = new SimulationEngineWrapper(diagram);
        JSONUtils.correctBeanOptions((Object)((Object)simulationEngineWrapper), (JSONArray)jsonParams);
        SimulationEngine simulationEngine = simulationEngineWrapper.getEngine();
        SimulationJobControl jobControl = new SimulationJobControl(simulationEngine);
        String curSession = SecurityManager.getSession();
        logToJC.put(curSession, jobControl);
        buffers.put(curSession, new StringBuffer());
        Thread t = new Thread((Runnable)((Object)jobControl));
        WebSession.addThread((Thread)t);
        t.setPriority(1);
        t.start();
        String processName = "beans/process/" + Util.getUniqueId();
        WebServicesServlet.getSessionCache().addObject(processName, (Object)jobControl, true);
        response.sendStringArray(new String[]{processName, String.valueOf(simulationEngine.getPlots().length)});
    }

    private static void sendSimulationStatus(String jobId, JSONResponse response) throws IOException {
        Object jobControlObj = WebServicesServlet.getSessionCache().getObject(jobId);
        if (jobControlObj instanceof SimulationJobControl) {
            SimulationJobControl jobControl = (SimulationJobControl)jobControlObj;
            String errorStr = jobControl.getErrorMessage();
            if (errorStr == null) {
                String message;
                int status = jobControl.getStatus();
                String[] imageNames = null;
                BufferedImage[] resultImages = jobControl.generateResultImage();
                if (resultImages != null) {
                    imageNames = new String[resultImages.length + 1];
                    for (int i = 0; i < resultImages.length; ++i) {
                        imageNames[i] = jobId + "_img_" + i;
                        WebSession.getCurrentSession().putImage(imageNames[i], resultImages[i]);
                    }
                    imageNames[imageNames.length - 1] = message = jobControl.getJobMessage();
                }
                if (status < 3) {
                    int percent = jobControl.getPreparedness();
                    response.sendStatus(status, percent, imageNames);
                } else if (status == 3 || status == 4) {
                    response.sendStatus(status, 100, imageNames);
                } else if (status == 5) {
                    message = jobControl.getJobMessage();
                    if (message == null) {
                        message = "Can not simulate model. Error not specified.";
                    }
                    response.error(message);
                }
            } else {
                response.error(errorStr);
            }
        } else {
            response.error("Invalid process ID specified: " + jobId);
        }
    }

    private static void stopSimulation(String jobId, JSONResponse response) throws IOException {
        Object jobControlObj = WebServicesServlet.getSessionCache().getObject(jobId);
        if (jobControlObj instanceof SimulationJobControl) {
            SimulationJobControl jobControl = (SimulationJobControl)jobControlObj;
            jobControl.terminate();
            String message = jobControl.getJobMessage();
            if (message == null) {
                message = "Can not simulate model. Error not specified.";
            }
            response.sendStringArray(new String[]{"Simulation terminated", message});
            String curSession = SecurityManager.getSession();
            logToJC.remove(curSession);
            buffers.remove(curSession);
        } else {
            response.error("Invalid process ID specified: " + jobId);
        }
    }

    private static void sendSimulationResult(String resultDe, JSONResponse response) throws IOException {
        Object cachedObj = WebServicesServlet.getSessionCache().getObject(resultDe);
        SimulationResult simulationResult = null;
        if (cachedObj instanceof SimulationJobControl) {
            SimulationJobControl jobControl = (SimulationJobControl)cachedObj;
            simulationResult = jobControl.getSimulationResult();
        } else if (cachedObj instanceof SimulationResult) {
            simulationResult = (SimulationResult)cachedObj;
        } else if (cachedObj == null) {
            DataElementPath simulationResultPath = DataElementPath.create((String)resultDe);
            simulationResult = (SimulationResult)simulationResultPath.optDataElement(SimulationResult.class);
        }
        if (simulationResult != null) {
            JsonValue json = SimulationProvider.simulationResultToJSON(simulationResult);
            response.sendJSON(json);
        } else {
            response.error("Invalid process ID specified: " + resultDe);
        }
    }

    private static JsonValue simulationResultToJSON(SimulationResult simulationResult) {
        JsonObject res = Json.object();
        JsonObject vars = Json.object();
        simulationResult.getVariablePathMap().forEach((arg_0, arg_1) -> ((JsonObject)vars).add(arg_0, arg_1));
        res.add("vars", (JsonValue)vars);
        JsonArray times = Json.array((double[])simulationResult.getTimes());
        res.add("times", (JsonValue)times);
        int nData = simulationResult.getValue(0).length;
        int nPoints = times.size();
        double[][] values = new double[nData][nPoints];
        for (int t = 0; t < nPoints; ++t) {
            double[] valuesAtT = simulationResult.getValue(t);
            for (int i = 0; i < nData; ++i) {
                values[i][t] = valuesAtT[i];
            }
        }
        JsonArray jsonValues = new JsonArray();
        for (int i = 0; i < nData; ++i) {
            jsonValues.add((JsonValue)Json.array((double[])values[i]));
        }
        res.add("values", (JsonValue)jsonValues);
        if (simulationResult instanceof StochasticSimulationResult) {
            res.add("Q1", (JsonValue)SimulationProvider.toJsonArray(SimulationProvider.transpose(((StochasticSimulationResult)simulationResult).getQ1())));
            res.add("Q2", (JsonValue)SimulationProvider.toJsonArray(SimulationProvider.transpose(((StochasticSimulationResult)simulationResult).getMedian())));
            res.add("Q3", (JsonValue)SimulationProvider.toJsonArray(SimulationProvider.transpose(((StochasticSimulationResult)simulationResult).getQ3())));
        }
        return res;
    }

    private static JsonArray toJsonArray(double[][] array) {
        JsonArray jsonValues = new JsonArray();
        for (int i = 0; i < array.length; ++i) {
            jsonValues.add((JsonValue)Json.array((double[])array[i]));
        }
        return jsonValues;
    }

    private static double[][] transpose(double[][] array) {
        double[][] result = new double[array[0].length][array.length];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < array.length; ++j) {
                result[i][j] = array[j][i];
            }
        }
        return result;
    }

    private void saveSimulatorOptions(Diagram diagram, String engineBean, JSONResponse response) throws Exception {
        WebServicesServlet.getSessionCache().setObjectChanged(diagram.getCompletePath().toString(), (Object)diagram);
        Object bean = WebBeanProvider.getBean((String)engineBean);
        if (bean != null && bean instanceof SimulationEngineWrapper) {
            diagram.getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)"simulationOptions", SimulationEngine.class, (Object)((SimulationEngineWrapper)((Object)bean)).getEngine()));
            response.sendString("ok");
        } else {
            response.error("Can not find bean for simulation engine");
        }
    }

    private void saveSimulationResult(DataElementPath dataElementPath, String jobID, JSONResponse response) throws IOException {
        Object cachedObj = WebServicesServlet.getSessionCache().getObject(jobID);
        if (cachedObj instanceof SimulationJobControl) {
            SimulationJobControl jobControl = (SimulationJobControl)cachedObj;
            SimulationResult tmpResult = jobControl.getSimulationResult();
            SimulationResult simulationResult = tmpResult.clone(dataElementPath.getParentCollection(), dataElementPath.getName());
            CollectionFactoryUtils.save((DataElement)simulationResult);
            response.sendString("ok");
        } else {
            response.error("Can not find simulation result. Please, run simulation again.");
        }
    }

    public static InteractiveSimulation getInteractiveSimulation(String simulationDe) throws WebException {
        Object cachedObj = WebServicesServlet.getSessionCache().getObject(simulationDe);
        if (cachedObj instanceof InteractiveSimulation) {
            return (InteractiveSimulation)((Object)cachedObj);
        }
        throw new WebException("EX_QUERY_NO_ELEMENT", new Object[]{simulationDe});
    }

    private static void createSimulationDocument(Diagram diagram, JSONResponse response) throws Exception {
        PlotInfo[] plotInfos;
        String simulationName = "Simulation " + diagram.getName();
        String completeSimulationName = DataElementPath.create((String)simulationName).getChildPath(diagram.getCompletePath().getPathComponents()).toString();
        InteractiveSimulation simulation = new InteractiveSimulation(null, simulationName, diagram);
        PlotsInfo plotsInfo = DiagramUtility.getPlotsInfo((Diagram)simulation.getDiagram());
        if (plotsInfo == null) {
            response.error("No plots specified for diagram. Can not create document!");
            return;
        }
        HashSet<String> names = new HashSet<String>();
        for (PlotInfo plotInfo : plotInfos = plotsInfo.getActivePlots()) {
            for (Curve c : plotInfo.getYVariables()) {
                names.add(c.getCompleteName());
            }
            PlotVariable xVar = plotInfo.getXVariable();
            names.add(xVar.getCompleteName());
        }
        simulation.setOutputNames(names);
        simulation.doSimulation();
        WebServicesServlet.getSessionCache().addObject(completeSimulationName, (Object)simulation, true);
        response.sendString(completeSimulationName);
    }

    private static void updateSimulation(String simulationDe, JSONResponse response) throws IOException, WebException {
        InteractiveSimulation simulation = SimulationProvider.getInteractiveSimulation(simulationDe);
        simulation.getInputParameters().stream().forEach(parameter -> simulation.updateValue((InputParameter)parameter));
        simulation.doSimulation();
        response.sendString("ok");
    }

    private static void sendSimulationPlot(String simulationDe, JSONResponse response) throws IOException, WebException {
        InteractiveSimulation simulation = SimulationProvider.getInteractiveSimulation(simulationDe);
        PlotsInfo plotsInfo = DiagramUtility.getPlotsInfo((Diagram)simulation.getDiagram());
        Object[] plotInfos = plotsInfo.getActivePlots();
        String[] imageNames = null;
        Map<String, double[]> values = simulation.getResult();
        BufferedImage[] resultImages = (BufferedImage[])StreamEx.of((Object[])plotInfos).map(p -> {
            WebSimplePlotPane wp = new WebSimplePlotPane(700, 500, (PlotInfo)p);
            wp.redrawChart(values);
            return wp;
        }).map(p -> p.getImage()).toArray(BufferedImage[]::new);
        if (resultImages != null) {
            imageNames = new String[resultImages.length];
            for (int i = 0; i < resultImages.length; ++i) {
                imageNames[i] = simulationDe + "_img_" + i;
                WebSession.getCurrentSession().putImage(imageNames[i], resultImages[i]);
            }
            response.sendStringArray(imageNames);
        } else {
            response.sendStringArray(new String[0]);
        }
    }

    private void resetSimulationParameters(String simulationDe, List<String> asList, JSONResponse response) throws IOException, WebException {
        InteractiveSimulation simulation = SimulationProvider.getInteractiveSimulation(simulationDe);
        if (asList.isEmpty()) {
            simulation.resetParameters();
        } else {
            asList.stream().forEach(parameter -> {
                InputParameter param = simulation.getParameter((String)parameter);
                if (param != null) {
                    simulation.resetParameter(param);
                }
            });
        }
        simulation.doSimulation();
        response.sendString("ok");
    }

    private void increaseSimulationParameters(String simulationDe, List<String> asList, JSONResponse response) throws IOException, WebException {
        InteractiveSimulation simulation = SimulationProvider.getInteractiveSimulation(simulationDe);
        asList.stream().forEach(parameter -> {
            InputParameter selected = simulation.getParameter((String)parameter);
            selected.setValue(selected.getValue() + selected.getValueStep());
            simulation.updateValue(selected);
        });
        simulation.doSimulation();
        response.sendString("ok");
    }

    private void decreaseSimulationParameters(String simulationDe, List<String> asList, JSONResponse response) throws IOException, WebException {
        InteractiveSimulation simulation = SimulationProvider.getInteractiveSimulation(simulationDe);
        asList.stream().forEach(parameter -> {
            InputParameter selected = simulation.getParameter((String)parameter);
            selected.setValue(selected.getValue() - selected.getValueStep());
            simulation.updateValue(selected);
        });
        simulation.doSimulation();
        response.sendString("ok");
    }

    private void saveParametersToDiagram(String simulationDe, JSONResponse response) throws IOException, WebException {
        InteractiveSimulation simulation = SimulationProvider.getInteractiveSimulation(simulationDe);
        simulation.saveParametersToDiagram();
        response.sendString("ok");
    }

    private static class WebSimplePlotPane {
        protected static final Logger log = Logger.getLogger(WebSimplePlotPane.class.getName());
        protected JFreeChart chart;
        private XYLineAndShapeRenderer renderer;
        private PlotInfo plotInfo;
        private String xVariable;
        private int width;
        private int height;

        public WebSimplePlotPane(int ix, int iy, PlotInfo plotInfo) {
            this.width = ix;
            this.height = iy;
            try {
                this.chart = ChartFactory.createXYLineChart((String)plotInfo.getTitle(), (String)"Axis (X)", (String)"Axis (Y)", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                this.plotInfo = plotInfo;
                this.xVariable = this.plotInfo.getXVariable().getName();
                this.chart.getXYPlot().setBackgroundPaint((Paint)Color.white);
                this.chart.setBackgroundPaint((Paint)Color.white);
                XYSeriesCollection dataset = new XYSeriesCollection();
                this.chart.getXYPlot().setDataset((XYDataset)dataset);
                this.renderer = new XYLineAndShapeRenderer();
                this.renderer.setDrawSeriesLineAsPath(true);
                if (plotInfo.getExperiments() != null) {
                    ResultPlotPane.addExperiments(plotInfo.getExperiments(), this.renderer, (AbstractSeriesDataset)dataset, Double.MAX_VALUE);
                }
                int counter = this.chart.getXYPlot().getDataset().getSeriesCount();
                for (Curve c : plotInfo.getYVariables()) {
                    this.renderer.setSeriesPaint(counter, (Paint)c.getPen().getColor());
                    this.renderer.setSeriesStroke(counter, (Stroke)c.getPen().getStroke());
                    this.renderer.setSeriesShapesVisible(counter, false);
                    this.renderer.setSeriesLinesVisible(counter, true);
                    this.renderer.setSeriesShape(counter, null);
                    dataset.addSeries(new XYSeries((Comparable)((Object)c.getCompleteName()), false, true));
                    ++counter;
                }
                this.chart.getXYPlot().setRenderer((XYItemRenderer)this.renderer);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Error occured while creating chart panel: " + ex);
            }
        }

        public void redrawChart(Map<String, double[]> values) {
            this.renderer.setDrawSeriesLineAsPath(true);
            double[] x = values.get(this.xVariable);
            XYSeriesCollection xyDataset = (XYSeriesCollection)this.chart.getXYPlot().getDataset();
            for (Curve c : this.plotInfo.getYVariables()) {
                XYSeries series = xyDataset.getSeries((Comparable)((Object)c.getCompleteName()));
                series.clear();
                double[] y = values.get(c.getCompleteName());
                for (int i = 0; i < x.length; ++i) {
                    series.add(x[i], y[i]);
                }
            }
        }

        public BufferedImage getImage() {
            return this.chart.createBufferedImage(this.width, this.height);
        }
    }

    public static class SessionWriter
    extends Writer {
        StringBuffer buffer = new StringBuffer();

        @Override
        public void write(char[] bytes, int offset, int len) throws IOException {
            String curSession = SecurityManager.getSession();
            buffers.computeIfAbsent(curSession, s -> new StringBuffer()).append(bytes, offset, len);
        }

        @Override
        public void flush() throws IOException {
            String curSession = SecurityManager.getSession();
            SimulationJobControl jc = (SimulationJobControl)logToJC.get(curSession);
            if (jc != null) {
                StringBuffer buffer = buffers.computeIfAbsent(curSession, s -> new StringBuffer());
                jc.addJobMessage(buffer.toString());
                buffer.setLength(0);
            }
        }

        @Override
        public void close() throws IOException {
        }
    }
}

