/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.web;

import biouml.model.dynamics.plot.PlotInfo;
import biouml.plugins.simulation.CycledResultListener;
import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.ResultPlotPane;
import biouml.plugins.simulation.ResultWriter;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.UniformSpan;
import biouml.plugins.simulation.plot.PlotPane;
import biouml.standard.simulation.ResultListener;
import biouml.standard.simulation.SimulationResult;
import biouml.standard.simulation.StochasticSimulationResult;
import biouml.standard.simulation.plot.Plot;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.general.Series;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import ru.biosoft.analysis.Util;
import ru.biosoft.graphics.Pen;
import ru.biosoft.jobcontrol.AbstractJobControl;
import ru.biosoft.jobcontrol.JobControlException;
import ru.biosoft.util.LimitedTextBuffer;

public class SimulationJobControl
extends AbstractJobControl
implements CycledResultListener {
    protected static final Logger log = Logger.getLogger(SimulationJobControl.class.getName());
    protected SimulationEngine engine;
    protected WebResultPlot[] plots;
    protected String errorMessage = null;
    private LimitedTextBuffer message = new LimitedTextBuffer(100);
    protected boolean isInit = false;
    private SimulationResult simulationResult;

    public SimulationJobControl(SimulationEngine simulationEngine) {
        super(null);
        this.engine = simulationEngine;
    }

    protected void doRun() throws JobControlException {
        File dir;
        if (this.engine.needToShowPlot && !this.engine.hasVariablesToPlot()) {
            this.errorMessage = "There are no variables to plot<br>Set up and adjust variables in the \"Plot\" view part.";
            return;
        }
        List<Object> incorrect = new ArrayList();
        try {
            incorrect = this.engine.getIncorrectPlotVariables();
        }
        catch (Exception ex) {
            this.errorMessage = ex.getMessage();
            return;
        }
        if (incorrect.size() > 0) {
            this.errorMessage = "Some plot variables are missing or incorrect. Please, change plot settings for " + String.join((CharSequence)", ", incorrect) + " in the \"Plot\" view part.";
            return;
        }
        String outputDir = this.engine.getOutputDir();
        if (outputDir != null && !(dir = new File(outputDir)).exists()) {
            dir.mkdirs();
        }
        Model model = null;
        try {
            model = this.engine.createModel();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not generate model", e);
            this.errorMessage = e.getMessage();
        }
        if (model != null) {
            try {
                this.simulationResult = this.engine.generateSimulationResult();
                ResultWriter resultWriter = new ResultWriter(this.simulationResult);
                int type = this.engine.getSimulationType();
                this.plots = type == SimulationEngine.STOCHASTIC_TYPE ? (WebResultPlot[])StreamEx.of((Object[])this.engine.getPlots()).map(p -> new StochasticWebResultPlot((PlotInfo)p)).toArray(WebResultPlot[]::new) : (WebResultPlot[])StreamEx.of((Object[])this.engine.getPlots()).map(p -> new WebResultPlot((PlotInfo)p)).toArray(WebResultPlot[]::new);
                for (WebResultPlot plot : this.plots) {
                    plot.init(this.engine);
                }
                this.isInit = true;
                this.errorMessage = this.engine.simulate(model, new ResultListener[]{this, resultWriter});
                if (this.errorMessage != null) {
                    this.setTerminated(5);
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not simulate model", t);
                if (this.errorMessage == null) {
                    this.errorMessage = "Can not simulate model: " + t.getMessage();
                }
                this.setTerminated(5);
            }
        } else {
            if (this.errorMessage == null) {
                this.errorMessage = this.message.toString();
            }
            this.setTerminated(5);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void start(Object model) {
        for (WebResultPlot plot : this.plots) {
            plot.start(model);
        }
    }

    public void add(double t, double[] y) throws Exception {
        for (WebResultPlot plot : this.plots) {
            plot.add(t, y);
        }
        double percent = (t - this.engine.getInitialTime()) / (this.engine.getCompletionTime() - this.engine.getInitialTime()) * 100.0;
        this.setPreparedness((int)percent);
    }

    public BufferedImage[] generateResultImage() {
        return this.isInit ? (BufferedImage[])StreamEx.of((Object[])this.plots).map(p -> p.getImage()).toArray(BufferedImage[]::new) : null;
    }

    public SimulationResult getSimulationResult() {
        return this.simulationResult;
    }

    public void terminate() {
        this.engine.stopSimulation();
        super.terminate();
    }

    public SimulationEngine getSimulationEngine() {
        return this.engine;
    }

    @Override
    public void finish() {
    }

    @Override
    public void addAsFirst(double t, double[] y) {
    }

    @Override
    public void update(double t, double[] y) {
    }

    @Override
    public void startCycle() {
        for (WebResultPlot plot : this.plots) {
            plot.startCycle();
        }
    }

    public String getJobMessage() {
        return this.message.toString();
    }

    public void addJobMessage(String message) {
        this.message.add(message);
    }

    public static class StochasticWebResultPlot
    extends WebResultPlot {
        private List<double[][]> values;
        private Map<Integer, Integer> varIndexInPlot;
        private int currentCycle;
        private int spanIndex;
        private int spanSize;

        public StochasticWebResultPlot(PlotInfo plotInfo) {
            super(plotInfo);
        }

        @Override
        public void init(SimulationEngine engine) {
            this.spanSize = new UniformSpan(engine.getInitialTime(), engine.getCompletionTime(), engine.getTimeIncrement()).getLength();
            this.dataset = new YIntervalSeriesCollection();
            this.xVariable = engine.getXVariable(this.plotInfo);
            this.variableIndeces = engine.getVariablesToPlot(this.plotInfo);
            String yAxisLabel = this.variableIndeces.size() == 1 ? StreamEx.of(this.variableIndeces.keySet()).findFirst().map(v -> v.title).get() : "Quantity or concentration";
            this.chart = ChartFactory.createXYLineChart((String)this.plotInfo.getTitle(), (String)this.xVariable.title, (String)yAxisLabel, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            this.chart.setBackgroundPaint((Paint)Color.white);
            DeviationRenderer renderer = new DeviationRenderer();
            renderer.setDrawSeriesLineAsPath(true);
            XYPlot plot = this.chart.getXYPlot();
            ValueAxis axis = PlotPane.generateAxis(Plot.AxisType.getAxisType((String)this.plotInfo.getXAxisType()));
            if (axis != null) {
                plot.setDomainAxis(axis);
            }
            if (this.plotInfo.getXFrom() != this.plotInfo.getXTo()) {
                plot.getDomainAxis().setLowerBound(this.plotInfo.getXFrom());
                plot.getDomainAxis().setUpperBound(this.plotInfo.getXTo());
            } else {
                plot.getDomainAxis().setLowerBound(engine.getInitialTime());
                plot.getDomainAxis().setUpperBound(engine.getCompletionTime());
            }
            plot.getDomainAxis().setAutoRange(this.plotInfo.isXAutoRange());
            axis = PlotPane.generateAxis(Plot.AxisType.getAxisType((String)this.plotInfo.getYAxisType()));
            if (axis != null) {
                plot.setRangeAxis(axis);
            }
            if (this.plotInfo.getYFrom() != this.plotInfo.getYTo()) {
                plot.getRangeAxis().setLowerBound(this.plotInfo.getYFrom());
                plot.getRangeAxis().setUpperBound(this.plotInfo.getYTo());
            }
            plot.getRangeAxis().setAutoRange(this.plotInfo.isYAutoRange());
            int counter = 0;
            for (Map.Entry e : this.variableIndeces.entrySet()) {
                SimulationEngine.Var var = (SimulationEngine.Var)e.getKey();
                YIntervalSeries series = (YIntervalSeries)((List)e.getValue()).get(0);
                if (series == null) continue;
                Pen spec = var.pen;
                if (spec != null) {
                    renderer.setSeriesShapesVisible(counter, false);
                    renderer.setSeriesPaint(counter, (Paint)spec.getColor());
                    renderer.setSeriesFillPaint(counter, (Paint)spec.getColor());
                    renderer.setSeriesStroke(counter, (Stroke)spec.getStroke());
                }
                ++counter;
                ((YIntervalSeriesCollection)this.dataset).addSeries(series);
            }
            if (this.plotInfo.getExperiments() != null) {
                ResultPlotPane.addExperiments(this.plotInfo.getExperiments(), (XYLineAndShapeRenderer)renderer, (AbstractSeriesDataset)this.dataset, engine.getCompletionTime());
            }
            this.chart.getXYPlot().setBackgroundPaint((Paint)Color.white);
            this.chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
            this.chart.getXYPlot().setDataset((XYDataset)this.dataset);
            this.varIndexInPlot = new HashMap<Integer, Integer>();
            int i = 0;
            for (Map.Entry e : this.variableIndeces.entrySet()) {
                this.varIndexInPlot.put(((SimulationEngine.Var)e.getKey()).index, i);
                ++i;
            }
        }

        @Override
        public void add(double t, double[] y) {
            double[][] vals = this.values.get(this.currentCycle);
            for (Map.Entry e : this.variableIndeces.entrySet()) {
                int varIndex = ((SimulationEngine.Var)e.getKey()).index;
                int xIndex = this.xVariable.index;
                int index = this.varIndexInPlot.get(varIndex);
                vals[index][this.spanIndex] = y[varIndex];
                Series s = (Series)((List)e.getValue()).get(0);
                if (this.currentCycle >= 2) {
                    double[] variableValues = new double[this.currentCycle + 1];
                    for (int k = 0; k <= this.currentCycle; ++k) {
                        variableValues[k] = this.values.get(k)[index][this.spanIndex];
                    }
                    Util.sort((double[])variableValues);
                    double median = StochasticSimulationResult.median((double[])variableValues);
                    double q1 = StochasticSimulationResult.quartile1((double[])variableValues);
                    double q3 = StochasticSimulationResult.quartile3((double[])variableValues);
                    ((YIntervalSeries)s).add(y[xIndex], median, q1, q3);
                    continue;
                }
                ((YIntervalSeries)s).add(y[xIndex], y[varIndex], y[varIndex], y[varIndex]);
            }
            ++this.spanIndex;
        }

        @Override
        public void start(Object model) {
            this.currentCycle = 0;
            this.spanIndex = 0;
            this.values = new ArrayList<double[][]>();
            this.values.add(new double[this.variableIndeces.size()][this.spanSize]);
        }

        @Override
        public void startCycle() {
            ++this.currentCycle;
            this.spanIndex = 0;
            for (List list : this.variableIndeces.values()) {
                for (Series s : list) {
                    ((YIntervalSeries)s).clear();
                }
            }
            this.values.add(new double[this.variableIndeces.size()][this.spanSize]);
        }
    }

    public static class WebResultPlot {
        protected JFreeChart chart;
        protected Map<SimulationEngine.Var, List<Series>> variableIndeces;
        protected AbstractXYDataset dataset;
        protected SimulationEngine.Var xVariable;
        protected PlotInfo plotInfo;

        public WebResultPlot(PlotInfo plotInfo) {
            this.plotInfo = plotInfo;
        }

        public void init(SimulationEngine engine) {
            this.dataset = new XYSeriesCollection();
            this.xVariable = engine.getXVariable(this.plotInfo);
            this.variableIndeces = engine.getVariablesToPlot(this.plotInfo);
            String yAxisLabel = this.variableIndeces.size() == 1 ? StreamEx.of(this.variableIndeces.keySet()).findFirst().map(v -> v.title).get() : "Quantity or concentration";
            this.chart = ChartFactory.createXYLineChart((String)this.plotInfo.getTitle(), (String)this.xVariable.title, (String)yAxisLabel, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            this.chart.setBackgroundPaint((Paint)Color.white);
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setDrawSeriesLineAsPath(true);
            XYPlot plot = this.chart.getXYPlot();
            ValueAxis axis = PlotPane.generateAxis(Plot.AxisType.getAxisType((String)this.plotInfo.getXAxisType()));
            if (axis != null) {
                plot.setDomainAxis(axis);
            }
            if (this.plotInfo.getXFrom() != this.plotInfo.getXTo()) {
                plot.getDomainAxis().setLowerBound(this.plotInfo.getXFrom());
                plot.getDomainAxis().setUpperBound(this.plotInfo.getXTo());
            } else {
                plot.getDomainAxis().setLowerBound(engine.getInitialTime());
                plot.getDomainAxis().setUpperBound(engine.getCompletionTime());
            }
            plot.getDomainAxis().setAutoRange(this.plotInfo.isXAutoRange());
            axis = PlotPane.generateAxis(Plot.AxisType.getAxisType((String)this.plotInfo.getYAxisType()));
            if (axis != null) {
                plot.setRangeAxis(axis);
            }
            if (this.plotInfo.getYFrom() != this.plotInfo.getYTo()) {
                plot.getRangeAxis().setLowerBound(this.plotInfo.getYFrom());
                plot.getRangeAxis().setUpperBound(this.plotInfo.getYTo());
            }
            plot.getRangeAxis().setAutoRange(this.plotInfo.isYAutoRange());
            int counter = 0;
            for (Map.Entry<SimulationEngine.Var, List<Series>> e : this.variableIndeces.entrySet()) {
                SimulationEngine.Var var = e.getKey();
                XYSeries series = (XYSeries)e.getValue().get(0);
                if (series == null) continue;
                Pen spec = var.pen;
                if (spec != null) {
                    renderer.setSeriesShapesVisible(counter, false);
                    renderer.setSeriesPaint(counter, (Paint)spec.getColor());
                    renderer.setSeriesStroke(counter, (Stroke)spec.getStroke());
                }
                ++counter;
                ((XYSeriesCollection)this.dataset).addSeries(series);
            }
            if (this.plotInfo.getExperiments() != null) {
                ResultPlotPane.addExperiments(this.plotInfo.getExperiments(), renderer, (AbstractSeriesDataset)this.dataset, engine.getCompletionTime());
            }
            this.chart.getXYPlot().setBackgroundPaint((Paint)Color.white);
            this.chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
            this.chart.getXYPlot().setDataset((XYDataset)this.dataset);
        }

        public BufferedImage getImage() {
            return this.chart.createBufferedImage(550, 350);
        }

        public void add(double t, double[] y) {
            int size = this.variableIndeces.size();
            int count = 0;
            for (Map.Entry<SimulationEngine.Var, List<Series>> e : this.variableIndeces.entrySet()) {
                SimulationEngine.Var var = e.getKey();
                if (var.index == null) continue;
                XYSeries series = (XYSeries)e.getValue().get(0);
                double yV = y[var.index];
                double xV = y[this.xVariable.index];
                series.add(xV, yV, count == size - 1);
                ++count;
            }
        }

        public void start(Object model) {
        }

        public void startCycle() {
        }
    }
}

