/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.web;

import biouml.model.Diagram;
import biouml.model.dynamics.plot.Curve;
import biouml.model.dynamics.plot.Experiment;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.model.dynamics.plot.PlotsInfo;
import com.developmentontheedge.beans.annot.PropertyName;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.VectorDataCollection;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.PenEditor;
import ru.biosoft.server.servlets.webservices.BiosoftWebRequest;
import ru.biosoft.server.servlets.webservices.WebException;
import ru.biosoft.table.access.TableResolver;
import ru.biosoft.util.bean.BeanInfoEx2;

public class PlotInfoTableResolver
extends TableResolver {
    public static final String TABLE_TYPE_PARAMETER = "tabletype";
    public static final String PLOT_NAME_PARAMETER = "plotname";
    private String type = "curves";
    private String plotName = null;

    public PlotInfoTableResolver(BiosoftWebRequest arguments) throws WebException {
        this.type = arguments.getString(TABLE_TYPE_PARAMETER);
        if (this.type.equals("curves") || this.type.equals("experiments")) {
            this.plotName = arguments.getString(PLOT_NAME_PARAMETER);
        }
    }

    public DataCollection<?> getTable(DataElement de) throws Exception {
        PlotInfo plotInfo;
        Diagram diagram = (Diagram)de;
        Object plotObject = diagram.getAttributes().getValue("Plots");
        PlotsInfo plotsInfo = null;
        if (plotObject instanceof PlotsInfo) {
            plotsInfo = (PlotsInfo)plotObject;
        }
        if ((plotInfo = (PlotInfo)StreamEx.of((Object[])plotsInfo.getPlots()).findFirst(pi -> pi.getTitle().equals(this.plotName)).orElse(null)) != null) {
            if (this.type.equals("curves")) {
                VectorDataCollection vdc = new VectorDataCollection("Curves", CurveWrapper.class, null);
                for (Curve curve : plotInfo.getYVariables()) {
                    vdc.put((DataElement)new CurveWrapper(curve));
                }
                return vdc;
            }
            if (this.type.equals("experiments")) {
                VectorDataCollection vdc = new VectorDataCollection("Experiments", Experiment.class, null);
                if (plotInfo.getExperiments() != null) {
                    for (Experiment v : plotInfo.getExperiments()) {
                        vdc.put((DataElement)v);
                    }
                }
                return vdc;
            }
        } else {
            throw new WebException("EX_QUERY_NO_TABLE", new Object[]{"plots"});
        }
        return null;
    }

    public static class CurveWrapperBeanInfo
    extends BeanInfoEx2<CurveWrapper> {
        public CurveWrapperBeanInfo() {
            super(CurveWrapper.class);
        }

        public void initProperties() throws Exception {
            this.add("path");
            this.add("curveName");
            this.add("title");
            this.add("pen", PenEditor.class);
        }
    }

    public class CurveWrapper
    implements DataElement {
        private Curve curve;
        private String curveName;

        public CurveWrapper(Curve curve) {
            this.curve = curve;
            this.curveName = curve.getName();
        }

        public String getName() {
            return this.curve.getCompleteName();
        }

        public void setName(String name) {
            this.curve.setName(name);
        }

        public DataCollection<?> getOrigin() {
            return null;
        }

        public Curve getCurve() {
            return this.curve;
        }

        @PropertyName(value="Path")
        public String getPath() {
            return this.curve.getPath();
        }

        public void setPath(String path) {
            this.curve.setPath(path);
        }

        @PropertyName(value="Title")
        public String getTitle() {
            return this.curve.getTitle();
        }

        public void setTitle(String title) {
            this.curve.setTitle(title);
        }

        @PropertyName(value="Line spec")
        public Pen getPen() {
            return this.curve.getPen();
        }

        public void setPen(Pen pen) {
            this.curve.setPen(pen);
        }

        @PropertyName(value="Name")
        public String getCurveName() {
            return this.curveName;
        }

        public void setCurveName(String curveName) {
            this.curveName = curveName;
        }
    }
}

