/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.web;

import biouml.model.Diagram;
import biouml.model.SubDiagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.plot.Curve;
import biouml.model.dynamics.plot.Experiment;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.Util;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import one.util.streamex.StreamEx;
import org.json.JSONArray;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.graphics.Pen;
import ru.biosoft.server.JSONUtils;
import ru.biosoft.server.servlets.webservices.BiosoftWebRequest;
import ru.biosoft.server.servlets.webservices.JSONResponse;
import ru.biosoft.server.servlets.webservices.providers.WebBeanProvider;
import ru.biosoft.server.servlets.webservices.providers.WebJSONProviderSupport;

public class DiagramPlotProvider
extends WebJSONProviderSupport {
    public void process(BiosoftWebRequest arguments, JSONResponse response) throws Exception {
        PlotInfo plot;
        DataElementPath dePath = arguments.getDataElementPath();
        String action = arguments.getAction();
        Object de = WebBeanProvider.getBean((String)dePath.toString());
        if (!(de instanceof Diagram)) {
            throw new IllegalArgumentException("Object is not a diagram: " + dePath);
        }
        Diagram diagram = (Diagram)de;
        PlotsInfo plots = DiagramUtility.getPlotsInfo((Diagram)diagram);
        if (plots == null) {
            plots = new PlotsInfo((EModel)diagram.getRole(EModel.class));
            DiagramUtility.setPlotsInfo((Diagram)diagram, (PlotsInfo)plots);
        }
        if ("plots_list".equals(action)) {
            String[] plotNames = (String[])StreamEx.of((Object[])plots.getPlots()).map(pi -> pi.getTitle()).toArray(String[]::new);
            response.sendStringArray(plotNames);
            return;
        }
        if ("plot_variables".equals(action)) {
            JsonArray result = new JsonArray();
            if (!(diagram.getRole() instanceof EModel)) {
                response.sendJSON((JsonValue)result);
            } else {
                EModel emodel = (EModel)diagram.getRole();
                String path = arguments.getOrDefault("subdiagram", "");
                Diagram subDiagram = Util.getInnerDiagram((Diagram)emodel.getParent(), (String)path);
                if (!(subDiagram.getRole() instanceof EModel)) {
                    response.sendJSON((JsonValue)result);
                } else {
                    ((EModel)subDiagram.getRole(EModel.class)).getVariables().stream().forEach(variable -> {
                        JsonObject obj = new JsonObject();
                        obj.add("name", variable.getName());
                        obj.add("title", variable.getTitle());
                        result.add((JsonValue)obj);
                    });
                    response.sendJSON((JsonValue)result);
                }
            }
            return;
        }
        if ("subdiagrams".equals(action)) {
            if (DiagramUtility.isComposite((Diagram)diagram)) {
                String[] subDiagrams = (String[])StreamEx.of((Collection)Util.getSubDiagrams((Diagram)diagram)).map(s -> Util.getPath((SubDiagram)s)).toArray(String[]::new);
                response.sendStringArray(subDiagrams);
            } else {
                response.sendString("");
            }
            return;
        }
        if ("add_plot".equals(action)) {
            String plotName = arguments.getString("plotname");
            PlotInfo[] oldPlots = plots.getPlots();
            PlotInfo[] newPlots = new PlotInfo[oldPlots.length + 1];
            System.arraycopy(oldPlots, 0, newPlots, 0, oldPlots.length);
            PlotInfo newPlot = new PlotInfo((EModel)diagram.getRole(EModel.class));
            newPlot.setTitle(plotName);
            newPlots[oldPlots.length] = newPlot;
            plots.setPlots(newPlots);
            response.sendString("");
            return;
        }
        if ("remove_plot".equals(action)) {
            String plotName = arguments.getString("plotname");
            Object[] oldPlots = plots.getPlots();
            PlotInfo[] newPlots = (PlotInfo[])((StreamEx)StreamEx.of((Object[])oldPlots).filter(pi -> !pi.getTitle().equals(plotName))).toArray(PlotInfo[]::new);
            if (newPlots.length < oldPlots.length) {
                plots.setPlots(newPlots);
            }
            response.sendString("");
            return;
        }
        String plotName = arguments.get("plotname");
        PlotInfo plotInfo = plot = plotName != null ? (PlotInfo)StreamEx.of((Object[])plots.getPlots()).findFirst(pi -> pi.getTitle().equals(plotName)).orElse(null) : plots.getPlots()[0];
        if (plot == null && plotName != null) {
            throw new IllegalArgumentException("Plot " + plotName + " not found in diagram " + dePath);
        }
        if ("add".equals(action)) {
            String varName = arguments.getString("varname");
            String lineTitle = arguments.get("title");
            String path = arguments.getOrDefault("subdiagram", "");
            JSONArray colorArray = arguments.optJSONArray("color");
            Object[] curves = plot.getYVariables();
            if (StreamEx.of((Object[])curves).anyMatch(curve -> curve.getName().equals(varName) && curve.getPath().equals(path))) {
                response.error("Curve for variable '" + varName + "' already exist");
            } else if (lineTitle != null && StreamEx.of((Object[])curves).anyMatch(curve -> curve.getTitle().equals(lineTitle))) {
                response.error("Curve with title '" + lineTitle + "' already exist. Please, change line title.");
            } else {
                Curve[] newCurves = new Curve[curves.length + 1];
                System.arraycopy(curves, 0, newCurves, 0, curves.length);
                EModel emodel = (EModel)diagram.getRole(EModel.class);
                Diagram diagram2 = Util.getInnerDiagram((Diagram)emodel.getParent(), (String)path);
                if (!(diagram2.getRole() instanceof EModel)) {
                    response.error("Subdiagram " + diagram2.getName() + " is not EModel");
                } else {
                    Variable var = ((EModel)diagram2.getRole(EModel.class)).getVariable(varName);
                    String curveTitle = lineTitle == null ? var.getTitle() : lineTitle;
                    Curve newCurve = new Curve(path, varName, curveTitle, emodel);
                    if (colorArray != null) {
                        Color newColor = JSONUtils.parseColor((String)colorArray.getString(0));
                        newCurve.setPen(new Pen(new BasicStroke(1.0f), newColor));
                    }
                    newCurves[curves.length] = newCurve;
                    plot.setYVariables(newCurves);
                    response.sendString("");
                }
            }
        } else if ("remove".equals(action)) {
            String[] cnames = arguments.optStrings("rows");
            if (cnames != null) {
                HashSet<String> toRemove;
                String what = arguments.getString("what");
                if (what.equals("curves")) {
                    ArrayList<Object> curves = new ArrayList<Object>();
                    toRemove = new HashSet<String>(Arrays.asList(cnames));
                    for (Curve curve2 : plot.getYVariables()) {
                        if (toRemove.contains(curve2.getCompleteName())) continue;
                        curves.add(curve2);
                    }
                    plot.setYVariables(curves.toArray(new Curve[0]));
                } else if (what.equals("experiments") && plot.getExperiments() != null) {
                    ArrayList<Object> exps = new ArrayList<Object>();
                    toRemove = new HashSet<String>(Arrays.asList(cnames));
                    for (Experiment experiment : plot.getExperiments()) {
                        if (toRemove.contains(experiment.getName())) continue;
                        exps.add(experiment);
                    }
                    plot.setExperiments(exps.toArray(new Experiment[0]));
                }
            }
            response.sendString("");
        }
        if ("addexp".equals(action)) {
            String source = arguments.getString("source");
            DataElementPath sourcePath = DataElementPath.create((String)source);
            String varX = arguments.getString("x");
            String varY = arguments.getString("y");
            String lineTitle = arguments.get("title");
            JSONArray colorArray = arguments.optJSONArray("color");
            Object[] experiments = plot.getExperiments();
            if (experiments == null) {
                experiments = new Experiment[]{};
            }
            if (StreamEx.of((Object[])experiments).anyMatch(curve -> curve.getPath().equals((Object)sourcePath) && curve.getNameX().equals(varX) && curve.getNameY().equals(varY))) {
                response.error("Experiment already exist.");
            } else if (lineTitle != null && StreamEx.of((Object[])experiments).anyMatch(curve -> curve.getTitle().equals(lineTitle))) {
                response.error("Curve with title '" + lineTitle + "' already exist. Please, change line title.");
            } else {
                Experiment[] experimentArray = new Experiment[experiments.length + 1];
                System.arraycopy(experiments, 0, experimentArray, 0, experiments.length);
                String curveTitle = lineTitle == null ? varY : lineTitle;
                Experiment newExp = new Experiment(sourcePath, varX, varY, curveTitle, null);
                if (colorArray != null) {
                    Color newColor = JSONUtils.parseColor((String)colorArray.getString(0));
                    newExp.setPen(new Pen(new BasicStroke(1.0f), newColor));
                }
                experimentArray[experiments.length] = newExp;
                plot.setExperiments(experimentArray);
                response.sendString("");
            }
        }
    }
}

