/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.plot;

import biouml.standard.simulation.SimulationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.table.ColumnModel;
import ru.biosoft.table.RowDataElement;
import ru.biosoft.table.StandardTableDataCollection;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.util.ListUtil;

public class TableSimulationResultsWrapper
extends StandardTableDataCollection {
    private final double[] timeFilter = new double[3];
    private Map<String, List<String>> resultVariables;
    private final List<String> nameList = new ArrayList<String>();
    private final Map<String, Integer> idToIndex = new HashMap<String, Integer>();
    private double[][] values;
    private boolean initialized = false;
    private boolean initializing = false;
    private ColumnModel columnModel;

    public ColumnModel getColumnModel() {
        this.init();
        return this.columnModel;
    }

    public TableSimulationResultsWrapper(DataCollection<?> parent, String name) {
        super(null, name);
    }

    public TableSimulationResultsWrapper(Map<String, List<String>> resultVariables, double[] timeFilter) {
        this(null, "plotData");
        this.resultVariables = resultVariables;
        System.arraycopy(timeFilter, 0, this.timeFilter, 0, 3);
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.initializing = true;
        this.getInfo().getProperties().setProperty("persistent.integerIds", "true");
        this.columnModel = new ColumnModel((TableDataCollection)this);
        int rowCount = 0;
        int currentColumn = 0;
        int colCount = ListUtil.sumTotalSize(this.resultVariables);
        for (Map.Entry<String, List<String>> entry : this.resultVariables.entrySet()) {
            SimulationResult sResult = (SimulationResult)DataElementPath.create((String)entry.getKey()).getDataElement(SimulationResult.class);
            sResult = sResult.approximate(this.timeFilter[0], this.timeFilter[1], this.timeFilter[2]);
            List<String> varNames = entry.getValue();
            double[] times = sResult.getTimes();
            rowCount = times.length;
            this.values = new double[rowCount][colCount];
            for (int i = 0; i < rowCount; ++i) {
                String name = String.valueOf(times[i]).replaceAll("\\.0$", "");
                this.nameList.add(name);
                this.idToIndex.put(name, i);
            }
            Map vMap = sResult.getVariableMap();
            double[][] sValues = sResult.getValues();
            for (String varName : varNames) {
                Integer cc = (Integer)vMap.get(varName);
                if (null == cc) continue;
                String columnName = sResult.getName() + " " + varName.replace("/", "_");
                this.columnModel.addColumn(columnName, Double.class);
                for (int i = 0; i < rowCount; ++i) {
                    this.values[i][currentColumn] = sValues[i][cc];
                }
                ++currentColumn;
            }
        }
        this.initializing = false;
        this.initialized = true;
    }

    public int getSize() {
        return this.getNameList().size();
    }

    public String getName(int index) {
        return this.getNameList().get(index);
    }

    @Nonnull
    public List<String> getNameList() {
        if (this.initializing) {
            return Collections.emptyList();
        }
        this.init();
        return this.nameList;
    }

    protected RowDataElement doGet(String name) throws Exception {
        this.init();
        if (this.idToIndex.containsKey(name)) {
            return this.getAt(this.idToIndex.get(name));
        }
        return null;
    }

    public RowDataElement getAt(int index) {
        this.init();
        String name = this.getName(index);
        RowDataElement rde = new RowDataElement(name, (TableDataCollection)this);
        Object[] result = new Object[this.columnModel.getColumnCount()];
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            result[i] = this.values[index][i];
        }
        rde.setValues(result);
        return rde;
    }

    public Object getValueAt(int rowIdx, int columnIdx) {
        this.init();
        return this.values[rowIdx][columnIdx];
    }
}

