/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.plot;

import biouml.standard.simulation.SimulationResult;
import biouml.standard.simulation.plot.Plot;
import biouml.standard.simulation.plot.Series;
import com.developmentontheedge.beans.swing.table.RowModelEvent;
import com.developmentontheedge.beans.swing.table.RowModelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import ru.biosoft.access.core.DataElementPath;

public class TablePane
extends JPanel
implements PropertyChangeListener,
RowModelListener,
PlotChangeListener {
    protected static final Logger log = Logger.getLogger(TablePane.class.getName());
    protected JTable table;
    private JComboBox<ColumnNameAndPosition> allColumnsList;
    private JComboBox<ColumnNameAndPosition> visibleColumnsList;
    private SimulationResult seriesResult = null;
    private ArrayList<String> columnNames = new ArrayList();
    private JTextField lowerLimit;
    private JTextField upperLimit;
    private JTextField step;
    private boolean timeFilterInitialized = false;
    protected Plot plot;
    boolean seriesChanged = true;

    public TablePane(int ix, int iy) {
        super(new BorderLayout());
        try {
            JPanel filters = new JPanel();
            filters.setLayout(new BorderLayout());
            JPanel columnsFilterPanel = new JPanel(new GridLayout(2, 3));
            JLabel acll = new JLabel("All columns:");
            columnsFilterPanel.add(acll);
            this.allColumnsList = new JComboBox<ColumnNameAndPosition>(new ColumnNameAndPosition[0]);
            columnsFilterPanel.add(this.allColumnsList);
            this.allColumnsList.setPreferredSize(new Dimension(150, 20));
            JButton dropToRightListButton = new JButton(new AbstractAction("Add"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int index = TablePane.this.allColumnsList.getSelectedIndex();
                    if (0 > index) {
                        return;
                    }
                    ColumnNameAndPosition item = (ColumnNameAndPosition)TablePane.this.allColumnsList.getItemAt(index);
                    for (int i = 0; i < TablePane.this.visibleColumnsList.getItemCount(); ++i) {
                        if (!item.equals(TablePane.this.visibleColumnsList.getItemAt(i))) continue;
                        return;
                    }
                    TablePane.this.visibleColumnsList.addItem(item);
                    TablePane.this.drawSeries();
                }
            });
            columnsFilterPanel.add(dropToRightListButton);
            dropToRightListButton.setPreferredSize(new Dimension(30, 20));
            JLabel vcll = new JLabel("Visible columns:");
            columnsFilterPanel.add(vcll);
            this.visibleColumnsList = new JComboBox<ColumnNameAndPosition>(new ColumnNameAndPosition[0]);
            columnsFilterPanel.add(this.visibleColumnsList);
            this.visibleColumnsList.setPreferredSize(new Dimension(150, 20));
            JButton removeButton = new JButton(new AbstractAction("Remove"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int index = TablePane.this.visibleColumnsList.getSelectedIndex();
                    if (0 > index) {
                        return;
                    }
                    TablePane.this.visibleColumnsList.removeItemAt(index);
                    TablePane.this.drawSeries();
                }
            });
            columnsFilterPanel.add(removeButton);
            dropToRightListButton.setPreferredSize(new Dimension(50, 20));
            filters.add((Component)columnsFilterPanel, "North");
            JPanel timeFilterPanel = new JPanel(new GridLayout(2, 4));
            JLabel lowerLimitLabel = new JLabel("Lower time limit:");
            timeFilterPanel.add(lowerLimitLabel);
            this.lowerLimit = new JTextField("0.0");
            timeFilterPanel.add(this.lowerLimit);
            this.lowerLimit.setPreferredSize(new Dimension(100, 20));
            JLabel upperLimitLabel = new JLabel("Upper time limit:");
            timeFilterPanel.add(upperLimitLabel);
            this.upperLimit = new JTextField("1.0");
            timeFilterPanel.add(this.upperLimit);
            this.upperLimit.setPreferredSize(new Dimension(100, 20));
            JLabel stepLabel = new JLabel("Time step:");
            timeFilterPanel.add(stepLabel);
            this.step = new JTextField("0.1");
            timeFilterPanel.add(this.step);
            this.step.setPreferredSize(new Dimension(100, 20));
            JButton applyFilter = new JButton(new AbstractAction("Apply time filter"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TablePane.this.updateContents();
                }
            });
            timeFilterPanel.add(applyFilter);
            filters.add((Component)timeFilterPanel, "South");
            filters.setBorder(new EmptyBorder(0, 5, 0, 0));
            this.add((Component)filters, "North");
            this.table = new JTable(new String[][]{{""}}, new String[]{""});
            JScrollPane tablePane = new JScrollPane(this.table);
            tablePane.setPreferredSize(new Dimension(ix, iy));
            tablePane.setHorizontalScrollBarPolicy(32);
            tablePane.setVerticalScrollBarPolicy(22);
            this.add((Component)tablePane, "Center");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error occured while creating table panel: " + ex);
        }
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        Plot oldPlot = this.plot;
        this.plot = plot;
        if (oldPlot != null) {
            oldPlot.removePropertyChangeListener((PropertyChangeListener)this);
            oldPlot.getRowModel().removeRowModelListener((RowModelListener)this);
        }
        if (this.plot != null) {
            this.plot.addPropertyChangeListener((PropertyChangeListener)this);
            this.plot.getRowModel().addRowModelListener((RowModelListener)this);
        }
        this.seriesChanged = true;
    }

    public void updateContents() {
        List series = this.plot.getSeries();
        if (series == null) {
            return;
        }
        Iterator iter = series.iterator();
        this.seriesResult = new SimulationResult(null, "");
        this.columnNames.clear();
        this.columnNames.add("Time");
        boolean firstTime = true;
        int rowCount = 0;
        int currentColumn = 0;
        this.allColumnsList.removeAllItems();
        this.visibleColumnsList.removeAllItems();
        this.allColumnsList.addItem(new ColumnNameAndPosition("Time", -1));
        this.visibleColumnsList.addItem(new ColumnNameAndPosition("Time", -1));
        if (iter != null) {
            while (iter.hasNext()) {
                block17: {
                    Series s = (Series)iter.next();
                    if (s.getSourceNature().equals((Object)Series.SourceNature.EXPERIMENTAL_DATA) || "time".equalsIgnoreCase(s.getYVar())) continue;
                    String columnName = s.getSource() + " " + s.getYVar();
                    this.columnNames.add(columnName);
                    this.allColumnsList.addItem(new ColumnNameAndPosition(columnName, currentColumn));
                    this.visibleColumnsList.addItem(new ColumnNameAndPosition(columnName, currentColumn));
                    try {
                        int i;
                        String path;
                        double[][] values;
                        if (!s.getSourceNature().equals((Object)Series.SourceNature.SIMULATION_RESULT)) break block17;
                        SimulationResult sResult = (SimulationResult)DataElementPath.create((String)s.getSource()).getDataElement(SimulationResult.class);
                        if (this.timeFilterInitialized) {
                            double lowLim = Double.parseDouble(this.lowerLimit.getText());
                            double upLim = Double.parseDouble(this.upperLimit.getText());
                            double st = Double.parseDouble(this.step.getText());
                            sResult = sResult.approximate(lowLim, upLim, st);
                        }
                        double[] times = sResult.getTimes();
                        if (firstTime) {
                            rowCount = sResult.getTimes().length;
                            this.seriesResult.setTimes(times);
                            try {
                                if (!this.timeFilterInitialized) {
                                    this.lowerLimit.setText(String.valueOf(times[0]));
                                    this.upperLimit.setText(String.valueOf(times[times.length - 1]));
                                    this.step.setText(String.valueOf(times[1] - times[0]));
                                    this.timeFilterInitialized = true;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            values = new double[rowCount][series.size()];
                            this.seriesResult.setValues(values);
                            firstTime = false;
                        }
                        values = this.seriesResult.getValues();
                        double[][] sValues = sResult.getValues();
                        Map vMap = sResult.getVariablePathMap();
                        Integer cc = (Integer)vMap.get(path = s.getYPath().isEmpty() ? s.getYVar() : s.getYPath() + "/" + s.getYVar());
                        if (null != cc) {
                            for (i = 0; i < rowCount; ++i) {
                                values[i][currentColumn] = sValues[i][cc];
                            }
                        } else {
                            for (i = 0; i < rowCount; ++i) {
                                values[i][currentColumn] = times[i];
                            }
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "No source " + s.getSource() + " found in repository.");
                    }
                }
                ++currentColumn;
            }
        }
        try {
            this.allColumnsList.setSelectedIndex(0);
            this.visibleColumnsList.setSelectedIndex(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.seriesChanged) {
            this.seriesChanged = false;
        }
        this.drawSeries();
    }

    private void drawSeries() {
        int colQ = this.visibleColumnsList.getItemCount();
        boolean timeColumnVisible = false;
        for (int i = 0; i < colQ; ++i) {
            if (-1 != this.visibleColumnsList.getItemAt(i).getPosition()) continue;
            timeColumnVisible = true;
        }
        int[] requiredColumns = new int[timeColumnVisible ? colQ - 1 : colQ];
        int j = 0;
        for (int i = 0; i < colQ; ++i) {
            int pos = this.visibleColumnsList.getItemAt(i).getPosition();
            if (-1 == pos) continue;
            requiredColumns[j] = pos;
            ++j;
        }
        this.redrawSeries(this.seriesResult, this.columnNames, requiredColumns, timeColumnVisible);
    }

    private void redrawSeries(final SimulationResult seriesResult, final ArrayList<String> columnNames, final int[] requiredColumns, final boolean timeColumnVisible) {
        try {
            this.table.setModel(new AbstractTableModel(){

                @Override
                public String getColumnName(int y) {
                    try {
                        if (timeColumnVisible) {
                            if (0 == y) {
                                return (String)columnNames.get(0);
                            }
                            return (String)columnNames.get(requiredColumns[y - 1] + 1);
                        }
                        return (String)columnNames.get(requiredColumns[y] + 1);
                    }
                    catch (Exception exception) {
                        return "";
                    }
                }

                @Override
                public Object getValueAt(int x, int y) {
                    try {
                        if (timeColumnVisible) {
                            if (0 == y) {
                                return String.valueOf(seriesResult.getTimes()[x]);
                            }
                            return String.valueOf(seriesResult.getValues()[x][requiredColumns[y - 1]]);
                        }
                        return String.valueOf(seriesResult.getValues()[x][requiredColumns[y]]);
                    }
                    catch (Exception exception) {
                        return "";
                    }
                }

                @Override
                public int getRowCount() {
                    try {
                        if (0 >= seriesResult.getTimes().length) {
                            return 0;
                        }
                        return seriesResult.getTimes().length;
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }

                @Override
                public int getColumnCount() {
                    try {
                        if (0 >= requiredColumns.length) {
                            return timeColumnVisible ? 1 : 0;
                        }
                        return requiredColumns.length + (timeColumnVisible ? 1 : 0);
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }
            });
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                TableColumn tc = this.table.getColumn(this.table.getColumnName(i));
                tc.setPreferredWidth(String.valueOf(tc.getHeaderValue()).length() * 10);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error occured while filling in chart data for series : \n" + ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
    }

    public void tableChanged(RowModelEvent e) {
    }

    public void plotChanged(PlotChangeEvent arg0) {
    }

    private static class ColumnNameAndPosition {
        private String name;
        private int position;

        public ColumnNameAndPosition(String name, int position) {
            this.name = name;
            this.position = position;
        }

        public String getName() {
            return this.name;
        }

        public int getPosition() {
            return this.position;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object instanceof ColumnNameAndPosition) {
                ColumnNameAndPosition o = (ColumnNameAndPosition)object;
                if (null == this.name) {
                    return null == o.getName();
                }
                return this.name.equals(o.getName());
            }
            return false;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

