/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.plot;

import biouml.plugins.simulation.ResultPlotPane;
import biouml.standard.simulation.plot.Plot;
import biouml.standard.simulation.plot.Series;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.font.ColorFont;

public class PlotPane
extends JPanel
implements PropertyChangeListener,
PlotChangeListener {
    protected static final Logger log = Logger.getLogger(PlotPane.class.getName());
    protected JFreeChart chart;
    private ChartPanel chartPanel;
    private static final Shape circle = new Ellipse2D.Float(0.0f, 0.0f, 6.0f, 6.0f);
    private static final Paint[] POSSIBLE_COLORS = new Paint[]{new Color(255, 85, 85), new Color(85, 85, 255), new Color(0, 255, 0), Color.pink, ChartColor.DARK_RED, ChartColor.DARK_BLUE, ChartColor.DARK_GREEN, ChartColor.DARK_YELLOW, ChartColor.DARK_MAGENTA, ChartColor.DARK_CYAN, Color.darkGray, ChartColor.VERY_DARK_RED, ChartColor.VERY_DARK_BLUE, ChartColor.VERY_DARK_GREEN, ChartColor.VERY_DARK_YELLOW, ChartColor.VERY_DARK_MAGENTA, ChartColor.VERY_DARK_CYAN};
    protected Plot plot;
    boolean seriesChanged = true;
    public static final int MAX_DELAY = 200;
    private Thread redrawThread = null;

    public PlotPane(int ix, int iy) {
        super(new BorderLayout());
        try {
            this.chart = ChartFactory.createXYLineChart((String)"", (String)"Axis (X)", (String)"Axis (Y)", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            this.chart.getXYPlot().setBackgroundPaint((Paint)Color.white);
            this.chart.setBackgroundPaint((Paint)Color.white);
            this.chartPanel = new ChartPanel(this.chart);
            this.chartPanel.setPreferredSize(new Dimension(ix, iy));
            this.add((Component)this.chartPanel);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error occured while creating chart panel: " + ex);
        }
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        Plot oldPlot = this.plot;
        this.plot = plot;
        if (oldPlot != null) {
            oldPlot.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.plot != null) {
            this.plot.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.seriesChanged = true;
        this.setChartProperties();
    }

    protected XYSeriesEx findXYSeries(Series s) {
        XYSeriesCollection xyDataset = (XYSeriesCollection)this.chart.getXYPlot().getDataset();
        int xySeriesCount = xyDataset.getSeriesCount();
        for (int j = 0; j < xySeriesCount; ++j) {
            XYSeriesEx xyS = (XYSeriesEx)xyDataset.getSeries(j);
            if (xyS.getSeries() != s) continue;
            return xyS;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("plot")) {
            this.setPlot((Plot)pce.getNewValue());
            this.clearChart();
        } else if (pce.getPropertyName().equals("title")) {
            this.chart.setTitle((String)pce.getNewValue());
        } else if (pce.getPropertyName().equals("xTitle")) {
            this.chart.getXYPlot().getDomainAxis().setLabel((String)pce.getNewValue());
        } else if (pce.getPropertyName().equals("xTitleFont")) {
            this.chart.getXYPlot().getDomainAxis().setLabelFont(((ColorFont)pce.getNewValue()).getFont());
            this.chart.getXYPlot().getDomainAxis().setLabelPaint((Paint)((ColorFont)pce.getNewValue()).getColor());
        } else if (pce.getPropertyName().equals("xTickLabelFont")) {
            this.chart.getXYPlot().getDomainAxis().setTickLabelFont(((ColorFont)pce.getNewValue()).getFont());
        } else if (pce.getPropertyName().equals("xTo")) {
            this.chart.getXYPlot().getDomainAxis().setUpperBound(((Double)pce.getNewValue()).doubleValue());
        } else if (pce.getPropertyName().equals("xFrom")) {
            this.chart.getXYPlot().getDomainAxis().setLowerBound(((Double)pce.getNewValue()).doubleValue());
        } else if (pce.getPropertyName().equals("yTitle")) {
            this.chart.getXYPlot().getRangeAxis().setLabel((String)pce.getNewValue());
        } else if (pce.getPropertyName().equals("yTitleFont")) {
            this.chart.getXYPlot().getRangeAxis().setLabelFont(((ColorFont)pce.getNewValue()).getFont());
            this.chart.getXYPlot().getRangeAxis().setLabelPaint((Paint)((ColorFont)pce.getNewValue()).getColor());
        } else if (pce.getPropertyName().equals("xTickLabelFont")) {
            this.chart.getXYPlot().getRangeAxis().setTickLabelFont(((ColorFont)pce.getNewValue()).getFont());
        } else if (pce.getPropertyName().equals("yTo")) {
            this.chart.getXYPlot().getRangeAxis().setUpperBound(((Double)pce.getNewValue()).doubleValue());
        } else if (pce.getPropertyName().equals("yFrom")) {
            this.chart.getXYPlot().getRangeAxis().setLowerBound(((Double)pce.getNewValue()).doubleValue());
        } else if (pce.getPropertyName().equals("legend")) {
            Series s = (Series)pce.getSource();
            try {
                XYSeriesEx xyEx = this.findXYSeries(s);
                xyEx.setKey((Comparable)((Object)((String)pce.getNewValue())));
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Error occured while updating legend to value " + pce.getNewValue() + ": " + ex);
            }
        } else if (!pce.getPropertyName().equals("spec") && pce.getPropertyName().equals("plotData")) {
            this.scheduleRedraw();
        }
    }

    public void plotChanged(PlotChangeEvent event) {
        if (this.plot == null) {
            return;
        }
        try {
            XYPlot xyPlot = (XYPlot)event.getSource();
            boolean isNotificatioNEnabled = this.plot.isNotificationEnabled();
            this.plot.setNotificationEnabled(false);
            if (this.chart.getTitle() != null) {
                this.plot.setTitle(this.chart.getTitle().getText());
            }
            this.plot.setXTitle(xyPlot.getDomainAxis().getLabel());
            this.plot.setYTitle(xyPlot.getRangeAxis().getLabel());
            Paint paintX = xyPlot.getDomainAxis().getLabelPaint();
            this.plot.setXTitleFont(new ColorFont(xyPlot.getDomainAxis().getLabelFont(), paintX instanceof Color ? (Color)paintX : Color.black));
            Paint paintY = xyPlot.getRangeAxis().getLabelPaint();
            this.plot.setYTitleFont(new ColorFont(xyPlot.getRangeAxis().getLabelFont(), paintY instanceof Color ? (Color)paintY : Color.black));
            this.plot.setXTickLabelFont(new ColorFont(xyPlot.getDomainAxis().getTickLabelFont(), Color.black));
            this.plot.setYTickLabelFont(new ColorFont(xyPlot.getRangeAxis().getTickLabelFont(), Color.black));
            this.plot.setXFrom(xyPlot.getDomainAxis().getLowerBound());
            this.plot.setXTo(xyPlot.getDomainAxis().getUpperBound());
            this.plot.setYFrom(xyPlot.getRangeAxis().getLowerBound());
            this.plot.setYTo(xyPlot.getRangeAxis().getUpperBound());
            this.plot.setXAutoRange(false);
            this.plot.setYAutoRange(false);
            this.plot.setNotificationEnabled(isNotificatioNEnabled);
            if (this.chart.getXYPlot() == null) {
                return;
            }
            XYSeriesCollection xyDataset = (XYSeriesCollection)this.chart.getXYPlot().getDataset();
            for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
                XYSeriesEx xyS = (XYSeriesEx)xyDataset.getSeries(i);
                Series s = xyS.getSeries();
                if (s == null) continue;
                s.setLegend((String)((Object)xyS.getKey()));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error occured while updating series: " + t, t);
        }
    }

    public void setChartProperties() {
        this.chart.getPlot().removeChangeListener((PlotChangeListener)this);
        PlotPane.setChartProperties(this.plot, this.chart);
        this.chart.getPlot().addChangeListener((PlotChangeListener)this);
    }

    public static void setChartProperties(Plot plot, JFreeChart chart) {
        if (plot != null) {
            chart.setTitle(plot.getTitle());
            ValueAxis axis = PlotPane.generateAxis(Plot.AxisType.getAxisType((String)plot.getXAxisType()));
            if (axis != null) {
                chart.getXYPlot().setDomainAxis(axis);
            }
            if ((axis = PlotPane.generateAxis(Plot.AxisType.getAxisType((String)plot.getYAxisType()))) != null) {
                chart.getXYPlot().setRangeAxis(axis);
            }
            chart.getXYPlot().getDomainAxis().setLabel(plot.getXTitle());
            chart.getXYPlot().getRangeAxis().setLabel(plot.getYTitle());
            chart.getXYPlot().getDomainAxis().setLabelFont(plot.getXTitleFont().getFont());
            chart.getXYPlot().getRangeAxis().setLabelFont(plot.getYTitleFont().getFont());
            chart.getXYPlot().getDomainAxis().setLabelPaint((Paint)plot.getXTitleFont().getColor());
            chart.getXYPlot().getRangeAxis().setLabelPaint((Paint)plot.getYTitleFont().getColor());
            chart.getXYPlot().getDomainAxis().setTickLabelFont(plot.getXTickLabelFont().getFont());
            chart.getXYPlot().getRangeAxis().setTickLabelFont(plot.getYTickLabelFont().getFont());
            chart.getXYPlot().getDomainAxis().setTickLabelPaint((Paint)plot.getXTickLabelFont().getColor());
            chart.getXYPlot().getRangeAxis().setTickLabelPaint((Paint)plot.getYTickLabelFont().getColor());
            if (plot.getXFrom() != plot.getXTo()) {
                chart.getXYPlot().getDomainAxis().setLowerBound(plot.getXFrom());
                chart.getXYPlot().getDomainAxis().setUpperBound(plot.getXTo());
            }
            chart.getXYPlot().getDomainAxis().setAutoRange(plot.isXAutoRange());
            if (plot.getYFrom() != plot.getYTo()) {
                chart.getXYPlot().getRangeAxis().setLowerBound(plot.getYFrom());
                chart.getXYPlot().getRangeAxis().setUpperBound(plot.getYTo());
            }
            chart.getXYPlot().getRangeAxis().setAutoRange(plot.isYAutoRange());
            chart.getXYPlot().setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(ResultPlotPane.POSSIBLE_COLORS, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
        }
    }

    public static ValueAxis generateAxis(Plot.AxisType axisType) {
        switch (axisType) {
            case LOGARITHMIC: {
                LogarithmicAxis logAxis = new LogarithmicAxis("");
                logAxis.setExpTickLabelsFlag(true);
                logAxis.setStrictValuesFlag(false);
                return logAxis;
            }
            case LOG10: {
                LogarithmicAxis logAxis = new LogarithmicAxis("");
                logAxis.setLog10TickLabelsFlag(true);
                logAxis.setStrictValuesFlag(false);
                return logAxis;
            }
            case NUMBER: {
                NumberAxis numAxis = new NumberAxis("");
                numAxis.setAutoRangeIncludesZero(false);
                return numAxis;
            }
        }
        return null;
    }

    public void clearChart() {
        XYSeriesCollection xyDataset = (XYSeriesCollection)this.chart.getXYPlot().getDataset();
        if (xyDataset != null) {
            xyDataset.removeAllSeries();
        }
    }

    public synchronized void scheduleRedraw() {
        this.seriesChanged = true;
        if (this.redrawThread != null) {
            return;
        }
        this.redrawThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    PlotPane.this.redrawChart();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                PlotPane.this.redrawThread = null;
            }
        };
        this.redrawThread.start();
    }

    public synchronized void redrawChart() {
        if (!this.seriesChanged) {
            return;
        }
        this.chart.getPlot().removeChangeListener((PlotChangeListener)this);
        PlotPane.redrawChart(this.plot, this.chart);
        this.chart.getPlot().addChangeListener((PlotChangeListener)this);
        if (this.seriesChanged) {
            this.seriesChanged = false;
        }
    }

    public static void redrawChart(Plot plot, JFreeChart chart) {
        chart.getXYPlot().setDataset((XYDataset)new XYSeriesCollection());
        if (plot == null) {
            log.log(Level.SEVERE, "Could not redraw chart: the \"plot\" structure is null.");
            return;
        }
        List series = plot.getSeries();
        if (series == null) {
            return;
        }
        Iterator iter = series.iterator();
        if (iter != null) {
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setDrawSeriesLineAsPath(true);
            int counter = 0;
            while (iter.hasNext()) {
                Series nextSeries = (Series)iter.next();
                if (nextSeries.getSourceNature().equals((Object)Series.SourceNature.SIMULATION_RESULT)) {
                    renderer.setSeriesShapesVisible(counter, false);
                } else if (nextSeries.getSourceNature().equals((Object)Series.SourceNature.EXPERIMENTAL_DATA)) {
                    renderer.setSeriesLinesVisible(counter, false);
                    renderer.setSeriesShape(counter, circle);
                }
                Pen spec = nextSeries.getSpec();
                if (spec != null) {
                    renderer.setSeriesPaint(counter, (Paint)spec.getColor());
                    renderer.setSeriesStroke(counter, (Stroke)spec.getStroke());
                } else if (counter < POSSIBLE_COLORS.length) {
                    Color color = (Color)POSSIBLE_COLORS[counter];
                    renderer.setSeriesPaint(counter, POSSIBLE_COLORS[counter]);
                    nextSeries.setSpec(new Pen(1.0f, color));
                }
                PlotPane.redrawSeries(nextSeries, chart);
                ++counter;
            }
            chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
            PlotPane.setChartProperties(plot, chart);
        }
    }

    protected static void redrawSeries(Series s, JFreeChart chart) {
        try {
            XYSeriesCollection xyDataset = (XYSeriesCollection)chart.getXYPlot().getDataset();
            double[] xValues = s.getXValues();
            double[] yValues = s.getYValues();
            String name = s.getLegend() != null && !s.getLegend().equals("") ? s.getLegend() : s.getYVar();
            XYSeriesEx series = new XYSeriesEx(name, s, s.getXVar().equals("time"));
            for (int i = 0; i < xValues.length; ++i) {
                series.add(xValues[i], yValues[i]);
            }
            if (xyDataset.getSeriesCount() > 15) {
                return;
            }
            xyDataset.addSeries((XYSeries)series);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error occured while filling in chart data for series : \n" + ex);
        }
    }

    public static class XYSeriesEx
    extends XYSeries {
        protected Series series;

        public XYSeriesEx(String name, Series series, boolean sortAndRemoveDuplicates) {
            super((Comparable)((Object)name), sortAndRemoveDuplicates, true);
            this.series = series;
        }

        public Series getSeries() {
            return this.series;
        }
    }
}

