/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.plot;

import biouml.plugins.simulation.resources.MessageBundle;
import biouml.standard.simulation.SimulationResult;
import biouml.standard.simulation.plot.DataGeneratorSeries;
import biouml.standard.simulation.plot.Plot;
import biouml.standard.simulation.plot.Series;
import com.developmentontheedge.beans.Option;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.table.TableDataCollection;

public class PlotEx
extends Option {
    protected static final Logger log = Logger.getLogger(PlotEx.class.getName());
    protected Plot plot;
    protected DataElementPath savePlotPath = null;
    protected DataElementPath currentPlotPath = null;
    protected SimulationResult defaultResult;

    public PlotEx(Plot plot) {
        this.plot = plot;
        if (plot != null) {
            this.currentPlotPath = DataElementPath.create((DataElement)plot);
            plot.setParent((Option)this);
        }
    }

    public PlotEx(SimulationResult result) {
        this.plot = Plot.createDefaultPlot(null);
        this.currentPlotPath = DataElementPath.create((DataElement)this.plot);
        this.defaultResult = result;
        this.plot.setParent((Option)this);
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        Plot oldPlot = this.plot;
        oldPlot.setParent(null);
        this.plot = plot;
        this.plot.setParent((Option)this);
        this.firePropertyChange("plot", oldPlot, plot);
    }

    public DataElementPath getSavePlotPath() {
        return this.savePlotPath;
    }

    public void setSavePlotPath(DataElementPath path) {
        this.savePlotPath = path;
    }

    public DataElementPath getCurrentPlotPath() {
        return this.currentPlotPath;
    }

    public void setCurrentPlotPath(DataElementPath path) {
        this.currentPlotPath = path;
        Plot oldPlot = this.plot;
        oldPlot.setParent(null);
        this.plot = (Plot)path.getDataElement(Plot.class);
        this.plot.setParent((Option)this);
        this.firePropertyChange("plot", oldPlot, this.plot);
    }

    public SimulationResult getDefaultSimulationResult() {
        return this.defaultResult;
    }

    public void setDefaultSimulationResult(SimulationResult defaultResult) {
        this.defaultResult = defaultResult;
    }

    public SimulationResult getSimulationResult(DataElementPath resultPath) {
        DataElement dc = resultPath.optDataElement();
        if (dc instanceof SimulationResult) {
            return (SimulationResult)dc;
        }
        return null;
    }

    public boolean hasDefaultResult() {
        return this.defaultResult != null;
    }

    public boolean isDefaultResult(String name) {
        return this.defaultResult.getName().equals(name);
    }

    public boolean savePlot() {
        try {
            MessageBundle messageBundle = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
            if (this.savePlotPath == null) {
                String title = messageBundle.getResourceString("PLOT_PANE_PLOT_DC_ERROR_TITLE");
                String message = messageBundle.getResourceString("PLOT_PANE_PLOT_DC_ERROR_MESSAGE");
                JOptionPane.showMessageDialog(null, message, title, 0);
                return false;
            }
            List series = this.plot.getSeries();
            if (series != null) {
                for (Series s : series) {
                    TableDataCollection experiment;
                    if (s instanceof DataGeneratorSeries) continue;
                    String resultName = s.getSource();
                    if (s.getSourceNature().equals((Object)Series.SourceNature.SIMULATION_RESULT)) {
                        DataElement result = DataElementPath.create((String)s.getSource()).optDataElement();
                        if (result != null && result instanceof SimulationResult) continue;
                        String title = messageBundle.getResourceString("PLOT_PANE_PLOT_INCONSISTENT_ERROR_TITLE");
                        String message = messageBundle.getResourceString("PLOT_PANE_PLOT_INCONSISTENT_SR_ERROR_MESSAGE");
                        message = MessageFormat.format(message, resultName);
                        JOptionPane.showMessageDialog(null, message, title, 0);
                        return false;
                    }
                    if (!s.getSourceNature().equals((Object)Series.SourceNature.EXPERIMENTAL_DATA) || (experiment = (TableDataCollection)DataElementPath.create((String)s.getSource()).optDataElement(TableDataCollection.class)) != null) continue;
                    String title = messageBundle.getResourceString("PLOT_PANE_PLOT_INCONSISTENT_ERROR_TITLE");
                    String message = messageBundle.getResourceString("PLOT_PANE_PLOT_INCONSISTENT_EDF_ERROR_MESSAGE");
                    message = MessageFormat.format(message, resultName);
                    JOptionPane.showMessageDialog(null, message, title, 0);
                    return false;
                }
            }
            PlotEx.savePlot(this.plot, this.savePlotPath);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error occured while saving plot in data collection: " + ex);
        }
        return true;
    }

    public static void savePlot(Plot plot, DataElementPath plotPath) throws Exception {
        DataCollection parent = plotPath.getParentCollection();
        Plot plot_ = plot.clone(parent, plotPath.getName());
        parent.put((DataElement)plot_);
        parent.release(plot_.getName());
    }

    public TableDataCollection getExperiment(DataElementPath experimentPath) {
        DataElement de = experimentPath.optDataElement();
        if (de instanceof TableDataCollection) {
            return (TableDataCollection)de;
        }
        return null;
    }
}

