/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.plot;

import biouml.plugins.simulation.plot.PlotEx;
import biouml.plugins.simulation.resources.MessageBundle;
import biouml.standard.diagram.Util;
import biouml.standard.simulation.SimulationResult;
import biouml.standard.simulation.plot.Plot;
import biouml.standard.simulation.plot.Series;
import com.developmentontheedge.beans.swing.PropertyInspector;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.repository.DataElementPathField;
import ru.biosoft.table.TableColumn;
import ru.biosoft.table.TableDataCollection;

public class PlotEditorPane
extends JPanel {
    protected static final Logger log = Logger.getLogger(PlotEditorPane.class.getName());
    protected MessageBundle messageBundle = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
    protected PlotEx plotEx;
    protected PropertyInspector plotInspector = new PropertyInspector();
    protected TabularPropertyInspector tabSeriesInspector = new TabularPropertyInspector();
    protected DataElementPathField resultPath = null;
    protected JComboBox<String> xPath = new JComboBox();
    protected JComboBox<VariableItem> xVariable = new JComboBox();
    protected JComboBox<String> yPath = new JComboBox();
    protected JComboBox<VariableItem> yVariable = new JComboBox();
    protected DataElementPathField experimentPath = null;
    protected JComboBox<String> plotType = new JComboBox();
    protected JButton addButton = new JButton();
    protected JButton removeButton = new JButton();
    protected JRadioButton resultNameRB = new JRadioButton();
    protected JRadioButton experimentNameRB = new JRadioButton();
    private ActionListener addButtonListener;
    private ActionListener removeButtonListener;
    private ActionListener pathListener;
    private DocumentListener documentListener;
    private ActionListener resultNameRBListener;
    private ActionListener experimentRBListener;
    private ListSelectionListener seriesSelectionListener;
    private PropertyChangeListener plotPropertyChangeListener;

    public PlotEditorPane() {
        this.createInterfaceElements();
        this.initListeners();
    }

    public PlotEditorPane(PlotEx plotEx) {
        this.createInterfaceElements();
        this.initListeners();
        this.setPlot(plotEx, true);
    }

    public void setPlot(PlotEx plotEx) {
        this.setPlot(plotEx, false);
    }

    public void setPlot(PlotEx plotEx, boolean mode) {
        this.plotEx = plotEx;
        this.updateInterfaceElements(mode);
        this.registerListeners();
        if (plotEx.hasDefaultResult()) {
            this.resultPath.setPath(DataElementPath.create((DataElement)plotEx.getDefaultSimulationResult()));
            this.resultNameRB.setSelected(true);
            this.updateVariableCombos();
        }
    }

    protected Border createBorder(String key) {
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        return BorderFactory.createTitledBorder(loweredetched, this.messageBundle.getResourceString(key));
    }

    protected void createInterfaceElements() {
        this.setLayout(new BorderLayout());
        JPanel upperPane = new JPanel();
        upperPane.setLayout(new GridBagLayout());
        upperPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel seriesPane = new JPanel(new GridBagLayout());
        seriesPane.setBorder(this.createBorder("PLOT_SERIES_BORDER_TITLE"));
        upperPane.add((Component)seriesPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        seriesPane.add((Component)this.resultNameRB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 0, 0), 0, 0));
        seriesPane.add((Component)this.experimentNameRB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 0, 0), 0, 0));
        seriesPane.add((Component)new JLabel(this.messageBundle.getResourceString("PLOT_SIMULATION_RESULT")), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 2, 0, 0), 0, 0));
        seriesPane.add((Component)new JLabel(this.messageBundle.getResourceString("PLOT_EXPERIMENTAL_DATA")), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 2, 0, 0), 0, 0));
        seriesPane.add((Component)new JLabel(this.messageBundle.getResourceString("PLOT_X_VARIABLE")), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 2, 0, 0), 0, 0));
        seriesPane.add((Component)new JLabel(this.messageBundle.getResourceString("PLOT_Y_VARIABLE")), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 2, 0, 0), 0, 0));
        this.resultPath = new DataElementPathField("resultPath", SimulationResult.class, this.messageBundle.getResourceString("CLICK_SIMULATION_RESULT"), null, true);
        seriesPane.add((Component)this.resultPath, new GridBagConstraints(2, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 0, 0), 0, 0));
        this.experimentPath = new DataElementPathField("experimentPath", TableDataCollection.class, this.messageBundle.getResourceString("CLICK_EXPERIMENT"), null, true);
        seriesPane.add((Component)this.experimentPath, new GridBagConstraints(2, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(1, 3, 0, 0), 0, 0));
        seriesPane.add(this.xPath, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 2, 0, 0), 0, 0));
        seriesPane.add(this.xVariable, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 2, 0, 0), 0, 0));
        seriesPane.add(this.yPath, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 2, 0, 0), 0, 0));
        seriesPane.add(this.yVariable, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 2, 0, 0), 0, 0));
        this.xPath.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PlotEditorPane.this.resultNameRB.isSelected() && PlotEditorPane.this.resultPath.getPath() != null) {
                    SimulationResult result = PlotEditorPane.this.plotEx.getSimulationResult(PlotEditorPane.this.resultPath.getPath());
                    List<String> availableVariables = PlotEditorPane.getVariablesForPath(e.getItem().toString(), result);
                    PlotEditorPane.this.xVariable.removeAllItems();
                    for (String var : availableVariables) {
                        VariableItem item = new VariableItem(var);
                        PlotEditorPane.this.xVariable.addItem(item);
                        if (!var.equals("time")) continue;
                        PlotEditorPane.this.xVariable.setSelectedItem(item);
                    }
                }
            }
        });
        this.yPath.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PlotEditorPane.this.resultNameRB.isSelected() && PlotEditorPane.this.resultPath.getPath() != null) {
                    PlotEditorPane.this.yVariable.removeAllItems();
                    SimulationResult result = PlotEditorPane.this.plotEx.getSimulationResult(PlotEditorPane.this.resultPath.getPath());
                    List<String> availableVariables = PlotEditorPane.getVariablesForPath(e.getItem().toString(), result);
                    for (String var : availableVariables) {
                        PlotEditorPane.this.yVariable.addItem(new VariableItem(var));
                    }
                    PlotEditorPane.this.yVariable.setSelectedIndex(0);
                }
            }
        });
        this.addButton.setText(this.messageBundle.getResourceString("PLOT_ADD_BUTTON"));
        upperPane.add((Component)this.addButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.removeButton.setText(this.messageBundle.getResourceString("PLOT_REMOVE_BUTTON"));
        upperPane.add((Component)this.removeButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.addButton.setMinimumSize(this.removeButton.getMinimumSize());
        this.addButton.setPreferredSize(this.removeButton.getMinimumSize());
        this.plotInspector.setPreferredSize(new Dimension(400, 320));
        this.plotInspector.setMinimumSize(new Dimension(300, 200));
        this.plotInspector.setBorder(this.createBorder("PLOT_INSPECTOR_BORDER_TITLE"));
        upperPane.add((Component)this.plotInspector, new GridBagConstraints(1, 0, 1, 3, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabSeriesInspector.setBorder(this.createBorder("PLOT_TAB_PROPERTIES_BORDER_TITLE"));
        this.tabSeriesInspector.setPreferredSize(new Dimension(400, 200));
        JSplitPane splitPane = new JSplitPane(0, false, upperPane, (Component)this.tabSeriesInspector);
        splitPane.setDividerLocation(0.5);
        splitPane.setDividerSize(2);
        splitPane.setBorder(null);
        this.add((Component)splitPane, "Center");
    }

    public void updateInterfaceElements(boolean extendedMode) {
        if (extendedMode) {
            this.plotInspector.explore((Object)this.plotEx);
        } else {
            this.plotInspector.explore((Object)this.plotEx.getPlot());
        }
        this.plotInspector.expandAll(true);
        this.plotInspector.setRootVisible(false);
        this.initTabSeriesInspector(this.plotEx.getPlot());
    }

    private void initListeners() {
        this.plotPropertyChangeListener = e -> {
            if (e.getPropertyName().equals("plot")) {
                this.updateSeries();
            }
        };
        this.addButtonListener = ae -> this.addSeries();
        this.removeButtonListener = ae -> {
            int index = this.tabSeriesInspector.getTable().getSelectedRow();
            this.removeSeries(index);
        };
        this.pathListener = ie -> this.updateVariableCombos();
        this.documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PlotEditorPane.this.updateVariableCombos();
            }
        };
        this.resultNameRBListener = e -> {
            this.experimentNameRB.setSelected(false);
            this.updateVariableCombos();
        };
        this.experimentRBListener = e -> {
            this.resultNameRB.setSelected(false);
            this.updateVariableCombos();
        };
        this.seriesSelectionListener = e -> {
            int index = this.tabSeriesInspector.getTable().getSelectedRow();
            this.removeButton.setEnabled(index >= 0);
        };
    }

    protected void registerListeners() {
        this.plotEx.removePropertyChangeListener(this.plotPropertyChangeListener);
        this.plotEx.addPropertyChangeListener(this.plotPropertyChangeListener);
        this.addButton.removeActionListener(this.addButtonListener);
        this.addButton.addActionListener(this.addButtonListener);
        this.removeButton.removeActionListener(this.removeButtonListener);
        this.removeButton.addActionListener(this.removeButtonListener);
        this.resultPath.removeActionListener(this.pathListener);
        this.resultPath.addActionListener(this.pathListener);
        this.resultPath.getDocument().removeDocumentListener(this.documentListener);
        this.resultPath.getDocument().addDocumentListener(this.documentListener);
        this.experimentPath.removeActionListener(this.pathListener);
        this.experimentPath.addActionListener(this.pathListener);
        this.experimentPath.getDocument().removeDocumentListener(this.documentListener);
        this.experimentPath.getDocument().addDocumentListener(this.documentListener);
        this.resultNameRB.removeActionListener(this.resultNameRBListener);
        this.resultNameRB.addActionListener(this.resultNameRBListener);
        this.experimentNameRB.removeActionListener(this.experimentRBListener);
        this.experimentNameRB.addActionListener(this.experimentRBListener);
        this.tabSeriesInspector.getTable().getSelectionModel().removeListSelectionListener(this.seriesSelectionListener);
        this.tabSeriesInspector.getTable().getSelectionModel().addListSelectionListener(this.seriesSelectionListener);
    }

    protected void updateSeries() {
        this.initTabSeriesInspector(this.plotEx.getPlot());
    }

    protected void initTabSeriesInspector(Plot plot) {
        if (plot == null) {
            return;
        }
        List series = plot.getSeries();
        if (series != null && series.size() > 0) {
            this.tabSeriesInspector.explore(plot.getRowModel(), series.get(0), 4);
        } else {
            this.tabSeriesInspector.explore(plot.getRowModel(), (Object)Plot.getDefaultSeries(), 4);
        }
    }

    protected void updateVariableCombos() {
        try {
            TableDataCollection experiment;
            this.xVariable.removeAllItems();
            this.xPath.removeAllItems();
            this.yVariable.removeAllItems();
            this.yPath.removeAllItems();
            if (this.resultNameRB.isSelected() && this.resultPath.getPath() != null) {
                SimulationResult result = this.plotEx.getSimulationResult(this.resultPath.getPath());
                if (result == null) {
                    return;
                }
                Set paths = result.getPaths();
                for (String path : paths) {
                    this.yPath.addItem(path);
                    this.xPath.addItem(path);
                }
                this.xPath.setSelectedItem("");
                this.yPath.setSelectedItem("");
            } else if (this.experimentNameRB.isSelected() && this.experimentPath.getPath() != null && (experiment = this.plotEx.getExperiment(this.experimentPath.getPath())) != null && experiment.getColumnModel().getColumnCount() > 0) {
                for (TableColumn column : experiment.getColumnModel()) {
                    this.yVariable.addItem(new VariableItem(column.getName()));
                    this.xVariable.addItem(new VariableItem(column.getName()));
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Could not update variable combo box: " + ex.getMessage(), ex);
        }
    }

    protected void addSeries() {
        try {
            VariableItem xVar = (VariableItem)this.xVariable.getSelectedItem();
            VariableItem yVar = (VariableItem)this.yVariable.getSelectedItem();
            if (this.resultNameRB.isSelected()) {
                this.plotEx.getPlot().addSeries(Plot.getDefaultSeries((String)((String)this.xPath.getSelectedItem()), (String)xVar.getName(), (String)((String)this.yPath.getSelectedItem()), (String)yVar.getName(), (String)this.resultPath.getPath().toString(), (Series.SourceNature)Series.SourceNature.SIMULATION_RESULT));
            } else if (this.experimentNameRB.isSelected()) {
                this.plotEx.getPlot().addSeries(Plot.getDefaultSeries((String)xVar.getName(), (String)yVar.getName(), (String)this.experimentPath.getPath().toString(), (Series.SourceNature)Series.SourceNature.EXPERIMENTAL_DATA));
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error occured while adding new series: " + ex);
        }
    }

    protected void removeSeries(int index) {
        if (index >= 0 && index < this.plotEx.getPlot().getRowModel().size()) {
            this.plotEx.getPlot().removeSeries(index);
        }
    }

    public static List<String> getVariablesForPath(String path, SimulationResult result) {
        List<String> variables = PlotEditorPane.getVariablesForPathmapping(path, result).get(path);
        if (variables == null) {
            return new ArrayList<String>();
        }
        return variables;
    }

    public static Map<String, List<String>> getVariablesForPathmapping(String path, SimulationResult result) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Map variables = result.getVariablePathMap();
        for (String varPath : variables.keySet()) {
            String[] components = Util.getMainPathComponents((String)varPath);
            map.computeIfAbsent(components[0], k -> new ArrayList()).add(components[1]);
        }
        for (List array : map.values()) {
            Collections.sort(array);
        }
        return map;
    }

    public static class VariableItem
    implements Comparable<VariableItem> {
        protected String path;
        protected String name;
        protected String title;

        public VariableItem(String path) {
            String[] components = Util.getMainPathComponents((String)path);
            this.path = components[0];
            this.title = this.name = components[1];
        }

        public String getName() {
            return this.name;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(VariableItem obj) {
            return this.name.compareTo(obj.name);
        }
    }
}

