/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.plot;

import biouml.plugins.simulation.plot.PlotEx;
import biouml.plugins.simulation.plot.PlotPane;
import biouml.standard.simulation.SimulationResult;
import biouml.standard.simulation.plot.Plot;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.swing.table.RowModelEvent;
import com.developmentontheedge.beans.swing.table.RowModelListener;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.repository.DataElementPathDialog;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.gui.Document;

@ClassIcon(value="resources/plotDocument.gif")
public class PlotDocument
extends Document {
    private final PlotPane plotPane;
    private boolean isChanged;
    private final PlotChangeListener listener;
    private SimulationResult defaultSimulationResult;

    public PlotDocument(Plot plot) {
        super((Object)plot);
        if (plot.getOrigin() == null) {
            this.isChanged = true;
        }
        this.viewPane = new ViewPane();
        this.plotPane = new PlotPane(700, 500);
        this.viewPane.add((Component)this.plotPane);
        this.plotPane.setPlot(plot);
        this.plotPane.redrawChart();
        this.listener = new PlotChangeListener();
        plot.addPropertyChangeListener((PropertyChangeListener)this.listener);
        plot.getRowModel().addRowModelListener((RowModelListener)this.listener);
    }

    public String getDisplayName() {
        Plot plot = this.getPlot();
        if (plot.getOrigin() != null) {
            return plot.getOrigin().getName() + " : " + plot.getName();
        }
        return plot.getName();
    }

    protected void doUpdate() {
        this.plotPane.scheduleRedraw();
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isMutable() {
        Plot plot = this.getPlot();
        return plot != null && (plot.getOrigin() == null || plot.getOrigin() != null && plot.getOrigin().isMutable());
    }

    private Plot getPlot() {
        return (Plot)this.getModel();
    }

    public void save() {
        Plot plot = this.getPlot();
        if (plot.getOrigin() != null) {
            DataElementPath path = DataElementPath.create((DataElement)plot);
            try {
                path.save((DataElement)plot);
                this.isChanged = false;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Saving error", e);
            }
        } else {
            DataElementPathDialog dialog = new DataElementPathDialog("Save plot document as");
            DataElementPath plotPath = null;
            if (this.defaultSimulationResult != null && this.defaultSimulationResult.getOrigin() != null) {
                plotPath = DataElementPath.create((DataCollection)this.defaultSimulationResult.getOrigin(), (String)plot.getName());
            }
            dialog.setValue(plotPath);
            dialog.setElementClass(new Class[]{Plot.class});
            dialog.setPromptOverwrite(true);
            if (dialog.doModal()) {
                try {
                    DataElementPath path = dialog.getValue();
                    PlotEx.savePlot(plot, path);
                    this.isChanged = false;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Saving error", e);
                }
            }
        }
    }

    public void updateActionsState() {
        if (this.isChanged) {
            Application.getActionManager().enableActions(true, new String[]{"Save document"});
        }
    }

    public SimulationResult getDefaultSimulationResult() {
        return this.defaultSimulationResult;
    }

    public void setDefaultSimulationResult(SimulationResult defaultSimulationResult) {
        this.defaultSimulationResult = defaultSimulationResult;
    }

    public void close() {
        Plot plot = this.getPlot();
        plot.removePropertyChangeListener((PropertyChangeListener)this.listener);
        if (plot.getOrigin() != null) {
            plot.getOrigin().release(plot.getName());
        }
        super.close();
    }

    private class PlotChangeListener
    implements PropertyChangeListener,
    RowModelListener {
        private PlotChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PlotDocument.this.update();
            PlotDocument.this.isChanged = true;
            PlotDocument.this.updateActionsState();
        }

        public void tableChanged(RowModelEvent e) {
            PlotDocument.this.update();
            PlotDocument.this.isChanged = true;
            PlotDocument.this.updateActionsState();
        }
    }
}

