/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.plot;

import biouml.plugins.simulation.plot.PlotEditorPane;
import biouml.plugins.simulation.plot.PlotEx;
import biouml.plugins.simulation.plot.PlotPane;
import biouml.plugins.simulation.plot.TablePane;
import biouml.plugins.simulation.resources.MessageBundle;
import biouml.standard.simulation.SimulationResult;
import biouml.standard.simulation.plot.Plot;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class PlotDialog
extends OkCancelDialog {
    protected MessageBundle messageBundle = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
    protected JTabbedPane jTabPanel = new JTabbedPane();
    protected PlotEditorPane editor;
    protected PlotPane chart;
    protected TablePane table;

    public PlotDialog(JFrame frame, Plot plot) {
        super(frame, "");
        this.init(new PlotEx(plot));
    }

    public PlotDialog(SimulationResult result) {
        super((JFrame)Application.getApplicationFrame(), "");
        this.init(new PlotEx(result));
    }

    protected void init(PlotEx plotEx) {
        this.setTitle(this.messageBundle.getResourceString("PLOT_DIALOG_TITLE"));
        this.editor = new PlotEditorPane(plotEx);
        this.chart = new PlotPane(700, 500);
        this.table = new TablePane(700, 500);
        this.jTabPanel.addTab(this.messageBundle.getResourceString("PLOT_DESCRIPTION_TAB_TITLE"), this.editor);
        this.jTabPanel.addTab(this.messageBundle.getResourceString("PLOT_PLOT_TAB_TITLE"), this.chart);
        this.jTabPanel.addTab(this.messageBundle.getResourceString("PLOT_TABLE_TAB_TITLE"), this.table);
        this.jTabPanel.addChangeListener(e -> {
            if (this.jTabPanel.getSelectedIndex() == 1) {
                this.updateChart();
            }
            if (this.jTabPanel.getSelectedIndex() == 2) {
                this.updateTable();
            }
        });
        this.getContentPane().add(this.jTabPanel);
        this.updateChart();
        this.updateTable();
    }

    public void chooseTab(int tabNumber) {
        try {
            this.jTabPanel.setSelectedIndex(tabNumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateChart() {
        this.chart.setPlot(this.editor.plotEx.getPlot());
        this.chart.redrawChart();
    }

    public void updateTable() {
        this.table.setPlot(this.editor.plotEx.getPlot());
        this.table.updateContents();
    }

    public void okPressed() {
        this.editor.plotEx.savePlot();
    }
}

