/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.radau5;

import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.SimulatorProfile;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.ode.radau5.Decsol;
import biouml.plugins.simulation.ode.radau5.IntegratorT;
import biouml.plugins.simulation.ode.radau5.Radau5Options;
import biouml.standard.simulation.ResultListener;

public class StiffIntegratorT
extends IntegratorT {
    private static final double t11 = 0.09123239487089295;
    private static final double t12 = -0.1412552950209542;
    private static final double t13 = -0.030029194105147424;
    private static final double t21 = 0.241717932707107;
    private static final double t22 = 0.20412935229379994;
    private static final double t23 = 0.3829421127572619;
    private static final double t31 = 0.966048182615093;
    private static final double ti11 = 4.325579890063155;
    private static final double ti12 = 0.33919925181580984;
    private static final double ti13 = 0.5417705399358749;
    private static final double ti21 = -4.178718591551905;
    private static final double ti22 = -0.32768282076106237;
    private static final double ti23 = 0.47662355450055044;
    private static final double ti31 = -0.5028726349457868;
    private static final double ti32 = 2.571926949855605;
    private static final double ti33 = -0.5960392048282249;
    private static final double sq6 = Math.sqrt(6.0);
    private static final double c1 = (4.0 - sq6) / 10.0;
    private static final double c2 = (4.0 + sq6) / 10.0;
    private static final double c1m1 = c1 - 1.0;
    private static final double c2m1 = c2 - 1.0;
    private static final double c1mc2 = c1 - c2;
    private static final double u1 = 1.0 / ((6.0 + Math.pow(81.0, 0.3333333333333333) - Math.pow(9.0, 0.3333333333333333)) / 30.0);
    private static final double preAlph = (12.0 - Math.pow(81.0, 0.3333333333333333) + Math.pow(9.0, 0.3333333333333333)) / 60.0;
    private static final double preBeta = (Math.pow(81.0, 0.3333333333333333) + Math.pow(9.0, 0.3333333333333333)) * Math.sqrt(3.0) / 60.0;
    private static final double cno = preAlph * preAlph + preBeta * preBeta;
    private static final double alph = preAlph / cno;
    private static final double beta = preBeta / cno;
    private static final int MAS_IDENTITY_JAC_FULL = 1;
    private static final int MAS_IDENTITY_JAC_BAND = 2;
    private static final int MAS_BAND_JAC_FULL = 3;
    private static final int MAS_BAND_JAC_BAND = 4;
    private static final int MAS_FULL_JAC_FULL = 5;
    private static final int MAS_IDENTITY_JAC_FULL_HESS = 7;
    int mljac;
    int mujac;
    boolean implicitEquation;
    int mlmas;
    int mumas;
    int nit;
    boolean startn;
    int nind1;
    int nind2;
    int nind3;
    boolean predictGustaffson;
    int m1;
    int m2;
    int nm1;
    double fnewt;
    double quot1;
    double quot2;
    double thet;
    boolean jband;
    int ldjac;
    int lde1;
    int ldmas;
    int ijob;
    int njac;
    int ndec;
    int nsol;
    int mle;
    int mue;
    int mbjac;
    int mbb;
    int mdiag;
    int mdiff;
    int mbdiag;
    double fac1;
    double alphn;
    double betan;
    double err;
    boolean caljac;
    boolean calhes;
    boolean first;
    boolean reject;
    double[] z1;
    double[] z2;
    double[] z3;
    double[] y0;
    double[] scal;
    double[] f1;
    double[] f2;
    double[] f3;
    double[] cont;
    int[] ip1;
    int[] ip2;
    int[] iphes;
    double[][] e1;
    double[][] e2r;
    double[][] e2i;
    double[][] fjac;
    double[][] fmas;
    double[] yold;
    public int[] events;
    public boolean eventTriggered = false;
    protected boolean failed;
    protected static final int SUCCESS = 1;
    protected static final int SOLUTION_OUTPUT = 2;
    protected static final int ALGEBRAIC_ROUTINE_FAILED = -1;
    protected static final int TOO_SMALL_N_MAX = -2;
    protected static final int TOO_SMALL_STEP_SIZE = -3;
    protected static final int SINGULAR_MATRIX = -4;
    protected boolean eventAtSpanPoint;

    public int NumJacobian() {
        return this.njac;
    }

    public int NumDecomp() {
        return this.ndec;
    }

    public int NumSol() {
        return this.nsol;
    }

    public StiffIntegratorT(Model model, double[] y, Span span, double[] rtoler, double[] atoler, Radau5Options options, ResultListener[] resultListeners, SimulatorProfile profile) throws Exception {
        super(model, y, span, rtoler, atoler, options, resultListeners, profile);
        this.mljac = options.getMljac();
        this.mujac = options.getMujac();
        this.mlmas = options.getMlmas();
        this.mumas = options.getMumas();
        this.nit = options.getNit();
        this.startn = options.isStartn();
        this.fnewt = options.getFnewt();
        this.quot1 = options.getQuot1();
        this.quot2 = options.getQuot2();
        this.thet = options.getThet();
        this.njac = 0;
        this.ndec = 0;
        this.nsol = 0;
        this.fac1 = 0.0;
        this.alphn = 0.0;
        this.betan = 0.0;
        this.err = 0.0;
        this.caljac = true;
        this.calhes = true;
        this.first = true;
        this.reject = false;
        for (int i = 0; i < this.n; ++i) {
            if (atoler[i] <= 0.0 || rtoler[i] <= 1.0E-15) {
                throw new IllegalArgumentException("Tolerances i-th elements are too small: atol = " + atoler[i] + ", rtol = " + rtoler[i]);
            }
            double quot = atoler[i] / rtoler[i];
            rtoler[i] = 0.1 * Math.pow(rtoler[i], 0.6666666666666666);
            atoler[i] = rtoler[i] * quot;
        }
        if (Math.abs(this.h) < 1.0E-15) {
            this.h = 1.0E-6;
        }
        if (this.facl < 1.0 || this.facr > 1.0) {
            throw new IllegalArgumentException("Incorrect input facl or facr = " + this.facl + "   " + this.facr);
        }
        if (this.nit <= 0) {
            throw new IllegalArgumentException("Number of newton iterations can not be negative: " + this.nit);
        }
        this.nind1 = this.n;
        this.predictGustaffson = options.isPredictGustafsson();
        this.m1 = 0;
        this.m2 = this.n;
        this.nm1 = this.n;
        if (this.fnewt == 0.0) {
            this.fnewt = Math.max(1.0E-15 / rtoler[0], Math.min(0.03, Math.sqrt(rtoler[0])));
        }
        if (this.fnewt <= 1.0E-16 / rtoler[0]) {
            throw new IllegalArgumentException("Too small fnewt = " + this.fnewt);
        }
        if (this.quot1 > 1.0 || this.quot2 < 1.0) {
            throw new IllegalArgumentException("Incorrect quot1 = " + this.quot1 + "(must be <=1) or quot2  = " + this.quot2 + " (must be >=1). ");
        }
        if (this.thet >= 1.0) {
            throw new IllegalArgumentException("Incorrect thet = " + this.thet + ". It must be < 1.");
        }
        if (this.mljac < 0) {
            this.mljac = this.n;
        }
        if (this.mujac < 0) {
            this.mujac = this.n;
        }
        boolean bl = this.jband = this.mljac < this.nm1;
        if (this.jband) {
            this.ldjac = this.mljac + this.mujac + 1;
            this.lde1 = this.mljac + this.ldjac;
        } else {
            this.mljac = this.nm1;
            this.mujac = this.nm1;
            this.ldjac = this.nm1;
            this.lde1 = this.nm1;
        }
        this.ldmas = 0;
        if (this.jband) {
            this.ijob = 2;
        } else {
            this.ijob = 1;
            if (this.n > 2 && options.isHessenberg()) {
                this.ijob = 7;
            }
        }
        this.ldmas = Math.max(1, this.ldmas);
        if (this.mlmas > this.mljac || this.mumas > this.mujac) {
            throw new IllegalArgumentException("bandwith of 'mas' not smaller than bandwith of 'jac'");
        }
        this.mle = this.mljac;
        this.mue = this.mujac;
        this.mbjac = this.mljac + this.mujac + 1;
        this.mbb = this.mlmas + this.mumas + 1;
        this.mdiag = this.mle + this.mue;
        this.mdiff = this.mle + this.mue - this.mumas;
        this.mbdiag = this.mumas + 1;
        this.yold = new double[this.n];
        this.z1 = new double[this.n];
        this.z2 = new double[this.n];
        this.z3 = new double[this.n];
        this.y0 = new double[this.n];
        this.scal = new double[this.n];
        this.f1 = new double[this.n];
        this.f2 = new double[this.n];
        this.f3 = new double[this.n];
        this.cont = new double[4 * this.n];
        this.ip1 = new int[this.nm1];
        this.ip2 = new int[this.nm1];
        this.iphes = new int[this.n];
        this.fjac = new double[this.ldjac][this.n];
        this.fmas = new double[this.ldmas][this.n];
        this.e1 = new double[this.lde1][this.nm1];
        this.e2r = new double[this.lde1][this.nm1];
        this.e2i = new double[this.lde1][this.nm1];
    }

    public void doIntegration() throws Exception {
        this.failed = false;
        this.profile.setUnstable(false);
        int flag = this.doCoreIntegration();
        this.profile.setTime(this.x);
        this.profile.setX(this.y);
        this.handleFlag(flag);
        for (int i = 0; i < this.n; ++i) {
            double quot = this.atoler[i] / this.rtoler[i];
            this.rtoler[i] = Math.pow(10.0 * this.rtoler[i], 1.5);
            this.atoler[i] = this.rtoler[i] * quot;
        }
    }

    private void handleFlag(int flag) {
        if (flag < 0) {
            this.failed = true;
        }
        switch (flag) {
            case -4: {
                this.outStatistics("Exit of RADAU5 at x = " + this.x);
                this.outError("Matrix is repeatedly singular");
                this.profile.setUnstable(true);
                break;
            }
            case -2: {
                this.outStatistics("Exit of RADAU5 at x = " + this.x);
                this.outError("More than nmax = " + this.nmax + " steps are needed");
                this.profile.setStiff(true);
                break;
            }
            case -3: {
                this.outStatistics("Exit of RADAU5 at x = " + this.x);
                this.outError("Step size too small, h = " + this.h);
                this.profile.setStiff(true);
                break;
            }
            case -1: {
                this.outError("Step size too small, h = " + this.h);
                this.profile.setUnstable(true);
            }
        }
    }

    @Override
    protected int doCoreIntegration() throws Exception {
        double posneg = Math.signum(this.xend - this.x);
        double hmaxn = Math.min(Math.abs(this.hmax), Math.abs(this.xend - this.x));
        double cfac = this.safe * (double)(1 + 2 * this.nit);
        this.hold = this.h = posneg * Math.min(Math.abs(this.h), hmaxn);
        System.arraycopy(this.y, 0, this.yold, 0, this.n);
        boolean last = false;
        if ((this.x + this.h * 1.0001 - this.xend) * posneg >= 0.0) {
            this.h = this.xend - this.x;
            last = true;
        }
        double hopt = this.h;
        double faccon = 1.0;
        System.arraycopy(this.y, 0, this.cont, 0, this.n);
        for (int i = 0; i < this.n; ++i) {
            this.scal[i] = this.atoler[i] + this.rtoler[i] * Math.abs(this.y[i]);
        }
        this.y0 = this.odeModel.dy_dt(this.x, this.y);
        ++this.nfcn;
        double hacc = 0.0;
        double erracc = 0.0;
        double thqold = 0.0;
        int nsing = 0;
        int ier = 0;
        this.computeJacobian();
        boolean loop = true;
        block1: while (loop && !this.eventTriggered) {
            loop = false;
            this.eventTriggered = false;
            System.arraycopy(this.y, 0, this.yold, 0, this.n);
            this.fac1 = u1 / this.h;
            this.alphn = alph / this.h;
            this.betan = beta / this.h;
            ier = this.DecompReal();
            if (ier != 0) {
                if (ier == -1) {
                    return -1;
                }
                if (++nsing >= 5) {
                    return -4;
                }
                this.h *= 0.5;
                this.reject = true;
                last = false;
                if (!this.caljac) {
                    this.computeJacobian();
                }
                loop = true;
                continue;
            }
            ier = this.decompComplex();
            if (ier != 0) {
                if (ier == -1) {
                    return -1;
                }
                if (++nsing >= 5) {
                    return -4;
                }
                this.h *= 0.5;
                this.reject = true;
                last = false;
                if (!this.caljac) {
                    this.computeJacobian();
                }
                loop = true;
                continue;
            }
            ++this.ndec;
            while (!this.eventTriggered) {
                double dyno;
                ++this.nstep;
                if (this.nstep >= this.nmax) {
                    return -2;
                }
                if (0.1 * Math.abs(this.h) <= Math.abs(this.x) * 1.0E-16) {
                    return -3;
                }
                double xph = this.x + this.h;
                if (this.first || this.startn) {
                    for (int i = 0; i < this.n; ++i) {
                        this.f3[i] = 0.0;
                        this.f2[i] = 0.0;
                        this.f1[i] = 0.0;
                        this.z3[i] = 0.0;
                        this.z2[i] = 0.0;
                        this.z1[i] = 0.0;
                    }
                } else {
                    double c3q = this.h / this.hold;
                    double c1q = c1 * c3q;
                    double c2q = c2 * c3q;
                    for (int i = 0; i < this.n; ++i) {
                        double ak1 = this.cont[i + this.n];
                        double ak2 = this.cont[i + 2 * this.n];
                        double ak3 = this.cont[i + 3 * this.n];
                        this.z1[i] = c1q * (ak1 + (c1q - c2m1) * (ak2 + (c1q - c1m1) * ak3));
                        this.z2[i] = c2q * (ak1 + (c2q - c2m1) * (ak2 + (c2q - c1m1) * ak3));
                        this.z3[i] = c3q * (ak1 + (c3q - c2m1) * (ak2 + (c3q - c1m1) * ak3));
                        this.f1[i] = 4.325579890063155 * this.z1[i] + 0.33919925181580984 * this.z2[i] + 0.5417705399358749 * this.z3[i];
                        this.f2[i] = -4.178718591551905 * this.z1[i] + -0.32768282076106237 * this.z2[i] + 0.47662355450055044 * this.z3[i];
                        this.f3[i] = -0.5028726349457868 * this.z1[i] + 2.571926949855605 * this.z2[i] + -0.5960392048282249 * this.z3[i];
                    }
                }
                int newt = 0;
                faccon = Math.pow(Math.max(faccon, 1.0E-16), 0.8);
                double theta = Math.abs(this.thet);
                double dynold = 0.0;
                do {
                    int i;
                    int i2;
                    if (newt >= this.nit) {
                        if (ier != 0 && ++nsing >= 5) {
                            return -4;
                        }
                        this.h *= 0.5;
                        this.reject = true;
                        last = false;
                        if (!this.caljac) {
                            this.computeJacobian();
                        }
                        loop = true;
                        break;
                    }
                    for (i2 = 0; i2 < this.n; ++i2) {
                        this.cont[i2] = this.y[i2] + this.z1[i2];
                    }
                    this.z1 = this.odeModel.dy_dt(this.x + c1 * this.h, this.cont);
                    for (i2 = 0; i2 < this.n; ++i2) {
                        this.cont[i2] = this.y[i2] + this.z2[i2];
                    }
                    this.z2 = this.odeModel.dy_dt(this.x + c2 * this.h, this.cont);
                    for (i2 = 0; i2 < this.n; ++i2) {
                        this.cont[i2] = this.y[i2] + this.z3[i2];
                    }
                    this.z3 = this.odeModel.dy_dt(xph, this.cont);
                    this.nfcn += 3;
                    for (i2 = 0; i2 < this.n; ++i2) {
                        double a1 = this.z1[i2];
                        double a2 = this.z2[i2];
                        double a3 = this.z3[i2];
                        this.z1[i2] = 4.325579890063155 * a1 + 0.33919925181580984 * a2 + 0.5417705399358749 * a3;
                        this.z2[i2] = -4.178718591551905 * a1 + -0.32768282076106237 * a2 + 0.47662355450055044 * a3;
                        this.z3[i2] = -0.5028726349457868 * a1 + 2.571926949855605 * a2 + -0.5960392048282249 * a3;
                    }
                    ier = this.linearSolve();
                    if (ier == -1) {
                        return -1;
                    }
                    ++this.nsol;
                    ++newt;
                    dyno = 0.0;
                    for (i = 0; i < this.n; ++i) {
                        double denom = this.scal[i];
                        dyno = dyno + Math.pow(this.z1[i] / denom, 2.0) + Math.pow(this.z2[i] / denom, 2.0) + Math.pow(this.z3[i] / denom, 2.0);
                    }
                    dyno = Math.sqrt(dyno / (double)(3 * this.n));
                    if (newt > 1 && newt < this.nit) {
                        double thq = dyno / dynold;
                        theta = newt == 2 ? thq : Math.sqrt(thq * thqold);
                        thqold = thq;
                        if (theta < 0.99) {
                            faccon = theta / (1.0 - theta);
                            double dyth = faccon * dyno * Math.pow(theta, this.nit - 1 - newt) / this.fnewt;
                            if (dyth >= 1.0) {
                                double qnewt = Math.max(1.0E-4, Math.min(20.0, dyth));
                                this.h *= 0.8 * Math.pow(qnewt, -1.0 / (3.0 + (double)this.nit - (double)newt));
                                this.reject = true;
                                last = false;
                                if (this.caljac) {
                                    this.computeJacobian();
                                }
                                loop = true;
                                break;
                            }
                        } else {
                            if (ier != 0 && ++nsing >= 5) {
                                return -4;
                            }
                            this.h *= 0.5;
                            this.reject = true;
                            last = false;
                            if (!this.caljac) {
                                this.computeJacobian();
                            }
                            loop = true;
                            break;
                        }
                    }
                    dynold = Math.max(dyno, 1.0E-16);
                    for (i = 0; i < this.n; ++i) {
                        this.f1[i] = this.f1[i] + this.z1[i];
                        this.f2[i] = this.f2[i] + this.z2[i];
                        this.f3[i] = this.f3[i] + this.z3[i];
                        this.z1[i] = 0.09123239487089295 * this.f1[i] + -0.1412552950209542 * this.f2[i] + -0.030029194105147424 * this.f3[i];
                        this.z2[i] = 0.241717932707107 * this.f1[i] + 0.20412935229379994 * this.f2[i] + 0.3829421127572619 * this.f3[i];
                        this.z3[i] = 0.966048182615093 * this.f1[i] + this.f2[i];
                    }
                } while (!(faccon * dyno <= this.fnewt));
                if (loop) continue block1;
                this.err = 0.0;
                ier = this.estimateError();
                if (ier == -1) {
                    return -1;
                }
                double fac = Math.min(this.safe, cfac / (double)(newt + 2 * this.nit));
                double quot = Math.max(this.facr, Math.min(this.facl, Math.pow(this.err, 0.25) / fac));
                double hnew = this.h / quot;
                if (this.err < 1.0) {
                    int i;
                    this.first = false;
                    ++this.naccpt;
                    if (this.predictGustaffson) {
                        if (this.naccpt > 1) {
                            double facgus = hacc / this.h * Math.pow(this.err * this.err / erracc, 0.25) / this.safe;
                            facgus = Math.max(this.facr, Math.min(this.facl, facgus));
                            quot = Math.max(quot, facgus);
                            hnew = this.h / quot;
                        }
                        hacc = this.h;
                        erracc = Math.max(0.01, this.err);
                    }
                    this.xold = this.x;
                    this.hold = this.h;
                    this.x = xph;
                    for (i = 0; i < this.n; ++i) {
                        this.y[i] = this.y[i] + this.z3[i];
                        this.cont[i + this.n] = (this.z2[i] - this.z3[i]) / c2m1;
                        double ak = (this.z1[i] - this.z2[i]) / c1mc2;
                        double acont3 = this.z1[i] / c1;
                        acont3 = (ak - acont3) / c2;
                        this.cont[i + 2 * this.n] = (ak - this.cont[i + this.n]) / c1m1;
                        this.cont[i + 3 * this.n] = this.cont[i + 2 * this.n] - acont3;
                    }
                    for (i = 0; i < this.n; ++i) {
                        this.scal[i] = this.atoler[i] + this.rtoler[i] * Math.abs(this.y[i]);
                    }
                    System.arraycopy(this.y, 0, this.cont, 0, this.n);
                    this.outSolution();
                    this.caljac = false;
                    if (last) {
                        this.h = hopt;
                        return 1;
                    }
                    this.y0 = this.odeModel.dy_dt(this.x, this.y);
                    ++this.nfcn;
                    hnew = posneg * Math.min(Math.abs(hnew), hmaxn);
                    hopt = Math.min(this.h, hnew);
                    if (this.reject) {
                        hnew = posneg * Math.min(Math.abs(hnew), Math.abs(this.h));
                    }
                    this.reject = false;
                    if ((this.x + hnew / this.quot1 - this.xend) * posneg >= 0.0) {
                        this.h = this.xend - this.x;
                        last = true;
                    } else {
                        double qt = hnew / this.h;
                        if (theta <= this.thet && qt >= this.quot1 && qt <= this.quot2) continue;
                        this.h = hnew;
                    }
                    if (theta > this.thet) {
                        this.computeJacobian();
                    }
                    loop = true;
                    continue block1;
                }
                this.reject = true;
                last = false;
                double d = this.h = this.first ? this.h * 0.1 : hnew;
                if (this.naccpt >= 1) {
                    ++this.nrejct;
                }
                if (!this.caljac) {
                    this.computeJacobian();
                }
                loop = true;
                continue block1;
            }
        }
        return 1;
    }

    private void computeJacobian() throws Exception {
        ++this.njac;
        if (this.jband) {
            int mujacp = this.mujac + 1;
            int md = Math.min(this.mbjac, this.m2);
            for (int mm1 = 0; mm1 < this.m1 / this.m2 + 1; ++mm1) {
                for (int k = 0; k < md; ++k) {
                    int j = k + mm1 * this.m2;
                    do {
                        this.f1[j] = this.y[j];
                        this.f2[j] = Math.sqrt(1.0E-16 * Math.max(1.0E-5, Math.abs(this.y[j])));
                        this.y[j] = this.y[j] + this.f2[j];
                    } while ((j += md) <= (mm1 + 1) * this.m2 - 1);
                    System.arraycopy(this.odeModel.dy_dt(this.x, this.y), 0, this.cont, 0, this.n);
                    j = k + mm1 * this.m2;
                    int j1 = k;
                    int lbeg = Math.max(0, j1 - this.mujac) + this.m1;
                    do {
                        int lend = Math.min(this.m2, j1 + this.mljac) + this.m1;
                        this.y[j] = this.f1[j];
                        int mujacj = mujacp - j1 - this.m1 - 1;
                        for (int l = lbeg; l <= lend; ++l) {
                            this.fjac[l + mujacj][j] = (this.cont[l] - this.y0[l]) / this.f2[j];
                        }
                        j1 += md;
                        lbeg = lend + 1;
                    } while ((j += md) <= (mm1 + 1) * this.m2 - 1);
                }
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                double ysafe = this.y[i];
                double delta = Math.sqrt(1.0E-16 * Math.max(1.0E-5, Math.abs(ysafe)));
                this.y[i] = ysafe + delta;
                System.arraycopy(this.odeModel.dy_dt(this.x, this.y), 0, this.cont, 0, this.n);
                for (int j = this.m1; j < this.n; ++j) {
                    this.fjac[j - this.m1][i] = (this.cont[j] - this.y0[j]) / delta;
                }
                this.y[i] = ysafe;
            }
        }
        this.caljac = true;
        this.calhes = true;
    }

    private double[] getSolution(double time) {
        double[] solution = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            double s = (time - this.x) / this.hold;
            solution[i] = this.cont[i] + s * (this.cont[i + this.n] + (s - c2m1) * (this.cont[i + 2 * this.n] + (s - c1m1) * this.cont[i + 3 * this.n]));
        }
        return solution;
    }

    public void outSolution() throws Exception {
        this.eventAtSpanPoint = false;
        double[] oldEvents = this.odeModel.checkEvent(this.xold, this.yold);
        double[] newEvents = this.odeModel.checkEvent(this.x, this.y);
        this.events = new int[oldEvents.length];
        double endOfStep = this.inspectEvents(oldEvents, newEvents);
        double nextSpanPoint = this.span.getTime(this.nextSpanIndex);
        while (this.nextSpanIndex < this.span.getLength() && nextSpanPoint < endOfStep) {
            this.fireSolutionUpdate(nextSpanPoint, this.getSolution(nextSpanPoint));
            ++this.nextSpanIndex;
            if (this.nextSpanIndex >= this.span.getLength()) break;
            nextSpanPoint = this.span.getTime(this.nextSpanIndex);
        }
        if (nextSpanPoint == endOfStep) {
            if (this.eventTriggered) {
                this.eventAtSpanPoint = true;
            } else {
                this.fireSolutionUpdate(nextSpanPoint, this.getSolution(nextSpanPoint));
            }
        }
        if (this.eventTriggered) {
            this.y = this.getSolution(endOfStep);
            this.x = endOfStep;
        }
    }

    private double inspectEvents(double[] oldEvents, double[] newEvents) throws Exception {
        double minEventTime = this.xend + 1.0;
        for (int j = 0; j < this.events.length; ++j) {
            this.events[j] = 0;
            if (oldEvents[j] != -1.0 || newEvents[j] != 1.0) continue;
            this.eventTriggered = true;
            double eventTime = this.findEventTime(j);
            if (eventTime < minEventTime) {
                for (int i = 0; i < j; ++i) {
                    this.events[i] = 0;
                }
                this.events[j] = 1;
                minEventTime = eventTime;
                continue;
            }
            if (!this.equals(eventTime, minEventTime)) continue;
            this.events[j] = 1;
        }
        if (this.eventTriggered) {
            return minEventTime;
        }
        return this.x;
    }

    boolean equals(double time1, double time2) {
        return Math.abs(time1 - time2) < 1.0E-16;
    }

    private double findEventTime(int eventIndex) throws Exception {
        double leftPoint = this.xold;
        double rightPoint = this.x;
        while (rightPoint - leftPoint > 1.0E-12) {
            double[] presentTimeEvents;
            double middle = (rightPoint + leftPoint) / 2.0;
            if (middle == leftPoint || middle == rightPoint) {
                return middle;
            }
            double[] solutionInXd = this.getSolution(middle);
            double[] pastTimeEvents = this.odeModel.checkEvent(leftPoint, this.yold);
            if (pastTimeEvents[eventIndex] * (presentTimeEvents = this.odeModel.checkEvent(middle, solutionInXd))[eventIndex] < 0.0) {
                rightPoint = middle;
                continue;
            }
            leftPoint = middle;
        }
        return rightPoint;
    }

    int DecompReal() {
        int ier = 0;
        switch (this.ijob) {
            case 1: {
                int j = 0;
                while (j < this.n) {
                    for (int i = 0; i < this.n; ++i) {
                        this.e1[i][j] = -this.fjac[i][j];
                    }
                    double[] dArray = this.e1[j];
                    int n = j++;
                    dArray[n] = dArray[n] + this.fac1;
                }
                ier = Decsol.dec(this.n, this.e1, this.ip1);
                break;
            }
            case 2: {
                int j = 0;
                while (j < this.n) {
                    for (int i = 0; i < this.mbjac; ++i) {
                        this.e1[i + this.mle][j] = -this.fjac[i][j];
                    }
                    double[] dArray = this.e1[this.mdiag];
                    int n = j++;
                    dArray[n] = dArray[n] + this.fac1;
                }
                ier = Decsol.decb(this.n, this.e1, this.mle, this.mue, this.ip1);
                break;
            }
            case 3: {
                for (int j = 0; j < this.n; ++j) {
                    int i;
                    for (i = 0; i < this.n; ++i) {
                        this.e1[i][j] = -this.fjac[i][j];
                    }
                    for (i = Math.max(0, j - this.mumas); i < Math.min(this.n, j + this.mlmas + 1); ++i) {
                        double[] dArray = this.e1[i];
                        int n = j;
                        dArray[n] = dArray[n] + this.fac1 * this.fmas[i - j + this.mbdiag - 1][j];
                    }
                }
                ier = Decsol.dec(this.n, this.e1, this.ip1);
                break;
            }
            case 4: {
                for (int j = 0; j < this.n; ++j) {
                    int i;
                    for (i = 0; i < this.mbjac; ++i) {
                        this.e1[i + this.mle][j] = -this.fjac[i][j];
                    }
                    for (i = 0; i < this.mbb; ++i) {
                        double[] dArray = this.e1[i + this.mdiff];
                        int n = j;
                        dArray[n] = dArray[n] + this.fac1 * this.fmas[i][j];
                    }
                }
                ier = Decsol.decb(this.n, this.e1, this.mle, this.mue, this.ip1);
                break;
            }
            case 5: {
                for (int j = 0; j < this.n; ++j) {
                    for (int i = 0; i < this.n; ++i) {
                        this.e1[i][j] = this.fmas[i][j] * this.fac1 - this.fjac[i][j];
                    }
                }
                ier = Decsol.dec(this.n, this.e1, this.ip1);
                break;
            }
            case 7: {
                int j;
                if (this.calhes) {
                    Decsol.elmhes(this.n, 0, this.n, this.fjac, this.iphes);
                }
                this.calhes = false;
                for (j = 0; j < this.n - 1; ++j) {
                    this.e1[j + 1][j] = -this.fjac[j + 1][j];
                }
                j = 0;
                while (j < this.n) {
                    for (int i = 0; i <= j; ++i) {
                        this.e1[i][j] = -this.fjac[i][j];
                    }
                    double[] dArray = this.e1[j];
                    int n = j++;
                    dArray[n] = dArray[n] + this.fac1;
                }
                ier = Decsol.dech(this.n, this.e1, 1, this.ip1);
                break;
            }
            default: {
                return -1;
            }
        }
        return ier;
    }

    int decompComplex() {
        int ier = 0;
        switch (this.ijob) {
            case 1: {
                for (int j = 0; j < this.n; ++j) {
                    for (int i = 0; i < this.n; ++i) {
                        this.e2r[i][j] = -this.fjac[i][j];
                        this.e2i[i][j] = 0.0;
                    }
                    double[] dArray = this.e2r[j];
                    int n = j;
                    dArray[n] = dArray[n] + this.alphn;
                    this.e2i[j][j] = this.betan;
                }
                ier = Decsol.decc(this.n, this.e2r, this.e2i, this.ip2);
                break;
            }
            case 2: {
                for (int j = 0; j < this.n; ++j) {
                    for (int i = 0; i < this.mbjac; ++i) {
                        this.e2r[i + this.mle][j] = -this.fjac[i][j];
                        this.e2i[i + this.mle][j] = 0.0;
                    }
                    double[] dArray = this.e2r[this.mdiag];
                    int n = j;
                    dArray[n] = dArray[n] + this.alphn;
                    this.e2i[this.mdiag][j] = this.betan;
                }
                ier = Decsol.decbc(this.n, this.e2r, this.e2i, this.mle, this.mue, this.ip2);
                break;
            }
            case 3: {
                int i;
                int j;
                for (j = 0; j < this.n; ++j) {
                    for (i = 0; i < this.n; ++i) {
                        this.e2r[i][j] = -this.fjac[i][j];
                        this.e2i[i][j] = 0.0;
                    }
                }
                for (j = 0; j < this.n; ++j) {
                    for (i = Math.max(0, j - this.mumas); i < Math.min(this.n, j + this.mlmas + 1); ++i) {
                        double bb = this.fmas[i - j + this.mbdiag - 1][j];
                        double[] dArray = this.e2r[i];
                        int n = j;
                        dArray[n] = dArray[n] + this.alphn * bb;
                        this.e2i[i][j] = this.betan * bb;
                    }
                }
                ier = Decsol.decc(this.n, this.e2r, this.e2i, this.ip2);
                break;
            }
            case 4: {
                for (int j = 0; j < this.n; ++j) {
                    int i;
                    for (i = 0; i < this.mbjac; ++i) {
                        this.e2r[i + this.mle][j] = -this.fjac[i][j];
                        this.e2i[i + this.mle][j] = 0.0;
                    }
                    for (i = Math.max(0, this.mumas - j); i < Math.min(this.mbb, this.mumas - j + this.n); ++i) {
                        double bb = this.fmas[i][j];
                        double[] dArray = this.e2r[i + this.mdiff];
                        int n = j;
                        dArray[n] = dArray[n] + this.alphn * bb;
                        this.e2i[i + this.mdiff][j] = this.betan * bb;
                    }
                }
                ier = Decsol.decbc(this.n, this.e2r, this.e2i, this.mle, this.mue, this.ip2);
                break;
            }
            case 5: {
                for (int j = 0; j < this.n; ++j) {
                    for (int i = 0; i < this.n; ++i) {
                        double bb = this.fmas[i][j];
                        this.e2r[i][j] = this.alphn * bb - this.fjac[i][j];
                        this.e2i[i][j] = this.betan * bb;
                    }
                }
                ier = Decsol.decc(this.n, this.e2r, this.e2i, this.ip2);
                break;
            }
            case 7: {
                int j;
                for (j = 0; j < this.n - 1; ++j) {
                    this.e2r[j + 1][j] = -this.fjac[j + 1][j];
                    this.e2i[j + 1][j] = 0.0;
                }
                for (j = 0; j < this.n; ++j) {
                    for (int i = 0; i <= j; ++i) {
                        this.e2i[i][j] = 0.0;
                        this.e2r[i][j] = -this.fjac[i][j];
                    }
                    double[] dArray = this.e2r[j];
                    int n = j;
                    dArray[n] = dArray[n] + this.alphn;
                    this.e2i[j][j] = this.betan;
                }
                ier = Decsol.dechc(this.n, this.e2r, this.e2i, 1, this.ip2);
            }
        }
        return ier;
    }

    int linearSolve() {
        int ier = 0;
        switch (this.ijob) {
            case 1: {
                for (int i = 0; i < this.n; ++i) {
                    double s2 = -this.f2[i];
                    double s3 = -this.f3[i];
                    int n = i;
                    this.z1[n] = this.z1[n] - this.f1[i] * this.fac1;
                    this.z2[i] = this.z2[i] + s2 * this.alphn - s3 * this.betan;
                    this.z3[i] = this.z3[i] + s3 * this.alphn + s2 * this.betan;
                }
                Decsol.sol(this.n, this.e1, this.z1, this.ip1);
                Decsol.solc(this.n, this.e2r, this.e2i, this.z2, this.z3, this.ip2);
                break;
            }
            case 2: {
                for (int i = 0; i < this.n; ++i) {
                    double s2 = -this.f2[i];
                    double s3 = -this.f3[i];
                    int n = i;
                    this.z1[n] = this.z1[n] - this.f1[i] * this.fac1;
                    this.z2[i] = this.z2[i] + s2 * this.alphn - s3 * this.betan;
                    this.z3[i] = this.z3[i] + s3 * this.alphn + s2 * this.betan;
                }
                Decsol.solb(this.n, this.e1, this.mle, this.mue, this.z1, this.ip1);
                Decsol.solbc(this.n, this.e2r, this.e2i, this.mle, this.mue, this.z2, this.z3, this.ip2);
                break;
            }
            case 3: {
                for (int i = 0; i < this.n; ++i) {
                    double s3 = 0.0;
                    double s2 = 0.0;
                    double s1 = 0.0;
                    for (int j = Math.max(0, i - this.mlmas); j < Math.min(this.n, i + this.mumas + 1); ++j) {
                        double bb = this.fmas[i - j + this.mbdiag - 1][j];
                        s1 -= bb * this.f1[j];
                        s2 -= bb * this.f2[j];
                        s3 -= bb * this.f3[j];
                    }
                    int n = i;
                    this.z1[n] = this.z1[n] + s1 * this.fac1;
                    this.z2[i] = this.z2[i] + s2 * this.alphn - s3 * this.betan;
                    this.z3[i] = this.z3[i] + s3 * this.alphn + s2 * this.betan;
                }
                Decsol.sol(this.n, this.e1, this.z1, this.ip1);
                Decsol.solc(this.n, this.e2r, this.e2i, this.z2, this.z3, this.ip2);
                break;
            }
            case 4: {
                for (int i = 0; i < this.n; ++i) {
                    double s3 = 0.0;
                    double s2 = 0.0;
                    double s1 = 0.0;
                    for (int j = Math.max(0, i - this.mlmas); j < Math.min(this.n, i + this.mumas + 1); ++j) {
                        double bb = this.fmas[i - j + this.mbdiag - 1][j];
                        s1 -= bb * this.f1[j];
                        s2 -= bb * this.f2[j];
                        s3 -= bb * this.f3[j];
                    }
                    int n = i;
                    this.z1[n] = this.z1[n] + s1 * this.fac1;
                    this.z2[i] = this.z2[i] + s2 * this.alphn - s3 * this.betan;
                    this.z3[i] = this.z3[i] + s3 * this.alphn + s2 * this.betan;
                }
                Decsol.solb(this.n, this.e1, this.mle, this.mue, this.z1, this.ip1);
                Decsol.solbc(this.n, this.e2r, this.e2i, this.mle, this.mue, this.z2, this.z3, this.ip2);
                break;
            }
            case 5: {
                for (int i = 0; i < this.n; ++i) {
                    double s3 = 0.0;
                    double s2 = 0.0;
                    double s1 = 0.0;
                    for (int j = 0; j < this.n; ++j) {
                        double bb = this.fmas[i][j];
                        s1 -= bb * this.f1[j];
                        s2 -= bb * this.f2[j];
                        s3 -= bb * this.f3[j];
                    }
                    int n = i;
                    this.z1[n] = this.z1[n] + s1 * this.fac1;
                    this.z2[i] = this.z2[i] + s2 * this.alphn - s3 * this.betan;
                    this.z3[i] = this.z3[i] + s3 * this.alphn + s2 * this.betan;
                }
                Decsol.sol(this.n, this.e1, this.z1, this.ip1);
                Decsol.solc(this.n, this.e2r, this.e2i, this.z2, this.z3, this.ip2);
                break;
            }
            case 7: {
                double e1imp;
                int i;
                double zsafe;
                int ii;
                int mp1;
                int mp;
                int mm1;
                for (int i2 = 0; i2 < this.n; ++i2) {
                    double s2 = -this.f2[i2];
                    double s3 = -this.f3[i2];
                    int n = i2;
                    this.z1[n] = this.z1[n] - this.f1[i2] * this.fac1;
                    this.z2[i2] = this.z2[i2] + s2 * this.alphn - s3 * this.betan;
                    this.z3[i2] = this.z3[i2] + s3 * this.alphn + s2 * this.betan;
                }
                for (mm1 = this.n - 3; mm1 >= 0; --mm1) {
                    mp = this.n - mm1 - 2;
                    mp1 = mp - 1;
                    ii = this.iphes[mp];
                    if (ii != mp) {
                        zsafe = this.z1[mp];
                        this.z1[mp] = this.z1[ii];
                        this.z1[ii] = zsafe;
                        zsafe = this.z2[mp];
                        this.z2[mp] = this.z2[ii];
                        this.z2[ii] = zsafe;
                        zsafe = this.z3[mp];
                        this.z3[mp] = this.z3[ii];
                        this.z3[ii] = zsafe;
                    }
                    i = mp + 1;
                    while (i < this.n) {
                        e1imp = this.fjac[i][mp1];
                        int n = i;
                        this.z1[n] = this.z1[n] - e1imp * this.z1[mp];
                        int n2 = i;
                        this.z2[n2] = this.z2[n2] - e1imp * this.z2[mp];
                        int n3 = i++;
                        this.z3[n3] = this.z3[n3] - e1imp * this.z3[mp];
                    }
                }
                Decsol.solh(this.n, this.e1, 1, this.z1, this.ip1);
                Decsol.solhc(this.n, this.e2r, this.e2i, 1, this.z2, this.z3, this.ip2);
                for (mm1 = 0; mm1 < this.n - 2; ++mm1) {
                    mp = this.n - mm1 - 2;
                    mp1 = mp - 1;
                    i = mp;
                    while (i < this.n) {
                        e1imp = this.fjac[i][mp1];
                        int n = i;
                        this.z1[n] = this.z1[n] + e1imp * this.z1[mp];
                        int n4 = i;
                        this.z2[n4] = this.z2[n4] + e1imp * this.z2[mp];
                        int n5 = i++;
                        this.z3[n5] = this.z3[n5] + e1imp * this.z3[mp];
                    }
                    ii = this.iphes[mp];
                    if (ii == mp) continue;
                    zsafe = this.z1[mp];
                    this.z1[mp] = this.z1[ii];
                    this.z1[ii] = zsafe;
                    zsafe = this.z2[mp];
                    this.z2[mp] = this.z2[ii];
                    this.z2[ii] = zsafe;
                    zsafe = this.z3[mp];
                    this.z3[mp] = this.z3[ii];
                    this.z3[ii] = zsafe;
                }
                break;
            }
            default: {
                return -1;
            }
        }
        return ier;
    }

    int estimateError() throws Exception {
        int i;
        double zsafe;
        int ii;
        int mp;
        int mm1;
        int i2;
        boolean mm = false;
        int ier = 0;
        double hee1 = -(13.0 + 7.0 * sq6) / (3.0 * this.h);
        double hee2 = (-13.0 + 7.0 * sq6) / (3.0 * this.h);
        double hee3 = -1.0 / (3.0 * this.h);
        switch (this.ijob) {
            case 1: {
                for (i2 = 0; i2 < this.n; ++i2) {
                    this.f2[i2] = hee1 * this.z1[i2] + hee2 * this.z2[i2] + hee3 * this.z3[i2];
                    this.cont[i2] = this.f2[i2] + this.y0[i2];
                }
                Decsol.sol(this.n, this.e1, this.cont, this.ip1);
                break;
            }
            case 2: {
                for (i2 = 0; i2 < this.n; ++i2) {
                    this.f2[i2] = hee1 * this.z1[i2] + hee2 * this.z2[i2] + hee3 * this.z3[i2];
                    this.cont[i2] = this.f2[i2] + this.y0[i2];
                }
                Decsol.solb(this.n, this.e1, this.mle, this.mue, this.cont, this.ip1);
                break;
            }
            case 3: {
                int j;
                double sum;
                for (i2 = 0; i2 < this.n; ++i2) {
                    this.f1[i2] = hee1 * this.z1[i2] + hee2 * this.z2[i2] + hee3 * this.z3[i2];
                }
                for (i2 = 0; i2 < this.n; ++i2) {
                    sum = 0.0;
                    for (j = Math.max(0, i2 - this.mlmas); j < Math.min(this.n, i2 + this.mumas + 1); ++j) {
                        sum += this.fmas[i2 - j + this.mbdiag - 1][j] * this.f1[j];
                    }
                    this.f2[i2] = sum;
                    this.cont[i2] = sum + this.y0[i2];
                }
                Decsol.sol(this.n, this.e1, this.cont, this.ip1);
                break;
            }
            case 4: {
                int j;
                double sum;
                for (i2 = 0; i2 < this.n; ++i2) {
                    this.f1[i2] = hee1 * this.z1[i2] + hee2 * this.z2[i2] + hee3 * this.z3[i2];
                }
                for (i2 = 0; i2 < this.n; ++i2) {
                    sum = 0.0;
                    for (j = Math.max(0, i2 - this.mlmas); j < Math.min(this.n, i2 + this.mumas + 1); ++j) {
                        sum += this.fmas[i2 - j + this.mbdiag - 1][j] * this.f1[j];
                    }
                    this.f2[i2] = sum;
                    this.cont[i2] = sum + this.y0[i2];
                }
                Decsol.solb(this.n, this.e1, this.mle, this.mue, this.cont, this.ip1);
                break;
            }
            case 5: {
                int j;
                double sum;
                for (i2 = 0; i2 < this.n; ++i2) {
                    this.f1[i2] = hee1 * this.z1[i2] + hee2 * this.z2[i2] + hee3 * this.z3[i2];
                }
                for (i2 = 0; i2 < this.n; ++i2) {
                    sum = 0.0;
                    for (j = 0; j < this.n; ++j) {
                        sum += this.fmas[j][i2] * this.f1[j];
                    }
                    this.f2[i2] = sum;
                    this.cont[i2] = sum + this.y0[i2];
                }
                Decsol.sol(this.n, this.e1, this.cont, this.ip1);
                break;
            }
            case 7: {
                for (i2 = 0; i2 < this.n; ++i2) {
                    this.f2[i2] = hee1 * this.z1[i2] + hee2 * this.z2[i2] + hee3 * this.z3[i2];
                    this.cont[i2] = this.f2[i2] + this.y0[i2];
                }
                for (mm1 = this.n - 3; mm1 >= 0; --mm1) {
                    mp = this.n - mm1 - 2;
                    ii = this.iphes[mp];
                    if (ii != mp) {
                        zsafe = this.cont[mp];
                        this.cont[mp] = this.cont[ii];
                        this.cont[ii] = zsafe;
                    }
                    for (i = mp; i < this.n; ++i) {
                        int n = i;
                        this.cont[n] = this.cont[n] - this.fjac[i][mp - 1] * this.cont[mp];
                    }
                }
                Decsol.solh(this.n, this.e1, 1, this.cont, this.ip1);
                for (mm1 = 0; mm1 < this.n - 2; ++mm1) {
                    for (i = mp = this.n - mm1 - 2; i < this.n; ++i) {
                        int n = i;
                        this.cont[n] = this.cont[n] + this.fjac[i][mp - 1] * this.cont[mp];
                    }
                    ii = this.iphes[mp];
                    if (ii == mp) continue;
                    zsafe = this.cont[mp];
                    this.cont[mp] = this.cont[ii];
                    this.cont[ii] = zsafe;
                }
                break;
            }
            default: {
                return -1;
            }
        }
        this.err = 0.0;
        for (i2 = 0; i2 < this.n; ++i2) {
            this.err += Math.pow(this.cont[i2] / this.scal[i2], 2.0);
        }
        this.err = Math.max(Math.sqrt(this.err / (double)this.n), 1.0E-10);
        if (this.err < 1.0) {
            return ier;
        }
        if (this.first || this.reject) {
            for (i2 = 0; i2 < this.n; ++i2) {
                this.cont[i2] = this.y[i2] + this.cont[i2];
            }
            this.f1 = this.odeModel.dy_dt(this.x, this.cont);
            ++this.nfcn;
            for (i2 = 0; i2 < this.n; ++i2) {
                this.cont[i2] = this.f1[i2] + this.f2[i2];
            }
            switch (this.ijob) {
                case 1: 
                case 3: 
                case 5: {
                    Decsol.sol(this.n, this.e1, this.cont, this.ip1);
                    break;
                }
                case 2: 
                case 4: {
                    Decsol.solb(this.n, this.e1, this.mle, this.mue, this.cont, this.ip1);
                    break;
                }
                case 7: {
                    for (mm1 = this.n - 3; mm1 >= 0; --mm1) {
                        mp = this.n - mm1 - 2;
                        ii = this.iphes[mp];
                        if (ii != mp) {
                            zsafe = this.cont[mp];
                            this.cont[mp] = this.cont[ii];
                            this.cont[ii] = zsafe;
                        }
                        for (i = mp; i < this.n; ++i) {
                            int n = i;
                            this.cont[n] = this.cont[n] - this.fjac[i][mp - 1] * this.cont[mp];
                        }
                    }
                    Decsol.solh(this.n, this.e1, 1, this.cont, this.ip1);
                    for (mm1 = 0; mm1 < this.n - 2; ++mm1) {
                        for (i = mp = this.n - mm1 - 2; i < this.n; ++i) {
                            int n = i;
                            this.cont[n] = this.cont[n] + this.fjac[i][mp - 1] * this.cont[mp];
                        }
                        ii = this.iphes[mp];
                        if (ii == mp) continue;
                        zsafe = this.cont[mp];
                        this.cont[mp] = this.cont[ii];
                        this.cont[ii] = zsafe;
                    }
                    break;
                }
                default: {
                    return -1;
                }
            }
            this.err = 0.0;
            for (i2 = 0; i2 < this.n; ++i2) {
                this.err += Math.pow(this.cont[i2] / this.scal[i2], 2.0);
            }
            this.err = Math.max(Math.sqrt(this.err / (double)this.n), 1.0E-10);
        }
        return ier;
    }
}

