/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.radau5;

import biouml.plugins.simulation.OdeSimulatorOptions;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;

public class Radau5Options
extends OdeSimulatorOptions {
    private double hinit = 1.0E-6;
    private int mljac = -1;
    private int mujac = -1;
    private int mlmas = 0;
    private int mumas = 0;
    private double hmax = 0.0;
    private int nmax = 100000;
    private double safe = 0.9;
    private double facl = 5.0;
    private double facr = 0.125;
    private int nit = 7;
    private boolean startn = false;
    private boolean predictGustafsson = false;
    private boolean hessenberg = false;
    private double fnewt = 0.0;
    private double quot1 = 1.0;
    private double quot2 = 1.2;
    private double thet = 0.01;

    @PropertyName(value="Initial step size")
    @PropertyDescription(value="Initial step size guess.")
    public double getHinit() {
        return this.hinit;
    }

    public void setHinit(double hinit) {
        double oldValue = this.hinit;
        this.hinit = hinit;
        this.firePropertyChange("hinit", oldValue, hinit);
    }

    @PropertyName(value="Max time step")
    @PropertyDescription(value="Maximal step size, if set to zero, step size is not bounded.")
    public double getHmax() {
        return this.hmax;
    }

    public void setHmax(double hmax) {
        double oldValue = this.hmax;
        this.hmax = hmax;
        this.firePropertyChange("hmax", oldValue, hmax);
    }

    @PropertyName(value="Safety factor")
    @PropertyDescription(value="The safety factor in step size prediction, default is 0.9.")
    public double getSafe() {
        return this.safe;
    }

    public void setSafe(double safe) {
        double oldValue = this.safe;
        this.safe = safe;
        this.firePropertyChange("safe", oldValue, safe);
    }

    @PropertyName(value="Min Step size factor")
    @PropertyDescription(value="New step size is chosen subject to the restriction 1/facl <= hnew/hold. Default value: 5.0.")
    public double getFacl() {
        return this.facl;
    }

    public void setFacl(double facl) {
        double oldValue = this.facl;
        this.facl = facl;
        this.firePropertyChange("facl", oldValue, facl);
    }

    @PropertyName(value="Max Step size factor")
    @PropertyDescription(value="New step size is chosen subject to the restriction hnew/hold <= 1/facr. Default value: 1.0/8.0.")
    public double getFacr() {
        return this.facr;
    }

    public void setFacr(double facr) {
        double oldValue = this.facr;
        this.facr = facr;
        this.firePropertyChange("facr", oldValue, facr);
    }

    @PropertyName(value="Newton stop criteria")
    @PropertyDescription(value="Stopping criterion for Newton's method, usually chosen < 1. Smaller values  make simulation slower, but safer. Default min(0.03, sqrt(rtol))")
    public double getFnewt() {
        return this.fnewt;
    }

    public void setFnewt(double fnewt) {
        double oldValue = this.fnewt;
        this.fnewt = fnewt;
        this.firePropertyChange("fnewt", oldValue, fnewt);
    }

    @PropertyName(value="quot1")
    @PropertyDescription(value="If quot1 < hnew/hold < quot2, then the step size is not changed. This saves, together with a large thet, lu-decompositions and computing time for large systems. for small systems one may have quot1 = 1.0, quot2 = 1.2, for large full systems quot1 = 0.99, quot2 = 2.0 might be good. Defaults quot1 = 1.0, quot2 = 1.2.")
    public double getQuot1() {
        return this.quot1;
    }

    public void setQuot1(double quot1) {
        double oldValue = this.quot1;
        this.quot1 = quot1;
        this.firePropertyChange("quot1", oldValue, quot1);
    }

    @PropertyName(value="quot2")
    @PropertyDescription(value="If quot1 < hnew/hold < quot2, then the step size is not changed. This saves, together with a large thet, lu-decompositions and computing time for large systems. for small systems one may have quot1 = 1.0, quot2 = 1.2, for large full systems quot1 = 0.99, quot2 = 2.0 might be good. Defaults quot1 = 1.0, quot2 = 1.2.")
    public double getQuot2() {
        return this.quot2;
    }

    public void setQuot2(double quot2) {
        double oldValue = this.quot2;
        this.quot2 = quot2;
        this.firePropertyChange("quot2", oldValue, quot2);
    }

    @PropertyName(value="thet")
    @PropertyDescription(value="Decides whether the Jacobian should be recomputed. Increase thet, to 0.1 say, when Jacobian evaluations are costly. for small systems thet should be smaller (0.001, say). Negative thet forces the code to compute the Jacobian after every accepted step. Default 0.001.")
    public double getThet() {
        return this.thet;
    }

    public void setThet(double thet) {
        double oldValue = this.thet;
        this.thet = thet;
        this.firePropertyChange("thet", oldValue, thet);
    }

    @PropertyName(value="Jacobian Ml")
    @PropertyDescription(value="Jacobian Ml = n - m1: If the non-trivial part of the Jacobian is full 0 <= Jacobian Ml < n - m1: If the (mm+1) submatrices (for k = 0, mm) partial f[i+m1] / partial y[j+k*m2],  i, j = 0, m2-1 are banded, Jacobian Ml is the maximal lower bandwidth of these mm+1 submatrices")
    public int getMljac() {
        return this.mljac;
    }

    public void setMljac(int mljac) {
        int oldValue = this.mljac;
        this.mljac = mljac;
        this.firePropertyChange("mljac", oldValue, mljac);
    }

    @PropertyName(value="Jacobian Mu")
    @PropertyDescription(value="Maximal upper bandwidth of these mm + 1 submatrices. Need not be defined if Jacobian Ml = n - m1")
    public int getMujac() {
        return this.mujac;
    }

    public void setMujac(int mujac) {
        int oldValue = this.mujac;
        this.mujac = mujac;
        this.firePropertyChange("mujac", oldValue, mujac);
    }

    @PropertyName(value="Mass Ml")
    @PropertyDescription(value="Switch for the banded structure of the mass-matrix: mlmas = n: The full matrix case. The linear algebra is done by full-matrix Gauss-elimination. 0 <= mlmas < n:    mlmas is the lower bandwith of the matrix ( >= number of non-zero diagonals below the main diagonal). mlmas is supposed to be <= mljac.")
    public int getMlmas() {
        return this.mlmas;
    }

    public void setMlmas(int mlmas) {
        int oldValue = this.mlmas;
        this.mlmas = mlmas;
        this.firePropertyChange("mlmas", oldValue, mlmas);
    }

    @PropertyName(value="Mass Mu")
    @PropertyDescription(value="Upper bandwith of mass-matrix ( >= number of non-zero diagonals above the main diagonal). Need not be defined if mlmas = n. mumas is supposed to be <= mujac.")
    public int getMumas() {
        return this.mumas;
    }

    public void setMumas(int mumas) {
        int oldValue = this.mumas;
        this.mumas = mumas;
        this.firePropertyChange("mumas", oldValue, mumas);
    }

    @PropertyName(value="Max steps number")
    @PropertyDescription(value="Maximal number of allowed steps. The default value is 100000.")
    public int getNmax() {
        return this.nmax;
    }

    public void setNmax(int nmax) {
        int oldValue = this.nmax;
        this.nmax = nmax;
        this.firePropertyChange("nmax", oldValue, nmax);
    }

    @PropertyName(value="Newton iterations number")
    @PropertyDescription(value="The maximum number of Newton iterations for the solution of the implicit system in each step. The default value is 7.")
    public int getNit() {
        return this.nit;
    }

    public void setNit(int nit) {
        int oldValue = this.nit;
        this.nit = nit;
        this.firePropertyChange("nit", oldValue, nit);
    }

    @PropertyName(value="Start from zero")
    @PropertyDescription(value="If false then the extrapolated collocation solution is taken as starting value for Newton's method. If true then zero starting values are used. The latter is recommended if Newton's method has difficulties with convergence. Default is false.")
    public boolean isStartn() {
        return this.startn;
    }

    public void setStartn(boolean startn) {
        boolean oldValue = this.startn;
        this.startn = startn;
        this.firePropertyChange("startn", oldValue, startn);
    }

    @PropertyName(value="Gustafsson predictive")
    @PropertyDescription(value="Switch for step size strategy: predictive controller (Gustafsson) or classical step size control.")
    public boolean isPredictGustafsson() {
        return this.predictGustafsson;
    }

    public void setPredictGustafsson(boolean predictGustafsson) {
        boolean oldValue = this.predictGustafsson;
        this.predictGustafsson = predictGustafsson;
        this.firePropertyChange("predictGustafsson", oldValue, predictGustafsson);
    }

    @PropertyName(value="Hessenberg jacobian")
    @PropertyDescription(value="If true, Jacobian matrix is transformed to Hessenberg form. This is particularly advantageous for large systems with full Jacobian. It does not work for banded Jacobian and implicit systems.")
    public boolean isHessenberg() {
        return this.hessenberg;
    }

    public void setHessenberg(boolean hessenberg) {
        boolean oldValue = this.hessenberg;
        this.hessenberg = hessenberg;
        this.firePropertyChange("hessenberg", oldValue, hessenberg);
    }
}

