/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.radau5;

import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.SimulatorInfo;
import biouml.plugins.simulation.SimulatorSupport;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.StdMet;
import biouml.plugins.simulation.ode.radau5.Radau5Options;
import biouml.plugins.simulation.ode.radau5.StiffIntegratorT;
import biouml.standard.simulation.ResultListener;
import java.util.logging.Level;
import ru.biosoft.jobcontrol.FunctionJobControl;

public class Radau5
extends SimulatorSupport {
    private StiffIntegratorT engine;
    private int[] events;
    Options options = (Options)((Object)this.getDefaultOptions());

    @Override
    public SimulatorInfo getInfo() {
        SimulatorInfo info = new SimulatorInfo();
        info.name = "Radau5";
        info.eventsSupport = true;
        return info;
    }

    @Override
    public Object getDefaultOptions() {
        return new Radau5Options();
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public boolean doStep() {
        try {
            if (this.fireInitialValues) {
                this.fireSolutionUpdate(this.span.getTimeStart(), this.engine.y);
                this.fireInitialValues = false;
            }
            this.routine();
            return !this.terminated && !this.engine.failed && !(this.engine.x <= this.engine.xend) && !this.engine.eventTriggered;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
            return false;
        }
    }

    @Override
    public void init(Model model, double[] x0, Span tspan, ResultListener[] listeners, FunctionJobControl jobControl) throws Exception {
        if (!(model instanceof OdeModel)) {
            throw new Exception("Radau5 solver can be used only for OdeModels");
        }
        this.odeModel = (OdeModel)model;
        if (!this.odeModel.isInit()) {
            this.odeModel.init();
        }
        if (this.preprocessFastReactions && this.odeModel.hasFastOde()) {
            x0 = this.preprocessFastReactions();
        }
        this.profile.setStiff(false);
        this.profile.setUnstable(false);
        this.span = tspan;
        this.resultListeners = listeners;
        Radau5Options radauOpts = (Radau5Options)this.options;
        double[] atol = StdMet.generateArray(radauOpts.getAtol(), x0.length);
        double[] rtol = StdMet.generateArray(radauOpts.getRtol(), x0.length);
        this.engine = new StiffIntegratorT(this.odeModel, x0, tspan, rtol, atol, radauOpts, this.resultListeners, this.profile);
    }

    public void routine() throws Exception {
        this.engine.doIntegration();
        if (this.engine.eventTriggered) {
            this.events = this.engine.events;
        }
    }

    @Override
    public int[] getEvents() {
        return this.events;
    }

    @Override
    public void setInitialValues(double[] x0) throws Exception {
        this.odeModel.setCurrentValues(x0);
        double time = this.odeModel.getTime();
        double[] rateVars = this.odeModel.getY();
        Radau5Options radauOpts = (Radau5Options)this.options;
        double[] atol = StdMet.generateArray(radauOpts.getAtol(), x0.length);
        double[] rtol = StdMet.generateArray(radauOpts.getRtol(), x0.length);
        this.span = this.span.getRestrictedSpan(time, this.span.getTimeFinal());
        this.engine = new StiffIntegratorT(this.odeModel, rateVars, this.span, rtol, atol, radauOpts, this.resultListeners, this.profile);
    }
}

