/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.radau5;

import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.SimulatorProfile;
import biouml.plugins.simulation.SimulatorSupport;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.StdMet;
import biouml.plugins.simulation.ode.radau5.Radau5Options;
import biouml.standard.simulation.ResultListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IntegratorT {
    protected static final Logger log = Logger.getLogger(SimulatorSupport.class.getName());
    public static final double UROUND = 1.0E-16;
    protected int nextSpanIndex;
    String statisticsMode;
    protected OdeModel odeModel;
    int n;
    double[] y;
    double x;
    double xend;
    double dx;
    double[] rtoler;
    double[] atoler;
    double h;
    double hmax;
    int nmax;
    double safe;
    double facl;
    double facr;
    int nfcn;
    int nstep;
    int naccpt;
    int nrejct;
    double xold;
    double hold;
    Span span;
    ResultListener[] resultListeners;
    SimulatorProfile profile;

    public IntegratorT(Model model, double[] y, Span span, double[] rtoler, double[] atoler, Radau5Options options, ResultListener[] resultListeners, SimulatorProfile profile) throws Exception {
        this.odeModel = (OdeModel)model;
        this.y = y;
        this.n = y.length;
        this.x = span.getTimeStart();
        this.nextSpanIndex = 1;
        this.xend = span.getTimeFinal();
        this.rtoler = rtoler;
        this.atoler = atoler;
        this.hold = this.h = options.getHinit();
        this.hmax = options.getHmax();
        this.nmax = options.getNmax();
        this.safe = options.getSafe();
        this.facl = options.getFacl();
        this.facr = options.getFacr();
        this.statisticsMode = options.getStatisticsMode();
        this.nfcn = 0;
        this.nstep = 0;
        this.naccpt = 0;
        this.nrejct = 0;
        this.xold = this.x;
        this.span = span;
        this.resultListeners = resultListeners;
        this.profile = profile;
        if (rtoler == null) {
            this.rtoler = StdMet.generateArray(1.0E-7, this.n);
        }
        if (atoler == null) {
            this.atoler = StdMet.generateArray(1.0E-7, this.n);
        }
        if (this.hmax == 0.0) {
            this.hmax = this.xend - this.x;
        }
        if (this.nmax == 0) {
            this.nmax = 100000;
        }
        if (this.nmax <= 0) {
            throw new IllegalArgumentException("Incorrect nmax = " + this.nmax);
        }
        if (this.safe == 0.0) {
            this.safe = 0.9;
        }
        if (this.safe <= 0.001 || this.safe >= 1.0) {
            throw new IllegalArgumentException("Safety factor must be in the domain (0.001, 1.0) but was " + this.safe);
        }
    }

    public int NumFunction() {
        return this.nfcn;
    }

    public int NumStep() {
        return this.nstep;
    }

    public int NumAccept() {
        return this.naccpt;
    }

    public int NumReject() {
        return this.nrejct;
    }

    protected int doCoreIntegration() throws Exception {
        return 0;
    }

    protected synchronized void fireSolutionUpdate(double t, double[] x) throws Exception {
        if (this.odeModel != null) {
            double[] y = this.odeModel.extendResult(t, x);
            this.odeModel.updateHistory(t);
            if (this.resultListeners != null) {
                for (int i = 0; i < this.resultListeners.length; ++i) {
                    this.resultListeners[i].add(t, y);
                }
            }
        }
    }

    protected void outError(String message) {
        log.log(Level.SEVERE, message);
        System.out.println(message);
    }

    protected void outStatistics(String ... messages) {
        if (!this.statisticsMode.equals("On")) {
            return;
        }
        for (String message : messages) {
            log.info(message);
            System.out.println(message);
        }
        System.out.println();
    }

    protected void outIntermediate(String ... messages) {
        if (this.statisticsMode.equals("Off")) {
            return;
        }
        for (String message : messages) {
            log.info(message);
            System.out.println(message);
        }
        System.out.println();
    }
}

