/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.radau5;

public class Decsol {
    private Decsol() {
    }

    protected static int dec(int n, double[][] A, int[] ip) {
        int k;
        int ier = 0;
        ip[n - 1] = 1;
        if (n != 1) {
            int nm1 = n - 1;
            for (k = 0; k < nm1; ++k) {
                int i;
                int kp1 = k + 1;
                int m = k;
                for (i = kp1; i < n; ++i) {
                    if (!(Math.abs(A[i][k]) > Math.abs(A[m][k]))) continue;
                    m = i;
                }
                ip[k] = m;
                double t = A[m][k];
                if (m != k) {
                    ip[n - 1] = -ip[n - 1];
                    A[m][k] = A[k][k];
                    A[k][k] = t;
                }
                if (t == 0.0) {
                    ier = k;
                    ip[n - 1] = 0;
                    return ier;
                }
                t = 1.0 / t;
                for (i = kp1; i < n; ++i) {
                    double[] dArray = A[i];
                    int n2 = k;
                    dArray[n2] = dArray[n2] * -t;
                }
                for (int j = kp1; j < n; ++j) {
                    t = A[m][j];
                    A[m][j] = A[k][j];
                    A[k][j] = t;
                    if (t == 0.0) continue;
                    for (int i2 = kp1; i2 < n; ++i2) {
                        double[] dArray = A[i2];
                        int n3 = j;
                        dArray[n3] = dArray[n3] + A[i2][k] * t;
                    }
                }
            }
        }
        k = n;
        if (A[n - 1][n - 1] == 0.0) {
            ier = k;
            ip[n - 1] = 0;
        }
        return ier;
    }

    protected static void sol(int n, double[][] A, double[] b, int[] ip) {
        if (n != 1) {
            int i;
            double t;
            int k;
            int nm1 = n - 1;
            for (k = 0; k < nm1; ++k) {
                int kp1 = k + 1;
                int m = ip[k];
                t = b[m];
                b[m] = b[k];
                b[k] = t;
                for (i = kp1; i < n; ++i) {
                    int n2 = i;
                    b[n2] = b[n2] + A[i][k] * t;
                }
            }
            for (k = 0; k < nm1; ++k) {
                int km1 = n - k - 2;
                int kb = km1 + 1;
                b[kb] = b[kb] / A[kb][kb];
                t = -b[kb];
                for (i = 0; i <= km1; ++i) {
                    int n3 = i;
                    b[n3] = b[n3] + A[i][kb] * t;
                }
            }
        }
        b[0] = b[0] / A[0][0];
    }

    protected static int dech(int n, double[][] A, int lb, int[] ip) {
        int k;
        int ier = 0;
        ip[n - 1] = 1;
        if (n != 1) {
            int nm1 = n - 1;
            for (k = 0; k < nm1; ++k) {
                int i;
                int kp1 = k + 1;
                int m = k;
                int na = Math.min(n, lb + k + 1);
                for (i = kp1; i < na; ++i) {
                    if (!(Math.abs(A[i][k]) > Math.abs(A[m][k]))) continue;
                    m = i;
                }
                ip[k] = m;
                double t = A[m][k];
                if (m != k) {
                    ip[n - 1] = -ip[n - 1];
                    A[m][k] = A[k][k];
                    A[k][k] = t;
                }
                if (t == 0.0) {
                    ier = k;
                    ip[n - 1] = 0;
                    return ier;
                }
                t = 1.0 / t;
                for (i = kp1; i < n; ++i) {
                    double[] dArray = A[i];
                    int n2 = k;
                    dArray[n2] = dArray[n2] * -t;
                }
                for (int j = kp1; j < n; ++j) {
                    t = A[m][j];
                    A[m][j] = A[k][j];
                    A[k][j] = t;
                    if (t == 0.0) continue;
                    for (int i2 = kp1; i2 < na; ++i2) {
                        double[] dArray = A[i2];
                        int n3 = j;
                        dArray[n3] = dArray[n3] + A[i2][k] * t;
                    }
                }
            }
        }
        k = n;
        if (A[n - 1][n - 1] == 0.0) {
            ier = k;
            ip[n - 1] = 0;
        }
        return ier;
    }

    protected static void solh(int n, double[][] A, int lb, double[] b, int[] ip) {
        if (n != 1) {
            int i;
            double t;
            int k;
            int nm1 = n - 1;
            for (k = 0; k < nm1; ++k) {
                int kp1 = k + 1;
                int m = ip[k];
                t = b[m];
                b[m] = b[k];
                b[k] = t;
                int na = Math.min(n, lb + k + 1);
                for (i = kp1; i < na; ++i) {
                    int n2 = i;
                    b[n2] = b[n2] + A[i][k] * t;
                }
            }
            for (k = 0; k < nm1; ++k) {
                int km1 = n - k - 2;
                int kb = km1 + 1;
                b[kb] = b[kb] / A[kb][kb];
                t = -b[kb];
                for (i = 0; i <= km1; ++i) {
                    int n3 = i;
                    b[n3] = b[n3] + A[i][kb] * t;
                }
            }
        }
        b[0] = b[0] / A[0][0];
    }

    protected static int decc(int n, double[][] AR, double[][] AI, int[] ip) {
        int k;
        int ier = 0;
        ip[n - 1] = 1;
        if (n != 1) {
            int nm1 = n - 1;
            for (k = 0; k < nm1; ++k) {
                double prodi;
                double prodr;
                int i;
                int kp1 = k + 1;
                int m = k;
                for (i = kp1; i < n; ++i) {
                    if (!(Math.abs(AR[i][k]) + Math.abs(AI[i][k]) > Math.abs(AR[m][k]) + Math.abs(AI[m][k]))) continue;
                    m = i;
                }
                ip[k] = m;
                double tr = AR[m][k];
                double ti = AI[m][k];
                if (m != k) {
                    ip[n - 1] = -ip[n - 1];
                    AR[m][k] = AR[k][k];
                    AI[m][k] = AI[k][k];
                    AR[k][k] = tr;
                    AI[k][k] = ti;
                }
                if (Math.abs(tr) + Math.abs(ti) == 0.0) {
                    ier = k;
                    ip[n - 1] = 0;
                    return ier;
                }
                double den = tr * tr + ti * ti;
                tr /= den;
                ti = -ti / den;
                for (i = kp1; i < n; ++i) {
                    prodr = AR[i][k] * tr - AI[i][k] * ti;
                    prodi = AI[i][k] * tr + AR[i][k] * ti;
                    AR[i][k] = -prodr;
                    AI[i][k] = -prodi;
                }
                for (int j = kp1; j < n; ++j) {
                    int i2;
                    tr = AR[m][j];
                    ti = AI[m][j];
                    AR[m][j] = AR[k][j];
                    AI[m][j] = AI[k][j];
                    AR[k][j] = tr;
                    AI[k][j] = ti;
                    if (Math.abs(tr) + Math.abs(ti) == 0.0) continue;
                    if (ti == 0.0) {
                        for (i2 = kp1; i2 < n; ++i2) {
                            prodr = AR[i2][k] * tr;
                            prodi = AI[i2][k] * tr;
                            double[] dArray = AR[i2];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + prodr;
                            double[] dArray2 = AI[i2];
                            int n3 = j;
                            dArray2[n3] = dArray2[n3] + prodi;
                        }
                        continue;
                    }
                    if (tr == 0.0) {
                        for (i2 = kp1; i2 < n; ++i2) {
                            prodr = -AI[i2][k] * ti;
                            prodi = AR[i2][k] * ti;
                            double[] dArray = AR[i2];
                            int n4 = j;
                            dArray[n4] = dArray[n4] + prodr;
                            double[] dArray3 = AI[i2];
                            int n5 = j;
                            dArray3[n5] = dArray3[n5] + prodi;
                        }
                        continue;
                    }
                    for (i2 = kp1; i2 < n; ++i2) {
                        prodr = AR[i2][k] * tr - AI[i2][k] * ti;
                        prodi = AI[i2][k] * tr + AR[i2][k] * ti;
                        double[] dArray = AR[i2];
                        int n6 = j;
                        dArray[n6] = dArray[n6] + prodr;
                        double[] dArray4 = AI[i2];
                        int n7 = j;
                        dArray4[n7] = dArray4[n7] + prodi;
                    }
                }
            }
        }
        k = n;
        if (Math.abs(AR[n - 1][n - 1]) + Math.abs(AI[n - 1][n - 1]) == 0.0) {
            ier = k;
            ip[n - 1] = 0;
        }
        return ier;
    }

    protected static void solc(int n, double[][] AR, double[][] AI, double[] br, double[] bi, int[] ip) {
        double den;
        double prodi;
        double prodr;
        if (n != 1) {
            int i;
            double ti;
            double tr;
            int k;
            int nm1 = n - 1;
            for (k = 0; k < nm1; ++k) {
                int kp1 = k + 1;
                int m = ip[k];
                tr = br[m];
                ti = bi[m];
                br[m] = br[k];
                bi[m] = bi[k];
                br[k] = tr;
                bi[k] = ti;
                i = kp1;
                while (i < n) {
                    prodr = AR[i][k] * tr - AI[i][k] * ti;
                    prodi = AI[i][k] * tr + AR[i][k] * ti;
                    int n2 = i;
                    br[n2] = br[n2] + prodr;
                    int n3 = i++;
                    bi[n3] = bi[n3] + prodi;
                }
            }
            for (k = 0; k < nm1; ++k) {
                int km1 = n - k - 2;
                int kb = km1 + 1;
                den = AR[kb][kb] * AR[kb][kb] + AI[kb][kb] * AI[kb][kb];
                prodr = br[kb] * AR[kb][kb] + bi[kb] * AI[kb][kb];
                prodi = bi[kb] * AR[kb][kb] - br[kb] * AI[kb][kb];
                br[kb] = prodr / den;
                bi[kb] = prodi / den;
                tr = -br[kb];
                ti = -bi[kb];
                i = 0;
                while (i <= km1) {
                    prodr = AR[i][kb] * tr - AI[i][kb] * ti;
                    prodi = AI[i][kb] * tr + AR[i][kb] * ti;
                    int n4 = i;
                    br[n4] = br[n4] + prodr;
                    int n5 = i++;
                    bi[n5] = bi[n5] + prodi;
                }
            }
        }
        den = AR[0][0] * AR[0][0] + AI[0][0] * AI[0][0];
        prodr = br[0] * AR[0][0] + bi[0] * AI[0][0];
        prodi = bi[0] * AR[0][0] - br[0] * AI[0][0];
        br[0] = prodr / den;
        bi[0] = prodi / den;
    }

    protected static int dechc(int n, double[][] AR, double[][] AI, int lb, int[] ip) {
        int k;
        int ier = 0;
        ip[n - 1] = 1;
        if (n != 1 && lb != 0) {
            int nm1 = n - 1;
            for (k = 0; k < nm1; ++k) {
                double prodi;
                double prodr;
                int i;
                int kp1 = k + 1;
                int m = k;
                int na = Math.min(n, lb + k + 1);
                for (i = kp1; i < na; ++i) {
                    if (!(Math.abs(AR[i][k]) + Math.abs(AI[i][k]) > Math.abs(AR[m][k]) + Math.abs(AI[m][k]))) continue;
                    m = i;
                }
                ip[k] = m;
                double tr = AR[m][k];
                double ti = AI[m][k];
                if (m != k) {
                    ip[n - 1] = -ip[n - 1];
                    AR[m][k] = AR[k][k];
                    AI[m][k] = AI[k][k];
                    AR[k][k] = tr;
                    AI[k][k] = ti;
                }
                if (Math.abs(tr) + Math.abs(ti) == 0.0) {
                    ier = k;
                    ip[n - 1] = 0;
                    return ier;
                }
                double den = tr * tr + ti * ti;
                tr /= den;
                ti = -ti / den;
                for (i = kp1; i < na; ++i) {
                    prodr = AR[i][k] * tr - AI[i][k] * ti;
                    prodi = AI[i][k] * tr + AR[i][k] * ti;
                    AR[i][k] = -prodr;
                    AI[i][k] = -prodi;
                }
                for (int j = kp1; j < n; ++j) {
                    int i2;
                    tr = AR[m][j];
                    ti = AI[m][j];
                    AR[m][j] = AR[k][j];
                    AI[m][j] = AI[k][j];
                    AR[k][j] = tr;
                    AI[k][j] = ti;
                    if (Math.abs(tr) + Math.abs(ti) == 0.0) continue;
                    if (ti == 0.0) {
                        for (i2 = kp1; i2 < na; ++i2) {
                            prodr = AR[i2][k] * tr;
                            prodi = AI[i2][k] * tr;
                            double[] dArray = AR[i2];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + prodr;
                            double[] dArray2 = AI[i2];
                            int n3 = j;
                            dArray2[n3] = dArray2[n3] + prodi;
                        }
                        continue;
                    }
                    if (tr == 0.0) {
                        for (i2 = kp1; i2 < na; ++i2) {
                            prodr = -AI[i2][k] * ti;
                            prodi = AR[i2][k] * ti;
                            double[] dArray = AR[i2];
                            int n4 = j;
                            dArray[n4] = dArray[n4] + prodr;
                            double[] dArray3 = AI[i2];
                            int n5 = j;
                            dArray3[n5] = dArray3[n5] + prodi;
                        }
                        continue;
                    }
                    for (i2 = kp1; i2 < na; ++i2) {
                        prodr = AR[i2][k] * tr - AI[i2][k] * ti;
                        prodi = AI[i2][k] * tr + AR[i2][k] * ti;
                        double[] dArray = AR[i2];
                        int n6 = j;
                        dArray[n6] = dArray[n6] + prodr;
                        double[] dArray4 = AI[i2];
                        int n7 = j;
                        dArray4[n7] = dArray4[n7] + prodi;
                    }
                }
            }
        }
        k = n;
        if (Math.abs(AR[n - 1][n - 1]) + Math.abs(AI[n - 1][n - 1]) == 0.0) {
            ier = k;
            ip[n - 1] = 0;
        }
        return ier;
    }

    protected static void solhc(int n, double[][] AR, double[][] AI, int lb, double[] br, double[] bi, int[] ip) {
        double den;
        double prodi;
        double prodr;
        if (n != 1) {
            int i;
            double ti;
            double tr;
            int k;
            int nm1 = n - 1;
            if (lb != 0) {
                for (k = 0; k < nm1; ++k) {
                    int kp1 = k + 1;
                    int m = ip[k];
                    tr = br[m];
                    ti = bi[m];
                    br[m] = br[k];
                    bi[m] = bi[k];
                    br[k] = tr;
                    bi[k] = ti;
                    i = kp1;
                    while (i < Math.min(n, lb + k + 1)) {
                        prodr = AR[i][k] * tr - AI[i][k] * ti;
                        prodi = AI[i][k] * tr + AR[i][k] * ti;
                        int n2 = i;
                        br[n2] = br[n2] + prodr;
                        int n3 = i++;
                        bi[n3] = bi[n3] + prodi;
                    }
                }
            }
            for (k = 0; k < nm1; ++k) {
                int km1 = n - k - 2;
                int kb = km1 + 1;
                den = AR[kb][kb] * AR[kb][kb] + AI[kb][kb] * AI[kb][kb];
                prodr = br[kb] * AR[kb][kb] + bi[kb] * AI[kb][kb];
                prodi = bi[kb] * AR[kb][kb] - br[kb] * AI[kb][kb];
                br[kb] = prodr / den;
                bi[kb] = prodi / den;
                tr = -br[kb];
                ti = -bi[kb];
                i = 0;
                while (i < km1) {
                    prodr = AR[i][kb] * tr - AI[i][kb] * ti;
                    prodi = AI[i][kb] * tr + AR[i][kb] * ti;
                    int n4 = i;
                    br[n4] = br[n4] + prodr;
                    int n5 = i++;
                    bi[n5] = bi[n5] + prodi;
                }
            }
        }
        den = AR[0][0] * AR[0][0] + AI[0][0] * AI[0][0];
        prodr = br[0] * AR[0][0] + bi[0] * AI[0][0];
        prodi = bi[0] * AR[0][0] - br[0] * AI[0][0];
        br[0] = prodr / den;
        bi[0] = prodi / den;
    }

    protected static int decb(int n, double[][] A, int ml, int mu, int[] ip) {
        int k;
        int ier = 0;
        ip[n - 1] = 1;
        int md = ml + mu;
        int md1 = md + 1;
        int ju = 0;
        if (n != 1 && ml != 0) {
            int i;
            int j;
            if (n >= mu + 2) {
                for (j = mu + 1; j < n; ++j) {
                    for (i = 0; i < ml; ++i) {
                        A[i][j] = 0.0;
                    }
                }
            }
            int nm1 = n - 1;
            for (k = 0; k < nm1; ++k) {
                int i2;
                int kp1 = k + 1;
                int m = md;
                int mdl = Math.min(ml, n - k - 1) + md;
                for (i2 = md1; i2 <= mdl; ++i2) {
                    if (!(Math.abs(A[i2][k]) > Math.abs(A[m][k]))) continue;
                    m = i2;
                }
                ip[k] = m + k - md;
                double t = A[m][k];
                if (m != md) {
                    ip[n - 1] = -ip[n - 1];
                    A[m][k] = A[md][k];
                    A[md][k] = t;
                }
                if (t == 0.0) {
                    ier = k;
                    ip[n - 1] = 0;
                    return ier;
                }
                t = 1.0 / t;
                for (i2 = md1; i2 <= mdl; ++i2) {
                    double[] dArray = A[i2];
                    int n2 = k;
                    dArray[n2] = dArray[n2] * -t;
                }
                ju = Math.min(Math.max(ju, mu + ip[k] + 1), n);
                int mm = md;
                if (ju < kp1) continue;
                for (j = kp1; j < ju; ++j) {
                    t = A[--m][j];
                    if (m != --mm) {
                        A[m][j] = A[mm][j];
                        A[mm][j] = t;
                    }
                    if (t == 0.0) continue;
                    int jk = j - k;
                    for (i = md1; i <= mdl; ++i) {
                        int ijk = i - jk;
                        double[] dArray = A[ijk];
                        int n3 = j;
                        dArray[n3] = dArray[n3] + A[i][k] * t;
                    }
                }
            }
        }
        k = n;
        if (A[md][n - 1] == 0.0) {
            ier = k;
            ip[n - 1] = 0;
        }
        return ier;
    }

    protected static void solb(int n, double[][] A, int ml, int mu, double[] b, int[] ip) {
        int md = ml + mu;
        int md1 = md + 1;
        int mdm = md - 1;
        int nm1 = n - 1;
        if (n != 1) {
            int imd;
            int i;
            double t;
            int k;
            if (ml != 0) {
                for (k = 0; k < nm1; ++k) {
                    int m = ip[k];
                    t = b[m];
                    b[m] = b[k];
                    b[k] = t;
                    int mdl = Math.min(ml, n - k - 1) + md;
                    for (i = md1; i <= mdl; ++i) {
                        int n2 = imd = i + k - md;
                        b[n2] = b[n2] + A[i][k] * t;
                    }
                }
            }
            for (k = 0; k < nm1; ++k) {
                int lm;
                int kb = n - k - 1;
                b[kb] = b[kb] / A[md][kb];
                t = -b[kb];
                int kmd = md - kb;
                for (i = lm = Math.max(0, kmd); i <= mdm; ++i) {
                    int n3 = imd = i - kmd;
                    b[n3] = b[n3] + A[i][kb] * t;
                }
            }
        }
        b[0] = b[0] / A[md][0];
    }

    protected static int decbc(int n, double[][] AR, double[][] AI, int ml, int mu, int[] ip) {
        int k;
        int ier = 0;
        ip[n - 1] = 1;
        int md = ml + mu;
        int md1 = md + 1;
        int ju = 0;
        if (n != 1 && ml != 0) {
            int i;
            int j;
            if (n >= mu + 2) {
                for (j = mu + 1; j < n; ++j) {
                    for (i = 0; i < ml; ++i) {
                        AR[i][j] = 0.0;
                        AI[i][j] = 0.0;
                    }
                }
            }
            int nm1 = n - 1;
            for (k = 0; k < nm1; ++k) {
                double prodi;
                double prodr;
                int i2;
                int kp1 = k + 1;
                int m = md;
                int mdl = Math.min(ml, n - k - 1) + md;
                for (i2 = md1; i2 <= mdl; ++i2) {
                    if (!(Math.abs(AR[i2][k]) + Math.abs(AI[i2][k]) > Math.abs(AR[m][k]) + Math.abs(AI[m][k]))) continue;
                    m = i2;
                }
                ip[k] = m + k - md;
                double tr = AR[m][k];
                double ti = AI[m][k];
                if (m != k) {
                    ip[n - 1] = -ip[n - 1];
                    AR[m][k] = AR[md][k];
                    AI[m][k] = AI[md][k];
                    AR[md][k] = tr;
                    AI[md][k] = ti;
                }
                if (Math.abs(tr) + Math.abs(ti) == 0.0) {
                    ier = k;
                    ip[n - 1] = 0;
                    return ier;
                }
                double den = tr * tr + ti * ti;
                tr /= den;
                ti = -ti / den;
                for (i2 = md1; i2 <= mdl; ++i2) {
                    prodr = AR[i2][k] * tr - AI[i2][k] * ti;
                    prodi = AI[i2][k] * tr + AR[i2][k] * ti;
                    AR[i2][k] = -prodr;
                    AI[i2][k] = -prodi;
                }
                ju = Math.min(Math.max(ju, mu + ip[k] + 1), n);
                int mm = md;
                if (ju < kp1) continue;
                for (j = kp1; j < ju; ++j) {
                    int ijk;
                    int jk;
                    tr = AR[--m][j];
                    ti = AI[m][j];
                    if (m != --mm) {
                        AR[m][j] = AR[mm][j];
                        AI[m][j] = AI[mm][j];
                        AR[mm][j] = tr;
                        AI[mm][j] = ti;
                    }
                    if (Math.abs(tr) + Math.abs(ti) == 0.0) continue;
                    if (ti == 0.0) {
                        jk = j - k;
                        for (i = md1; i <= mdl; ++i) {
                            ijk = i - jk;
                            prodr = AR[i][k] * tr;
                            prodi = AI[i][k] * tr;
                            double[] dArray = AR[ijk];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + prodr;
                            double[] dArray2 = AI[ijk];
                            int n3 = j;
                            dArray2[n3] = dArray2[n3] + prodi;
                        }
                        continue;
                    }
                    if (tr == 0.0) {
                        jk = j - k;
                        for (i = md1; i <= mdl; ++i) {
                            ijk = i - jk;
                            prodr = -AI[i][k] * ti;
                            prodi = AR[i][k] * ti;
                            double[] dArray = AR[ijk];
                            int n4 = j;
                            dArray[n4] = dArray[n4] + prodr;
                            double[] dArray3 = AI[ijk];
                            int n5 = j;
                            dArray3[n5] = dArray3[n5] + prodi;
                        }
                        continue;
                    }
                    jk = j - k;
                    for (i = md1; i <= mdl; ++i) {
                        ijk = i - jk;
                        prodr = AR[i][k] * tr - AI[i][k] * ti;
                        prodi = AI[i][k] * tr + AR[i][k] * ti;
                        double[] dArray = AR[ijk];
                        int n6 = j;
                        dArray[n6] = dArray[n6] + prodr;
                        double[] dArray4 = AI[ijk];
                        int n7 = j;
                        dArray4[n7] = dArray4[n7] + prodi;
                    }
                }
            }
        }
        k = n;
        if (Math.abs(AR[md][n - 1]) + Math.abs(AI[md][n - 1]) == 0.0) {
            ier = k;
            ip[n - 1] = 0;
        }
        return ier;
    }

    protected static void solbc(int n, double[][] AR, double[][] AI, int ml, int mu, double[] br, double[] bi, int[] ip) {
        int md = ml + mu;
        int md1 = md + 1;
        int mdm = md - 1;
        int nm1 = n - 1;
        if (n != 1) {
            double den;
            double prodi;
            double prodr;
            int imd;
            int i;
            double ti;
            double tr;
            int k;
            if (ml != 0) {
                for (k = 0; k < nm1; ++k) {
                    int m = ip[k];
                    tr = br[m];
                    ti = bi[m];
                    br[m] = br[k];
                    bi[m] = bi[k];
                    br[k] = tr;
                    bi[k] = ti;
                    int mdl = Math.min(ml, n - k - 1) + md;
                    for (i = md1; i <= mdl; ++i) {
                        imd = i + k - md;
                        prodr = AR[i][k] * tr - AI[i][k] * ti;
                        prodi = AI[i][k] * tr + AR[i][k] * ti;
                        int n2 = imd;
                        br[n2] = br[n2] + prodr;
                        int n3 = imd;
                        bi[n3] = bi[n3] + prodi;
                    }
                }
            }
            for (k = 0; k < nm1; ++k) {
                int lm;
                int kb = n - k - 1;
                den = AR[md][kb] * AR[md][kb] + AI[md][kb] * AI[md][kb];
                prodr = br[kb] * AR[md][kb] + bi[kb] * AI[md][kb];
                prodi = bi[kb] * AR[md][kb] - br[kb] * AI[md][kb];
                br[kb] = prodr / den;
                bi[kb] = prodi / den;
                tr = -br[kb];
                ti = -bi[kb];
                int kmd = md - kb;
                for (i = lm = Math.max(0, kmd); i <= mdm; ++i) {
                    imd = i - kmd;
                    prodr = AR[i][kb] * tr - AI[i][kb] * ti;
                    prodi = AI[i][kb] * tr + AR[i][kb] * ti;
                    int n4 = imd;
                    br[n4] = br[n4] + prodr;
                    int n5 = imd;
                    bi[n5] = bi[n5] + prodi;
                }
            }
            den = AR[md][0] * AR[md][0] + AI[md][0] * AI[md][0];
            prodr = br[0] * AR[md][0] + bi[0] * AI[md][0];
            prodi = bi[0] * AR[md][0] - br[0] * AI[md][0];
            br[0] = prodr / den;
            bi[0] = prodi / den;
        }
    }

    protected static void elmhes(int n, int low, int igh, double[][] A, int[] inter) {
        int la = igh - 2;
        int kp1 = low + 1;
        if (la < kp1) {
            return;
        }
        for (int m = kp1; m <= la; ++m) {
            int mp1;
            double y;
            int j;
            int mm1 = m - 1;
            double x = 0.0;
            int ii = m;
            for (j = m; j < igh; ++j) {
                if (!(Math.abs(A[j][mm1]) > Math.abs(x))) continue;
                x = A[j][mm1];
                ii = j;
            }
            inter[m] = ii;
            if (ii != m) {
                for (j = mm1; j < n; ++j) {
                    y = A[ii][j];
                    A[ii][j] = A[m][j];
                    A[m][j] = y;
                }
                for (j = 0; j < igh; ++j) {
                    y = A[j][ii];
                    A[j][ii] = A[j][m];
                    A[j][m] = y;
                }
            }
            if (x == 0.0) continue;
            for (int i = mp1 = m + 1; i < igh; ++i) {
                int j2;
                y = A[i][mm1];
                if (y == 0.0) {
                    return;
                }
                A[i][mm1] = y /= x;
                for (j2 = m; j2 < n; ++j2) {
                    double[] dArray = A[i];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] - y * A[m][j2];
                }
                for (j2 = 0; j2 < igh; ++j2) {
                    double[] dArray = A[i];
                    int n3 = m;
                    dArray[n3] = dArray[n3] + y * A[j2][i];
                }
            }
        }
    }
}

