/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import java.util.Arrays;
import one.util.streamex.DoubleStreamEx;

public class VectorUtils {
    private VectorUtils() {
    }

    public static void linearSum(double a, double[] x, double b, double[] y, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = a * x[i] + b * y[i];
        }
    }

    public static void prod(double[] x, double[] y, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = x[i] * y[i];
        }
    }

    public static void divide(double[] x, double[] y, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = x[i] / y[i];
        }
    }

    public static void scale(double c, double[] x, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = c * x[i];
        }
    }

    public static void abs(double[] x, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = Math.abs(x[i]);
        }
    }

    public static void inv(double[] x, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = 1.0 / x[i];
        }
    }

    public static void addConst(double[] x, double b, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = x[i] + b;
        }
    }

    public static void addConst(double b, double[] x) {
        int n = x.length;
        int i = 0;
        while (i < n) {
            int n2 = i++;
            x[n2] = x[n2] + b;
        }
    }

    public static double dotProd(double[] x, double[] y) {
        int n = x.length;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += x[i] * y[i];
        }
        return sum;
    }

    public static double maxNorm(double[] x) {
        double max = 0.0;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, Math.abs(x[i]));
        }
        return max;
    }

    public static double wrmsNorm(double[] x, double[] w) {
        double sum = 0.0;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            double prodi = x[i] * w[i];
            sum += prodi * prodi;
        }
        return Math.sqrt(sum / (double)n);
    }

    public static double wrmsNormMask(double[] x, double[] w, double[] id) {
        double sum = 0.0;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            if (!(id[i] > 0.0)) continue;
            double prodi = x[i] * w[i];
            sum += prodi * prodi;
        }
        return Math.sqrt(sum / (double)n);
    }

    public static double getMin(double[] x) {
        int n = x.length;
        double min = x[0];
        for (int i = 1; i < n; ++i) {
            if (!(x[i] < min)) continue;
            min = x[i];
        }
        return min;
    }

    public static double l2Norm(double[] x, double[] w) {
        double sum = 0.0;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            double prodi = x[i] * w[i];
            sum += prodi * prodi;
        }
        return Math.sqrt(sum);
    }

    public static double l1Norm(double[] x) {
        double sum = 0.0;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            sum += Math.abs(x[i]);
        }
        return sum;
    }

    public static void compare(double c, double[] x, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = Math.abs(x[i]) >= c ? 1.0 : 0.0;
        }
    }

    public static boolean invTest(double[] x, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            if (x[i] == 0.0) {
                return false;
            }
            z[i] = 1.0 / x[i];
        }
        return true;
    }

    public static boolean constrMask(double[] c, double[] x, double[] m) {
        int n = x.length;
        boolean test = true;
        for (int i = 0; i < n; ++i) {
            m[i] = 0.0;
            if (c[i] == 0.0) continue;
            if (c[i] > 1.5 || c[i] < -1.5) {
                if (!(x[i] * c[i] <= 0.0)) continue;
                test = false;
                m[i] = 1.0;
                continue;
            }
            if (!(c[i] > 0.5) && !(c[i] < -0.5) || !(x[i] * c[i] < 0.0)) continue;
            test = false;
            m[i] = 1.0;
        }
        return test;
    }

    public static double minQuotient(double[] num, double[] denom) {
        int n = num.length;
        boolean notEvenOnce = true;
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            if (denom[i] == 0.0) continue;
            if (!notEvenOnce) {
                min = Math.min(min, num[i] / denom[i]);
                continue;
            }
            min = num[i] / denom[i];
            notEvenOnce = false;
        }
        return min;
    }

    public static double[] newVector(double val, int n) {
        double[] result = new double[n];
        Arrays.fill(result, val);
        return result;
    }

    public static void copy(double[] x, double[] z) {
        System.arraycopy(x, 0, z, 0, x.length);
    }

    public static double[] copy(double[] x) {
        double[] result = new double[x.length];
        System.arraycopy(x, 0, result, 0, x.length);
        return result;
    }

    public static void linearSum(double[] x, double[] y, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = x[i] + y[i];
        }
    }

    public static void linearDiff(double[] x, double[] y, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = x[i] - y[i];
        }
    }

    public static void neg(double[] x, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = -x[i];
        }
    }

    public static void scaleSum(double a, double[] x, double[] y, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = a * (x[i] + y[i]);
        }
    }

    public static void scaleDiff(double a, double[] x, double[] y, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = a * (x[i] - y[i]);
        }
    }

    public static void linearSum(double a, double[] x, double[] y, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = a * x[i] + y[i];
        }
    }

    public static void linearSum(double[] x, double b, double[] y, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = x[i] + b * y[i];
        }
    }

    public static void linearSum(double a, double[] x, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            z[n2] = z[n2] + a * x[i];
        }
    }

    public static void linearDiff(double a, double[] x, double[] y, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = a * x[i] - y[i];
        }
    }

    public static void scale(double a, double[] x) {
        int n = x.length;
        int i = 0;
        while (i < n) {
            int n2 = i++;
            x[n2] = x[n2] * a;
        }
    }

    public static void add(double[] x, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            z[n2] = z[n2] + x[i];
        }
    }

    public static void substract(double[] x, double[] z) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            z[n2] = z[n2] - x[i];
        }
    }

    public static void addScaled(double a, double[] x, double[] y) {
        int n = x.length;
        if (a == 1.0) {
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                y[n2] = y[n2] + x[i];
            }
            return;
        }
        if (a == -1.0) {
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                y[n3] = y[n3] - x[i];
            }
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n4 = i;
            y[n4] = y[n4] + a * x[i];
        }
    }

    public static String toString(double[] y) {
        return DoubleStreamEx.of((double[])y).mapToObj(val -> val + "\n").joining();
    }
}

