/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.ode.jvode.Matrix;

public class MatrixUtils {
    public static int DenseGETRF(Matrix A, int[] p) {
        return MatrixUtils.denseGETRF(A.cols, A.M, A.N, p);
    }

    public static void DenseGETRS(Matrix A, int[] p, double[] b) {
        MatrixUtils.denseGETRS(A.cols, A.N, p, b);
    }

    public static int denseGETRF(double[][] a, int m, int n, int[] p) {
        for (int k = 0; k < n; ++k) {
            int i;
            double[] ak = a[k];
            int l = k;
            for (i = k + 1; i < m; ++i) {
                double aki = ak[i];
                double akl = ak[l];
                if (aki < 0.0) {
                    aki = -aki;
                }
                if (akl < 0.0) {
                    akl = -akl;
                }
                if (!(aki > akl)) continue;
                l = i;
            }
            p[k] = l;
            if (ak[l] == 0.0) {
                return k + 1;
            }
            if (l != k) {
                for (i = 0; i < n; ++i) {
                    double temp = a[i][l];
                    a[i][l] = a[i][k];
                    a[i][k] = temp;
                }
            }
            double mult = 1.0 / ak[k];
            i = k + 1;
            while (i < m) {
                int n2 = i++;
                ak[n2] = ak[n2] * mult;
            }
            for (int j = k + 1; j < n; ++j) {
                double[] aj = a[j];
                double ajk = aj[k];
                if (ajk == 0.0) continue;
                for (i = k + 1; i < m; ++i) {
                    int n3 = i;
                    aj[n3] = aj[n3] - ajk * ak[i];
                }
            }
        }
        return 0;
    }

    public static void denseGETRS(double[][] a, int n, int[] p, double[] b) {
        int i;
        double bk;
        int k;
        for (k = 0; k < n; ++k) {
            int pk = p[k];
            if (pk == k) continue;
            double tmp = b[k];
            b[k] = b[pk];
            b[pk] = tmp;
        }
        for (k = 0; k < n - 1; ++k) {
            double[] ak = a[k];
            bk = b[k];
            for (i = k + 1; i < n; ++i) {
                int n2 = i;
                b[n2] = b[n2] - ak[i] * bk;
            }
        }
        for (k = n - 1; k > 0; --k) {
            double[] ak = a[k];
            int n3 = k;
            double d = b[n3] / ak[k];
            b[n3] = d;
            bk = d;
            for (i = 0; i < k; ++i) {
                int n4 = i;
                b[n4] = b[n4] - ak[i] * bk;
            }
        }
        b[0] = b[0] / a[0][0];
    }

    public static int DensePOTRF(Matrix A) {
        return MatrixUtils.densePOTRF(A.cols, A.M);
    }

    public static void DensePOTRS(Matrix A, double[] b) {
        MatrixUtils.densePOTRS2(A.cols, A.M, b);
    }

    static int densePOTRF(double[][] a, int m) {
        for (int j = 0; j < m; ++j) {
            double a_diag;
            int i;
            if (j > 0) {
                for (i = j; i < m; ++i) {
                    for (int k = 0; k < j; ++k) {
                        double[] dArray = a[j];
                        int n = i;
                        dArray[n] = dArray[n] - a[k][i] * a[k][j];
                    }
                }
            }
            if ((a_diag = a[j][j]) <= 0.0) {
                return j;
            }
            a_diag = Math.sqrt(a_diag);
            i = j;
            while (i < m) {
                double[] dArray = a[j];
                int n = i++;
                dArray[n] = dArray[n] / a_diag;
            }
        }
        return 0;
    }

    static void densePOTRS(double[][] a, int m, double[] b) {
        double[] aj;
        for (int j = 0; j < m - 1; ++j) {
            aj = a[j];
            int n = j;
            b[n] = b[n] / aj[j];
            for (int i = j + 1; i < m; ++i) {
                int n2 = i;
                b[n2] = b[n2] - b[j] * aj[i];
            }
        }
        aj = a[m - 1];
        int n = m - 1;
        b[n] = b[n] / aj[m - 1];
        aj = a[m - 1];
        int n3 = m - 1;
        b[n3] = b[n3] / aj[m - 1];
        for (int i = m - 2; i >= 0; --i) {
            double[] ai = a[i];
            for (int j = i + 1; j < m; ++j) {
                int n4 = i;
                b[n4] = b[n4] - ai[j] * b[j];
            }
            int n5 = i;
            b[n5] = b[n5] / ai[i];
        }
    }

    static void densePOTRS2(double[][] a, int m, double[] b) {
        for (int j = 0; j < m - 1; ++j) {
            int n = j;
            b[n] = b[n] / a[j][j];
            for (int i = j + 1; i < m; ++i) {
                int n2 = i;
                b[n2] = b[n2] - b[j] * a[j][i];
            }
        }
        int n = m - 1;
        b[n] = b[n] / a[m - 1][m - 1];
        int n3 = m - 1;
        b[n3] = b[n3] / a[m - 1][m - 1];
        for (int i = m - 2; i >= 0; --i) {
            for (int j = i + 1; j < m; ++j) {
                int n4 = i;
                b[n4] = b[n4] - a[i][j] * b[j];
            }
            int n5 = i;
            b[n5] = b[n5] / a[i][i];
        }
    }

    public static int DenseGEQRF(Matrix A, double[] beta, double[] wrk) {
        return MatrixUtils.denseGEQRF(A.cols, A.M, A.N, beta, wrk);
    }

    public static int DenseORMQR(Matrix A, double[] beta, double[] vn, double[] vm, double[] wrk) {
        return MatrixUtils.denseORMQR(A.cols, A.M, A.N, beta, vn, vm, wrk);
    }

    static int denseGEQRF(double[][] a, int m, int n, double[] beta, double[] v) {
        for (int j = 0; j < n; ++j) {
            int i;
            double[] col_j = a[j];
            double ajj = col_j[j];
            v[0] = 1.0;
            double s = 0.0;
            for (i = 1; i < m - j; ++i) {
                v[i] = col_j[i + j];
                s += v[i] * v[i];
            }
            if (s != 0.0) {
                double mu = Math.sqrt(ajj * ajj + s);
                double v1 = ajj <= 0.0 ? ajj - mu : -s / (ajj + mu);
                double v1_2 = v1 * v1;
                beta[j] = 2.0 * v1_2 / (s + v1_2);
                i = 1;
                while (i < m - j) {
                    int n2 = i++;
                    v[n2] = v[n2] / v1;
                }
            } else {
                beta[j] = 0.0;
            }
            for (int k = j; k < n; ++k) {
                double[] col_k = a[k];
                s = 0.0;
                for (i = 0; i < m - j; ++i) {
                    s += col_k[i + j] * v[i];
                }
                s *= beta[j];
                for (i = 0; i < m - j; ++i) {
                    int n3 = i + j;
                    col_k[n3] = col_k[n3] - s * v[i];
                }
            }
            if (j >= m - 1) continue;
            for (i = 1; i < m - j; ++i) {
                col_j[i + j] = v[i];
            }
        }
        return 0;
    }

    static int denseORMQR(double[][] a, int m, int n, double[] beta, double[] vn, double[] vm, double[] v) {
        int i;
        for (i = 0; i < n; ++i) {
            vm[i] = vn[i];
        }
        for (i = n; i < m; ++i) {
            vm[i] = 0.0;
        }
        for (int j = n - 1; j >= 0; --j) {
            int i2;
            double[] col_j = a[j];
            v[0] = 1.0;
            double s = vm[j];
            for (i2 = 1; i2 < m - j; ++i2) {
                v[i2] = col_j[i2 + j];
                s += v[i2] * vm[i2 + j];
            }
            s *= beta[j];
            for (i2 = 0; i2 < m - j; ++i2) {
                int n2 = i2 + j;
                vm[n2] = vm[n2] - s * v[i2];
            }
        }
        return 0;
    }

    public static int BandGBTRF(Matrix A, int[] p) {
        return MatrixUtils.bandGBTRF(A.cols, A.N, A.mu, A.ml, A.smu, p);
    }

    static int bandGBTRF(double[][] a, int n, int mu, int ml, int smu, int[] p) {
        int num_rows = smu - mu;
        if (num_rows > 0) {
            for (int c = 0; c < n; ++c) {
                double[] ac = a[c];
                for (int r = 0; r < num_rows; ++r) {
                    ac[r] = 0.0;
                }
            }
        }
        for (int k = 0; k < n - 1; ++k) {
            int last_row_k = Math.min(n - 1, k + ml);
            double[] col_k = a[k];
            int l = k;
            double max = Math.abs(col_k[smu]);
            int i = k + 1;
            int j = 1;
            while (i <= last_row_k) {
                if (Math.abs(col_k[j + smu]) > max) {
                    l = i;
                    max = Math.abs(col_k[j + smu]);
                }
                ++i;
                ++j;
            }
            int storage_l = l - k + smu;
            p[k] = l;
            if (col_k[storage_l] == 0.0) {
                return k + 1;
            }
            boolean swap = l != k;
            if (swap) {
                double temp = col_k[storage_l];
                col_k[storage_l] = col_k[smu];
                col_k[smu] = temp;
            }
            double mult = -1.0 / col_k[smu];
            i = k + 1;
            j = 1;
            while (i <= last_row_k) {
                int n2 = j + smu;
                col_k[n2] = col_k[n2] * mult;
                ++i;
                ++j;
            }
            int last_col_k = Math.min(k + smu, n - 1);
            for (int j2 = k + 1; j2 <= last_col_k; ++j2) {
                double[] col_j = a[j2];
                storage_l = l - j2 + smu;
                int storage_k = k - j2 + smu;
                double a_kj = col_j[storage_l];
                if (swap) {
                    col_j[storage_l] = col_j[storage_k];
                    col_j[storage_k] = a_kj;
                }
                if (a_kj == 0.0) continue;
                int i2 = k + 1;
                int s = 0;
                while (i2 <= last_row_k) {
                    int n3 = i2 - j2 + smu;
                    col_j[n3] = col_j[n3] + col_j[storage_l] * col_k[s + 1 + smu];
                    ++i2;
                    ++s;
                }
            }
        }
        p[n - 1] = n - 1;
        if (a[n - 1][smu] == 0.0) {
            return n;
        }
        return 0;
    }

    public static void BandGBTRS(Matrix A, int[] p, double[] b) {
        MatrixUtils.bandGBTRS(A.cols, A.N, A.smu, A.ml, p, b);
    }

    static void bandGBTRS(double[][] a, int n, int smu, int ml, int[] p, double[] b) {
        int i;
        double mult;
        int k;
        for (k = 0; k < n - 1; ++k) {
            int l = p[k];
            mult = b[l];
            if (l != k) {
                b[l] = b[k];
                b[k] = mult;
            }
            int last_row_k = Math.min(n - 1, k + ml);
            for (i = k + 1; i <= last_row_k; ++i) {
                int n2 = i;
                b[n2] = b[n2] + mult * a[k][i - k + smu];
            }
        }
        for (k = n - 1; k >= 0; --k) {
            int first_row_k = Math.max(0, k - smu);
            int n3 = k;
            b[n3] = b[n3] / a[k][smu];
            mult = -b[k];
            for (i = first_row_k; i <= k - 1; ++i) {
                int n4 = i;
                b[n4] = b[n4] + mult * a[k][i - k + smu];
            }
        }
    }

    public static void denseAddIdentity(double[][] a, int n) {
        int i = 0;
        while (i < n) {
            double[] dArray = a[i];
            int n2 = i++;
            dArray[n2] = dArray[n2] + 1.0;
        }
    }

    public static double[][] newDenseMat(int m, int n) {
        if (n <= 0 || m <= 0) {
            return null;
        }
        double[][] a = new double[n][];
        for (int j = 0; j < n; ++j) {
            a[j] = new double[m];
        }
        return a;
    }

    public static double[][] newBandMat(int n, int smu, int ml) {
        if (n <= 0) {
            return null;
        }
        double[][] a = new double[n][];
        int colSize = smu + ml + 1;
        for (int j = 0; j < n; ++j) {
            a[j] = new double[colSize];
        }
        return a;
    }
}

