/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

public class Matrix {
    public static final int SUNDIALS_DENSE = 1;
    public static final int SUNDIALS_BAND = 2;
    private int type;
    public int M;
    public int N;
    private int ldim;
    int mu;
    int ml;
    int smu;
    public int ldata;
    public double[][] cols;

    public double getDenseElement(int i, int j) {
        return this.cols[j][i];
    }

    public void setDenseElement(int i, int j, double val) {
        this.cols[j][i] = val;
    }

    public double getBandElement(int i, int j) {
        return this.cols[j][i - j + this.smu];
    }

    public void setBandElement(int i, int j, double val) {
        this.cols[j][i - j + this.smu] = val;
    }

    public Matrix(int M, int N) {
        if (M < 0 || N < 0) {
            throw new IllegalArgumentException("Matrix dimensions must be positive");
        }
        this.cols = new double[N][];
        for (int j = 0; j < N; ++j) {
            this.cols[j] = new double[M];
        }
        this.M = M;
        this.N = N;
        this.ldim = M;
        this.ldata = M * N;
        this.type = 1;
    }

    public Matrix(int N, int mu, int ml, int smu) {
        if (N <= 0) {
            throw new IllegalArgumentException("Matrix dimenxions must be positive");
        }
        this.ldim = smu + ml + 1;
        this.cols = new double[N][];
        for (int j = 0; j < N; ++j) {
            this.cols[j] = new double[this.ldim];
        }
        this.M = N;
        this.N = N;
        this.mu = mu;
        this.ml = ml;
        this.smu = smu;
        this.ldata = N * this.ldim;
        this.type = 2;
    }

    public void addIdentity() {
        switch (this.type) {
            case 1: {
                int i = 0;
                while (i < this.N) {
                    double[] dArray = this.cols[i];
                    int n = i++;
                    dArray[n] = dArray[n] + 1.0;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.M; ++i) {
                    double[] dArray = this.cols[i];
                    int n = this.smu;
                    dArray[n] = dArray[n] + 1.0;
                }
                break;
            }
        }
    }

    public void setToZero() {
        switch (this.type) {
            case 1: {
                for (int j = 0; j < this.N; ++j) {
                    for (int i = 0; i < this.M; ++i) {
                        this.cols[j][i] = 0.0;
                    }
                }
                break;
            }
            case 2: {
                int colSize = this.mu + this.ml + 1;
                for (int j = 0; j < this.M; ++j) {
                    for (int i = 0; i < colSize; ++i) {
                        this.cols[j][i + this.smu - this.mu] = 0.0;
                    }
                }
                break;
            }
        }
    }

    public void scale(double c) {
        switch (this.type) {
            case 1: {
                Matrix.denseScale(c, this.cols, this.M, this.N);
                break;
            }
            case 2: {
                Matrix.bandScale(c, this.cols, this.N, this.mu, this.ml, this.smu);
            }
        }
    }

    public static void denseScale(double c, double[][] a, int m, int n) {
        for (int j = 0; j < n; ++j) {
            int i = 0;
            while (i < m) {
                double[] dArray = a[j];
                int n2 = i++;
                dArray[n2] = dArray[n2] * c;
            }
        }
    }

    static void bandScale(double c, double[][] a, int n, int mu, int ml, int smu) {
        int colSize = mu + ml + 1;
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < colSize; ++i) {
                double[] dArray = a[j];
                int n2 = i + smu - mu;
                dArray[n2] = dArray[n2] * c;
            }
        }
    }

    public void denseCopy(Matrix b) {
        Matrix.denseCopy(this.cols, b.cols, this.M, this.N);
    }

    public void bandCopy(Matrix b, int copymu, int copyml) {
        Matrix.bandCopy(this.cols, b.cols, this.N, this.smu, b.smu, copymu, copyml);
    }

    public static void denseCopy(double[][] a, double[][] b, int m, int n) {
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                b[j][i] = a[j][i];
            }
        }
    }

    static void bandCopy(double[][] a, double[][] b, int n, int asmu, int bsmu, int copymu, int copyml) {
        int copySize = copymu + copyml + 1;
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < copySize; ++i) {
                b[j][i + bsmu - copymu] = a[j][i + asmu - copymu];
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\n");
        switch (this.type) {
            case 1: {
                for (int i = 0; i < this.M; ++i) {
                    for (int j = 0; j < this.N; ++j) {
                        sb.append(this.getDenseElement(i, j));
                        sb.append(" ");
                    }
                    sb.append("\n");
                }
                sb.append("\n");
                break;
            }
            case 2: {
                for (int i = 0; i < this.N; ++i) {
                    int j;
                    int start = Math.max(0, i - this.ml);
                    int finish = Math.min(this.N - 1, i + this.mu);
                    for (j = 0; j < start; ++j) {
                        sb.append(" ");
                    }
                    for (j = start; j <= finish; ++j) {
                        sb.append(this.getBandElement(i, j));
                        sb.append(" ");
                    }
                    sb.append("\n");
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

