/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.jvode.VectorUtils;
import java.util.Arrays;

public abstract class JVodeSupport {
    public static final int ADAMS_Q_MAX = 12;
    public static final int BDF_Q_MAX = 5;
    public static final int Q_MAX = 12;
    public static final int L_MAX = 13;
    public static final int NUM_TESTS = 5;
    public static final double CORTES = 0.1;
    public static final int MXNCF = 10;
    public static final int MXNEF = 7;
    public static final int NLS_MAXCOR = 3;
    public static final int MXHNIL_DEFAULT = 10;
    public static final int MXSTEP_DEFAULT = 100000;
    public static final double HMIN_DEFAULT = 1.0E-100;
    public static final double HMAX_INV_DEFAULT = 1.0E-100;
    private static final double ETAMX1 = 10000.0;
    public static final double UROUND = 2.220446049250313E-16;
    public static final double UROUND_100 = 2.220446049250313E-14;
    public static final double UROUND_SQRT = Math.sqrt(2.220446049250313E-16);
    protected OdeModel f;
    Method method;
    IterationType iterationType;
    JacobianType jacobianType;
    protected double rtol;
    protected double[] atolVector;
    protected EwtFn ewtFunc;
    protected double time;
    protected double[][] z = new double[13][];
    protected int n;
    protected double[] errorWeight;
    protected double[] y;
    protected double[] acor;
    protected double[] temp;
    protected double[] ftemp;
    protected boolean tStopSet;
    protected double tStop;
    protected int q;
    protected int qPrime;
    protected int qNext;
    protected int qWait;
    protected int qPlusOne;
    protected double h0;
    protected double h;
    protected double hPrime;
    protected double hNext;
    protected double eta;
    protected double hScale;
    protected double tn;
    protected double cv_tretlast;
    protected double[] tau = new double[14];
    protected double[] tq = new double[6];
    protected double[] l = new double[13];
    protected double rl1;
    protected double gamma;
    protected double gammaPrev;
    protected double gammaRatio;
    protected double convergenceRate;
    protected double acorNorm;
    protected double convCoef = 0.1;
    protected int mNewt;
    protected int qMax;
    protected int maxSteps = 100000;
    protected int maxCor = 3;
    protected int maxHnil = 10;
    protected int maxTestFails = 7;
    protected int maxConvFails = 10;
    protected double hMin = 1.0E-100;
    protected double hMaxInv = 1.0E-100;
    double etaMax = 10000.0;
    protected int nFlag;
    protected double dsm;
    protected int nef;
    protected int ncf;
    public int nSteps;
    public int nFCalls;
    public int nCorrFails;
    public int nTestFails;
    public int nNewtonIter;
    public int nSetupCalls;
    public int nHnil;
    protected double etaqm1;
    protected double etaq;
    protected double etaqp1;
    public int qu;
    protected long nLastSetupSteps;
    protected double h0u;
    public double hu;
    protected double tq5Saved;
    protected boolean currentJacobian;
    protected double toleranceScale;
    protected int acorIndex;
    protected boolean setupNonNull;
    protected boolean stabLimitDetect = false;
    protected double[][] ssdat = new double[6][4];
    protected int nscon;
    protected long nOrderReduct;
    protected int eventNumber;
    protected int[] eventInfo;
    protected int[] eventDirections;
    protected double tLo;
    protected double tHi;
    protected double eventTime;
    protected double[] eventFuncLo;
    protected double[] eventFuncHi;
    protected double[] eventFuncRout;
    protected double toutCopy;
    protected double eventTol;
    protected int lastStepRoot;
    public long nEventFuncionCalls;
    protected boolean[] eventActive;
    protected int maxWrnMessages;

    public double getTime() {
        return this.time;
    }

    public double[] getY() {
        return Arrays.copyOf(this.y, this.y.length);
    }

    public void setInitialValues(double[] x0, double t0) throws Exception {
        this.y = Arrays.copyOf(x0, this.n);
        for (int j = 0; j <= this.qMax; ++j) {
            this.z[j] = new double[this.n];
        }
        this.z[0] = Arrays.copyOf(x0, this.n);
        this.tn = t0;
        this.time = t0;
        this.f.extendResult(t0, x0);
    }

    public void setMaxSteps(int max) {
        this.maxSteps = max;
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public void setHMin(double min) {
        this.hMin = min;
    }

    public void setHMaxInv(double max) {
        this.hMaxInv = max;
    }

    public int[] getEventInfo() {
        return this.eventInfo;
    }

    abstract int init();

    abstract int setup(int var1);

    abstract int solve(double[] var1);

    public JVodeSupport(Method method, OdeModel model, double[] u0, double t0) throws IllegalArgumentException {
        int i;
        if (model == null) {
            throw new IllegalArgumentException("Model is null.");
        }
        this.n = u0.length;
        this.y = Arrays.copyOf(u0, this.n);
        this.tn = t0;
        this.time = t0;
        this.f = model;
        this.method = method;
        this.iterationType = IterationType.FUNCTIONAL;
        this.qMax = method == Method.ADAMS ? 12 : 5;
        this.tStopSet = false;
        this.maxWrnMessages = 1;
        this.errorWeight = new double[this.n];
        this.acor = new double[this.n];
        this.temp = new double[this.n];
        this.ftemp = new double[this.n];
        for (int j = 0; j <= this.qMax; ++j) {
            this.z[j] = new double[this.n];
        }
        VectorUtils.copy(this.y, this.z[0]);
        this.q = 1;
        this.qWait = this.qPlusOne = 2;
        this.toleranceScale = 1.0;
        this.setupNonNull = true;
        this.eventNumber = 0;
        try {
            double[] test = this.f.checkEvent(this.tn, this.y);
            if (test != null) {
                this.eventNumber = test.length;
            }
        }
        catch (Exception ex) {
            return;
        }
        if (this.eventNumber == 0) {
            return;
        }
        this.eventFuncLo = new double[this.eventNumber];
        this.eventFuncHi = new double[this.eventNumber];
        this.eventFuncRout = new double[this.eventNumber];
        this.eventInfo = new int[this.eventNumber];
        this.eventDirections = new int[this.eventNumber];
        this.eventActive = new boolean[this.eventNumber];
        for (i = 0; i < this.eventNumber; ++i) {
            this.eventDirections[i] = 1;
        }
        for (i = 0; i < this.eventNumber; ++i) {
            this.eventActive[i] = true;
        }
    }

    public void setTolerances(double reltol, double abstol) {
        this.setTolerances(reltol, VectorUtils.newVector(abstol, this.n));
    }

    public void setTolerances(double reltol, double[] abstol) {
        if (reltol < 0.0) {
            throw new IllegalArgumentException("reltol < 0 illegal.");
        }
        if (abstol.length != 0 && VectorUtils.getMin(abstol) < 0.0) {
            throw new IllegalArgumentException("abstol < 0 illegal.");
        }
        this.atolVector = VectorUtils.copy(abstol);
        this.rtol = reltol;
        this.ewtFunc = new EwtSet();
    }

    public void setTolerances(EwtFn efun) {
        this.ewtFunc = efun;
    }

    public static interface EwtFn {
        public int getValue(double[] var1, double[] var2);
    }

    public class EwtSet
    implements EwtFn {
        @Override
        public int getValue(double[] ycur, double[] weight) {
            VectorUtils.abs(ycur, weight);
            VectorUtils.linearSum(JVodeSupport.this.rtol, weight, JVodeSupport.this.atolVector, weight);
            if (VectorUtils.getMin(weight) <= 0.0) {
                return -1;
            }
            VectorUtils.inv(weight, weight);
            return 0;
        }
    }

    public static enum JacobianType {
        DENSE,
        BAND,
        DIAG;

    }

    public static enum IterationType {
        NEWTON,
        FUNCTIONAL;

    }

    public static enum Method {
        ADAMS,
        BDF;

    }
}

