/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.jvode.IterativeSolver;
import biouml.plugins.simulation.ode.jvode.JVodeSupport;
import biouml.plugins.simulation.ode.jvode.VectorUtils;
import java.util.Arrays;
import java.util.logging.Level;

public class JVodeSptfqmr
extends IterativeSolver {
    public static final int SPTFQMR_SUCCESS = 0;
    public static final int SPTFQMR_RES_REDUCED = 1;
    public static final int SPTFQMR_CONV_FAIL = 2;
    public static final int SPTFQMR_PSOLVE_FAIL_REC = 3;
    public static final int SPTFQMR_ATIMES_FAIL_REC = 4;
    public static final int SPTFQMR_PSET_FAIL_REC = 5;
    public static final int SPTFQMR_MEM_NULL = -1;
    public static final int SPTFQMR_ATIMES_FAIL_UNREC = -2;
    public static final int SPTFQMR_PSOLVE_FAIL_UNREC = -3;
    public static final int SPTFQMR_PSET_FAIL_UNREC = -4;
    public int l_max;
    double[] r_star;
    double[] q;
    double[] d;
    double[] v;
    double[] p;
    double[][] r;
    double[] u;
    double[] vtemp1;
    double[] vtemp2;
    double[] vtemp3;

    public JVodeSptfqmr(JVodeSupport.Method method, OdeModel f, double[] u0, double t0, int pretype, int maxl) throws Exception {
        super(method, f, u0, t0);
        this.s_type = 3;
        this.s_pretype = pretype;
        this.s_maxl = maxl <= 0 ? 5 : maxl;
        this.l_max = this.s_maxl;
        this.s_eplifac = 0.05;
        this.lastFlag = 0;
        this.setupNonNull = false;
        if (pretype != 0 && pretype != 1 && pretype != 2 && pretype != 3) {
            JVodeSptfqmr.processError("Illegal value for pretype. Legal values are PREC_NONE, PREC_LEFT, PREC_RIGHT, and PREC_BOTH.");
        }
        this.s_ytemp = new double[this.n];
        this.s_x = new double[this.n];
        Arrays.fill(this.s_ytemp, 1.0);
        this.s_sqrtN = Math.sqrt(VectorUtils.dotProd(this.s_ytemp, this.s_ytemp));
        this.r_star = new double[this.n];
        this.q = new double[this.n];
        this.d = new double[this.n];
        this.v = new double[this.n];
        this.p = new double[this.n];
        this.r = new double[2][this.n];
        this.u = new double[this.n];
        this.vtemp1 = new double[this.n];
        this.vtemp2 = new double[this.n];
        this.vtemp3 = new double[this.n];
    }

    @Override
    public int init() {
        this.s_nstlpre = 0;
        this.s_ncfl = 0;
        this.s_nps = 0;
        this.s_nli = 0;
        this.s_npe = 0;
        this.s_nfes = 0;
        this.s_njtimes = 0;
        this.setupNonNull = this.s_pretype != 0 && this.precondition != null;
        this.l_max = this.s_maxl;
        this.lastFlag = 0;
        return 0;
    }

    @Override
    public int setup(int convfail) {
        boolean jbad;
        double dgamma = Math.abs(this.gamma / this.gammaPrev - 1.0);
        this.currentJacobian = jbad = this.nSteps == 0 || this.nSteps > this.s_nstlpre + 50 || convfail == 1 && dgamma < 0.2 || convfail == 2;
        boolean jok = !jbad;
        int retval = this.precondition.setup(this.tn, this.z[0], this.ftemp, jok, this.gamma);
        if (retval < 0) {
            this.lastFlag = -4;
        }
        if (retval > 0) {
            this.lastFlag = 5;
        }
        this.currentJacobian = jbad;
        if (this.currentJacobian) {
            ++this.s_npe;
            this.s_nstlpre = this.nSteps;
        }
        this.lastFlag = 0;
        return retval;
    }

    @Override
    public int solve(double[] b) {
        this.s_deltar = this.s_eplifac * this.tq[4];
        double bnorm = VectorUtils.wrmsNorm(b, this.errorWeight);
        if (bnorm <= this.s_deltar) {
            if (this.mNewt > 0) {
                Arrays.fill(b, 0.0);
            }
            return 0;
        }
        this.s_ycur = this.y;
        this.s_fcur = this.ftemp;
        this.s_delta = this.s_deltar * this.s_sqrtN;
        Arrays.fill(this.s_x, 0.0);
        int retval = this.SptfqmrSolve(this.s_x, b, this.s_pretype, this.s_delta, this.errorWeight, this.errorWeight);
        VectorUtils.copy(this.s_x, b);
        if (retval != 0) {
            ++this.s_ncfl;
        }
        this.lastFlag = retval;
        switch (retval) {
            case 0: {
                return 0;
            }
            case 1: {
                if (this.mNewt == 0) {
                    return 0;
                }
                return 1;
            }
            case 2: 
            case 3: 
            case 4: {
                return 1;
            }
            case -1: {
                return -1;
            }
            case -2: {
                return -1;
            }
            case -3: {
                return -1;
            }
        }
        return 0;
    }

    public int SptfqmrSolve(double[] x, double[] b, int pretype, double delta, double[] sx, double[] sb) {
        try {
            int ier;
            boolean scale_b;
            double[] rho = new double[2];
            double r_curr_norm = -1.0;
            double temp_val = -1.0;
            boolean converged = false;
            boolean b_ok = false;
            if (pretype != 1 && pretype != 2 && pretype != 3) {
                pretype = 0;
            }
            boolean preOnLeft = pretype == 3 || pretype == 1;
            boolean preOnRight = pretype == 3 || pretype == 2;
            boolean scale_x = sx != null;
            boolean bl = scale_b = sb != null;
            if (VectorUtils.dotProd(x, x) == 0.0) {
                VectorUtils.copy(b, this.r_star);
            } else {
                ier = this.atimes(x, this.r_star);
                if (ier != 0) {
                    return ier < 0 ? -2 : 4;
                }
                VectorUtils.linearDiff(b, this.r_star, this.r_star);
            }
            if (preOnLeft) {
                ier = this.pSolve(this.r_star, this.vtemp1, 1);
                ++this.s_nps;
                if (ier != 0) {
                    return ier < 0 ? -3 : 3;
                }
            } else {
                VectorUtils.copy(this.r_star, this.vtemp1);
            }
            if (scale_b) {
                VectorUtils.prod(sb, this.vtemp1, this.r_star);
            } else {
                VectorUtils.copy(this.vtemp1, this.r_star);
            }
            rho[0] = VectorUtils.dotProd(this.r_star, this.r_star);
            double r_init_norm = Math.sqrt(rho[0]);
            if (r_init_norm <= delta) {
                return 0;
            }
            if (scale_x) {
                VectorUtils.divide(this.r_star, sx, this.vtemp1);
            } else {
                VectorUtils.copy(this.r_star, this.vtemp1);
            }
            if (preOnRight) {
                VectorUtils.copy(this.vtemp1, this.v);
                ier = this.pSolve(this.v, this.vtemp1, 2);
                ++this.s_nps;
                if (ier != 0) {
                    return ier < 0 ? -3 : 3;
                }
            }
            if ((ier = this.atimes(this.vtemp1, this.v)) != 0) {
                return ier < 0 ? -2 : 4;
            }
            if (preOnLeft) {
                ier = this.pSolve(this.v, this.vtemp1, 1);
                ++this.s_nps;
                if (ier != 0) {
                    return ier < 0 ? -3 : 3;
                }
            } else {
                VectorUtils.copy(this.v, this.vtemp1);
            }
            if (scale_b) {
                VectorUtils.prod(sb, this.vtemp1, this.v);
            } else {
                VectorUtils.copy(this.vtemp1, this.v);
            }
            VectorUtils.copy(this.r_star, this.r[0]);
            VectorUtils.copy(this.r_star, this.u);
            VectorUtils.copy(this.r_star, this.p);
            Arrays.fill(this.d, 0.0);
            double tau = r_init_norm;
            double eta = 0.0;
            double v_bar = 0.0;
            for (int n = 0; n < this.l_max; ++n) {
                ++this.s_nli;
                double sigma = VectorUtils.dotProd(this.r_star, this.v);
                double alpha = rho[0] / sigma;
                VectorUtils.linearSum(-alpha, this.v, this.u, this.q);
                VectorUtils.linearSum(this.u, this.q, this.r[1]);
                if (scale_x) {
                    VectorUtils.divide(this.r[1], sx, this.r[1]);
                }
                if (preOnRight) {
                    VectorUtils.copy(this.r[1], this.vtemp1);
                    ier = this.pSolve(this.vtemp1, this.r[1], 2);
                    ++this.s_nps;
                    if (ier != 0) {
                        return ier < 0 ? -3 : 3;
                    }
                }
                if ((ier = this.atimes(this.r[1], this.vtemp1)) != 0) {
                    return ier < 0 ? -2 : 4;
                }
                if (preOnLeft) {
                    ier = this.pSolve(this.vtemp1, this.r[1], 1);
                    ++this.s_nps;
                    if (ier != 0) {
                        return ier < 0 ? -3 : 3;
                    }
                } else {
                    VectorUtils.copy(this.vtemp1, this.r[1]);
                }
                if (scale_b) {
                    VectorUtils.prod(sb, this.r[1], this.vtemp1);
                } else {
                    VectorUtils.copy(this.r[1], this.vtemp1);
                }
                VectorUtils.linearSum(-alpha, this.vtemp1, this.r[0], this.r[1]);
                for (int m = 0; m < 2; ++m) {
                    double omega;
                    if (m == 0) {
                        temp_val = Math.sqrt(VectorUtils.dotProd(this.r[1], this.r[1]));
                        omega = Math.sqrt(Math.sqrt(VectorUtils.dotProd(this.r[0], this.r[0])) * temp_val);
                        VectorUtils.linearSum(v_bar * v_bar * eta / alpha, this.d, this.u, this.d);
                    } else {
                        omega = temp_val;
                        VectorUtils.linearSum(v_bar * v_bar * eta / alpha, this.d, this.q, this.d);
                    }
                    v_bar = omega / tau;
                    double c = 1.0 / Math.sqrt(1.0 + v_bar * v_bar);
                    tau = tau * v_bar * c;
                    eta = c * c * alpha;
                    VectorUtils.linearSum(eta, this.d, x);
                    r_curr_norm = tau * Math.sqrt(m + 1);
                    if (r_curr_norm <= delta) {
                        converged = true;
                        break;
                    }
                    if (!(r_curr_norm > delta) && (!(r_curr_norm >= r_init_norm) || m != 1 || n != this.l_max)) continue;
                    if (scale_x) {
                        VectorUtils.divide(x, sx, this.vtemp1);
                    } else {
                        VectorUtils.copy(x, this.vtemp1);
                    }
                    if (preOnRight) {
                        ier = this.pSolve(this.vtemp1, this.vtemp2, 2);
                        ++this.s_nps;
                        if (ier != 0) {
                            return ier < 0 ? -3 : 3;
                        }
                        VectorUtils.copy(this.vtemp2, this.vtemp1);
                    }
                    if ((ier = this.atimes(this.vtemp1, this.vtemp2)) != 0) {
                        return ier < 0 ? -2 : 4;
                    }
                    if (preOnLeft) {
                        ier = this.pSolve(this.vtemp2, this.vtemp1, 1);
                        ++this.s_nps;
                        if (ier != 0) {
                            return ier < 0 ? -3 : 3;
                        }
                    } else {
                        VectorUtils.copy(this.vtemp2, this.vtemp1);
                    }
                    if (scale_b) {
                        VectorUtils.prod(sb, this.vtemp1, this.vtemp2);
                    } else {
                        VectorUtils.copy(this.vtemp1, this.vtemp2);
                    }
                    if (!b_ok) {
                        b_ok = true;
                        if (preOnLeft) {
                            ier = this.pSolve(b, this.vtemp3, 1);
                            ++this.s_nps;
                            if (ier != 0) {
                                return ier < 0 ? -3 : 3;
                            }
                        } else {
                            VectorUtils.copy(b, this.vtemp3);
                        }
                        if (scale_b) {
                            VectorUtils.prod(sb, this.vtemp3, this.vtemp3);
                        }
                    }
                    VectorUtils.linearDiff(this.vtemp3, this.vtemp2, this.vtemp1);
                    r_curr_norm = Math.sqrt(VectorUtils.dotProd(this.vtemp1, this.vtemp1));
                    if (!(r_curr_norm <= delta)) continue;
                    converged = true;
                    break;
                }
                if (converged) break;
                rho[1] = VectorUtils.dotProd(this.r_star, this.r[1]);
                double beta = rho[1] / rho[0];
                VectorUtils.linearSum(beta, this.q, this.r[1], this.u);
                VectorUtils.linearSum(beta, this.q, beta * beta, this.p, this.p);
                VectorUtils.linearSum(this.u, this.p, this.p);
                if (scale_x) {
                    VectorUtils.divide(this.p, sx, this.vtemp1);
                } else {
                    VectorUtils.copy(this.p, this.vtemp1);
                }
                if (preOnRight) {
                    VectorUtils.copy(this.vtemp1, this.v);
                    ier = this.pSolve(this.v, this.vtemp1, 2);
                    ++this.s_nps;
                    if (ier != 0) {
                        return ier < 0 ? -3 : 3;
                    }
                }
                if ((ier = this.atimes(this.vtemp1, this.v)) != 0) {
                    return ier < 0 ? -2 : 4;
                }
                if (preOnLeft) {
                    ier = this.pSolve(this.v, this.vtemp1, 1);
                    ++this.s_nps;
                    if (ier != 0) {
                        return ier < 0 ? -3 : 3;
                    }
                } else {
                    VectorUtils.copy(this.v, this.vtemp1);
                }
                if (scale_b) {
                    VectorUtils.prod(sb, this.vtemp1, this.v);
                } else {
                    VectorUtils.copy(this.vtemp1, this.v);
                }
                VectorUtils.copy(this.r[1], this.r[0]);
                rho[0] = rho[1];
            }
            if (converged || r_curr_norm < r_init_norm) {
                if (scale_x) {
                    VectorUtils.divide(x, sx, x);
                }
                if (preOnRight) {
                    ier = this.pSolve(x, this.vtemp1, 2);
                    ++this.s_nps;
                    if (ier != 0) {
                        return ier < 0 ? -3 : 3;
                    }
                    VectorUtils.copy(this.vtemp1, x);
                }
                if (converged) {
                    return 0;
                }
                return 1;
            }
            return 2;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
            return 2;
        }
    }
}

