/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.jvode.IterativeSolver;
import biouml.plugins.simulation.ode.jvode.IterativeUtils;
import biouml.plugins.simulation.ode.jvode.JVodeSupport;
import biouml.plugins.simulation.ode.jvode.VectorUtils;
import java.util.Arrays;
import java.util.logging.Level;

public class JVodeSpgmr
extends IterativeSolver {
    public static final int SPGMR_SUCCESS = 0;
    public static final int SPGMR_RES_REDUCED = 1;
    public static final int SPGMR_CONV_FAIL = 2;
    public static final int SPGMR_QRFACT_FAIL = 3;
    public static final int SPGMR_PSOLVE_FAIL_REC = 4;
    public static final int SPGMR_ATIMES_FAIL_REC = 5;
    public static final int SPGMR_PSET_FAIL_REC = 6;
    public static final int SPGMR_MEM_NULL = -1;
    public static final int SPGMR_ATIMES_FAIL_UNREC = -2;
    public static final int SPGMR_PSOLVE_FAIL_UNREC = -3;
    public static final int SPGMR_GS_FAIL = -4;
    public static final int SPGMR_QRSOL_FAIL = -5;
    public static final int SPGMR_PSET_FAIL_UNREC = -6;
    int l_max;
    double[][] V;
    double[][] Hes;
    double[] givens;
    double[] xcor;
    double[] yg;
    double[] vtemp;

    public JVodeSpgmr(JVodeSupport.Method method, OdeModel f, double[] u0, double t0, int pretype, int maxl) throws Exception {
        super(method, f, u0, t0);
        this.s_maxl = maxl <= 0 ? 5 : maxl;
        this.l_max = this.s_maxl;
        this.V = new double[this.l_max + 1][this.n];
        this.Hes = new double[this.l_max + 1][this.l_max];
        this.givens = new double[2 * this.l_max];
        this.xcor = new double[this.n];
        this.yg = new double[this.l_max + 1];
        this.vtemp = new double[this.n];
        this.s_type = 1;
        this.s_pretype = pretype;
        this.s_gstype = 1;
        this.s_eplifac = 0.05;
        this.lastFlag = 0;
        this.setupNonNull = false;
        if (pretype != 0 && pretype != 1 && pretype != 2 && pretype != 3) {
            throw new Exception("Illegal value for pretype. Legal values are PREC_NONE, PREC_LEFT, PREC_RIGHT, and PREC_BOTH.");
        }
        this.s_ytemp = new double[this.n];
        this.s_x = new double[this.n];
        Arrays.fill(this.s_ytemp, 1.0);
        this.s_sqrtN = Math.sqrt(VectorUtils.dotProd(this.s_ytemp, this.s_ytemp));
    }

    @Override
    public int init() {
        this.s_nstlpre = 0;
        this.s_ncfl = 0;
        this.s_nps = 0;
        this.s_nli = 0;
        this.s_npe = 0;
        this.s_nfes = 0;
        this.s_njtimes = 0;
        if (this.s_pretype != 0 && this.precondition == null) {
            return -1;
        }
        this.setupNonNull = this.s_pretype != 0 && this.precondition != null;
        this.lastFlag = 0;
        return 0;
    }

    @Override
    public int setup(int convfail) {
        boolean jbad;
        double dgamma = Math.abs(this.gamma / this.gammaPrev - 1.0);
        this.currentJacobian = jbad = this.nSteps == 0 || this.nSteps > this.s_nstlpre + 50 || convfail == 1 && dgamma < 0.2 || convfail == 2;
        boolean jok = !jbad;
        int retval = this.precondition.setup(this.tn, this.z[0], this.ftemp, jok, this.gamma);
        if (retval < 0) {
            this.lastFlag = -6;
        }
        if (retval > 0) {
            this.lastFlag = 6;
        }
        this.currentJacobian = jbad;
        if (this.currentJacobian) {
            ++this.s_npe;
            this.s_nstlpre = this.nSteps;
        }
        this.lastFlag = 0;
        return retval;
    }

    @Override
    public int solve(double[] b) {
        this.s_deltar = this.s_eplifac * this.tq[4];
        double bnorm = VectorUtils.wrmsNorm(b, this.errorWeight);
        if (bnorm <= this.s_deltar) {
            if (this.mNewt > 0) {
                Arrays.fill(b, 0.0);
            }
            return 0;
        }
        this.s_ycur = this.y;
        this.s_fcur = this.ftemp;
        this.s_delta = this.s_deltar * this.s_sqrtN;
        Arrays.fill(this.s_x, 0.0);
        int retval = this.SpgmrSolve(b, 0, this.errorWeight, this.errorWeight);
        VectorUtils.copy(this.s_x, b);
        if (retval != 0) {
            ++this.s_ncfl;
        }
        this.lastFlag = retval;
        switch (retval) {
            case 0: {
                return 0;
            }
            case 1: {
                if (this.mNewt == 0) {
                    return 0;
                }
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 1;
            }
            case -1: {
                return -1;
            }
            case -2: {
                return -1;
            }
            case -3: {
                return -1;
            }
            case -5: 
            case -4: {
                return -1;
            }
        }
        return 0;
    }

    public int SpgmrSolve(double[] b, int max_restarts, double[] s1, double[] s2) {
        try {
            double beta;
            int ier;
            boolean scale2;
            int l_plus_1 = 0;
            int krydim = 0;
            boolean converged = false;
            if (max_restarts < 0) {
                max_restarts = 0;
            }
            if (this.s_pretype != 1 && this.s_pretype != 2 && this.s_pretype != 3) {
                this.s_pretype = 0;
            }
            boolean preOnLeft = this.s_pretype == 1 || this.s_pretype == 3;
            boolean preOnRight = this.s_pretype == 2 || this.s_pretype == 3;
            boolean scale1 = s1 != null;
            boolean bl = scale2 = s2 != null;
            if (VectorUtils.dotProd(this.s_x, this.s_x) == 0.0) {
                VectorUtils.copy(b, this.vtemp);
            } else {
                ier = this.atimes(this.s_x, this.vtemp);
                if (ier != 0) {
                    return ier < 0 ? -2 : 5;
                }
                VectorUtils.linearDiff(b, this.vtemp, this.vtemp);
            }
            VectorUtils.copy(this.vtemp, this.V[0]);
            if (preOnLeft) {
                ier = this.pSolve(this.V[0], this.vtemp, 1);
                ++this.s_nps;
                if (ier != 0) {
                    return ier < 0 ? -3 : 4;
                }
            } else {
                VectorUtils.copy(this.V[0], this.vtemp);
            }
            if (scale1) {
                VectorUtils.prod(s1, this.vtemp, this.V[0]);
            } else {
                VectorUtils.copy(this.vtemp, this.V[0]);
            }
            double r_norm = beta = Math.sqrt(VectorUtils.dotProd(this.V[0], this.V[0]));
            if (r_norm <= this.s_delta) {
                return 0;
            }
            double rho = beta;
            Arrays.fill(this.xcor, 0.0);
            for (int ntries = 0; ntries <= max_restarts; ++ntries) {
                int k;
                int i;
                for (i = 0; i <= this.l_max; ++i) {
                    for (int j = 0; j < this.l_max; ++j) {
                        this.Hes[i][j] = 0.0;
                    }
                }
                double rotation_product = 1.0;
                VectorUtils.scale(1.0 / r_norm, this.V[0]);
                for (int l = 0; l < this.l_max; ++l) {
                    ++this.s_nli;
                    krydim = l_plus_1 = l + 1;
                    if (scale2) {
                        VectorUtils.divide(this.V[l], s2, this.vtemp);
                    } else {
                        VectorUtils.copy(this.V[l], this.vtemp);
                    }
                    if (preOnRight) {
                        VectorUtils.copy(this.vtemp, this.V[l_plus_1]);
                        ier = this.pSolve(this.V[l_plus_1], this.vtemp, 2);
                        ++this.s_nps;
                        if (ier != 0) {
                            return ier < 0 ? -3 : 4;
                        }
                    }
                    if ((ier = this.atimes(this.vtemp, this.V[l_plus_1])) != 0) {
                        return ier < 0 ? -2 : 5;
                    }
                    if (preOnLeft) {
                        ier = this.pSolve(this.V[l_plus_1], this.vtemp, 1);
                        ++this.s_nps;
                        if (ier != 0) {
                            return ier < 0 ? -3 : 4;
                        }
                    } else {
                        VectorUtils.copy(this.V[l_plus_1], this.vtemp);
                    }
                    if (scale1) {
                        VectorUtils.prod(s1, this.vtemp, this.V[l_plus_1]);
                    } else {
                        VectorUtils.copy(this.vtemp, this.V[l_plus_1]);
                    }
                    this.Hes[l_plus_1][l] = this.s_gstype == 2 ? IterativeUtils.ClassicalGS(this.V, this.Hes, l_plus_1, this.l_max, this.vtemp, this.yg) : IterativeUtils.ModifiedGS(this.V, this.Hes, l_plus_1, this.l_max);
                    if (IterativeUtils.QRfact(krydim, this.Hes, this.givens, l) != 0) {
                        return 3;
                    }
                    rho = Math.abs((rotation_product *= this.givens[2 * l + 1]) * r_norm);
                    if (rho <= this.s_delta) {
                        converged = true;
                        break;
                    }
                    VectorUtils.scale(1.0 / this.Hes[l_plus_1][l], this.V[l_plus_1]);
                }
                this.yg[0] = r_norm;
                for (i = 1; i <= krydim; ++i) {
                    this.yg[i] = 0.0;
                }
                if (IterativeUtils.QRsol(krydim, this.Hes, this.givens, this.yg) != 0) {
                    return -5;
                }
                for (k = 0; k < krydim; ++k) {
                    VectorUtils.linearSum(this.yg[k], this.V[k], this.xcor);
                }
                if (converged) {
                    if (scale2) {
                        VectorUtils.divide(this.xcor, s2, this.xcor);
                    }
                    if (preOnRight) {
                        ier = this.pSolve(this.xcor, this.vtemp, 2);
                        ++this.s_nps;
                        if (ier != 0) {
                            return ier < 0 ? -3 : 4;
                        }
                    } else {
                        VectorUtils.copy(this.xcor, this.vtemp);
                    }
                    VectorUtils.linearSum(this.s_x, this.vtemp, this.s_x);
                    return 0;
                }
                if (ntries == max_restarts) break;
                double s_product = 1.0;
                for (i = krydim; i > 0; --i) {
                    this.yg[i] = s_product * this.givens[2 * i - 2];
                    s_product *= this.givens[2 * i - 1];
                }
                this.yg[0] = s_product;
                r_norm *= s_product;
                i = 0;
                while (i <= krydim) {
                    int n = i++;
                    this.yg[n] = this.yg[n] * r_norm;
                }
                r_norm = Math.abs(r_norm);
                VectorUtils.scale(this.yg[0], this.V[0]);
                for (k = 1; k <= krydim; ++k) {
                    VectorUtils.linearSum(this.yg[k], this.V[k], this.V[0]);
                }
            }
            if (rho < beta) {
                if (scale2) {
                    VectorUtils.divide(this.xcor, s2, this.xcor);
                }
                if (preOnRight) {
                    ier = this.pSolve(this.xcor, this.vtemp, 2);
                    ++this.s_nps;
                    if (ier != 0) {
                        return ier < 0 ? -3 : 4;
                    }
                } else {
                    VectorUtils.copy(this.xcor, this.vtemp);
                }
                VectorUtils.linearSum(this.s_x, this.vtemp, this.s_x);
                return 1;
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
            return 2;
        }
        return 2;
    }
}

