/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.jvode.IterativeSolver;
import biouml.plugins.simulation.ode.jvode.JVodeSupport;
import biouml.plugins.simulation.ode.jvode.VectorUtils;
import java.util.Arrays;
import java.util.logging.Level;

public class JVodeSpbgs
extends IterativeSolver {
    public static final int SPBCG_SUCCESS = 0;
    public static final int SPBCG_RES_REDUCED = 1;
    public static final int SPBCG_CONV_FAIL = 2;
    public static final int SPBCG_PSOLVE_FAIL_REC = 3;
    public static final int SPBCG_ATIMES_FAIL_REC = 4;
    public static final int SPBCG_PSET_FAIL_REC = 5;
    public static final int SPBCG_MEM_NULL = -1;
    public static final int SPBCG_ATIMES_FAIL_UNREC = -2;
    public static final int SPBCG_PSOLVE_FAIL_UNREC = -3;
    public static final int SPBCG_PSET_FAIL_UNREC = -4;
    public int l_max;
    double[] r_star;
    double[] r;
    double[] p;
    double[] q;
    double[] u;
    double[] Ap;
    double[] vtemp;

    public JVodeSpbgs(JVodeSupport.Method method, OdeModel f, double[] u0, double t0, int pretype, int maxl) throws Exception {
        super(method, f, u0, t0);
        this.s_type = 2;
        this.s_pretype = pretype;
        this.s_maxl = maxl <= 0 ? 5 : maxl;
        this.l_max = this.s_maxl;
        this.s_eplifac = 0.05;
        this.lastFlag = 0;
        this.setupNonNull = false;
        if (pretype != 0 && pretype != 1 && pretype != 2 && pretype != 3) {
            throw new Exception("Illegal value for pretype. Legal values are PREC_NONE, PREC_LEFT, PREC_RIGHT, and PREC_BOTH.");
        }
        this.s_ytemp = new double[this.n];
        this.s_x = new double[this.n];
        Arrays.fill(this.s_ytemp, 1.0);
        this.s_sqrtN = Math.sqrt(VectorUtils.dotProd(this.s_ytemp, this.s_ytemp));
        this.r_star = new double[this.n];
        this.r = new double[this.n];
        this.p = new double[this.n];
        this.q = new double[this.n];
        this.u = new double[this.n];
        this.Ap = new double[this.n];
        this.vtemp = new double[this.n];
    }

    @Override
    public int init() {
        this.s_nstlpre = 0;
        this.s_ncfl = 0;
        this.s_nps = 0;
        this.s_nli = 0;
        this.s_npe = 0;
        this.s_nfes = 0;
        this.s_njtimes = 0;
        if (this.s_pretype != 0 && this.precondition == null) {
            throw new IllegalArgumentException("pretype != PREC_NONE, but PSOLVE = NULL is illegal.");
        }
        this.setupNonNull = this.s_pretype != 0 && this.precondition != null;
        this.l_max = this.s_maxl;
        this.lastFlag = 0;
        return 0;
    }

    @Override
    public int setup(int convfail) {
        boolean jbad;
        double dgamma = Math.abs(this.gamma / this.gammaPrev - 1.0);
        this.currentJacobian = jbad = this.nSteps == 0 || this.nSteps > this.s_nstlpre + 50 || convfail == 1 && dgamma < 0.2 || convfail == 2;
        boolean jok = !jbad;
        int retval = this.precondition.setup(this.tn, this.z[0], this.ftemp, jok, this.gamma);
        if (retval < 0) {
            this.lastFlag = -4;
        }
        if (retval > 0) {
            this.lastFlag = 5;
        }
        this.currentJacobian = jbad;
        if (this.currentJacobian) {
            ++this.s_npe;
            this.s_nstlpre = this.nSteps;
        }
        this.lastFlag = 0;
        return retval;
    }

    @Override
    public int solve(double[] b) {
        this.s_deltar = this.s_eplifac * this.tq[4];
        double bnorm = VectorUtils.wrmsNorm(b, this.errorWeight);
        if (bnorm <= this.s_deltar) {
            if (this.mNewt > 0) {
                Arrays.fill(b, 0.0);
            }
            return 0;
        }
        this.s_ycur = this.y;
        this.s_fcur = this.ftemp;
        this.s_delta = this.s_deltar * this.s_sqrtN;
        Arrays.fill(this.s_x, 0.0);
        int retval = this.SpbcgSolve(this.s_x, b, this.s_pretype, this.s_delta, this.errorWeight, this.errorWeight);
        VectorUtils.copy(this.s_x, b);
        if (retval != 0) {
            ++this.s_ncfl;
        }
        this.lastFlag = retval;
        switch (retval) {
            case 0: {
                return 0;
            }
            case 1: {
                if (this.mNewt == 0) {
                    return 0;
                }
                return 1;
            }
            case 2: 
            case 3: 
            case 4: {
                return 1;
            }
            case -1: {
                return -1;
            }
            case -2: {
                return -1;
            }
            case -3: {
                return -1;
            }
        }
        return 0;
    }

    public int SpbcgSolve(double[] x, double[] b, int pretype, double delta, double[] sx, double[] sb) {
        try {
            double rho;
            int ier;
            boolean scale_b;
            boolean converged = false;
            if (pretype != 1 && pretype != 2 && pretype != 3) {
                pretype = 0;
            }
            boolean preOnLeft = pretype == 3 || pretype == 1;
            boolean preOnRight = pretype == 3 || pretype == 2;
            boolean scale_x = sx != null;
            boolean bl = scale_b = sb != null;
            if (VectorUtils.dotProd(x, x) == 0.0) {
                VectorUtils.copy(b, this.r_star);
            } else {
                ier = this.atimes(x, this.r_star);
                if (ier != 0) {
                    return ier < 0 ? -2 : 4;
                }
                VectorUtils.linearDiff(b, this.r_star, this.r_star);
            }
            if (preOnLeft) {
                ier = this.pSolve(this.r_star, this.r, 1);
                ++this.s_nps;
                if (ier != 0) {
                    return ier < 0 ? -3 : 3;
                }
            } else {
                VectorUtils.copy(this.r_star, this.r);
            }
            if (scale_b) {
                VectorUtils.prod(sb, this.r, this.r_star);
            } else {
                VectorUtils.copy(this.r, this.r_star);
            }
            double beta_denom = VectorUtils.dotProd(this.r_star, this.r_star);
            double r_norm = rho = Math.sqrt(beta_denom);
            if (r_norm <= delta) {
                return 0;
            }
            VectorUtils.copy(this.r_star, this.r);
            VectorUtils.copy(this.r_star, this.p);
            for (int l = 0; l < this.l_max; ++l) {
                ++this.s_nli;
                if (scale_x) {
                    VectorUtils.divide(this.p, sx, this.vtemp);
                } else {
                    VectorUtils.copy(this.p, this.vtemp);
                }
                if (preOnRight) {
                    VectorUtils.copy(this.vtemp, this.Ap);
                    ier = this.pSolve(this.Ap, this.vtemp, 2);
                    ++this.s_nps;
                    if (ier != 0) {
                        return ier < 0 ? -3 : 3;
                    }
                }
                if ((ier = this.atimes(this.vtemp, this.Ap)) != 0) {
                    return ier < 0 ? -2 : 4;
                }
                if (preOnLeft) {
                    ier = this.pSolve(this.Ap, this.vtemp, 1);
                    ++this.s_nps;
                    if (ier != 0) {
                        return ier < 0 ? -3 : 3;
                    }
                } else {
                    VectorUtils.copy(this.Ap, this.vtemp);
                }
                if (scale_b) {
                    VectorUtils.prod(sb, this.vtemp, this.Ap);
                } else {
                    VectorUtils.copy(this.vtemp, this.Ap);
                }
                double alpha = VectorUtils.dotProd(this.r, this.r_star) / VectorUtils.dotProd(this.Ap, this.r_star);
                VectorUtils.linearSum(-alpha, this.Ap, this.r, this.q);
                if (scale_x) {
                    VectorUtils.divide(this.q, sx, this.vtemp);
                } else {
                    VectorUtils.copy(this.q, this.vtemp);
                }
                if (preOnRight) {
                    VectorUtils.copy(this.vtemp, this.u);
                    ier = this.pSolve(this.u, this.vtemp, 2);
                    ++this.s_nps;
                    if (ier != 0) {
                        return ier < 0 ? -3 : 3;
                    }
                }
                if ((ier = this.atimes(this.vtemp, this.u)) != 0) {
                    return ier < 0 ? -2 : 4;
                }
                if (preOnLeft) {
                    ier = this.pSolve(this.u, this.vtemp, 1);
                    ++this.s_nps;
                    if (ier != 0) {
                        return ier < 0 ? -3 : 3;
                    }
                } else {
                    VectorUtils.copy(this.u, this.vtemp);
                }
                if (scale_b) {
                    VectorUtils.prod(sb, this.vtemp, this.u);
                } else {
                    VectorUtils.copy(this.vtemp, this.u);
                }
                double omega_denom = VectorUtils.dotProd(this.u, this.u);
                if (omega_denom == 0.0) {
                    omega_denom = 1.0;
                }
                double omega = VectorUtils.dotProd(this.u, this.q) / omega_denom;
                VectorUtils.linearSum(alpha, this.p, omega, this.q, this.vtemp);
                VectorUtils.linearSum(x, this.vtemp, x);
                VectorUtils.linearSum(-omega, this.u, this.q, this.r);
                rho = Math.sqrt(VectorUtils.dotProd(this.r, this.r));
                if (rho <= delta) {
                    converged = true;
                    break;
                }
                double beta_num = VectorUtils.dotProd(this.r, this.r_star);
                double beta = beta_num / beta_denom * (alpha / omega);
                beta_denom = beta_num;
                VectorUtils.linearSum(-omega, this.Ap, this.p, this.vtemp);
                VectorUtils.linearSum(beta, this.vtemp, this.r, this.p);
            }
            if (converged || rho < r_norm) {
                if (scale_x) {
                    VectorUtils.divide(x, sx, x);
                }
                if (preOnRight) {
                    ier = this.pSolve(x, this.vtemp, 2);
                    ++this.s_nps;
                    if (ier != 0) {
                        return ier < 0 ? -3 : 3;
                    }
                    VectorUtils.copy(this.vtemp, x);
                }
                if (converged) {
                    return 0;
                }
                return 1;
            }
            return 2;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
            return 2;
        }
    }
}

