/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.SimulatorInfo;
import biouml.plugins.simulation.SimulatorSupport;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.jvode.JVode;
import biouml.plugins.simulation.ode.jvode.JVodeOptions;
import biouml.standard.simulation.ResultListener;
import ru.biosoft.jobcontrol.FunctionJobControl;

public class JVodeSolver
extends SimulatorSupport {
    private int nextIndex;
    private JVode jvode;
    JVodeOptions options = this.getDefaultOptions();

    @Override
    public void stop() {
        super.stop();
        if (this.jvode != null) {
            this.jvode.stop();
        }
    }

    @Override
    public SimulatorInfo getInfo() {
        SimulatorInfo info = new SimulatorInfo();
        info.name = "JVode";
        info.eventsSupport = true;
        return info;
    }

    public JVodeOptions getDefaultOptions() {
        return new JVodeOptions();
    }

    @Override
    public JVodeOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Options options) {
        this.options = (JVodeOptions)options;
    }

    @Override
    public int[] getEvents() {
        return this.jvode.getEventInfo();
    }

    @Override
    public void init(Model model, double[] u0, Span tspan, ResultListener[] listeners, FunctionJobControl jobControl) throws Exception {
        if (!(model instanceof OdeModel)) {
            throw new Exception("JVode solver can be used only for OdeModels");
        }
        this.span = tspan;
        this.nextIndex = 1;
        this.resultListeners = listeners;
        this.odeModel = (OdeModel)model;
        if (this.odeModel.hasFastOde() && this.preprocessFastReactions) {
            u0 = this.preprocessFastReactions();
        }
        this.profile.init(u0, this.span.getTimeStart());
        this.jvode = JVode.createJVode(this.options, tspan.getTimeStart(), u0, this.odeModel);
        this.jvode.setMaxSteps(this.options.getStepsLimit());
        this.jvode.setTolerances(this.options.getRtol(), this.options.getAtol());
        this.jvode.setHMin(this.options.getHMin());
        this.jvode.setHMaxInv(this.options.getHMaxInv());
        this.jvode.setDetectIncorrectNumbers(this.options.isDetectIncorrectNumbers());
    }

    @Override
    public boolean doStep() {
        try {
            if (this.fireInitialValues || this.eventAtSpanPoint) {
                this.fireSolutionUpdate(this.span.getTime(this.nextIndex - 1), this.jvode.getY());
            }
            this.fireInitialValues = false;
            double nextTime = this.span.getTime(this.nextIndex);
            int flag = !this.terminated ? this.jvode.start(nextTime) : -13;
            this.profile.setX(this.jvode.getY());
            this.profile.setTime(this.jvode.getTime());
            if (flag == 2) {
                this.eventAtSpanPoint = Math.abs(this.jvode.getTime() - nextTime) < 1.0E-8;
                return false;
            }
            if (flag == 0 || flag == 1) {
                this.profile.setTime(nextTime);
                this.eventAtSpanPoint = false;
                this.fireSolutionUpdate(nextTime, this.jvode.getY());
                ++this.nextIndex;
                return this.nextIndex < this.span.getLength();
            }
            if (flag == -13) {
                return false;
            }
            if (flag == -4 || flag == -3) {
                throw new Exception("Unrecoverable convergence error");
            }
            if (flag == -2) {
                throw new Exception("Too much accuracy requested");
            }
            if (flag == -1) {
                throw new Exception("Steps limit (" + this.jvode.maxSteps + ") exceeded");
            }
            if (flag == -7) {
                throw new Exception("ODE Right hand side function failed");
            }
            if (flag == -14) {
                throw new Exception("Incorrect calculations were made in the model.");
            }
            throw new Exception("Unknown error");
        }
        catch (Exception ex) {
            if (this.jobControl != null) {
                this.jobControl.terminate();
            }
            this.profile.setErrorMessage(ex.getLocalizedMessage());
            this.profile.setUnstable(true);
            this.profile.setX(this.jvode.getY());
            log.info(ex.getMessage());
            return false;
        }
    }

    @Override
    public void setInitialValues(double[] x0) throws Exception {
        this.odeModel.setCurrentValues(x0);
        this.jvode.setInitialValues(this.odeModel.getY(), this.odeModel.getTime());
        this.jvode.reset();
    }
}

