/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.OdeSimulatorOptions;
import biouml.plugins.simulation.ode.jvode.JVodeSupport;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;

public class JVodeOptions
extends OdeSimulatorOptions {
    public static final double ATOL_DEFAULT = 1.0E-20;
    public static final double RTOL_DEFAULT = 1.0E-12;
    private JVodeSupport.Method method;
    private JVodeSupport.IterationType iterationsMethod;
    private JVodeSupport.JacobianType jacobianApproximation;
    private int mu;
    private int ml;
    private int stepsLimit;
    private double hMin;
    private double hMaxInv;

    public JVodeOptions(JVodeSupport.Method method, JVodeSupport.IterationType iterationType, JVodeSupport.JacobianType jacobianType) {
        this.method = method;
        this.iterationsMethod = iterationType;
        this.jacobianApproximation = jacobianType;
        this.mu = 0;
        this.ml = 0;
        this.stepsLimit = 100000;
        this.hMin = 1.0E-100;
        this.hMaxInv = 1.0E-100;
        this.setAtol(1.0E-20);
        this.setRtol(1.0E-12);
    }

    public JVodeOptions() {
        this(JVodeSupport.Method.BDF, JVodeSupport.IterationType.NEWTON, JVodeSupport.JacobianType.DENSE);
    }

    @PropertyName(value="Steps limit")
    @PropertyDescription(value="Limitation for solver steps count")
    public int getStepsLimit() {
        return this.stepsLimit;
    }

    public void setStepsLimit(int limit) {
        int oldValue = this.stepsLimit;
        this.stepsLimit = limit;
        this.firePropertyChange("stepsLimit", oldValue, limit);
    }

    @PropertyName(value="Minimum time step")
    @PropertyDescription(value="Minimum time step.")
    public double getHMin() {
        return this.hMin;
    }

    public void setHMin(double min) {
        double oldValue = this.hMin;
        this.hMin = min;
        this.firePropertyChange("hMin", oldValue, min);
    }

    @PropertyName(value="Maximum time step inverted")
    @PropertyDescription(value="1 / maximum time step.")
    public double getHMaxInv() {
        return this.hMaxInv;
    }

    public void setHMaxInv(double max) {
        double oldValue = this.hMaxInv;
        this.hMaxInv = max;
        this.firePropertyChange("hMaxInv", oldValue, max);
    }

    public void setMu(int mu) {
        int oldValue = this.mu;
        this.mu = mu;
        this.firePropertyChange("mu", oldValue, mu);
    }

    @PropertyName(value="Mu")
    @PropertyDescription(value="Upper bandwidth of Banded Jacobian")
    public int getMu() {
        return this.mu;
    }

    @PropertyName(value="Ml")
    @PropertyDescription(value="Lower bandwidth of Banded Jacobian")
    public int getMl() {
        return this.ml;
    }

    public void setMl(int ml) {
        int oldValue = this.ml;
        this.ml = ml;
        this.firePropertyChange("ml", oldValue, ml);
    }

    @PropertyName(value="Integration method")
    @PropertyDescription(value="Integration method (ADAMS or BDF)")
    public int getMethod() {
        return this.method == null ? 0 : this.method.ordinal();
    }

    public void setMethod(int m) {
        int oldValue = this.getMethod();
        try {
            this.method = JVodeSupport.Method.values()[m];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Can not set method type = " + m + " only values from range (0-" + (JVodeSupport.Method.values().length - 1) + ") can be set");
        }
        this.firePropertyChange("method", oldValue, m);
    }

    public JVodeSupport.Method getMethodType() {
        return this.method;
    }

    @PropertyName(value="Inner linear solver type")
    @PropertyDescription(value="Inner linear solver type")
    public int getIterations() {
        return this.iterationsMethod == null ? 0 : this.iterationsMethod.ordinal();
    }

    public void setIterations(JVodeSupport.IterationType iter) {
        this.iterationsMethod = iter;
    }

    public void setIterations(int iter) {
        int oldValue = this.getIterations();
        try {
            this.iterationsMethod = JVodeSupport.IterationType.values()[iter];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Can not set iteration type = " + iter + " only values from range (0-" + (JVodeSupport.IterationType.values().length - 1) + ") can be set");
        }
        this.firePropertyChange("iterations", oldValue, iter);
    }

    public JVodeSupport.IterationType getIterationType() {
        return this.iterationsMethod;
    }

    @PropertyName(value="Jacobian approximation type")
    @PropertyDescription(value="Jacobian approximation type")
    public int getJacobianApproximation() {
        return this.jacobianApproximation == null ? 0 : this.jacobianApproximation.ordinal();
    }

    public void setJacobianType(JVodeSupport.JacobianType jac) {
        this.jacobianApproximation = jac;
    }

    public void setJacobianApproximation(int jac) {
        int oldValue = this.getJacobianApproximation();
        try {
            this.jacobianApproximation = JVodeSupport.JacobianType.values()[jac];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Can not set jacobian type = " + jac + " only values from range (0-" + (JVodeSupport.JacobianType.values().length - 1) + ") can be set");
        }
        this.firePropertyChange("jacobianApproximation", oldValue, jac);
    }

    public JVodeSupport.JacobianType getJacobianType() {
        return this.jacobianApproximation;
    }

    public boolean isNotBandJacobian() {
        return this.isFunctional() || this.jacobianApproximation != JVodeSupport.JacobianType.BAND;
    }

    public boolean isFunctional() {
        return this.iterationsMethod == JVodeSupport.IterationType.FUNCTIONAL;
    }
}

