/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.jvode.DirectSolver;
import biouml.plugins.simulation.ode.jvode.JVodeSupport;
import biouml.plugins.simulation.ode.jvode.VectorUtils;

public class JVodeDiag
extends DirectSolver {
    public static final int CVDIAG_INV_FAIL = -5;
    public static final int CVDIAG_RHSFUNC_UNRECVR = -6;
    public static final int CVDIAG_RHSFUNC_RECVR = -7;
    double gammaSaved;
    double[] iM;

    protected JVodeDiag(JVodeSupport.Method method, OdeModel f, double[] u0, double t0) {
        super(method, f, u0, t0);
        this.iterationType = JVodeSupport.IterationType.NEWTON;
        this.jacobianType = JVodeSupport.JacobianType.BAND;
        this.iM = new double[this.n];
    }

    @Override
    public int init() {
        return 0;
    }

    @Override
    public int setup(int convfail) {
        int i;
        double r = 0.1 * this.rl1;
        int n = this.ftemp.length;
        for (i = 0; i < n; ++i) {
            this.acor[i] = this.h * this.ftemp[i] - this.z[1][i];
            this.y[i] = r * this.acor[i] + this.z[0][i];
        }
        try {
            ++this.nfCallsDQ;
            this.iM = this.f.dy_dt(this.tn, this.y);
        }
        catch (IllegalArgumentException ex) {
            this.lastFlag = -7;
            return 1;
        }
        catch (Exception ex) {
            JVodeDiag.processError("The right-hand side routine failed in an unrecoverable manner.");
            this.lastFlag = -6;
            return -1;
        }
        for (i = 0; i < n; ++i) {
            this.iM[i] = 0.1 * this.acor[i] - this.h * (this.iM[i] - this.ftemp[i]);
            this.y[i] = this.acor[i] * this.errorWeight[i];
            if (Math.abs(this.y[i]) >= 2.220446049250313E-16) {
                this.y[i] = this.acor[i] * 0.1;
                this.iM[i] = this.iM[i] / this.y[i];
                continue;
            }
            this.y[i] = -1.0;
            this.iM[i] = -1.0;
        }
        boolean invOK = VectorUtils.invTest(this.iM, this.iM);
        if (!invOK) {
            this.lastFlag = -5;
            return 1;
        }
        this.currentJacobian = true;
        this.gammaSaved = this.gamma;
        this.lastFlag = 0;
        return 0;
    }

    @Override
    public int solve(double[] b) {
        if (this.gammaSaved != this.gamma) {
            double r = this.gamma / this.gammaSaved;
            int n = this.iM.length;
            for (int i = 0; i < n; ++i) {
                this.iM[i] = (1.0 / this.iM[i] - 1.0) * r + 1.0;
            }
            boolean invOK = VectorUtils.invTest(this.iM, this.iM);
            if (!invOK) {
                this.lastFlag = -5;
                return 1;
            }
            this.gammaSaved = this.gamma;
        }
        VectorUtils.prod(b, this.iM, b);
        this.lastFlag = 0;
        return 0;
    }
}

