/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.jvode.DirectSolver;
import biouml.plugins.simulation.ode.jvode.JVodeSupport;
import biouml.plugins.simulation.ode.jvode.Matrix;
import biouml.plugins.simulation.ode.jvode.MatrixUtils;
import biouml.plugins.simulation.ode.jvode.VectorUtils;
import java.util.logging.Level;

public class JVodeDense
extends DirectSolver {
    private DirectSolver.DenseJacobian jacobian;

    protected JVodeDense(JVodeSupport.Method method, OdeModel f, double[] u0, double t0, DirectSolver.DenseJacobian jac) {
        super(method, f, u0, t0);
        this.iterationType = JVodeSupport.IterationType.NEWTON;
        this.jacobianType = JVodeSupport.JacobianType.DENSE;
        this.matr = new Matrix(this.n, this.n);
        this.savedJ = new Matrix(this.n, this.n);
        this.pivots = new int[this.n];
        if (jac != null) {
            this.jacobian = jac;
        }
        this.lastFlag = 0;
    }

    public void setUserJacobian(DirectSolver.DenseJacobian jacobian) {
        this.jacobian = jacobian;
    }

    @Override
    public int init() {
        return 0;
    }

    @Override
    public int setup(int convfail) {
        boolean jbad;
        double dgamma = Math.abs(this.gamma / this.gammaPrev - 1.0);
        boolean bl = jbad = this.nSteps == 0 || this.nSteps > this.nStepsAtLastJac + 50 || convfail == 1 && dgamma < 0.2 || convfail == 2;
        if (!jbad) {
            this.currentJacobian = false;
            this.savedJ.denseCopy(this.matr);
        } else {
            ++this.nJacCalls;
            this.nStepsAtLastJac = this.nSteps;
            this.currentJacobian = true;
            this.matr.setToZero();
            int retval = this.jacobian();
            if (retval < 0) {
                JVodeDense.processError("The Jacobian routine failed in an unrecoverable manner.");
                this.lastFlag = -5;
                return -1;
            }
            if (retval > 0) {
                this.lastFlag = -6;
                return 1;
            }
            this.matr.denseCopy(this.savedJ);
        }
        this.matr.scale(-this.gamma);
        this.matr.addIdentity();
        return MatrixUtils.DenseGETRF(this.matr, this.pivots) > 0 ? 1 : 0;
    }

    @Override
    public int solve(double[] b) {
        MatrixUtils.DenseGETRS(this.matr, this.pivots, b);
        if (this.method == JVodeSupport.Method.BDF && this.gammaRatio != 1.0) {
            VectorUtils.scale(2.0 / (1.0 + this.gammaRatio), b);
        }
        this.lastFlag = 0;
        return 0;
    }

    public int jacobian() {
        try {
            double fnorm = VectorUtils.wrmsNorm(this.ftemp, this.errorWeight);
            double minInc = fnorm != 0.0 ? 1000.0 * Math.abs(this.h) * 2.220446049250313E-16 * (double)this.n * fnorm : 1.0;
            for (int j = 0; j < this.n; ++j) {
                double v2;
                double[] jthCol = new double[this.n];
                double yjsaved = this.z[0][j];
                double v1 = UROUND_SQRT * Math.abs(yjsaved);
                double inc = v1 > (v2 = minInc / this.errorWeight[j]) ? v1 : v2;
                this.z[0][j] = yjsaved + inc;
                this.acor = this.f.dy_dt(this.tn, this.z[0]);
                ++this.nfCallsDQ;
                this.z[0][j] = yjsaved;
                double inc_inv = 1.0 / inc;
                VectorUtils.scaleDiff(inc_inv, this.acor, this.ftemp, jthCol);
                this.matr.cols[j] = jthCol;
            }
            return 0;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
            return -1;
        }
    }
}

