/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.jvode.DirectSolver;
import biouml.plugins.simulation.ode.jvode.JVodeSupport;
import biouml.plugins.simulation.ode.jvode.Matrix;
import biouml.plugins.simulation.ode.jvode.MatrixUtils;
import biouml.plugins.simulation.ode.jvode.VectorUtils;

public class JVodeBand
extends DirectSolver {
    private DirectSolver.BandJacobian jacobian;
    private int ml;
    private int mu;
    private int smu;

    protected JVodeBand(JVodeSupport.Method method, OdeModel f, double[] u0, double t0, int mupper, int mlower, DirectSolver.BandJacobian jac) {
        super(method, f, u0, t0);
        this.iterationType = JVodeSupport.IterationType.NEWTON;
        this.jacobianType = JVodeSupport.JacobianType.BAND;
        this.ml = mlower;
        this.mu = mupper;
        if (this.ml < 0 || this.mu < 0 || this.ml >= this.n || this.mu >= this.n) {
            throw new IllegalArgumentException("Illegal bandwidth parameter(s). Must have 0 <=  ml, mu <= N-1.");
        }
        this.smu = Math.min(this.n - 1, this.mu + this.ml);
        this.matr = new Matrix(this.n, this.mu, this.ml, this.smu);
        this.savedJ = new Matrix(this.n, this.mu, this.ml, this.mu);
        this.pivots = new int[this.n];
        this.lastFlag = 0;
        if (jac != null) {
            this.jacobian = jac;
        }
    }

    public void setUserJacobian(DirectSolver.BandJacobian jacobian) {
        this.jacobian = jacobian;
    }

    @Override
    public int init() {
        return 0;
    }

    @Override
    public int setup(int convfail) {
        boolean jbad;
        double dgamma = Math.abs(this.gamma / this.gammaPrev - 1.0);
        boolean bl = jbad = this.nSteps == 0 || this.nSteps > this.nStepsAtLastJac + 50 || convfail == 1 && dgamma < 0.2 || convfail == 2;
        if (!jbad) {
            this.currentJacobian = false;
            this.savedJ.bandCopy(this.matr, this.mu, this.ml);
        } else {
            ++this.nJacCalls;
            this.nStepsAtLastJac = this.nSteps;
            this.currentJacobian = true;
            this.matr.setToZero();
            if (this.jacobian != null) {
                this.jacobian.getValue(this.n, this.mu, this.ml, this.tn, this.z[0], this.ftemp, this.matr);
            } else {
                try {
                    this.jacobian();
                }
                catch (Exception ex) {
                    JVodeBand.processError("The Jacobian routine failed in an unrecoverable manner.");
                    this.lastFlag = -5;
                    return -1;
                }
            }
            this.matr.bandCopy(this.savedJ, this.mu, this.ml);
        }
        this.matr.scale(-this.gamma);
        this.matr.addIdentity();
        int ier = MatrixUtils.BandGBTRF(this.matr, this.pivots);
        if (ier > 0) {
            this.lastFlag = ier;
            return 1;
        }
        this.lastFlag = 0;
        return 0;
    }

    @Override
    public int solve(double[] b) {
        MatrixUtils.BandGBTRS(this.matr, this.pivots, b);
        if (this.method == JVodeSupport.Method.BDF && this.gammaRatio != 1.0) {
            VectorUtils.scale(2.0 / (1.0 + this.gammaRatio), b);
        }
        this.lastFlag = 0;
        return 0;
    }

    public void jacobian() throws Exception {
        VectorUtils.copy(this.z[0], this.y);
        double fnorm = VectorUtils.wrmsNorm(this.ftemp, this.errorWeight);
        double minInc = fnorm != 0.0 ? 1000.0 * Math.abs(this.h) * 2.220446049250313E-16 * (double)this.n * fnorm : 1.0;
        int width = this.ml + this.mu + 1;
        int ngroups = Math.min(width, this.n);
        for (int group = 1; group <= ngroups; ++group) {
            int j;
            for (j = group - 1; j < this.n; j += width) {
                int n = j;
                this.y[n] = this.y[n] + Math.max(UROUND_SQRT * Math.abs(this.z[0][j]), minInc / this.errorWeight[j]);
            }
            ++this.nfCallsDQ;
            this.acor = this.f.dy_dt(this.tn, this.y);
            for (j = group - 1; j < this.n; j += width) {
                this.y[j] = this.z[0][j];
                double incInv = 1.0 / Math.max(UROUND_SQRT * Math.abs(this.z[0][j]), minInc / this.errorWeight[j]);
                int i1 = Math.max(0, j - this.mu);
                int i2 = Math.min(j + this.ml, this.n - 1);
                for (int i = i1; i <= i2; ++i) {
                    this.matr.setBandElement(i, j, incInv * (this.acor[i] - this.ftemp[i]));
                }
            }
        }
    }
}

