/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.SimulatorSupport;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.jvode.JVodeBand;
import biouml.plugins.simulation.ode.jvode.JVodeDense;
import biouml.plugins.simulation.ode.jvode.JVodeDiag;
import biouml.plugins.simulation.ode.jvode.JVodeOptions;
import biouml.plugins.simulation.ode.jvode.JVodeSupport;
import biouml.plugins.simulation.ode.jvode.Util;
import biouml.plugins.simulation.ode.jvode.VectorUtils;
import java.util.Arrays;
import java.util.logging.Logger;

public class JVode
extends JVodeSupport {
    protected static final Logger log = Logger.getLogger(SimulatorSupport.class.getName());
    protected boolean isRunning = true;
    private boolean detectIncorrectNumbers = false;
    private static final double TINY = 1.0E-10;
    public static final int SUCCESS = 0;
    protected static final int TSTOP_RETURN = 1;
    public static final int ROOT_RETURN = 2;
    protected static final int TOO_MUCH_WORK = -1;
    protected static final int TOO_MUCH_ACC = -2;
    protected static final int ERR_FAILURE = -3;
    protected static final int CONV_FAILURE = -4;
    protected static final int LSETUP_FAIL = -5;
    protected static final int LSOLVE_FAIL = -6;
    protected static final int RHSFUNC_FAIL = -7;
    protected static final int REPTD_RHSFUNC_ERR = -8;
    protected static final int UNREC_RHSFUNC_ERR = -9;
    protected static final int ILL_INPUT = -11;
    protected static final int TOO_CLOSE = -12;
    public static final int TERMINATED = -13;
    protected static final int INCORRECT_CALCULATIONS = -14;
    protected static final int NO_FAILURES = 0;
    protected static final int FAIL_BAD_J = 1;
    protected static final int FAIL_OTHER = 2;
    private static final int DO_ERROR_TEST = 2;
    private static final int PREDICT_AGAIN = 3;
    private static final int CONV_FAIL = 4;
    private static final int TRY_AGAIN = 5;
    private static final int FIRST_CALL = 6;
    private static final int PREV_CONV_FAIL = 7;
    private static final int PREV_ERR_FAIL = 8;
    private static final int RHSFUNC_RECVR = 9;
    private static final double FUZZ_FACTOR = 100.0;
    private static final double HLB_FACTOR = 100.0;
    private static final double HUB_FACTOR = 0.1;
    private static final double H_BIAS = 0.5;
    private static final int MAX_ITERS = 4;
    private static final double THRESH = 1.5;
    private static final double ETAMX2 = 10.0;
    private static final double ETAMX3 = 10.0;
    private static final double ETAMXF = 0.2;
    private static final double ETAMIN = 0.1;
    private static final double ETACF = 0.25;
    private static final double ADDON = 1.0E-6;
    private static final double BIAS1 = 6.0;
    private static final double BIAS2 = 6.0;
    private static final double BIAS3 = 10.0;
    private static final double ONEPSM = 1.000001;
    private static final int SMALL_NST = 10;
    private static final int MXNEF1 = 3;
    private static final int SMALL_NEF = 2;
    private static final int LONG_WAIT = 10;
    private static final double CRDOWN = 0.3;
    private static final double DGMAX = 0.3;
    private static final double RDIV = 2.0;
    private static final int MSBP = 20;

    protected JVode(JVodeSupport.Method method, OdeModel f, double[] u0, double t0) {
        super(method, f, u0, t0);
        this.iterationType = JVodeSupport.IterationType.FUNCTIONAL;
    }

    public static JVode createJVode(JVodeOptions options, double initialTime, double[] initialValue, OdeModel odeModel) {
        JVodeSupport.Method method = options.getMethodType();
        JVodeSupport.IterationType iterType = options.getIterationType();
        JVodeSupport.JacobianType jacType = options.getJacobianType();
        if (iterType == JVodeSupport.IterationType.FUNCTIONAL) {
            return new JVode(method, odeModel, initialValue, initialTime);
        }
        if (iterType == JVodeSupport.IterationType.NEWTON) {
            switch (jacType) {
                case DENSE: {
                    return new JVodeDense(method, odeModel, initialValue, initialTime, null);
                }
                case BAND: {
                    return new JVodeBand(method, odeModel, initialValue, initialTime, options.getMu(), options.getMl(), null);
                }
                case DIAG: {
                    return new JVodeDiag(method, odeModel, initialValue, initialTime);
                }
            }
            throw new IllegalArgumentException("Unknown JVODE jacobian type!");
        }
        throw new IllegalArgumentException("Unknown JVODE integration method!");
    }

    public void reset() {
        this.nSteps = 0;
    }

    public void stop() {
        this.isRunning = false;
    }

    private int start(double tout, boolean oneStepMode) throws Exception {
        int state;
        block43: {
            if (tout == this.tn) {
                return 0;
            }
            if (this.y == null) {
                throw new Exception("initial value is null.");
            }
            if (!oneStepMode) {
                this.toutCopy = tout;
            }
            state = 0;
            if (this.nSteps == 0) {
                this.z = new double[13][this.y.length];
                VectorUtils.copy(this.y, this.z[0]);
                this.initialSetup();
                try {
                    this.z[1] = this.f.dy_dt(this.tn, this.z[0]);
                    ++this.nFCalls;
                }
                catch (Exception ex) {
                    throw new Exception("At t = " + this.tn + ", the right-hand side routine failed in an unrecoverable manner.");
                }
                if (this.detectIncorrectNumbers && SimulatorSupport.checkNaNs(this.f.getCurrentState())) {
                    return -14;
                }
                if (this.h0 == 0.0) {
                    double toutHin = this.tStopSet && (tout - this.tn) * (tout - this.tStop) > 0.0 ? this.tStop : tout;
                    int hflag = this.computeStep(toutHin);
                    if (hflag != 0) {
                        this.handleFailure(hflag);
                        return hflag;
                    }
                } else if ((tout - this.tn) * this.h0 < 0.0) {
                    throw new Exception("h0 and tout - t0 inconsistent.");
                }
                this.h = Util.restrict(this.hMin, 1.0 / this.hMaxInv, this.h0);
                if (this.tStopSet) {
                    if ((this.tStop - this.tn) * this.h < 0.0) {
                        throw new Exception("The value tstop = " + this.tStop + " is behind current t = " + this.tn + " in the direction of integration.");
                    }
                    if ((this.tn + this.h - this.tStop) * this.h > 0.0) {
                        this.h = (this.tStop - this.tn) * 0.9999999999999991;
                    }
                }
                this.hScale = this.h;
                this.h0u = this.h;
                this.hPrime = this.h;
                VectorUtils.scale(this.h, this.z[1]);
                if (this.eventNumber > 0) {
                    this.checkRoot1();
                }
            } else {
                this.h = Util.restrict(this.hMin, 1.0 / this.hMaxInv, this.h);
                double troundoff = 2.220446049250313E-14 * (Math.abs(this.tn) + Math.abs(this.h));
                if (this.eventNumber > 0) {
                    int irfndp = this.lastStepRoot;
                    if (this.checkRoot2()) {
                        this.cv_tretlast = this.tLo;
                        this.time = this.tLo;
                        return 2;
                    }
                    if (Math.abs(this.tn - this.cv_tretlast) > troundoff) {
                        if (this.checkRoot3(oneStepMode)) {
                            this.lastStepRoot = 1;
                            this.cv_tretlast = this.tLo;
                            this.time = this.tLo;
                            return 2;
                        }
                        this.lastStepRoot = 0;
                        if (irfndp == 1 && oneStepMode) {
                            this.cv_tretlast = this.tn;
                            this.time = this.tn;
                            VectorUtils.copy(this.z[0], this.y);
                            return 0;
                        }
                    }
                }
                if (!oneStepMode && (this.tn - tout) * this.h >= 0.0) {
                    this.cv_tretlast = this.time = tout;
                    try {
                        this.getDky(tout, 0, this.y);
                    }
                    catch (Exception ex) {
                        JVode.processError("Trouble interpolating at tout = " + tout + " too far back in direction of integration");
                        throw new Exception(ex.getMessage());
                    }
                    return 0;
                }
                if (oneStepMode && Math.abs(this.tn - this.cv_tretlast) > troundoff) {
                    this.cv_tretlast = this.tn;
                    this.time = this.tn;
                    VectorUtils.copy(this.z[0], this.y);
                    return 0;
                }
                if (this.tStopSet) {
                    if (Math.abs(this.tn - this.tStop) <= troundoff) {
                        try {
                            this.getDky(this.tStop, 0, this.y);
                        }
                        catch (Exception ex) {
                            JVode.processError("The value tstop = " + this.tStop + " is behind current t = " + this.tn + " in the direction of integration.");
                            throw new Exception(ex.getMessage());
                        }
                        this.cv_tretlast = this.time = this.tStop;
                        this.tStopSet = false;
                        return 1;
                    }
                    if ((this.tn + this.hPrime - this.tStop) * this.h > 0.0) {
                        this.hPrime = (this.tStop - this.tn) * 0.9999999999999991;
                        this.eta = this.hPrime / this.h;
                    }
                }
            }
            int nstloc = 0;
            do {
                int kflag;
                this.hNext = this.h;
                this.qNext = this.q;
                if (this.nSteps > 0 && this.ewtFunc.getValue(this.z[0], this.errorWeight) != 0) {
                    JVode.processError("At " + this.tn + ", error estimation failed (probably component of error has become <= 0).");
                    state = -11;
                    this.cv_tretlast = this.tn;
                    this.time = this.tn;
                    VectorUtils.copy(this.z[0], this.y);
                    break block43;
                }
                if (this.maxSteps > 0 && nstloc >= this.maxSteps) {
                    JVode.processError("At " + this.tn + ", mxstep steps taken before reaching tout.");
                    state = -1;
                    this.cv_tretlast = this.tn;
                    this.time = this.tn;
                    VectorUtils.copy(this.z[0], this.y);
                    break block43;
                }
                this.toleranceScale = 2.220446049250313E-16 * VectorUtils.wrmsNorm(this.z[0], this.errorWeight);
                if (this.toleranceScale > 1.0) {
                    JVode.processError("At " + this.tn + ", too much accuracy requested.");
                    state = -2;
                    this.cv_tretlast = this.tn;
                    this.time = this.tn;
                    VectorUtils.copy(this.z[0], this.y);
                    this.toleranceScale *= 2.0;
                    break block43;
                }
                this.toleranceScale = 1.0;
                if (this.tn + this.h == this.tn) {
                    ++this.nHnil;
                }
                if ((kflag = this.doStep()) != 0) {
                    this.handleFailure(kflag);
                    this.cv_tretlast = this.tn;
                    this.time = this.tn;
                    VectorUtils.copy(this.z[0], this.y);
                    state = kflag;
                    break block43;
                }
                ++nstloc;
                if (this.eventNumber > 0) {
                    if (this.checkRoot3(oneStepMode)) {
                        this.lastStepRoot = 1;
                        state = 2;
                        this.cv_tretlast = this.time = this.tLo;
                        break block43;
                    }
                    if (this.nSteps == 1) {
                        boolean inactiveRoots = false;
                        for (int i = 0; i < this.eventNumber; ++i) {
                            if (this.eventActive[i]) continue;
                            inactiveRoots = true;
                            break;
                        }
                        if (this.maxWrnMessages > 0 && inactiveRoots) {
                            JVode.processError("At the end of the first step, there are still some root functions identically 0. This warning will not be issued again.");
                        }
                    }
                }
                if (!oneStepMode && (this.tn - tout) * this.h >= 0.0) {
                    state = 0;
                    this.cv_tretlast = tout;
                    this.time = tout;
                    this.getDky(tout, 0, this.y);
                    this.qNext = this.qPrime;
                    this.hNext = this.hPrime;
                    break block43;
                }
                if (!this.tStopSet) continue;
                double troundoff = 2.220446049250313E-14 * (Math.abs(this.tn) + Math.abs(this.h));
                if (Math.abs(this.tn - this.tStop) <= troundoff) {
                    this.getDky(this.tStop, 0, this.y);
                    this.cv_tretlast = this.tStop;
                    this.time = this.tStop;
                    this.tStopSet = false;
                    state = 1;
                    break block43;
                }
                if (!((this.tn + this.hPrime - this.tStop) * this.h > 0.0)) continue;
                this.hPrime = (this.tStop - this.tn) * 0.9999999999999991;
                this.eta = this.hPrime / this.h;
            } while (!oneStepMode);
            state = 0;
            this.cv_tretlast = this.time = this.tn;
            VectorUtils.copy(this.z[0], this.y);
            this.qNext = this.qPrime;
            this.hNext = this.hPrime;
        }
        return state;
    }

    public int start() throws Exception {
        return this.start(1.0, true);
    }

    public int start(double tout) throws Exception {
        return this.start(tout, false);
    }

    private void getDky(double t, int k, double[] dky) throws Exception {
        double tn1;
        double tp;
        if (k < 0 || k > this.q) {
            throw new Exception("Illegal value for k: " + k);
        }
        double tfuzz = 2.220446049250313E-14 * (Math.abs(this.tn) + Math.abs(this.hu));
        if (this.hu < 0.0) {
            tfuzz = -tfuzz;
        }
        if ((t - (tp = this.tn - this.hu - tfuzz)) * (t - (tn1 = this.tn + tfuzz)) > 0.0) {
            throw new Exception("Illegal value for t. t = " + t + " is not between tcur - hu = " + (this.tn - this.hu) + " and tcur = " + this.tn + ".");
        }
        double s = (t - this.tn) / this.h;
        for (int j = this.q; j >= k; --j) {
            double c = 1.0;
            for (int i = j; i >= j - k + 1; --i) {
                c *= (double)i;
            }
            if (j == this.q) {
                VectorUtils.scale(c, this.z[this.q], dky);
                continue;
            }
            VectorUtils.linearSum(c, this.z[j], s, dky, dky);
        }
        if (k == 0) {
            return;
        }
        double r = Math.pow(this.h, -k);
        VectorUtils.scale(r, dky);
    }

    private void initialSetup() throws Exception {
        if (this.ewtFunc == null) {
            throw new Exception("No integration tolerances have been specified.");
        }
        if (this.n > 0 && this.ewtFunc.getValue(this.z[0], this.errorWeight) != 0) {
            throw new Exception("Initial ewt has component(s) equal to zero (illegal).");
        }
        if (this.init() != 0) {
            throw new Exception("The linear solver's init routine failed.");
        }
    }

    private int computeStep(double tout) {
        double tround;
        double hnew = 0.0;
        double yddnrm = 0.0;
        double tdiff = tout - this.tn;
        int sign = tdiff > 0.0 ? 1 : -1;
        double tdist = Math.abs(tdiff);
        if (tdist < 2.0 * (tround = 2.220446049250313E-16 * Math.max(Math.abs(this.tn), Math.abs(tout)))) {
            return -12;
        }
        double hlb = 100.0 * tround;
        double hub = this.upperBoundH0(tdist);
        double hg = Math.sqrt(hlb * hub);
        if (hub < hlb) {
            this.h = (double)sign * hg;
            return 0;
        }
        boolean hnewOK = false;
        double hs = hg;
        for (int count1 = 1; count1 <= 4; ++count1) {
            boolean hgOK = false;
            for (int count2 = 1; count2 <= 4; ++count2) {
                try {
                    yddnrm = this.yddNorm((double)sign * hg);
                    hgOK = true;
                    break;
                }
                catch (IllegalArgumentException ex) {
                    hg *= 0.2;
                    continue;
                }
                catch (Exception ex) {
                    return -7;
                }
            }
            if (!hgOK) {
                if (count1 <= 2) {
                    return -8;
                }
                hnew = hs;
                break;
            }
            hs = hg;
            if (hnewOK || count1 == 4) {
                hnew = hg;
                break;
            }
            hnew = yddnrm * hub * hub > 2.0 ? Math.sqrt(2.0 / yddnrm) : Math.sqrt(hg * hub);
            double hrat = hnew / hg;
            if (hrat > 0.5 && hrat < 2.0) {
                hnewOK = true;
            }
            if (count1 > 1 && hrat > 2.0) {
                hnew = hg;
                hnewOK = true;
            }
            hg = hnew;
        }
        this.h0 = (double)sign * Util.restrict(hlb, hub, 0.5 * hnew);
        return 0;
    }

    private double upperBoundH0(double tdist) {
        VectorUtils.abs(this.z[0], this.acor);
        this.ewtFunc.getValue(this.z[0], this.temp);
        VectorUtils.inv(this.temp, this.temp);
        VectorUtils.linearSum(0.1, this.acor, this.temp);
        VectorUtils.abs(this.z[1], this.acor);
        VectorUtils.divide(this.acor, this.temp, this.temp);
        return Math.min(0.1 * tdist, 1.0 / VectorUtils.maxNorm(this.temp));
    }

    private double yddNorm(double hg) throws Exception {
        VectorUtils.linearSum(hg, this.z[1], this.z[0], this.y);
        ++this.nFCalls;
        this.temp = this.f.dy_dt(this.tn + hg, this.y);
        VectorUtils.scaleDiff(1.0 / hg, this.temp, this.z[1], this.temp);
        return VectorUtils.wrmsNorm(this.temp, this.errorWeight);
    }

    private int doStep() throws Exception {
        int eflag;
        double savedT = this.tn;
        this.nFlag = 6;
        this.nef = 0;
        this.ncf = 0;
        if (this.nSteps > 0 && this.hPrime != this.h) {
            this.adjustParams();
        }
        while (true) {
            this.predictZ();
            this.set();
            this.solveNonLinearSystem();
            int kflag = this.handleNFlag(savedT);
            if (kflag == 3) continue;
            if (kflag != 2) {
                return kflag;
            }
            eflag = this.doErrorTest(savedT);
            if (eflag != 5) break;
        }
        if (eflag != 0) {
            return eflag;
        }
        this.completeStep();
        this.prepareNextStep();
        if (this.stabLimitDetect) {
            this.stabilityBDF();
        }
        this.etaMax = this.nSteps <= 10 ? 10.0 : 10.0;
        VectorUtils.scale(this.tq[2], this.acor);
        return 0;
    }

    private void adjustParams() {
        if (this.qPrime != this.q) {
            this.adjustOrder(this.qPrime - this.q);
            this.q = this.qPrime;
            this.qWait = this.qPlusOne = this.q + 1;
        }
        this.rescaleZ();
    }

    private void adjustOrder(int deltaq) {
        if (this.q == 2 && deltaq != 1) {
            return;
        }
        switch (this.method) {
            case ADAMS: {
                this.adjustAdams(deltaq);
                break;
            }
            case BDF: {
                this.adjustBDF(deltaq);
            }
        }
    }

    private void adjustAdams(int deltaq) {
        int j;
        if (deltaq == 1) {
            Arrays.fill(this.z[this.qPlusOne], 0.0);
            return;
        }
        for (int i = 0; i <= this.qMax; ++i) {
            this.l[i] = 0.0;
        }
        this.l[1] = 1.0;
        double hsum = 0.0;
        for (j = 1; j <= this.q - 2; ++j) {
            double xi = (hsum += this.tau[j]) / this.hScale;
            for (int i = j + 1; i >= 1; --i) {
                this.l[i] = this.l[i] * xi + this.l[i - 1];
            }
        }
        for (j = 1; j <= this.q - 2; ++j) {
            this.l[j + 1] = (double)this.q * (this.l[j] / (double)(j + 1));
        }
        for (j = 2; j < this.q; ++j) {
            VectorUtils.linearSum(-this.l[j], this.z[this.q], this.z[j]);
        }
    }

    private void adjustBDF(int deltaq) {
        switch (deltaq) {
            case 1: {
                this.increaseBDF();
                return;
            }
            case -1: {
                this.decreaseBDF();
                return;
            }
        }
    }

    private void increaseBDF() {
        double alpha1 = 1.0;
        double prod = 1.0;
        double xiold = 1.0;
        for (int i = 0; i <= this.qMax; ++i) {
            this.l[i] = 0.0;
        }
        this.l[2] = 1.0;
        double alpha0 = -1.0;
        double hsum = this.hScale;
        if (this.q > 1) {
            for (int j = 1; j < this.q; ++j) {
                double xi = (hsum += this.tau[j + 1]) / this.hScale;
                prod *= xi;
                alpha0 -= 1.0 / (double)(j + 1);
                alpha1 += 1.0 / xi;
                for (int i = j + 2; i >= 2; --i) {
                    this.l[i] = this.l[i] * xiold + this.l[i - 1];
                }
                xiold = xi;
            }
        }
        double a1 = -(alpha0 + alpha1) / prod;
        VectorUtils.scale(a1, this.z[this.acorIndex], this.z[this.qPlusOne]);
        for (int j = 2; j <= this.q; ++j) {
            VectorUtils.linearSum(this.l[j], this.z[this.qPlusOne], this.z[j]);
        }
    }

    private void decreaseBDF() {
        int j;
        for (int i = 0; i <= this.qMax; ++i) {
            this.l[i] = 0.0;
        }
        this.l[2] = 1.0;
        double hsum = 0.0;
        for (j = 1; j <= this.q - 2; ++j) {
            hsum += this.tau[j];
            for (int i = j + 2; i >= 2; --i) {
                this.l[i] = this.l[i] * (hsum / this.hScale) + this.l[i - 1];
            }
        }
        for (j = 2; j < this.q; ++j) {
            VectorUtils.linearSum(-this.l[j], this.z[this.q], this.z[j]);
        }
    }

    private void rescaleZ() {
        double factor = this.eta;
        for (int j = 1; j <= this.q; ++j) {
            VectorUtils.scale(factor, this.z[j]);
            factor *= this.eta;
        }
        this.hNext = this.h = this.hScale * this.eta;
        this.hScale = this.h;
        this.nscon = 0;
    }

    private void predictZ() {
        this.tn += this.h;
        if (this.tStopSet && (this.tn - this.tStop) * this.h > 0.0) {
            this.tn = this.tStop;
        }
        for (int k = 1; k <= this.q; ++k) {
            for (int j = this.q; j >= k; --j) {
                VectorUtils.add(this.z[j], this.z[j - 1]);
            }
        }
    }

    private void set() {
        switch (this.method) {
            case ADAMS: {
                this.setAdams();
                break;
            }
            case BDF: {
                this.setBDF();
            }
        }
        this.rl1 = 1.0 / this.l[1];
        this.gamma = this.h * this.rl1;
        if (this.nSteps == 0) {
            this.gammaPrev = this.gamma;
        }
        this.gammaRatio = this.nSteps > 0 ? this.gamma / this.gammaPrev : 1.0;
    }

    private void setAdams() {
        if (this.q == 1) {
            this.tq[5] = 1.0;
            this.tq[1] = 1.0;
            this.l[1] = 1.0;
            this.l[0] = 1.0;
            this.tq[2] = 0.5;
            this.tq[3] = 0.08333333333333333;
            this.tq[4] = this.convCoef / this.tq[2];
            return;
        }
        double[] m = new double[13];
        double[] mm = new double[3];
        double hsum = this.adamsStart(m);
        mm[0] = this.altSum(this.q - 1, m, 1);
        mm[1] = this.altSum(this.q - 1, m, 2);
        this.adamsFinish(m, mm, hsum);
    }

    private double adamsStart(double[] m) {
        double hsum = this.h;
        m[0] = 1.0;
        for (int i = 1; i <= this.q; ++i) {
            m[i] = 0.0;
        }
        for (int j = 1; j < this.q; ++j) {
            if (j == this.q - 1 && this.qWait == 1) {
                this.tq[1] = (double)this.q * this.altSum(this.q - 2, m, 2) / m[this.q - 2];
            }
            double xi_inv = this.h / hsum;
            for (int i = j; i >= 1; --i) {
                int n = i;
                m[n] = m[n] + m[i - 1] * xi_inv;
            }
            hsum += this.tau[j];
        }
        return hsum;
    }

    private void adamsFinish(double[] m, double[] M, double hsum) {
        double M0_inv = 1.0 / M[0];
        this.l[0] = 1.0;
        for (int i = 1; i <= this.q; ++i) {
            this.l[i] = M0_inv * (m[i - 1] / (double)i);
        }
        double xi = hsum / this.h;
        double xi_inv = 1.0 / xi;
        this.tq[2] = M[1] * M0_inv / xi;
        this.tq[5] = xi / this.l[this.q];
        if (this.qWait == 1) {
            for (int i = this.q; i >= 1; --i) {
                int n = i;
                m[n] = m[n] + m[i - 1] * xi_inv;
            }
            M[2] = this.altSum(this.q, m, 2);
            this.tq[3] = M[2] * M0_inv / (double)this.qPlusOne;
        }
        this.tq[4] = this.convCoef / this.tq[2];
    }

    private double altSum(int iend, double[] a, int k) {
        if (iend < 0) {
            return 0.0;
        }
        double sum = 0.0;
        int sign = 1;
        for (int i = 0; i <= iend; ++i) {
            sum += (double)sign * (a[i] / (double)(i + k));
            sign = -sign;
        }
        return sum;
    }

    private void setBDF() {
        int i;
        double xistar_inv = 1.0;
        double xi_inv = 1.0;
        this.l[1] = 1.0;
        this.l[0] = 1.0;
        for (i = 2; i <= this.q; ++i) {
            this.l[i] = 0.0;
        }
        double alpha0_hat = -1.0;
        double alpha0 = -1.0;
        double hsum = this.h;
        if (this.q > 1) {
            for (int j = 2; j < this.q; ++j) {
                xi_inv = this.h / (hsum += this.tau[j - 1]);
                alpha0 -= 1.0 / (double)j;
                for (int i2 = j; i2 >= 1; --i2) {
                    int n = i2;
                    this.l[n] = this.l[n] + this.l[i2 - 1] * xi_inv;
                }
            }
            xistar_inv = -this.l[1] - (alpha0 -= 1.0 / (double)this.q);
            xi_inv = this.h / (hsum += this.tau[this.q - 1]);
            alpha0_hat = -this.l[1] - xi_inv;
            for (i = this.q; i >= 1; --i) {
                int n = i;
                this.l[n] = this.l[n] + this.l[i - 1] * xistar_inv;
            }
        }
        this.setTqBDF(hsum, alpha0, alpha0_hat, xi_inv, xistar_inv);
    }

    private void setTqBDF(double hsum, double alpha0, double alpha0_hat, double xi_inv, double xistar_inv) {
        double A1 = 1.0 - alpha0_hat + alpha0;
        double A2 = 1.0 + (double)this.q * A1;
        this.tq[2] = Math.abs(A1 / (alpha0 * A2));
        this.tq[5] = Math.abs(A2 * xistar_inv / (this.l[this.q] * xi_inv));
        if (this.qWait == 1) {
            double C = xistar_inv / this.l[this.q];
            double A3 = alpha0 + 1.0 / (double)this.q;
            double A4 = alpha0_hat + xi_inv;
            double Cpinv = (1.0 - A4 + A3) / A3;
            this.tq[1] = Math.abs(C * Cpinv);
            xi_inv = this.h / (hsum += this.tau[this.q]);
            double A5 = alpha0 - 1.0 / (double)(this.q + 1);
            double A6 = alpha0_hat - xi_inv;
            double Cppinv = (1.0 - A6 + A5) / A2;
            this.tq[3] = Math.abs(Cppinv / (xi_inv * (double)(this.q + 2) * A5));
        }
        this.tq[4] = this.convCoef / this.tq[2];
    }

    private void solveNonLinearSystem() throws Exception {
        this.nFlag = this.iterationType == JVodeSupport.IterationType.FUNCTIONAL ? this.solveFunctional() : this.solveNewton();
    }

    private int solveFunctional() throws Exception {
        this.convergenceRate = 1.0;
        int m = 0;
        try {
            ++this.nFCalls;
            this.temp = this.f.dy_dt(this.tn, this.z[0]);
        }
        catch (IllegalArgumentException ex) {
            return 9;
        }
        catch (Exception ex) {
            return -7;
        }
        if (this.detectIncorrectNumbers && SimulatorSupport.checkNaNs(this.f.getCurrentState())) {
            return -14;
        }
        Arrays.fill(this.acor, 0.0);
        double delp = 0.0;
        do {
            double dcon;
            ++this.nNewtonIter;
            VectorUtils.linearDiff(this.h, this.temp, this.z[1], this.temp);
            VectorUtils.scale(this.rl1, this.temp);
            VectorUtils.linearSum(this.rl1, this.temp, this.z[0], this.y);
            VectorUtils.linearDiff(this.temp, this.acor, this.acor);
            double del = VectorUtils.wrmsNorm(this.acor, this.errorWeight);
            VectorUtils.copy(this.temp, this.acor);
            if (m > 0) {
                this.convergenceRate = Math.max(0.3 * this.convergenceRate, del / delp);
            }
            if ((dcon = del * Math.min(1.0, this.convergenceRate) / this.tq[4]) <= 1.0) {
                this.acorNorm = m == 0 ? del : VectorUtils.wrmsNorm(this.acor, this.errorWeight);
                return 0;
            }
            if (++m == this.maxCor || m >= 2 && del > 2.0 * delp) {
                return 4;
            }
            delp = del;
            try {
                ++this.nFCalls;
                this.temp = this.f.dy_dt(this.tn, this.y);
            }
            catch (IllegalArgumentException ex) {
                return 9;
            }
            catch (Exception ex) {
                return -7;
            }
        } while (!this.detectIncorrectNumbers || !SimulatorSupport.checkNaNs(this.f.getCurrentState()));
        return -14;
    }

    private int solveNewton() throws Exception {
        boolean callSetup;
        int convfail;
        int n = convfail = this.nFlag == 6 || this.nFlag == 8 ? 0 : 2;
        if (this.setupNonNull) {
            callSetup = this.nFlag == 7 || this.nFlag == 8 || this.nSteps == 0 || (long)this.nSteps >= this.nLastSetupSteps + 20L || Math.abs(this.gammaRatio - 1.0) > 0.3;
        } else {
            this.convergenceRate = 1.0;
            callSetup = false;
        }
        while (true) {
            int ier;
            try {
                ++this.nFCalls;
                this.ftemp = this.f.dy_dt(this.tn, this.z[0]);
            }
            catch (IllegalArgumentException ex) {
                return 9;
            }
            catch (Exception ex) {
                return -7;
            }
            if (this.detectIncorrectNumbers && SimulatorSupport.checkNaNs(this.f.getCurrentState())) {
                return -14;
            }
            if (callSetup) {
                ier = this.setup(convfail);
                ++this.nSetupCalls;
                callSetup = false;
                this.convergenceRate = 1.0;
                this.gammaRatio = 1.0;
                this.gammaPrev = this.gamma;
                this.nLastSetupSteps = this.nSteps;
                if (ier < 0) {
                    return -5;
                }
                if (ier > 0) {
                    return 4;
                }
            }
            Arrays.fill(this.acor, 0.0);
            VectorUtils.copy(this.z[0], this.y);
            ier = this.doNewtonIteration();
            if (ier != 5) {
                return ier;
            }
            callSetup = true;
            convfail = 1;
        }
    }

    int doNewtonIteration() throws Exception {
        int m = 0;
        this.mNewt = 0;
        double delp = 0.0;
        double del = 0.0;
        do {
            if (!this.isRunning) {
                return -13;
            }
            VectorUtils.linearSum(this.rl1, this.z[1], this.acor, this.temp);
            VectorUtils.linearDiff(this.gamma, this.ftemp, this.temp, this.temp);
            double[] b = VectorUtils.copy(this.temp);
            int retval = this.solve(b);
            ++this.nNewtonIter;
            if (retval < 0) {
                return -6;
            }
            if (retval > 0) {
                return !this.currentJacobian && this.setupNonNull ? 5 : 4;
            }
            del = VectorUtils.wrmsNorm(b, this.errorWeight);
            VectorUtils.linearSum(this.acor, b, this.acor);
            VectorUtils.linearSum(this.z[0], this.acor, this.y);
            if (m > 0) {
                this.convergenceRate = Math.max(0.3 * this.convergenceRate, del / delp);
            }
            if (del * Math.min(1.0, this.convergenceRate) / this.tq[4] <= 1.0) {
                this.acorNorm = m == 0 ? del : VectorUtils.wrmsNorm(this.acor, this.errorWeight);
                this.currentJacobian = false;
                return 0;
            }
            this.mNewt = ++m;
            if (m == this.maxCor || m >= 2 && del > 2.0 * delp) {
                return !this.currentJacobian && this.setupNonNull ? 5 : 4;
            }
            delp = del;
            try {
                ++this.nFCalls;
                this.ftemp = this.f.dy_dt(this.tn, this.y);
            }
            catch (IllegalArgumentException ex) {
                return !this.currentJacobian && this.setupNonNull ? 5 : 9;
            }
            catch (Exception ex) {
                return -7;
            }
        } while (!this.detectIncorrectNumbers || !SimulatorSupport.checkNaNs(this.f.getCurrentState()));
        return -14;
    }

    int handleNFlag(double saved_t) {
        if (this.nFlag == 0) {
            return 2;
        }
        ++this.nCorrFails;
        this.restore(saved_t);
        if (this.nFlag == -14 || this.nFlag == -5 || this.nFlag == -6 || this.nFlag == -7) {
            return this.nFlag;
        }
        ++this.ncf;
        this.etaMax = 1.0;
        if (Math.abs(this.h) <= this.hMin * 1.000001 || this.ncf == this.maxConvFails) {
            if (this.nFlag == 4) {
                return -4;
            }
            if (this.nFlag == 9) {
                return -8;
            }
        }
        this.eta = Math.max(0.25, this.hMin / Math.abs(this.h));
        this.nFlag = 7;
        this.rescaleZ();
        return 3;
    }

    private void restore(double savedTime) {
        this.tn = savedTime;
        for (int k = 1; k <= this.q; ++k) {
            for (int j = this.q; j >= k; --j) {
                VectorUtils.substract(this.z[j], this.z[j - 1]);
            }
        }
    }

    private int doErrorTest(double savedTime) {
        this.dsm = this.acorNorm * this.tq[2];
        if (this.dsm <= 1.0) {
            return 0;
        }
        ++this.nef;
        ++this.nTestFails;
        this.nFlag = 8;
        this.restore(savedTime);
        if (Math.abs(this.h) <= this.hMin * 1.000001 || this.nef == this.maxTestFails) {
            return -3;
        }
        this.etaMax = 1.0;
        if (this.nef <= 3) {
            this.eta = 1.0 / (Math.pow(6.0 * this.dsm, 1.0 / (double)this.qPlusOne) + 1.0E-6);
            this.eta = Math.max(0.1, Math.max(this.eta, this.hMin / Math.abs(this.h)));
            if (this.nef >= 2) {
                this.eta = Math.min(this.eta, 0.2);
            }
            this.rescaleZ();
            return 5;
        }
        if (this.q > 1) {
            this.eta = Math.max(0.1, this.hMin / Math.abs(this.h));
            this.adjustOrder(-1);
            this.qWait = this.qPlusOne = this.q--;
            this.rescaleZ();
            return 5;
        }
        this.eta = Math.max(0.1, this.hMin / Math.abs(this.h));
        this.h *= this.eta;
        this.hNext = this.h;
        this.hScale = this.h;
        this.qWait = 10;
        this.nscon = 0;
        try {
            ++this.nFCalls;
            this.temp = this.f.dy_dt(this.tn, this.z[0]);
        }
        catch (IllegalArgumentException ex) {
            return -9;
        }
        catch (Exception ex) {
            return -7;
        }
        VectorUtils.scale(this.h, this.temp, this.z[1]);
        return 5;
    }

    private void completeStep() {
        ++this.nSteps;
        ++this.nscon;
        this.hu = this.h;
        this.qu = this.q;
        for (int i = this.q; i >= 2; --i) {
            this.tau[i] = this.tau[i - 1];
        }
        if (this.q == 1 && this.nSteps > 1) {
            this.tau[2] = this.tau[1];
        }
        this.tau[1] = this.h;
        for (int j = 0; j <= this.q; ++j) {
            VectorUtils.linearSum(this.l[j], this.acor, this.z[j]);
        }
        --this.qWait;
        if (this.qWait == 1 && this.q != this.qMax) {
            VectorUtils.copy(this.acor, this.z[this.qMax]);
            this.tq5Saved = this.tq[5];
            this.acorIndex = this.qMax;
        }
    }

    private void prepareNextStep() {
        if (this.etaMax == 1.0) {
            this.qWait = Math.max(this.qWait, 2);
            this.qPrime = this.q;
            this.hPrime = this.h;
            this.eta = 1.0;
            return;
        }
        this.etaq = 1.0 / (Math.pow(6.0 * this.dsm, 1.0 / (double)this.qPlusOne) + 1.0E-6);
        if (this.qWait != 0) {
            this.eta = this.etaq;
            this.qPrime = this.q;
            this.setEta();
            return;
        }
        this.qWait = 2;
        this.etaqm1 = this.computeEtaqm1();
        this.etaqp1 = this.computeEtaqp1();
        this.chooseEta();
        this.setEta();
    }

    private void setEta() {
        if (this.eta < 1.5) {
            this.eta = 1.0;
            this.hPrime = this.h;
        } else {
            this.eta = Math.min(this.eta, this.etaMax);
            this.eta /= Math.max(1.0, Math.abs(this.h) * this.hMaxInv * this.eta);
            this.hPrime = this.h * this.eta;
            if (this.qPrime < this.q) {
                this.nscon = 0;
            }
        }
    }

    private double computeEtaqm1() {
        if (this.q > 1) {
            double ddn = VectorUtils.wrmsNorm(this.z[this.q], this.errorWeight) * this.tq[1];
            return 1.0 / (Math.pow(6.0 * ddn, 1.0 / (double)this.q) + 1.0E-6);
        }
        return 0.0;
    }

    private double computeEtaqp1() {
        if (this.q != this.qMax) {
            if (this.tq5Saved == 0.0) {
                return 0.0;
            }
            double cquot = this.tq[5] / this.tq5Saved * Math.pow(this.h / this.tau[2], this.qPlusOne);
            VectorUtils.linearSum(-cquot, this.z[this.qMax], this.acor, this.temp);
            double dup = VectorUtils.wrmsNorm(this.temp, this.errorWeight) * this.tq[3];
            return 1.0 / (Math.pow(10.0 * dup, 1.0 / (double)(this.qPlusOne + 1)) + 1.0E-6);
        }
        return 0.0;
    }

    private void chooseEta() {
        double etam = Math.max(this.etaqm1, Math.max(this.etaq, this.etaqp1));
        if (etam < 1.5) {
            this.eta = 1.0;
            this.qPrime = this.q;
            return;
        }
        if (etam == this.etaq) {
            this.eta = this.etaq;
            this.qPrime = this.q;
        } else if (etam == this.etaqm1) {
            this.eta = this.etaqm1;
            this.qPrime = this.q - 1;
        } else {
            this.eta = this.etaqp1;
            this.qPrime = this.q + 1;
            if (this.method == JVodeSupport.Method.BDF) {
                VectorUtils.copy(this.acor, this.z[this.qMax]);
            }
        }
    }

    private void handleFailure(int flag) {
        switch (flag) {
            case -3: {
                JVode.processError("At t = " + this.tn + " and h = " + this.h + ", the error test failed repeatedly or with |h| = hmin.");
                break;
            }
            case -4: {
                JVode.processError("At t = " + this.tn + " and h = " + this.h + ", the corrector convergence test failed repeatedly or with |h| = hmin.");
                break;
            }
            case -5: {
                JVode.processError("At t = " + this.tn + ", the setup routine failed in an unrecoverable manner.");
                break;
            }
            case -6: {
                JVode.processError("At t = " + this.tn + ", the solve routine failed in an unrecoverable manner.");
                break;
            }
            case -7: {
                JVode.processError("At t = " + this.tn + ", the right-hand side routine failed in an unrecoverable manner.");
                break;
            }
            case -9: {
                JVode.processError("At t = " + this.tn + ", the right-hand side failed in a recoverable manner, but no recovery is possible.");
                break;
            }
            case -8: {
                JVode.processError("At t = " + this.tn + " repeated recoverable right-hand side function errors.");
                break;
            }
            case -12: {
                JVode.processError("tout too close to t0 to start integration.");
                break;
            }
            default: {
                return;
            }
        }
    }

    private void stabilityBDF() {
        if (this.q >= 3) {
            for (int k = 1; k <= 3; ++k) {
                for (int i = 5; i >= 2; --i) {
                    this.ssdat[i][k] = this.ssdat[i - 1][k];
                }
            }
            double factorial = 1.0;
            for (int i = 1; i <= this.q - 1; ++i) {
                factorial *= (double)i;
            }
            double sq = factorial * (double)this.q * (double)(this.q + 1) * this.acorNorm / Math.max(this.tq[5], 1.0E-10);
            double sqm1 = factorial * (double)this.q * VectorUtils.wrmsNorm(this.z[this.q], this.errorWeight);
            double sqm2 = factorial * VectorUtils.wrmsNorm(this.z[this.q - 1], this.errorWeight);
            this.ssdat[1][1] = sqm2 * sqm2;
            this.ssdat[1][2] = sqm1 * sqm1;
            this.ssdat[1][3] = sq * sq;
        }
        if (this.qPrime >= this.q) {
            if (this.q >= 3 && this.nscon >= this.q + 5 && this.checkStability() > 3) {
                this.qPrime = this.q - 1;
                this.eta = this.etaqm1;
                this.eta = Math.min(this.eta, this.etaMax);
                this.eta /= Math.max(1.0, Math.abs(this.h) * this.hMaxInv * this.eta);
                this.hPrime = this.h * this.eta;
                ++this.nOrderReduct;
            }
        } else {
            this.nscon = 0;
        }
    }

    int checkStability() {
        double tem;
        int i;
        int k;
        int kflag = 0;
        double[][] rat = new double[5][4];
        double[] rav = new double[4];
        double[] qkr = new double[4];
        double[] sigsq = new double[4];
        double[] smax = new double[4];
        double[] ssmax = new double[4];
        double[] drr = new double[4];
        double[] rrc = new double[4];
        double[] sqmx = new double[4];
        double[][] qjk = new double[4][4];
        double[] vrat = new double[5];
        double[][] qc = new double[6][4];
        double[][] qco = new double[6][4];
        double rrcut = 0.98;
        double vrrtol = 1.0E-4;
        double vrrt2 = 5.0E-4;
        double sqtol = 0.001;
        double rrtol = 0.01;
        double rr = 0.0;
        double[][] ssdat = this.ssdat;
        for (k = 1; k <= 3; ++k) {
            double smink = ssdat[1][k];
            double smaxk = 0.0;
            for (i = 1; i <= 5; ++i) {
                smink = Math.min(smink, ssdat[i][k]);
                smaxk = Math.min(smaxk, ssdat[i][k]);
            }
            if (smink < 1.0E-10 * smaxk) {
                return -1;
            }
            smax[k] = smaxk;
            ssmax[k] = smaxk * smaxk;
            double sumrat = 0.0;
            double sumrsq = 0.0;
            for (i = 1; i <= 4; ++i) {
                rat[i][k] = ssdat[i][k] / ssdat[i + 1][k];
                sumrat += rat[i][k];
                sumrsq += rat[i][k] * rat[i][k];
            }
            rav[k] = 0.25 * sumrat;
            vrat[k] = Math.abs(0.25 * sumrsq - rav[k] * rav[k]);
            qc[5][k] = ssdat[1][k] * ssdat[3][k] - ssdat[2][k] * ssdat[2][k];
            qc[4][k] = ssdat[2][k] * ssdat[3][k] - ssdat[1][k] * ssdat[4][k];
            qc[3][k] = 0.0;
            qc[2][k] = ssdat[2][k] * ssdat[5][k] - ssdat[3][k] * ssdat[4][k];
            qc[1][k] = ssdat[4][k] * ssdat[4][k] - ssdat[3][k] * ssdat[5][k];
            for (i = 1; i <= 5; ++i) {
                qco[i][k] = qc[i][k];
            }
        }
        double vmin = Math.min(vrat[1], Math.min(vrat[2], vrat[3]));
        double vmax = Math.max(vrat[1], Math.max(vrat[2], vrat[3]));
        if (vmin < vrrtol * vrrtol) {
            if (vmax > vrrt2 * vrrt2) {
                kflag = -2;
                return kflag;
            }
            rr = (rav[1] + rav[2] + rav[3]) / 3.0;
            double drrmax = 0.0;
            for (k = 1; k <= 3; ++k) {
                double adrr = Math.abs(rav[k] - rr);
                drrmax = Math.max(drrmax, adrr);
            }
            if (drrmax > vrrt2) {
                kflag = -3;
            }
            kflag = 1;
        } else {
            if (Math.abs(qco[1][1]) < 1.0E-10 * ssmax[1]) {
                return -4;
            }
            tem = qco[1][2] / qco[1][1];
            for (i = 2; i <= 5; ++i) {
                qco[i][2] = qco[i][2] - tem * qco[i][1];
            }
            qco[1][2] = 0.0;
            tem = qco[1][3] / qco[1][1];
            for (i = 2; i <= 5; ++i) {
                qco[i][3] = qco[i][3] - tem * qco[i][1];
            }
            qco[1][3] = 0.0;
            if (Math.abs(qco[2][2]) < 1.0E-10 * ssmax[2]) {
                return -4;
            }
            tem = qco[2][3] / qco[2][2];
            for (i = 3; i <= 5; ++i) {
                qco[i][3] = qco[i][3] - tem * qco[i][2];
            }
            if (Math.abs(qco[4][3]) < 1.0E-10 * ssmax[3]) {
                return -4;
            }
            rr = -qco[5][3] / qco[4][3];
            if (rr < 1.0E-10 || rr > 100.0) {
                return -5;
            }
            for (k = 1; k <= 3; ++k) {
                qkr[k] = qc[5][k] + rr * (qc[4][k] + rr * rr * (qc[2][k] + rr * qc[1][k]));
            }
            double sqmax = 0.0;
            for (k = 1; k <= 3; ++k) {
                double saqk = Math.abs(qkr[k]) / ssmax[k];
                if (!(saqk > sqmax)) continue;
                sqmax = saqk;
            }
            if (sqmax < sqtol) {
                kflag = 2;
            } else {
                double sqmin = 0.0;
                for (int it = 1; it <= 3; ++it) {
                    int j;
                    for (k = 1; k <= 3; ++k) {
                        double qp = qc[4][k] + rr * rr * (3.0 * qc[2][k] + rr * 4.0 * qc[1][k]);
                        drr[k] = 0.0;
                        if (Math.abs(qp) > 1.0E-10 * ssmax[k]) {
                            drr[k] = -qkr[k] / qp;
                        }
                        rrc[k] = rr + drr[k];
                    }
                    for (k = 1; k <= 3; ++k) {
                        double s = rrc[k];
                        double sqmaxk = 0.0;
                        for (j = 1; j <= 3; ++j) {
                            qjk[j][k] = qc[5][j] + s * (qc[4][j] + s * s * (qc[2][j] + s * qc[1][j]));
                            double saqj = Math.abs(qjk[j][k]) / ssmax[j];
                            if (!(saqj > sqmaxk)) continue;
                            sqmaxk = saqj;
                        }
                        sqmx[k] = sqmaxk;
                    }
                    sqmin = sqmx[1];
                    int kmin = 1;
                    for (k = 2; k <= 3; ++k) {
                        if (!(sqmx[k] < sqmin)) continue;
                        kmin = k;
                        sqmin = sqmx[k];
                    }
                    rr = rrc[kmin];
                    if (sqmin < sqtol) {
                        kflag = 3;
                        break;
                    }
                    for (j = 1; j <= 3; ++j) {
                        qkr[j] = qjk[j][kmin];
                    }
                }
                if (sqmin > sqtol) {
                    return -6;
                }
            }
        }
        for (k = 1; k <= 3; ++k) {
            double rsa = ssdat[1][k];
            double rsb = ssdat[2][k] * rr;
            double rsc = ssdat[3][k] * rr * rr;
            double rsd = ssdat[4][k] * rr * rr * rr;
            double rd1a = rsa - rsb;
            double rd1b = rsb - rsc;
            double rd1c = rsc - rsd;
            double rd2a = rd1a - rd1b;
            double rd2b = rd1b - rd1c;
            double rd3a = rd2a - rd2b;
            if (Math.abs(rd1b) < 1.0E-10 * smax[k]) {
                return -7;
            }
            double cest1 = -rd3a / rd1b;
            if (cest1 < 1.0E-10 || cest1 > 4.0) {
                return -7;
            }
            double corr1 = rd2b / cest1 / (rr * rr);
            sigsq[k] = ssdat[3][k] + corr1;
        }
        if (sigsq[2] < 1.0E-10) {
            return -8;
        }
        double qfac2 = 2.0 / (double)(this.q - 1);
        double ratp = sigsq[3] / sigsq[2];
        double ratm = sigsq[1] / sigsq[2];
        double qfac1 = 0.25 * (double)(this.q * this.q - 1);
        double bb = ratp * ratm - 1.0 - qfac1 * ratp;
        tem = 1.0 - qfac2 * bb;
        if (Math.abs(tem) < 1.0E-10) {
            return -8;
        }
        double rrb = 1.0 / tem;
        if (Math.abs(rrb - rr) > rrtol) {
            return -9;
        }
        if (rr > rrcut) {
            if (kflag == 1) {
                kflag = 4;
            }
            if (kflag == 2) {
                kflag = 5;
            }
            if (kflag == 3) {
                kflag = 6;
            }
        }
        return kflag;
    }

    private void checkRoot1() throws Exception {
        for (int i = 0; i < this.eventNumber; ++i) {
            this.eventInfo[i] = 0;
        }
        this.tLo = this.tn;
        this.eventTol = (Math.abs(this.tn) + Math.abs(this.h)) * 2.220446049250313E-14;
        try {
            this.nEventFuncionCalls = 1L;
            this.eventFuncLo = this.f.checkEvent(this.tLo, this.z[0]);
        }
        catch (Exception ex) {
            throw new Exception("At t = " + this.tn + ", the rootfinding routine failed in an unrecoverable manner.");
        }
        boolean zroot = false;
        for (int i = 0; i < this.eventNumber; ++i) {
            if (Math.abs(this.eventFuncLo[i]) != 0.0) continue;
            zroot = true;
            this.eventActive[i] = false;
        }
        if (!zroot) {
            return;
        }
        double hratio = Math.max(this.eventTol / Math.abs(this.h), 0.1);
        double smallh = hratio * this.h;
        this.tLo += smallh;
        VectorUtils.linearSum(hratio, this.z[1], this.z[0], this.y);
        try {
            this.eventFuncLo = this.f.checkEvent(this.tLo, this.y);
        }
        catch (Exception ex) {
            throw new Exception("At t = " + this.tn + ", the rootfinding routine failed in an unrecoverable manner.");
        }
        ++this.nEventFuncionCalls;
        for (int i = 0; i < this.eventNumber; ++i) {
            if (this.eventActive[i] || Math.abs(this.eventFuncLo[i]) == 0.0) continue;
            this.eventActive[i] = false;
        }
    }

    private boolean checkRoot2() throws Exception {
        int i;
        if (this.lastStepRoot == 0) {
            return false;
        }
        this.getDky(this.tLo, 0, this.y);
        try {
            ++this.nEventFuncionCalls;
            this.eventFuncLo = this.f.checkEvent(this.tLo, this.y);
        }
        catch (Exception ex) {
            throw new Exception("At t = " + this.tn + ", the rootfinding routine failed in an unrecoverable manner.");
        }
        boolean rootFound = false;
        for (i = 0; i < this.eventNumber; ++i) {
            this.eventInfo[i] = 0;
        }
        for (i = 0; i < this.eventNumber; ++i) {
            if (!this.eventActive[i] || Math.abs(this.eventFuncLo[i]) != 0.0) continue;
            rootFound = true;
            this.eventInfo[i] = 1;
        }
        if (!rootFound) {
            return false;
        }
        this.eventTol = (Math.abs(this.tn) + Math.abs(this.h)) * 2.220446049250313E-14;
        double smallh = this.h > 0.0 ? this.eventTol : -this.eventTol;
        this.tLo += smallh;
        if ((this.tLo - this.tn) * this.h >= 0.0) {
            VectorUtils.linearSum(smallh / this.h, this.z[1], this.y);
        } else {
            this.getDky(this.tLo, 0, this.y);
        }
        try {
            ++this.nEventFuncionCalls;
            this.eventFuncLo = this.f.checkEvent(this.tLo, this.y);
        }
        catch (Exception ex) {
            throw new Exception("At t = " + this.tn + ", the rootfinding routine failed in an unrecoverable manner.");
        }
        rootFound = false;
        for (int i2 = 0; i2 < this.eventNumber; ++i2) {
            if (Math.abs(this.eventFuncLo[i2]) != 0.0 || !this.eventActive[i2]) continue;
            if (this.eventInfo[i2] == 1) {
                throw new Exception("Root found at and very near t = " + this.tLo + ".");
            }
            rootFound = true;
            this.eventInfo[i2] = 1;
        }
        return rootFound;
    }

    private boolean checkRoot3(boolean oneStepMode) throws Exception {
        int i;
        if (oneStepMode) {
            this.tHi = this.tn;
            VectorUtils.copy(this.z[0], this.y);
        } else if ((this.toutCopy - this.tn) * this.h >= 0.0) {
            this.tHi = this.tn;
            VectorUtils.copy(this.z[0], this.y);
        } else {
            this.tHi = this.toutCopy;
            this.getDky(this.tHi, 0, this.y);
        }
        try {
            ++this.nEventFuncionCalls;
            this.eventFuncHi = this.f.checkEvent(this.tHi, this.y);
        }
        catch (Exception ex) {
            throw new Exception("At t = " + this.tLo + ", the rootfinding routine failed in an unrecoverable manner.");
        }
        this.eventTol = (Math.abs(this.tn) + Math.abs(this.h)) * 2.220446049250313E-14;
        boolean rootFound = this.rootfind();
        for (i = 0; i < this.eventNumber; ++i) {
            if (this.eventActive[i] || this.eventFuncRout[i] == 0.0) continue;
            this.eventActive[i] = true;
        }
        this.tLo = this.eventTime;
        for (i = 0; i < this.eventNumber; ++i) {
            this.eventFuncLo[i] = this.eventFuncRout[i];
        }
        if (rootFound) {
            this.getDky(this.eventTime, 0, this.y);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean rootfind() throws Exception {
        imax = 0;
        maxfrac = 0.0;
        rootFound = false;
        sgnchg = false;
        for (i = 0; i < this.eventNumber; ++i) {
            if (!this.eventActive[i]) continue;
            if (Math.abs(this.eventFuncHi[i]) == 0.0) {
                if (!((double)this.eventDirections[i] * this.eventFuncLo[i] <= 0.0)) continue;
                rootFound = true;
                continue;
            }
            if (!(this.eventFuncLo[i] * this.eventFuncHi[i] < 0.0) || !((double)this.eventDirections[i] * this.eventFuncLo[i] <= 0.0) || !((gfrac = Math.abs(this.eventFuncHi[i] / (this.eventFuncHi[i] - this.eventFuncLo[i]))) > maxfrac)) continue;
            sgnchg = true;
            maxfrac = gfrac;
            imax = i;
        }
        if (!sgnchg) {
            this.eventTime = this.tHi;
            for (i = 0; i < this.eventNumber; ++i) {
                this.eventFuncRout[i] = this.eventFuncHi[i];
            }
            if (!rootFound) {
                return false;
            }
            for (i = 0; i < this.eventNumber; ++i) {
                this.eventInfo[i] = 0;
                if (!this.eventActive[i] || Math.abs(this.eventFuncHi[i]) != 0.0) continue;
                this.eventInfo[i] = this.eventFuncLo[i] > 0.0 ? -1 : 1;
            }
            return true;
        }
        alpha = 1.0;
        side = 0;
        sideprev = -1;
        do lbl-1000:
        // 3 sources

        {
            block18: {
                if (Math.abs((tmid = this.tHi - (this.tHi - this.tLo) * this.eventFuncHi[imax] / (this.eventFuncHi[imax] - (alpha = sideprev == side ? (side == 2 ? alpha * 2.0 : alpha * 0.5) : 1.0) * this.eventFuncLo[imax])) - this.tLo) < 0.5 * this.eventTol) {
                    fracint = Math.abs(this.tHi - this.tLo) / this.eventTol;
                    fracsub = fracint > 5.0 || fracint == 0.0 ? 0.1 : 0.5 / fracint;
                    tmid = this.tLo + fracsub * (this.tHi - this.tLo);
                }
                if (Math.abs(this.tHi - tmid) < 0.5 * this.eventTol) {
                    fracint = Math.abs(this.tHi - this.tLo) / this.eventTol;
                    fracsub = fracint > 5.0 || fracint == 0.0 ? 0.1 : 0.5 / fracint;
                    tmid = this.tHi - fracsub * (this.tHi - this.tLo);
                }
                this.getDky(tmid, 0, this.y);
                try {
                    ++this.nEventFuncionCalls;
                    this.eventFuncRout = this.f.checkEvent(tmid, this.y);
                }
                catch (Exception ex) {
                    throw new Exception("At t = " + this.tn + ", the rootfinding routine failed in an unrecoverable manner.");
                }
                maxfrac = 0.0;
                rootFound = false;
                sgnchg = false;
                sideprev = side;
                for (i = 0; i < this.eventNumber; ++i) {
                    if (!this.eventActive[i]) continue;
                    if (Math.abs(this.eventFuncRout[i]) == 0.0) {
                        if (!((double)this.eventDirections[i] * this.eventFuncLo[i] <= 0.0)) continue;
                        rootFound = true;
                        continue;
                    }
                    if (!(this.eventFuncLo[i] * this.eventFuncRout[i] < 0.0) || !((double)this.eventDirections[i] * this.eventFuncLo[i] <= 0.0) || !((gfrac = Math.abs(this.eventFuncRout[i] / (this.eventFuncRout[i] - this.eventFuncLo[i]))) > maxfrac)) continue;
                    sgnchg = true;
                    maxfrac = gfrac;
                    imax = i;
                }
                if (!sgnchg) break block18;
                this.tHi = tmid;
                for (i = 0; i < this.eventNumber; ++i) {
                    this.eventFuncHi[i] = this.eventFuncRout[i];
                }
                side = 1;
                if (!(Math.abs(this.tHi - this.tLo) <= this.eventTol)) ** GOTO lbl-1000
                break;
            }
            if (rootFound) {
                this.tHi = tmid;
                for (i = 0; i < this.eventNumber; ++i) {
                    this.eventFuncHi[i] = this.eventFuncRout[i];
                }
                break;
            }
            this.tLo = tmid;
            for (i = 0; i < this.eventNumber; ++i) {
                this.eventFuncLo[i] = this.eventFuncRout[i];
            }
            side = 2;
        } while (!(Math.abs(this.tHi - this.tLo) <= this.eventTol));
        this.eventTime = this.tHi;
        for (i = 0; i < this.eventNumber; ++i) {
            this.eventFuncRout[i] = this.eventFuncHi[i];
            this.eventInfo[i] = 0;
            if (!this.eventActive[i] || Math.abs(this.eventFuncHi[i]) != 0.0 && !(this.eventFuncLo[i] * this.eventFuncHi[i] < 0.0) || !((double)this.eventDirections[i] * this.eventFuncLo[i] <= 0.0)) continue;
            this.eventInfo[i] = this.eventFuncLo[i] > 0.0 ? -1 : 1;
        }
        return true;
    }

    protected static void processError(String msgfmt) {
        log.info(msgfmt);
    }

    @Override
    int init() {
        return 0;
    }

    @Override
    int setup(int convfail) {
        return 0;
    }

    @Override
    int solve(double[] b) {
        return 0;
    }

    public void setDetectIncorrectNumbers(boolean detectIncorrectNumbers) {
        this.detectIncorrectNumbers = detectIncorrectNumbers;
    }
}

