/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.ode.jvode.VectorUtils;

public class IterativeUtils {
    public static final int PREC_NONE = 0;
    public static final int PREC_LEFT = 1;
    public static final int PREC_RIGHT = 2;
    public static final int PREC_BOTH = 3;
    public static final int MODIFIED_GS = 1;
    public static final int CLASSICAL_GS = 2;

    public static double ModifiedGS(double[][] v, double[][] h, int k, int p) {
        double new_product;
        int i0;
        double vk_norm = Math.sqrt(VectorUtils.dotProd(v[k], v[k]));
        int k_minus_1 = k - 1;
        for (int i = i0 = Math.max(k - p, 0); i < k; ++i) {
            h[i][k_minus_1] = VectorUtils.dotProd(v[i], v[k]);
            VectorUtils.linearSum(-h[i][k_minus_1], v[i], v[k]);
        }
        double temp = 1000.0 * vk_norm;
        double new_vk_norm = Math.sqrt(VectorUtils.dotProd(v[k], v[k]));
        if (temp + new_vk_norm != temp) {
            return 0.0;
        }
        double new_norm_2 = 0.0;
        for (int i = i0; i < k; ++i) {
            temp = 1000.0 * h[i][k_minus_1];
            new_product = VectorUtils.dotProd(v[i], v[k]);
            if (temp + new_product == temp) continue;
            double[] dArray = h[i];
            int n = k_minus_1;
            dArray[n] = dArray[n] + new_product;
            VectorUtils.linearSum(-new_product, v[i], v[k]);
            new_norm_2 += Math.pow(new_product, 2.0);
        }
        if (new_norm_2 != 0.0) {
            new_product = Math.pow(new_vk_norm, 2.0) - new_norm_2;
            new_vk_norm = new_product > 0.0 ? Math.sqrt(new_product) : 0.0;
        }
        return new_vk_norm;
    }

    public static double ClassicalGS(double[][] v, double[][] h, int k, int p, double[] temp, double[] s) {
        int i0;
        int i;
        int k_minus_1 = k - 1;
        double vk_norm = Math.sqrt(VectorUtils.dotProd(v[k], v[k]));
        for (i = i0 = Math.max(k - p, 0); i < k; ++i) {
            h[i][k_minus_1] = VectorUtils.dotProd(v[i], v[k]);
        }
        for (i = i0; i < k; ++i) {
            VectorUtils.linearSum(-h[i][k_minus_1], v[i], v[k]);
        }
        double new_vk_norm = Math.sqrt(VectorUtils.dotProd(v[k], v[k]));
        if (1000.0 * new_vk_norm < vk_norm) {
            int i2;
            for (i2 = i0; i2 < k; ++i2) {
                s[i2] = VectorUtils.dotProd(v[i2], v[k]);
            }
            if (i0 < k) {
                VectorUtils.scale(s[i0], v[i0], temp);
                double[] dArray = h[i0];
                int n = k_minus_1;
                dArray[n] = dArray[n] + s[i0];
            }
            for (i2 = i0 + 1; i2 < k; ++i2) {
                VectorUtils.linearSum(s[i2], v[i2], temp);
                double[] dArray = h[i2];
                int n = k_minus_1;
                dArray[n] = dArray[n] + s[i2];
            }
            VectorUtils.linearDiff(v[k], temp, v[k]);
            new_vk_norm = Math.sqrt(VectorUtils.dotProd(v[k], v[k]));
        }
        return new_vk_norm;
    }

    public static int QRfact(int n, double[][] h, double[] q, int job) {
        int code = 0;
        switch (job) {
            case 0: {
                code = 0;
                for (int k = 0; k < n; ++k) {
                    double temp3;
                    double s;
                    double c;
                    double temp2;
                    double temp1;
                    for (int j = 0; j < k - 1; ++j) {
                        int i = 2 * j;
                        temp1 = h[j][k];
                        temp2 = h[j + 1][k];
                        c = q[i];
                        s = q[i + 1];
                        h[j][k] = c * temp1 - s * temp2;
                        h[j + 1][k] = s * temp1 + c * temp2;
                    }
                    int q_ptr = 2 * k;
                    temp1 = h[k][k];
                    temp2 = h[k + 1][k];
                    if (temp2 == 0.0) {
                        c = 1.0;
                        s = 0.0;
                    } else if (Math.abs(temp2) >= Math.abs(temp1)) {
                        temp3 = temp1 / temp2;
                        s = -1.0 / Math.sqrt(1.0 + temp3 * temp3);
                        c = -s * temp3;
                    } else {
                        temp3 = temp2 / temp1;
                        c = 1.0 / Math.sqrt(1.0 + temp3 * temp3);
                        s = -c * temp3;
                    }
                    q[q_ptr] = c;
                    q[q_ptr + 1] = s;
                    h[k][k] = c * temp1 - s * temp2;
                    if (h[k][k] != 0.0) continue;
                    code = k + 1;
                }
                break;
            }
            default: {
                double s;
                double c;
                double temp2;
                double temp1;
                int n_minus_1 = n - 1;
                code = 0;
                for (int k = 0; k < n_minus_1; ++k) {
                    int i = 2 * k;
                    temp1 = h[k][n_minus_1];
                    temp2 = h[k + 1][n_minus_1];
                    c = q[i];
                    s = q[i + 1];
                    h[k][n_minus_1] = c * temp1 - s * temp2;
                    h[k + 1][n_minus_1] = s * temp1 + c * temp2;
                }
                temp1 = h[n_minus_1][n_minus_1];
                temp2 = h[n][n_minus_1];
                if (temp2 == 0.0) {
                    c = 1.0;
                    s = 0.0;
                } else if (Math.abs(temp2) >= Math.abs(temp1)) {
                    double temp3 = temp1 / temp2;
                    s = -1.0 / Math.sqrt(1.0 + temp3 * temp3);
                    c = -s * temp3;
                } else {
                    double temp3 = temp2 / temp1;
                    c = 1.0 / Math.sqrt(1.0 + temp3 * temp3);
                    s = -c * temp3;
                }
                int q_ptr = 2 * n_minus_1;
                q[q_ptr] = c;
                q[q_ptr + 1] = s;
                h[n_minus_1][n_minus_1] = c * temp1 - s * temp2;
                if (h[n_minus_1][n_minus_1] != 0.0) break;
                code = n;
            }
        }
        return code;
    }

    public static int QRsol(int n, double[][] h, double[] q, double[] b) {
        int k;
        int code = 0;
        for (k = 0; k < n; ++k) {
            int q_ptr = 2 * k;
            double c = q[q_ptr];
            double s = q[q_ptr + 1];
            double temp1 = b[k];
            double temp2 = b[k + 1];
            b[k] = c * temp1 - s * temp2;
            b[k + 1] = s * temp1 + c * temp2;
        }
        for (k = n - 1; k >= 0; --k) {
            if (h[k][k] == 0.0) {
                code = k + 1;
                break;
            }
            int n2 = k;
            b[n2] = b[n2] / h[k][k];
            for (int i = 0; i < k; ++i) {
                int n3 = i;
                b[n3] = b[n3] - b[k] * h[i][k];
            }
        }
        return code;
    }
}

