/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode.jvode;

import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.jvode.JVode;
import biouml.plugins.simulation.ode.jvode.JVodeSupport;
import biouml.plugins.simulation.ode.jvode.Matrix;
import biouml.plugins.simulation.ode.jvode.MatrixUtils;
import biouml.plugins.simulation.ode.jvode.VectorUtils;

public abstract class IterativeSolver
extends JVode {
    public static final int MAX_ITERS = 3;
    public static final int PREC_NONE = 0;
    public static final int PREC_LEFT = 1;
    public static final int PREC_RIGHT = 2;
    public static final int PREC_BOTH = 3;
    public static final int MODIFIED_GS = 1;
    public static final int CLASSICAL_GS = 2;
    public static final int CVSPILS_SUCCESS = 0;
    public static final int CVSPILS_MEM_NULL = -1;
    public static final int CVSPILS_LMEM_NULL = -2;
    public static final int CVSPILS_ILL_INPUT = -3;
    public static final int CVSPILS_MEM_FAIL = -4;
    public static final int CVSPILS_PMEM_NULL = -5;
    public static final int CVSPILS_MAXL = 5;
    public static final int CVSPILS_MSBPRE = 50;
    public static final double CVSPILS_DGMAX = 0.2;
    public static final double CVSPILS_EPLIN = 0.05;
    public static final int SPILS_SPGMR = 1;
    public static final int SPILS_SPBCG = 2;
    public static final int SPILS_SPTFQMR = 3;
    public static final String MSGS_CVMEM_NULL = "Integrator memory is NULL.";
    public static final String MSGS_MEM_FAIL = "A memory request failed.";
    public static final String MSGS_BAD_NVECTOR = "A required vector operation is not implemented.";
    public static final String MSGS_BAD_LSTYPE = "Incompatible linear solver type.";
    public static final String MSGS_BAD_PRETYPE = "Illegal value for pretype. Legal values are PREC_NONE, PREC_LEFT, PREC_RIGHT, and PREC_BOTH.";
    public static final String MSGS_PSOLVE_REQ = "pretype != PREC_NONE, but PSOLVE = NULL is illegal.";
    public static final String MSGS_LMEM_NULL = "Linear solver memory is NULL.";
    public static final String MSGS_BAD_GSTYPE = "Illegal value for gstype. Legal values are MODIFIED_GS and CLASSICAL_GS.";
    public static final String MSGS_BAD_EPLIN = "eplifac < 0 illegal.";
    public static final String MSGS_PSET_FAILED = "The preconditioner setup routine failed in an unrecoverable manner.";
    public static final String MSGS_PSOLVE_FAILED = "The preconditioner solve routine failed in an unrecoverable manner.";
    public static final String MSGS_JTIMES_FAILED = "The Jacobian x vector routine failed in an unrecoverable manner.";
    Precondition precondition;
    int s_type;
    int s_pretype;
    int s_gstype;
    double s_sqrtN;
    double s_eplifac;
    double s_deltar;
    double s_delta;
    int s_maxl;
    public int s_nstlpre;
    public int s_npe;
    public int s_nli;
    public int s_nps;
    public int s_ncfl;
    public int s_njtimes;
    public int s_nfes;
    double[] s_ytemp;
    double[] s_x;
    double[] s_ycur;
    double[] s_fcur;
    int lastFlag;

    public IterativeSolver(JVodeSupport.Method method, OdeModel f, double[] u0, double t0) {
        super(method, f, u0, t0);
    }

    void setPrecType(int pretype) {
        if (pretype != 0 && pretype != 1 && pretype != 2 && pretype != 3) {
            throw new IllegalArgumentException(MSGS_BAD_PRETYPE);
        }
        this.s_pretype = pretype;
    }

    public void setGSType(int gstype) {
        if (gstype != 1 && gstype != 2) {
            throw new IllegalArgumentException(MSGS_BAD_GSTYPE);
        }
        this.s_gstype = gstype;
    }

    void setMaxl(int maxl) throws Exception {
        if (this.s_type == 1) {
            throw new Exception(MSGS_BAD_LSTYPE);
        }
        this.s_maxl = maxl <= 0 ? 5 : maxl;
    }

    void setEpsLin(double eplifac) {
        if (eplifac < 0.0) {
            throw new IllegalArgumentException(MSGS_BAD_EPLIN);
        }
        this.s_eplifac = eplifac == 0.0 ? 0.05 : eplifac;
    }

    public void setBandPreconditioner(int n, int mu, int ml) throws Exception {
        this.precondition = new BandPrecondition(n, mu, ml);
    }

    public void setPreconditioner(Precondition precondition) {
        this.precondition = precondition;
    }

    public Precondition getPrecondition() {
        return this.precondition;
    }

    int getLastFlag(Object cvode_mem) {
        return this.lastFlag;
    }

    public int atimes(double[] v, double[] z) throws Exception {
        double[] temp = this.jTimes(v, this.tn, this.s_ycur, this.s_fcur, this.s_ytemp);
        ++this.s_njtimes;
        VectorUtils.linearSum(-this.gamma, temp, v, z);
        return 0;
    }

    public int pSolve(double[] r, double[] z, int lr) {
        return this.precondition.solve(this.tn, this.s_ycur, this.s_fcur, r, z, this.gamma, this.s_delta, lr, this.s_ytemp);
    }

    public double[] jTimes(double[] v, double t, double[] y, double[] fy, double[] work) throws Exception {
        double sig = 1.0 / VectorUtils.wrmsNorm(v, this.errorWeight);
        double[] z = new double[y.length];
        for (int iter = 0; iter < 3; ++iter) {
            VectorUtils.linearSum(sig, v, y, work);
            try {
                ++this.s_nfes;
                z = this.f.dy_dt(t, work);
                break;
            }
            catch (IllegalArgumentException ex) {
                sig *= 0.25;
                continue;
            }
        }
        double siginv = 1.0 / sig;
        VectorUtils.scaleDiff(siginv, z, fy, z);
        return z;
    }

    public static interface Precondition {
        public int setup(double var1, double[] var3, double[] var4, boolean var5, double var6);

        public int solve(double var1, double[] var3, double[] var4, double[] var5, double[] var6, double var7, double var9, int var11, double[] var12);
    }

    public class BandPrecondition
    implements Precondition {
        public static final double MIN_INC_MULT = 1000.0;
        int N;
        int ml;
        int mu;
        Matrix savedJ;
        Matrix savedP;
        int[] pivots;
        int nfeBP;

        public BandPrecondition(int N, int mu, int ml) throws Exception {
            int mlp;
            int mup;
            this.N = N;
            this.mu = mup = Math.min(N - 1, Math.max(0, mu));
            this.ml = mlp = Math.min(N - 1, Math.max(0, ml));
            this.nfeBP = 0;
            this.savedJ = new Matrix(N, mup, mlp, mup);
            int storagemu = Math.min(N - 1, mup + mlp);
            this.savedP = new Matrix(N, mup, mlp, storagemu);
            this.pivots = new int[N];
        }

        public int getNumRhsEvals() {
            return this.nfeBP;
        }

        @Override
        public int setup(double t, double[] y, double[] fy, boolean jok, double gamma) {
            if (jok) {
                this.savedJ.bandCopy(this.savedP, this.mu, this.ml);
            } else {
                this.savedJ.setToZero();
                try {
                    this.BandPDQJac(t, y, fy);
                }
                catch (IllegalArgumentException ex) {
                    return 1;
                }
                catch (Exception ex) {
                    return -1;
                }
                this.savedJ.bandCopy(this.savedP, this.mu, this.ml);
            }
            this.savedP.scale(-gamma);
            this.savedP.addIdentity();
            int retval = MatrixUtils.BandGBTRF(this.savedP, this.pivots);
            if (retval > 0) {
                return 1;
            }
            return 0;
        }

        @Override
        public int solve(double t, double[] y, double[] fy, double[] r, double[] z, double gamma, double delta, int lr, double[] tmp) {
            VectorUtils.copy(r, z);
            MatrixUtils.BandGBTRS(this.savedP, this.pivots, z);
            return 0;
        }

        void BandPDQJac(double t, double[] y, double[] fy) throws Exception {
            double[] ytemp = new double[y.length];
            VectorUtils.copy(y, ytemp);
            double fnorm = VectorUtils.wrmsNorm(fy, IterativeSolver.this.errorWeight);
            double minInc = fnorm != 1.0 ? 1000.0 * Math.abs(IterativeSolver.this.h) * 2.220446049250313E-16 * (double)this.N * fnorm : 1.0;
            int width = this.ml + this.mu + 1;
            int ngroups = Math.min(width, this.N);
            for (int group = 1; group <= ngroups; ++group) {
                double inc;
                int j;
                for (j = group - 1; j < this.N; j += width) {
                    inc = Math.max(JVodeSupport.UROUND_SQRT * Math.abs(y[j]), minInc / IterativeSolver.this.errorWeight[j]);
                    int n = j;
                    ytemp[n] = ytemp[n] + inc;
                }
                IterativeSolver.this.temp = IterativeSolver.this.f.dy_dt(t, ytemp);
                ++this.nfeBP;
                for (j = group - 1; j < this.N; j += width) {
                    ytemp[j] = y[j];
                    inc = Math.max(JVodeSupport.UROUND_SQRT * Math.abs(y[j]), minInc / IterativeSolver.this.errorWeight[j]);
                    double inc_inv = 1.0 / inc;
                    int i1 = Math.max(0, j - this.mu);
                    int i2 = Math.min(j + this.ml, this.N - 1);
                    for (int i = i1; i <= i2; ++i) {
                        this.savedJ.setBandElement(i, j, inc_inv * (IterativeSolver.this.temp[i] - fy[i]));
                    }
                }
            }
        }
    }
}

