/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode;

import java.util.Arrays;

public class StdMet {
    public static void printArray(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(a[i] + "   ");
        }
    }

    public static String toString(double[] a) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            stringBuilder.append(a[i]);
            stringBuilder.append("   ");
        }
        return stringBuilder.toString();
    }

    public static void zeroArray(double[] a) {
        Arrays.fill(a, 0.0);
    }

    public static void copyArray(double[] a, double[] b) throws Exception {
        if (a.length != b.length) {
            throw new Exception("array dimensions don't agree");
        }
        System.arraycopy(b, 0, a, 0, b.length);
    }

    public static double[] copyArray(double[] b) throws Exception {
        double[] a = new double[b.length];
        System.arraycopy(b, 0, a, 0, b.length);
        return a;
    }

    public static void copyMatrix(double[][] a, double[][] b) throws Exception {
        int an = a[0].length;
        int bn = b[0].length;
        if (an != bn || a.length != b.length) {
            throw new Exception("matrix dimensions don't agree");
        }
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < an; ++j) {
                a[i][j] = b[i][j];
            }
        }
    }

    public static double[][] copyMatrix(double[][] b) throws Exception {
        int n = b[0].length;
        double[][] a = new double[b.length][n];
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < n; ++j) {
                a[i][j] = b[i][j];
            }
        }
        return a;
    }

    public static void stam(double[] result, double scalar, double[] array) throws Exception {
        if (result.length != array.length) {
            throw new Exception("array dimensions don't agree");
        }
        for (int i = 0; i < array.length; ++i) {
            result[i] = scalar * array[i];
        }
    }

    public static void arraySum(double[] c, double[] a, double[] b) throws Exception {
        if (a.length != b.length || a.length != c.length) {
            throw new Exception("array dimensions don't agree");
        }
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] + b[i];
        }
    }

    public static void arrayDiff(double[] c, double[] a, double[] b) throws Exception {
        if (a.length != b.length || a.length != c.length) {
            throw new Exception("array dimensions don't agree");
        }
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] - b[i];
        }
    }

    public static void dotProduct(double[] result, double[] a, double[] b) throws Exception {
        if (result.length != a.length || result.length != b.length) {
            throw new Exception("array dimensions don't agree");
        }
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * b[i];
        }
    }

    public static void dotQuo(double[] result, double[] a, double[] b) throws Exception {
        if (result.length != a.length || result.length != b.length) {
            throw new Exception("array dimensions don't agree");
        }
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] / b[i];
        }
    }

    public static void matrixVectorProduct(double[] result, double[][] matrix, double[] array) throws Exception {
        if (matrix[0].length != array.length || result.length != array.length) {
            throw new Exception("array dimensions don't agree");
        }
        for (int i = 0; i < array.length; ++i) {
            double sigma = 0.0;
            double[] matrix_ith_row = matrix[i];
            for (int j = 0; j < array.length; ++j) {
                sigma += matrix_ith_row[j] * array[j];
            }
            result[i] = sigma;
        }
    }

    public static double normInf(double[] vector) {
        double max = -1.7976931348623157E308;
        for (int i = 0; i < vector.length; ++i) {
            double abs = Math.abs(vector[i]);
            if (!(abs > max)) continue;
            max = abs;
        }
        return max;
    }

    public static double normRMS(double[] vector) {
        double sum = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            double v = vector[i];
            sum += v * v;
        }
        return Math.sqrt(sum /= (double)vector.length);
    }

    public static double normEuclidean(double[] vector) {
        double sum = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            double v = vector[i];
            sum += v * v;
        }
        return Math.sqrt(sum);
    }

    public static void epsilon(double[] result, double[] xn, double[] xnPlusOne, double atol, double rtol) throws Exception {
        if (result.length != xn.length || result.length != xnPlusOne.length) {
            throw new Exception("array dimensions don't agree");
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = atol + Math.max(Math.abs(xn[i]), Math.abs(xnPlusOne[i])) * rtol;
        }
    }

    public static void tau(double[] result, double[] xn, double[] xnPlusOne, double[] atol, double[] rtol) throws Exception {
        if (result.length != xn.length || result.length != xnPlusOne.length || result.length != atol.length || result.length != rtol.length) {
            throw new Exception("array dimensions don't agree");
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = atol[i] + Math.max(Math.abs(xn[i]), Math.abs(xnPlusOne[i])) * rtol[i];
        }
    }

    public static double[] generateArray(double value, int length) throws IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException("Negative array length " + length);
        }
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = value;
        }
        return result;
    }
}

