/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode;

import biouml.plugins.simulation.ode.Btableau;
import biouml.plugins.simulation.ode.Btheta;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.StdMet;

public class RootFinder {
    private OdeModel f;
    private Btableau butcher;
    private double h;
    private double told;
    private int n;
    private double[] xold;
    private int s;
    private double[][] K;
    private boolean thetaStarFound;
    private double thetaStar;
    private double secError;
    private double gAtTStar;
    private double[] sigmaInterp;
    private double[] x_interp;
    private double[] stam1;
    public static final double SECTOL = 1.0E-10;

    public RootFinder(OdeModel function, Btableau butcher, double h, double told, double[] xold, double[][] K) {
        this.f = function;
        this.butcher = butcher;
        this.h = h;
        this.told = told;
        this.n = xold.length;
        this.s = butcher.getbl();
        this.xold = xold;
        this.s = butcher.getbl();
        this.K = K;
    }

    public double safeguarded_secant(int i, double ga, double gb) throws Exception {
        this.sigmaInterp = new double[this.n];
        this.x_interp = new double[this.n];
        this.stam1 = new double[this.n];
        this.thetaStarFound = false;
        double thetaA = 0.0;
        double thetaB = 1.0;
        if (ga == 0.0) {
            this.thetaStarFound = true;
            this.thetaStar = thetaA;
        } else if (gb == 0.0) {
            this.thetaStarFound = true;
            this.thetaStar = thetaB;
        }
        this.secError = Math.abs(thetaB - thetaA);
        while (!this.thetaStarFound && this.secError > 1.0E-10) {
            int j;
            this.thetaStar = thetaB - gb * (thetaB - thetaA) / (gb - ga);
            Btheta btheta = this.butcher.get_btheta();
            if (this.thetaStar <= thetaA || this.thetaStar >= thetaB) {
                this.thetaStar = 0.5 * (thetaA + thetaB);
                for (j = 0; j < this.s; ++j) {
                    StdMet.stam(this.stam1, this.h * btheta.f(this.thetaStar)[j], this.K[j]);
                    StdMet.arraySum(this.sigmaInterp, this.sigmaInterp, this.stam1);
                }
                StdMet.arraySum(this.x_interp, this.xold, this.sigmaInterp);
                StdMet.zeroArray(this.sigmaInterp);
                this.gAtTStar = this.f.checkEvent(this.told + this.h * this.thetaStar, this.x_interp)[i];
                if (this.gAtTStar == 0.0) {
                    this.thetaStarFound = true;
                }
                if (ga * this.gAtTStar >= 0.0) {
                    thetaA = this.thetaStar;
                } else {
                    thetaB = this.thetaStar;
                }
                this.secError = thetaB - thetaA;
                continue;
            }
            this.secError = Math.abs(this.thetaStar - thetaB) + 2.5E-11;
            for (j = 0; j < this.s; ++j) {
                StdMet.stam(this.stam1, this.h * btheta.f(this.thetaStar)[j], this.K[j]);
                StdMet.arraySum(this.sigmaInterp, this.sigmaInterp, this.stam1);
            }
            StdMet.arraySum(this.x_interp, this.xold, this.sigmaInterp);
            StdMet.zeroArray(this.sigmaInterp);
            this.gAtTStar = this.f.checkEvent(this.told + this.h * this.thetaStar, this.x_interp)[i];
            if (this.gAtTStar == 0.0) {
                this.thetaStarFound = true;
            }
            if (ga * this.gAtTStar >= 0.0) {
                thetaA = this.thetaStar;
                continue;
            }
            thetaB = this.thetaStar;
        }
        return this.thetaStar;
    }
}

