/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode;

import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.StdMet;

public class Initsss {
    private OdeModel f;
    private double t0;
    private double tf;
    private double[] x0;
    private double[] atol;
    private double[] rtol;
    private double hmax;
    private double hmin;
    private double htry;
    private double absh;
    private double rh;
    private double h;
    private double[] threshold;
    private double[] aRtolPow;
    private double[] max;
    private double[] f0;
    private double[] fOverMax;
    private double maxStep;
    private static final double ALPHA = 0.8;
    private static final double POW = 0.2;
    private static final double EPS = 2.220446049250313E-16;

    public Initsss(OdeModel function, Span tspan, double[] x0, double[] atol, double[] rtol) throws Exception {
        int i;
        this.f = function;
        this.t0 = tspan.getTimeStart();
        this.tf = tspan.getTimeFinal();
        this.x0 = new double[x0.length];
        this.atol = new double[atol.length];
        this.rtol = new double[rtol.length];
        StdMet.copyArray(this.x0, x0);
        StdMet.copyArray(this.atol, atol);
        StdMet.copyArray(this.rtol, rtol);
        this.hmax = Math.abs(0.1 * (this.tf - this.t0));
        this.hmin = 3.552713678800501E-15 * this.t0;
        this.absh = this.hmax;
        this.threshold = new double[atol.length];
        StdMet.dotQuo(this.threshold, atol, rtol);
        this.aRtolPow = new double[rtol.length];
        for (i = 0; i < rtol.length; ++i) {
            this.aRtolPow[i] = Math.pow(rtol[i], 0.2);
        }
        StdMet.stam(this.aRtolPow, 0.8, this.aRtolPow);
        this.max = new double[x0.length];
        for (i = 0; i < x0.length; ++i) {
            this.max[i] = Math.max(Math.abs(x0[i]), this.threshold[i]);
        }
        this.f0 = this.f.dy_dt(this.t0, x0);
        this.fOverMax = new double[this.f0.length];
        StdMet.dotQuo(this.fOverMax, this.f0, this.max);
        double normF = StdMet.normInf(this.fOverMax);
        double normR = StdMet.normInf(this.aRtolPow);
        this.rh = normF / normR;
        if (this.absh * this.rh > 1.0) {
            this.absh = 1.0 / this.rh;
        }
        this.h = this.absh = Math.max(this.absh, this.hmin);
    }

    public Initsss(OdeModel function, Span tspan, double[] x0, double[] atol, double[] rtol, double maxStep) throws Exception {
        int i;
        this.f = function;
        this.t0 = tspan.getTimeStart();
        this.tf = tspan.getTimeFinal();
        this.x0 = new double[x0.length];
        this.atol = new double[atol.length];
        this.rtol = new double[rtol.length];
        StdMet.copyArray(this.x0, x0);
        StdMet.copyArray(this.atol, atol);
        StdMet.copyArray(this.rtol, rtol);
        this.maxStep = maxStep;
        this.hmax = Math.min(Math.abs(this.tf - this.t0), Math.abs(maxStep));
        this.hmin = 3.552713678800501E-15 * this.t0;
        this.absh = this.hmax;
        this.threshold = new double[atol.length];
        StdMet.dotQuo(this.threshold, atol, rtol);
        this.aRtolPow = new double[rtol.length];
        for (i = 0; i < rtol.length; ++i) {
            this.aRtolPow[i] = Math.pow(rtol[i], 0.2);
        }
        StdMet.stam(this.aRtolPow, 0.8, this.aRtolPow);
        this.max = new double[x0.length];
        for (i = 0; i < x0.length; ++i) {
            this.max[i] = Math.max(Math.abs(x0[i]), this.threshold[i]);
        }
        this.f0 = this.f.dy_dt(this.t0, x0);
        this.fOverMax = new double[this.f0.length];
        StdMet.dotQuo(this.fOverMax, this.f0, this.max);
        double normF = StdMet.normInf(this.fOverMax);
        double normR = StdMet.normInf(this.aRtolPow);
        this.rh = normF / normR;
        if (this.absh * this.rh > 1.0) {
            this.absh = 1.0 / this.rh;
        }
        this.h = this.absh = Math.max(this.absh, this.hmin);
    }

    public double get_h() {
        return this.h;
    }
}

