/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode;

import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.OdeSimulatorOptions;
import biouml.plugins.simulation.OdeSimulatorOptionsBeanInfo;
import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.SimulatorInfo;
import biouml.plugins.simulation.SimulatorSupport;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.ode.Btableau;
import biouml.plugins.simulation.ode.ErrorEstimator;
import biouml.plugins.simulation.ode.EventDetector;
import biouml.plugins.simulation.ode.Imex1S;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.StdMet;
import biouml.standard.simulation.ResultListener;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import ru.biosoft.jobcontrol.FunctionJobControl;

public class ImexSD
extends SimulatorSupport {
    private Btableau butcher;
    private Imex1S engine;
    private int stepNum;
    private int stepLimit;
    private double t0;
    private double tFinal;
    private double tfBackup;
    private double tNew;
    private double atol;
    private double rtol;
    private double h;
    private boolean interpolate;
    private double tOld;
    private double[] u0;
    private double[] xOld;
    private double[] xNew;
    private double hNew;
    private boolean troubleFlag;
    private static final double alpha = 0.9;
    private double maxStepFactor = 5.0;
    private double minStepFactor = 0.2;
    private double p;
    private int nreject;
    private int naccept;
    private boolean eventOccured;
    private EventDetector eventDetector;
    private int nextSpanPointIndex;
    private static final double MIN_FRAGMENTATION = 1.0E15;
    ImexOptions options = (ImexOptions)((Object)this.getDefaultOptions());

    public ImexSD() throws Exception {
        this.butcher = new Btableau("imex443");
        this.engine = new Imex1S(this.butcher);
    }

    @Override
    public SimulatorInfo getInfo() {
        SimulatorInfo info = new SimulatorInfo();
        info.name = "Imex";
        info.eventsSupport = true;
        return info;
    }

    @Override
    public Object getDefaultOptions() {
        return new ImexOptions(0.01, true, "Off");
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Options options) {
        if (!(options instanceof ImexOptions)) {
            throw new IllegalArgumentException("Only ImexOptions are compatible with Imex simulator");
        }
        this.options = (ImexOptions)options;
    }

    @Override
    public int[] getEvents() {
        return this.eventDetector != null ? this.eventDetector.getEventInfo() : null;
    }

    @Override
    public boolean doStep() throws Exception {
        this.init(this.odeModel, this.u0, this.span, this.resultListeners, this.jobControl);
        this.routine();
        return !this.troubleFlag && !(this.tNew >= this.tFinal);
    }

    @Override
    public void init(Model model, double[] u0, Span tspan, ResultListener[] listeners, FunctionJobControl jobControl) throws Exception {
        if (!tspan.isProper()) {
            throw new Exception("Improper span: times are out of order");
        }
        this.span = tspan;
        this.odeModel = (OdeModel)model;
        if (!this.odeModel.isInit()) {
            this.odeModel.init();
        }
        this.jobControl = jobControl;
        this.t0 = tspan.getTimeStart();
        this.tFinal = tspan.getTimeFinal();
        this.tOld = this.t0;
        this.tNew = this.t0;
        this.atol = this.options.getAtol();
        this.rtol = this.options.getRtol();
        this.h = this.options.getInitialStep();
        this.minStepFactor = this.options.minStepFactor;
        this.maxStepFactor = this.options.maxStepFactor;
        this.stepLimit = this.options.stepLimit;
        this.hNew = this.h;
        this.p = 3.0;
        this.nreject = 0;
        this.naccept = 0;
        this.u0 = StdMet.copyArray(u0);
        this.xOld = StdMet.copyArray(u0);
        this.xNew = StdMet.copyArray(u0);
        this.locateEvents = this.options.getEventLocation();
        this.eventDetector = new EventDetector(this.odeModel, this);
        this.eventOccured = false;
        this.resultListeners = listeners;
        this.interpolate = this.span.getLength() > 1;
        this.nextSpanPointIndex = 1;
        this.stepNum = 0;
        this.profile.setUnstable(false);
        this.profile.setStiff(false);
        this.troubleFlag = false;
    }

    public void routine() throws Exception {
        this.outStatistics("Starting simulation", "Atol: " + this.atol, "Rtol:" + this.rtol, "Initial step:" + this.h);
        if (this.fireInitialValues || this.eventAtSpanPoint) {
            this.fireSolutionUpdate(this.t0, this.u0);
            this.fireInitialValues = false;
            this.eventAtSpanPoint = false;
        }
        double minStepSize = (this.tFinal - this.t0) / 1.0E15;
        this.troubleFlag = false;
        while (this.tNew < this.tFinal) {
            if (this.terminated || this.jobControl != null && this.jobControl.getStatus() == 4) {
                return;
            }
            if (this.stepNum > this.stepLimit) {
                this.troubleFlag = true;
                this.outError("Step limit " + this.stepLimit + " exceeded.");
                this.profile.setUnstable(true);
                return;
            }
            ++this.stepNum;
            if (this.locateEvents) {
                this.eventDetector.detectEvent(this.xOld, this.tOld, this.h);
                this.eventOccured = this.eventDetector.isEventDetected();
                if (this.eventOccured) {
                    this.xNew = this.eventDetector.getEventX();
                    this.tNew = this.eventDetector.getEventTime();
                    this.h *= this.eventDetector.getTheta();
                    this.tfBackup = this.tFinal;
                    this.tFinal = this.tOld + this.h;
                }
            }
            if (!this.eventOccured) {
                this.xNew = this.engine.doOneStep(this.odeModel, this.tOld, this.xOld, this.h / 2.0);
                this.xNew = this.engine.doOneStep(this.odeModel, this.tOld + this.h / 2.0, this.xNew, this.h / 2.0);
            }
            this.tNew = this.tOld + this.h;
            boolean success = this.checkError();
            if (this.troubleFlag) {
                return;
            }
            if (this.eventOccured) {
                if (success) {
                    this.outputSolution();
                    ++this.naccept;
                    this.outIntermediate("Event detected at t = " + this.tNew, "Final t = " + this.tOld, "Final u = " + StdMet.toString(this.xNew), "Rejected: " + this.nreject, "Accepeted: " + this.naccept);
                    break;
                }
                ++this.nreject;
                this.tFinal = this.tfBackup;
                this.h /= 2.0;
                this.outStatistics("Step rejected, new h = " + this.h);
                continue;
            }
            if (!success) {
                this.h = this.hNew;
                ++this.nreject;
                this.outStatistics("Step rejected", "New h = " + this.h);
                continue;
            }
            if (this.h <= minStepSize) {
                this.outError("Can't calculate model with necessary precision");
                this.troubleFlag = true;
                this.profile.setStiff(true);
                if (this.jobControl != null) {
                    this.jobControl.terminate();
                }
                return;
            }
            this.outputSolution();
            ++this.naccept;
            StdMet.copyArray(this.xOld, this.xNew);
            this.tOld = this.tNew;
            this.outStatistics("Step accepted", "new h = " + this.h, "Solution = " + StdMet.toString(this.xNew));
        }
        this.profile.setTime(this.tNew);
        this.profile.setX(this.xNew);
    }

    protected void outputSolution() throws Exception {
        if (!this.interpolate) {
            this.fireSolutionUpdate(this.tNew, this.xNew);
            return;
        }
        double nextSpanPoint = this.span.getTime(this.nextSpanPointIndex);
        while (this.nextSpanPointIndex < this.span.getLength() && nextSpanPoint < this.tNew) {
            this.fireSolutionUpdate(nextSpanPoint, this.getSolution(nextSpanPoint));
            ++this.nextSpanPointIndex;
            if (this.nextSpanPointIndex >= this.span.getLength()) break;
            nextSpanPoint = this.span.getTime(this.nextSpanPointIndex);
        }
        if (nextSpanPoint == this.tNew) {
            if (this.eventOccured) {
                this.eventAtSpanPoint = true;
            } else {
                this.fireSolutionUpdate(nextSpanPoint, this.getSolution(nextSpanPoint));
                ++this.nextSpanPointIndex;
            }
        }
    }

    private double[] getSolution(double time) throws Exception {
        return this.engine.doOneStep(this.odeModel, this.tOld, this.xOld, time - this.tOld);
    }

    @Override
    public void integrationStep(double[] xNew, double[] xOld, double tOld, double h, double theta) throws Exception {
        StdMet.copyArray(xNew, this.engine.doOneStep(this.odeModel, tOld, xOld, h * theta));
    }

    private boolean checkError() throws Exception {
        try {
            double[] xe = this.engine.doOneStep(this.odeModel, this.tOld, this.xOld, this.h);
            double[] estimation = ErrorEstimator.stepdoublingEstimate(this.h, xe, this.xNew, this.xOld, this.atol, this.rtol, this.p, this.maxStepFactor, this.minStepFactor, 0.9);
            this.hNew = estimation[0];
            double hopt = estimation[1];
            double norm = estimation[2];
            if (Double.isNaN(norm)) {
                this.outError("Problem is unstable");
                this.outIntermediate("Accepted: " + this.naccept, "Rejected: " + this.nreject);
                if (this.jobControl != null) {
                    this.jobControl.functionFinished();
                }
                return false;
            }
            if (this.tFinal - this.tOld <= this.hNew) {
                this.hNew = this.tFinal - this.tOld;
            }
            return this.h / hopt <= 3.0;
        }
        catch (Exception ex) {
            this.outError("Error estimation failed: " + ex.getMessage());
            this.troubleFlag = true;
            return false;
        }
    }

    @Override
    public void setInitialValues(double[] x0) {
    }

    public static class ImexOptionsBeanInfo
    extends OdeSimulatorOptionsBeanInfo {
        public ImexOptionsBeanInfo() {
            super(ImexOptions.class);
        }

        @Override
        public void initProperties() throws Exception {
            super.initProperties();
            this.add("stepLimit");
            this.add("maxStepFactor");
            this.add("minStepFactor");
        }
    }

    public static class ImexOptions
    extends OdeSimulatorOptions {
        private int stepLimit = 100000;
        private double maxStepFactor = 5.0;
        private double minStepFactor = 0.2;

        @PropertyName(value="Steps limit")
        @PropertyDescription(value="Limitation for solver steps count.")
        public int getStepLimit() {
            return this.stepLimit;
        }

        public void setStepLimit(int stepLimit) {
            int oldValue = this.stepLimit;
            this.stepLimit = stepLimit;
            this.firePropertyChange("stepLimit", oldValue, stepLimit);
        }

        @PropertyName(value="Max step factor")
        @PropertyDescription(value="Bound for step size growh: newH/oldH <= Max step factor.")
        public double getMaxStepFactor() {
            return this.maxStepFactor;
        }

        public void setMaxStepFactor(double factor) {
            if (factor < 1.0) {
                return;
            }
            double oldValue = this.maxStepFactor;
            this.maxStepFactor = factor;
            this.firePropertyChange("maxStepFactor", oldValue, this.maxStepFactor);
        }

        @PropertyName(value="Min step factor")
        @PropertyDescription(value="Bound for step size growh: newH/oldH >= Min step factor.")
        public double getMinStepFactor() {
            return this.minStepFactor;
        }

        public void setMinStepFactor(double factor) {
            if (factor > 1.0 || factor <= 0.0) {
                return;
            }
            double oldValue = this.minStepFactor;
            this.minStepFactor = factor;
            this.firePropertyChange("minStepFactor", oldValue, this.minStepFactor);
        }

        public ImexOptions() {
            this(0.0, true, "On");
        }

        public ImexOptions(double initialStep, boolean eventLocation, String statisticsMode) {
            this.setInitialStep(initialStep);
            this.setEventLocation(eventLocation);
            this.setStatisticsMode(statisticsMode);
        }
    }
}

