/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode;

import Jama.Matrix;
import biouml.plugins.simulation.ode.Btableau;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.StdMet;

public class Imex1S {
    private int s;
    private double[][] a;
    private double[] b;
    private double[][] ahat;
    private double[] bhat;
    private OdeModel f;
    private int n;
    private double[] uold;
    private double[] unew;
    private double[][] jacobian;
    private double[][] I;
    private double[][] k;
    private double[][] khat;
    private static final double deltaMin = 1.0E-4;
    private static final double deltaY = Math.sqrt(1.0E-4);

    public Imex1S(Btableau butcher) throws Exception {
        this.s = butcher.getbl();
        this.a = new double[butcher.getah()][butcher.getal()];
        this.b = new double[butcher.getbl()];
        this.ahat = new double[butcher.getahath()][butcher.getahatl()];
        this.bhat = new double[butcher.getbhatl()];
        StdMet.copyMatrix(this.a, butcher.get_a());
        StdMet.copyArray(this.b, butcher.get_b());
        StdMet.copyMatrix(this.ahat, butcher.get_ahat());
        StdMet.copyArray(this.bhat, butcher.get_bhat());
    }

    public double[] doOneStep(OdeModel function, double t, double[] u, double h) throws Exception {
        int i;
        this.n = u.length;
        this.f = function;
        this.uold = new double[this.n];
        this.unew = new double[this.n];
        this.jacobian = new double[this.n][this.n];
        this.I = new double[this.n][this.n];
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.I[i2][i2] = 1.0;
        }
        double[] yTemp = new double[this.n];
        double[] ad1 = new double[this.n];
        double[] stam1 = new double[this.n];
        double[] stam2 = new double[this.n];
        double[] as1 = new double[this.n];
        double[] mtam1 = new double[this.n];
        double[] fn = new double[this.n];
        double[] g = new double[this.n];
        double[] temp = new double[this.n];
        double[][] m1 = new double[this.n][this.n];
        double[][] m2 = new double[this.n][1];
        StdMet.copyArray(this.uold, u);
        double[] f1 = this.f.dy_dt(t, this.uold);
        for (i = 0; i < this.n; ++i) {
            double deltaX = deltaY * Math.abs(this.uold[i]);
            if (deltaX < 1.0E-4) {
                deltaX = 1.0E-4;
            }
            StdMet.copyArray(yTemp, this.uold);
            int n = i;
            yTemp[n] = yTemp[n] + deltaX;
            double[] f2 = this.f.dy_dt(t, yTemp);
            StdMet.arrayDiff(ad1, f2, f1);
            StdMet.stam(stam1, 1.0 / deltaX, ad1);
            for (int j = 0; j < this.n; ++j) {
                this.jacobian[j][i] = stam1[j];
            }
        }
        this.k = new double[this.s][this.n];
        this.khat = new double[this.s + 1][this.n];
        f1 = this.f.dy_dt(t, this.uold);
        StdMet.matrixVectorProduct(g, this.jacobian, this.uold);
        StdMet.arrayDiff(fn, f1, g);
        StdMet.copyArray(this.khat[0], fn);
        for (i = 0; i < this.s; ++i) {
            int j;
            StdMet.zeroArray(temp);
            for (j = 0; j < i; ++j) {
                StdMet.stam(stam1, this.a[i][j], this.k[j]);
                StdMet.stam(stam2, this.ahat[i + 1][j], this.khat[j]);
                StdMet.arraySum(as1, stam1, stam2);
                StdMet.arraySum(temp, temp, as1);
            }
            StdMet.stam(stam1, this.ahat[i + 1][i], this.khat[i]);
            StdMet.arraySum(temp, temp, stam1);
            StdMet.stam(temp, h, temp);
            StdMet.arraySum(temp, temp, this.uold);
            for (j = 0; j < this.n; ++j) {
                StdMet.stam(stam1, h * this.a[i][i], this.jacobian[j]);
                StdMet.copyArray(m1[j], stam1);
            }
            for (j = 0; j < this.n; ++j) {
                StdMet.arrayDiff(m1[j], this.I[j], m1[j]);
            }
            StdMet.matrixVectorProduct(mtam1, this.jacobian, temp);
            Matrix A = new Matrix(m1);
            for (int j2 = 0; j2 < this.n; ++j2) {
                m2[j2][0] = mtam1[j2];
            }
            Matrix B = new Matrix(m2);
            Matrix X = A.solve(B);
            double[] a1 = X.getColumnPackedCopy();
            StdMet.copyArray(this.k[i], a1);
            StdMet.stam(stam1, h * this.a[i][i], this.k[i]);
            StdMet.arraySum(temp, temp, stam1);
            f1 = this.f.dy_dt(t, temp);
            StdMet.matrixVectorProduct(g, this.jacobian, temp);
            StdMet.arrayDiff(fn, f1, g);
            StdMet.copyArray(this.khat[i + 1], fn);
        }
        StdMet.zeroArray(temp);
        for (i = 0; i < this.s; ++i) {
            StdMet.stam(stam1, this.b[i], this.k[i]);
            StdMet.stam(stam2, this.bhat[i], this.khat[i]);
            StdMet.arraySum(as1, stam1, stam2);
            StdMet.arraySum(temp, temp, as1);
        }
        StdMet.stam(stam1, this.bhat[this.s], this.khat[this.s]);
        StdMet.arraySum(temp, temp, stam1);
        StdMet.stam(temp, h, temp);
        StdMet.arraySum(this.unew, this.uold, temp);
        return this.unew;
    }
}

