/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode;

import biouml.plugins.simulation.SimulatorSupport;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.StdMet;
import java.util.HashMap;

public class EventDetector {
    private int[] events;
    private SimulatorSupport simulator;
    private OdeModel odeModel;
    private boolean eventDetected;
    private double thetaEvent;
    private double tEvent;
    private double[] xEvent;
    private static final double EVENT_LOCATION_TOLERANCE = 1.0E-10;

    public EventDetector(OdeModel odeModel, SimulatorSupport simulator) {
        this.odeModel = odeModel;
        this.simulator = simulator;
        this.eventDetected = false;
    }

    protected boolean detectEvent(double[] xOld, double tOld, double step) throws Exception {
        this.xEvent = new double[xOld.length];
        this.simulator.integrationStep(this.xEvent, xOld, tOld, step, 1.0);
        double[] eventsOld = this.odeModel.checkEvent(tOld, xOld);
        double[] eventsNew = this.odeModel.checkEvent(tOld + step, this.xEvent);
        this.events = new int[eventsOld.length];
        HashMap<Double, double[]> thetaToX = new HashMap<Double, double[]>();
        this.thetaEvent = 1.1;
        this.eventDetected = false;
        for (int i = 0; i < eventsOld.length; ++i) {
            if (eventsOld[i] != -1.0 || eventsNew[i] != 1.0) continue;
            double theta = this.simpleBisection(i, xOld, tOld, step);
            thetaToX.put(theta, this.xEvent);
            this.eventDetected = true;
            if (theta < this.thetaEvent) {
                for (int j = 0; j < i; ++j) {
                    this.events[j] = 0;
                }
                this.thetaEvent = theta;
            }
            if (!(theta <= this.thetaEvent)) continue;
            this.events[i] = 1;
        }
        if (this.eventDetected) {
            this.tEvent = tOld + step * this.thetaEvent;
            this.xEvent = (double[])thetaToX.get(this.thetaEvent);
        }
        return this.eventDetected;
    }

    public double simpleBisection(int i, double[] xOld, double tOld, double step) throws Exception {
        double thetaA = 0.0;
        double thetaB = 1.0;
        double thetaStarFinal = 1.0;
        double[] xTemp = new double[xOld.length];
        while (Math.abs(thetaB - thetaA) > 1.0E-10) {
            double thetaStar = (thetaB + thetaA) / 2.0;
            this.simulator.integrationStep(xTemp, xOld, tOld, step, thetaStar);
            double event = this.odeModel.checkEvent(tOld + step * thetaStar, xTemp)[i];
            if (event >= 0.0) {
                StdMet.copyArray(this.xEvent, xTemp);
                thetaStarFinal = thetaStar;
                thetaB = thetaStar;
                continue;
            }
            thetaA = thetaStar;
        }
        return thetaStarFinal;
    }

    public double[] getEventX() {
        return this.xEvent;
    }

    public double getTheta() {
        return this.thetaEvent;
    }

    public double getEventTime() {
        return this.tEvent;
    }

    public int[] getEventInfo() {
        return this.events;
    }

    public boolean isEventDetected() {
        return this.eventDetected;
    }
}

