/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode;

import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.OdeSimulatorOptions;
import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.SimulatorInfo;
import biouml.plugins.simulation.SimulatorSupport;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.ode.EventDetector;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.StdMet;
import biouml.standard.simulation.ResultListener;
import com.developmentontheedge.beans.BeanInfoEx;
import java.util.Arrays;
import ru.biosoft.jobcontrol.FunctionJobControl;

public class EulerSimple
extends SimulatorSupport {
    private static final double TIME_STEP_ERROR = 1.0E-9;
    protected ESOptions options = (ESOptions)((Object)this.getDefaultOptions());
    protected int nextSpanIndex = 1;
    protected EventDetector eventDetector;
    protected double tOld;
    protected double t;
    protected double[] xOld;
    protected double[] x;
    protected double tFinal;
    protected int n;
    protected double h;
    protected boolean locateEvent;

    @Override
    public SimulatorInfo getInfo() {
        SimulatorInfo info = new SimulatorInfo();
        info.name = "Euler";
        info.eventsSupport = true;
        return info;
    }

    @Override
    public Object getDefaultOptions() {
        return new ESOptions();
    }

    @Override
    public ESOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Options options) {
        if (!(options instanceof ESOptions)) {
            throw new IllegalArgumentException("Only ESOptions are comaptible with EulerSimple Simulator");
        }
        this.options = (ESOptions)options;
    }

    @Override
    public int[] getEvents() {
        return this.eventDetector != null ? this.eventDetector.getEventInfo() : null;
    }

    @Override
    public void init(Model model, double[] initialValues, Span tspan, ResultListener[] listeners, FunctionJobControl jobControl) throws Exception {
        this.odeModel = (OdeModel)model;
        if (!this.odeModel.isInit()) {
            this.odeModel.init();
        }
        this.resultListeners = listeners;
        if (this.odeModel.hasFastOde() && this.preprocessFastReactions) {
            initialValues = this.preprocessFastReactions();
        }
        this.span = tspan;
        this.t = this.span.getTimeStart();
        this.tFinal = this.span.getTimeFinal();
        this.h = this.options.getInitialStep();
        this.n = initialValues.length;
        this.x = StdMet.copyArray(initialValues);
        this.profile.init(this.x, this.t);
        this.nextSpanIndex = 1;
        this.locateEvent = this.options.getEventLocation();
        this.eventDetector = this.locateEvent ? new EventDetector(this.odeModel, this) : null;
    }

    @Override
    public boolean doStep() throws Exception {
        if (this.fireInitialValues || this.eventAtSpanPoint) {
            this.fireSolutionUpdate(this.t, this.x);
            this.fireInitialValues = false;
            this.eventAtSpanPoint = false;
        }
        if (this.terminated || this.jobControl != null && this.jobControl.getStatus() == 4) {
            return false;
        }
        double nextSpanPoint = this.span.getTime(this.nextSpanIndex);
        while (this.t < nextSpanPoint) {
            this.xOld = StdMet.copyArray(this.x);
            this.tOld = this.t;
            this.h = Math.min(this.h, nextSpanPoint - this.t);
            if (this.locateEvent && this.eventDetector.detectEvent(this.xOld, this.tOld, this.h)) {
                boolean bl = this.eventAtSpanPoint = Math.abs(nextSpanPoint - this.eventDetector.getEventTime()) < 1.0E-9;
                if (!this.eventAtSpanPoint) {
                    this.profile.setTime(this.eventDetector.getEventTime());
                } else {
                    this.profile.setTime(nextSpanPoint);
                }
                this.profile.setStep(this.h * this.eventDetector.getTheta());
                this.profile.setX(this.eventDetector.getEventX());
                this.h = this.options.getInitialStep();
                return false;
            }
            this.integrationStep(this.x, this.xOld, this.t, this.h);
            this.t += this.h;
            if (!this.options.isDetectIncorrectNumbers() || !SimulatorSupport.checkNaNs(this.x)) continue;
            this.profile.setStep(this.h);
            this.profile.setTime(this.t);
            this.profile.setX(this.x);
            this.profile.setUnstable(true);
            return false;
        }
        ++this.nextSpanIndex;
        this.fireSolutionUpdate(this.t, this.x);
        this.profile.setStep(this.h);
        this.profile.setTime(this.t);
        this.profile.setX(this.x);
        this.h = this.options.getInitialStep();
        return this.t < this.tFinal;
    }

    @Override
    public void integrationStep(double[] xNew, double[] xOld, double tOld, double h, double theta) throws Exception {
        this.integrationStep(xNew, xOld, tOld, h * theta);
    }

    public void integrationStep(double[] xNew, double[] xOld, double tOld, double h) throws Exception {
        double[] dydt = this.odeModel.dy_dt(tOld, xOld);
        for (int i = 0; i < this.n; ++i) {
            xNew[i] = xOld[i] + dydt[i] * h;
        }
    }

    @Override
    public void setInitialValues(double[] x0) throws Exception {
        this.odeModel.setCurrentValues(x0);
        this.x = Arrays.copyOf(this.odeModel.getY(), this.odeModel.getY().length);
    }

    public static class ESOptionsBeanInfo
    extends BeanInfoEx {
        public ESOptionsBeanInfo() {
            super(ESOptions.class, true);
        }

        public void initProperties() throws Exception {
            this.add("initialStep");
            this.add("eventLocation");
            this.add("statisticsMode");
            this.add("detectIncorrectNumbers");
        }
    }

    public static class ESOptions
    extends OdeSimulatorOptions {
        public ESOptions() {
            this.setStiffnessDetection(false);
            this.setEventLocation(true);
            this.setStatisticsMode("Off");
            this.setInitialStep(0.001);
        }
    }
}

