/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode;

import biouml.plugins.simulation.ode.StdMet;

public class ErrorEstimator {
    private ErrorEstimator() {
    }

    public static double[] embeddedEstimate(double h, double[] xold, double[] xnew, double[] xe, double[] atol, double[] rtol, double p, double aMax, double aMin, double alpha) throws Exception {
        int n = xold.length;
        double[] tau = new double[n];
        double[] ad1 = new double[n];
        double[] dq1 = new double[n];
        StdMet.tau(tau, xold, xnew, atol, rtol);
        StdMet.arrayDiff(ad1, xnew, xe);
        StdMet.dotQuo(dq1, ad1, tau);
        double epsilon = StdMet.normRMS(dq1);
        double hOpt = h * Math.pow(1.0 / epsilon, 1.0 / p);
        double hNew = Math.min(aMax * h, Math.max(aMin * h, alpha * hOpt));
        double[] estimation = new double[]{epsilon, hNew};
        return estimation;
    }

    public static double[] stepdoublingEstimate(double h, double[] eta1, double[] eta2, double[] xtemp, double atol, double rtol, double p, double aMax, double aMin, double alpha) throws Exception {
        int n = eta1.length;
        double[] diff1 = new double[n];
        double[] err = new double[n];
        double[] eps = new double[n];
        double[] est = new double[n];
        StdMet.arrayDiff(diff1, eta2, eta1);
        StdMet.stam(err, 1.0 / (Math.pow(2.0, p) - 1.0), diff1);
        StdMet.epsilon(eps, xtemp, eta1, atol, rtol);
        StdMet.dotQuo(est, err, eps);
        double norm = StdMet.normRMS(est);
        double hopt = h / Math.pow(Math.pow(2.0, p) * norm, 1.0 / (p + 1.0));
        double hNew = Math.min(aMax * h, Math.max(aMin * h, alpha * 2.0 * hopt));
        double[] estimation = new double[]{hNew, hopt, norm};
        return estimation;
    }
}

