/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode;

import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.OdeSimulatorOptions;
import biouml.plugins.simulation.OdeSimulatorOptionsBeanInfo;
import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.SimulatorInfo;
import biouml.plugins.simulation.SimulatorSupport;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.ode.Btableau;
import biouml.plugins.simulation.ode.ErrorEstimator;
import biouml.plugins.simulation.ode.EventDetector;
import biouml.plugins.simulation.ode.Initsss;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.StdMet;
import biouml.plugins.simulation.ode.StiffnessDetector;
import biouml.standard.simulation.ResultListener;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.util.logging.Level;
import ru.biosoft.jobcontrol.FunctionJobControl;

public class DormandPrince
extends SimulatorSupport {
    private static final double P = 5.0;
    private static final double ALPHA = 0.9;
    private static final int MAXFCN = 50000;
    private static final int NSUCCESS = 50;
    private static final int NFAILED = 10;
    private static final int K1 = 5;
    private static final int K2 = 6;
    private static final double BOUND = 3.25;
    private double t0;
    private double tFinal;
    private double tfBackup;
    private double[] x0;
    private Btableau butcher;
    private int s;
    private double[][] a;
    private double[] b;
    private double[] bhat;
    private double[] c;
    private boolean FSALenabled;
    private double[] atol;
    private double[] rtol;
    private static final double MINVALUE = 1.0E-16;
    private int n;
    private double tNew;
    private double tOld;
    private double[] xOld;
    private double[] xNew;
    private double[] xe;
    private double[][] K;
    private double[] g1;
    private double[] g2;
    private double[] as;
    private double epsilon;
    private double h;
    private double hNew;
    private double minStepFactor;
    private double maxStepFactor;
    private int nreject;
    private int naccept;
    private double avgStepSize;
    private boolean firstStep;
    private boolean justAccepted;
    private int spanLength;
    private boolean interpolate;
    private boolean detectSiffness;
    private int fevalTotal;
    private double tFirst;
    private int nsuccess;
    private int nfailed;
    private int checks1;
    private int checks2;
    private boolean eventOccured;
    private boolean precizeEvent;
    private EventDetector eventDetector;
    DPOptions options = (DPOptions)((Object)this.getDefaultOptions());
    private int nextSpanPointIndex;
    private boolean troubleFlag;

    @Override
    public SimulatorInfo getInfo() {
        SimulatorInfo info = new SimulatorInfo();
        info.name = "DormandPrince";
        info.eventsSupport = true;
        return info;
    }

    @Override
    public Object getDefaultOptions() {
        return new DPOptions(0.0, true, true, "Off");
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Options options) {
        if (!(options instanceof DPOptions)) {
            throw new IllegalArgumentException("Only DPOptions options are compatible with DormandPrince simulator");
        }
        this.options = (DPOptions)options;
    }

    @Override
    public boolean doStep() {
        try {
            this.init(this.odeModel, this.x0, this.span, this.resultListeners, this.jobControl);
            this.routine();
            return !this.troubleFlag && !(this.tNew >= this.tFinal);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
            this.profile.setUnstable(true);
            return false;
        }
    }

    @Override
    public void init(Model model, double[] x0, Span tspan, ResultListener[] listeners, FunctionJobControl jobControl) throws Exception {
        if (this.options.getAtol() <= 0.0) {
            throw new Exception("Absolute tolerance must be greater than zero");
        }
        if (this.options.getRtol() <= 0.0) {
            throw new Exception("Relative tolerance must be greater than zero");
        }
        if (!tspan.isProper()) {
            throw new Exception("Improper span: times are out of order");
        }
        if (!model.isInit()) {
            model.init();
        }
        this.odeModel = (OdeModel)model;
        if (this.odeModel.hasFastOde() && this.preprocessFastReactions) {
            x0 = this.preprocessFastReactions();
        }
        this.x0 = StdMet.copyArray(x0);
        this.n = x0.length;
        this.atol = StdMet.generateArray(this.options.getAtol(), this.n);
        this.rtol = StdMet.generateArray(this.options.getRtol(), this.n);
        this.span = tspan;
        this.spanLength = this.span.getLength();
        this.nextSpanPointIndex = 1;
        this.tNew = this.t0 = this.span.getTimeStart();
        this.tfBackup = this.tFinal = this.span.getTimeFinal();
        this.jobControl = jobControl;
        this.profile.init(x0, this.t0);
        this.butcher = new Btableau("dopr54");
        this.a = StdMet.copyMatrix(this.butcher.get_a());
        this.b = StdMet.copyArray(this.butcher.get_b());
        this.bhat = StdMet.copyArray(this.butcher.get_bEmb());
        this.c = StdMet.copyArray(this.butcher.get_c());
        this.s = this.butcher.getbl();
        this.h = this.options.getInitialStep();
        if (this.h <= 0.0) {
            this.h = new Initsss(this.odeModel, this.span, x0, this.atol, this.rtol).get_h();
        }
        this.interpolate = this.spanLength != 0;
        this.detectSiffness = this.options.getStiffnessDetection();
        this.fevalTotal = 0;
        this.precizeEvent = this.options.getPresizeEvents();
        this.locateEvents = this.options.getEventLocation();
        this.eventOccured = false;
        if (this.locateEvents) {
            this.eventDetector = new EventDetector(this.odeModel, this);
        }
        this.statisticsMode = this.options.getStatisticsMode();
        this.minStepFactor = this.options.getMinStepFactor();
        this.maxStepFactor = this.options.getMaxStepFactor();
        this.resultListeners = listeners;
        this.troubleFlag = false;
    }

    public void routine() throws Exception {
        if (this.fireInitialValues || this.eventAtSpanPoint) {
            this.fireSolutionUpdate(this.t0, this.x0);
            this.fireInitialValues = false;
            this.eventAtSpanPoint = false;
        }
        this.tOld = this.t0;
        this.xOld = StdMet.copyArray(this.x0);
        this.xNew = new double[this.n];
        this.xe = new double[this.n];
        this.K = new double[this.s][this.n];
        this.nreject = 0;
        this.naccept = 0;
        this.firstStep = true;
        this.tFirst = this.tOld;
        this.as = new double[this.n];
        this.g1 = new double[this.n];
        this.g2 = new double[this.n];
        while (this.tNew < this.tFinal) {
            if (this.terminated || this.jobControl != null && this.jobControl.getStatus() == 4) {
                return;
            }
            if (this.locateEvents) {
                this.eventDetector.detectEvent(this.xOld, this.tOld, this.h);
                this.eventOccured = this.eventDetector.isEventDetected();
                if (this.eventOccured) {
                    this.h *= this.eventDetector.getTheta();
                    if (this.precizeEvent) {
                        this.xNew = this.eventDetector.getEventX();
                    } else {
                        this.integrationStep(this.xNew, this.xOld, this.h, this.b);
                    }
                    this.tfBackup = this.tFinal;
                    this.tFinal = this.tOld + this.h;
                    this.outStatistics("Event detected at t = " + this.tNew);
                }
            }
            if (!this.eventOccured) {
                this.integrationStep(this.xNew, this.xOld, this.h, this.b);
            }
            this.firstStep = false;
            this.justAccepted = false;
            this.tNew = this.tOld + this.h;
            boolean success = this.checkError();
            if (this.troubleFlag) {
                return;
            }
            if (this.eventOccured) {
                if (success) {
                    this.outputSolution();
                    break;
                }
                ++this.nreject;
                ++this.nfailed;
                this.h /= 2.0;
                this.tFinal = this.tfBackup;
                this.outStatistics("Step rejected.", "New h = " + this.h);
                continue;
            }
            this.fevalTotal += this.s;
            this.checkStiffness1();
            if (this.troubleFlag) {
                return;
            }
            if (success) {
                this.outputSolution();
                this.tOld = this.tNew;
                this.xOld = StdMet.copyArray(this.xNew);
                if (this.nsuccess == 0) {
                    this.tFirst = this.tOld;
                }
                this.h = this.hNew;
                this.maxStepFactor = this.options.getMaxStepFactor();
                ++this.naccept;
                ++this.nsuccess;
                this.justAccepted = true;
                this.outStatistics("Step accepted, new h=" + this.h, "Solution = " + StdMet.toString(this.xOld), "t = " + this.tOld);
                continue;
            }
            this.h = this.hNew;
            this.maxStepFactor = 1.0;
            ++this.nreject;
            ++this.nfailed;
            this.outStatistics("Step rejected", "New h = " + this.h);
            this.checkStiffness2();
            if (!this.troubleFlag) continue;
            return;
        }
        this.profile.setStep(this.avgStepSize);
        this.profile.setTime(this.tNew);
        this.profile.setX(this.xNew);
    }

    protected void calculateK(double h, double[] as1, double[] g1, double[] g2) throws Exception {
        double[] sigma = new double[this.n];
        double[] stam = new double[this.n];
        for (int i = 0; i < this.s; ++i) {
            for (int j = 0; j < i; ++j) {
                StdMet.stam(stam, this.a[i][j], this.K[j]);
                StdMet.arraySum(sigma, sigma, stam);
            }
            if (i != 0 || this.firstStep || !this.FSALenabled) {
                StdMet.copyArray(g1, as1);
                StdMet.stam(stam, h, sigma);
                StdMet.arraySum(as1, this.xOld, stam);
                this.K[i] = this.odeModel.dy_dt(this.tOld + h * this.c[i], as1);
                StdMet.zeroArray(sigma);
                StdMet.copyArray(g2, as1);
                continue;
            }
            if (!this.justAccepted) continue;
            StdMet.copyArray(this.K[0], this.K[this.s - 1]);
        }
    }

    protected void calculateNewX(double[] xNew, double[] xOld, double h, double[] b) throws Exception {
        double[] sigma = new double[this.n];
        double[] stam = new double[this.n];
        for (int i = 0; i < this.s; ++i) {
            StdMet.stam(stam, h * b[i], this.K[i]);
            StdMet.arraySum(sigma, sigma, stam);
        }
        StdMet.arraySum(xNew, xOld, sigma);
    }

    protected double[] integrationStep(double[] xNew, double[] xOld, double h, double[] b) throws Exception {
        this.calculateK(h, this.as, this.g1, this.g2);
        this.calculateNewX(xNew, xOld, h, b);
        return xNew;
    }

    @Override
    public void integrationStep(double[] xNew, double[] xOld, double tOld, double h, double theta) throws Exception {
        if (this.precizeEvent) {
            this.integrationStep(xNew, xOld, h * theta, this.b);
        } else {
            this.calculateNewX(xNew, xOld, h, this.butcher.get_btheta().f(theta));
        }
    }

    protected void outputSolution() throws Exception {
        if (!this.interpolate) {
            this.fireSolutionUpdate(this.tNew, this.xNew);
            return;
        }
        double nextSpanPoint = this.span.getTime(this.nextSpanPointIndex);
        while (this.nextSpanPointIndex < this.span.getLength() && nextSpanPoint < this.tNew) {
            this.fireSolutionUpdate(nextSpanPoint, this.getSolution(nextSpanPoint));
            ++this.nextSpanPointIndex;
            if (this.nextSpanPointIndex >= this.span.getLength()) break;
            nextSpanPoint = this.span.getTime(this.nextSpanPointIndex);
        }
        if (nextSpanPoint == this.tNew) {
            if (this.eventOccured) {
                this.eventAtSpanPoint = true;
            } else {
                this.fireSolutionUpdate(nextSpanPoint, this.getSolution(nextSpanPoint));
                ++this.nextSpanPointIndex;
            }
        }
    }

    protected double[] getSolution(double time) throws Exception {
        double[] x = new double[this.n];
        double theta = (time - this.tOld) / this.h;
        this.calculateNewX(x, this.xOld, this.h, this.butcher.get_btheta().f(theta));
        return x;
    }

    private boolean checkError() throws Exception {
        this.integrationStep(this.xe, this.xOld, this.h, this.bhat);
        double[] estimation = ErrorEstimator.embeddedEstimate(this.h, this.xOld, this.xNew, this.xe, this.atol, this.rtol, 5.0, this.maxStepFactor, this.minStepFactor, 0.9);
        this.epsilon = estimation[0];
        this.hNew = estimation[1];
        if (1.1 * this.hNew >= this.tFinal - this.tNew && this.epsilon <= 1.0) {
            this.hNew = this.tFinal - this.tNew;
        }
        if (Double.isNaN(this.epsilon)) {
            this.setUnstable("Error estimation failed");
        }
        return this.epsilon <= 1.0;
    }

    private void checkStiffness1() throws Exception {
        if (this.fevalTotal > 50000 && this.detectSiffness) {
            ++this.checks1;
            if (this.hNew < 1.0E-16) {
                this.setStiff("Problem is stiff due to the minimum value of step = " + this.h);
            }
            double hRho = StiffnessDetector.calc_hRho(this.h, this.K[6], this.K[5], this.g2, this.g1);
            this.outStatistics("a check due to MAXFCN was done.", "h*rho = " + hRho);
            if (hRho > 3.25 || Double.isNaN(hRho)) {
                this.setStiff("Problem is stiff due to maximum ode right side calls at t = " + this.tOld);
            }
            this.fevalTotal = 0;
        }
    }

    private void checkStiffness2() throws Exception {
        if (this.nfailed >= 10 && this.detectSiffness) {
            if (this.nsuccess <= 50) {
                this.avgStepSize = (this.tOld - this.tFirst) / (double)this.nsuccess;
                if (this.avgStepSize == 0.0) {
                    this.avgStepSize = this.h;
                }
                if (this.h <= this.minStepFactor * this.avgStepSize && this.h >= this.avgStepSize / this.maxStepFactor && (double)this.fevalTotal > 50000.0 * (this.tOld - this.t0) / (this.tFinal - this.t0)) {
                    ++this.checks2;
                    double hRho = StiffnessDetector.calc_hRho(this.h, this.K[6], this.K[5], this.g2, this.g1);
                    this.outStatistics("A check due to ratio was done", "h*rho = " + hRho);
                    if (hRho > 3.25 || Double.isNaN(hRho)) {
                        this.setStiff("Problem is stiff due to ratio at t = " + this.tOld);
                        this.outStatistics("Solution at this time:", StdMet.toString(this.xOld), "# of checks due to MAXFCN: " + this.checks1, "# of checks due to MAXFCN: " + this.checks1, "accepted: " + this.naccept, "rejected: " + this.nreject);
                        return;
                    }
                }
            }
            this.nsuccess = 0;
            this.nfailed = 0;
        }
    }

    private void setStiff(String message) {
        this.outError(message);
        this.troubleFlag = true;
        this.profile.setStiff(true);
        if (this.jobControl != null) {
            this.jobControl.terminate();
        }
    }

    private void setUnstable(String message) {
        this.outError(message);
        this.troubleFlag = true;
        this.profile.setUnstable(true);
        if (this.jobControl != null) {
            this.jobControl.terminate();
        }
    }

    @Override
    public int[] getEvents() {
        return this.eventDetector != null ? this.eventDetector.getEventInfo() : null;
    }

    @Override
    public void setInitialValues(double[] x0) {
        try {
            this.odeModel.setCurrentValues(x0);
            StdMet.copyArray(this.x0, this.odeModel.getY());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class DPOptionsBeanInfo
    extends OdeSimulatorOptionsBeanInfo {
        public DPOptionsBeanInfo() {
            super(DPOptions.class);
        }

        @Override
        public void initProperties() throws Exception {
            super.initProperties();
            this.add("initialStep");
            this.add("maxStepFactor");
            this.add("minStepFactor");
            this.add("eventLocation");
            this.add("presizeEvents");
            this.add("stiffnessDetection");
        }
    }

    public static class DPOptions
    extends OdeSimulatorOptions {
        private double maxStepFactor = 5.0;
        private double minStepFactor = 0.2;
        private boolean presizeEvents = false;

        @PropertyName(value="Presize event location")
        @PropertyDescription(value="Slower but more safe for models with many events.")
        public boolean getPresizeEvents() {
            return this.presizeEvents;
        }

        public void setPresizeEvents(boolean presizeEvents) {
            boolean oldValue = this.presizeEvents;
            this.presizeEvents = presizeEvents;
            this.firePropertyChange("presizeEvents", oldValue, presizeEvents);
        }

        @PropertyName(value="Max step factor")
        @PropertyDescription(value="Bound for step size growh: newH/oldH <= Max step factor.")
        public double getMaxStepFactor() {
            return this.maxStepFactor;
        }

        public void setMaxStepFactor(double factor) {
            if (factor < 1.0) {
                return;
            }
            double oldValue = this.maxStepFactor;
            this.maxStepFactor = factor;
            this.firePropertyChange("maxStepFactor", oldValue, factor);
        }

        @PropertyName(value="Min step factor")
        @PropertyDescription(value="Bound for step size growh: newH/oldH >= Min step factor.")
        public double getMinStepFactor() {
            return this.minStepFactor;
        }

        public void setMinStepFactor(double factor) {
            if (factor > 1.0 || factor <= 0.0) {
                return;
            }
            double oldValue = this.minStepFactor;
            this.minStepFactor = factor;
            this.firePropertyChange("minStepFactor", oldValue, factor);
        }

        public DPOptions() {
            this(0.0, true, true, "Off");
        }

        public DPOptions(double initialStep, boolean stiffnessDetection, boolean eventLocation, String statisticsMode) {
            this.setInitialStep(initialStep);
            this.setStiffnessDetection(stiffnessDetection);
            this.setEventLocation(eventLocation);
            this.setStatisticsMode(statisticsMode);
        }
    }
}

