/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.simulation.ode;

import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.Options;
import biouml.plugins.simulation.SimulatorInfo;
import biouml.plugins.simulation.SimulatorSupport;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.ode.OdeModel;
import biouml.plugins.simulation.ode.StdMet;
import biouml.standard.simulation.ResultListener;
import com.developmentontheedge.beans.BeanInfoEx;
import java.util.Arrays;
import ru.biosoft.jobcontrol.FunctionJobControl;

public class DiscreteSimulator
extends SimulatorSupport {
    private DiscreteOptions options = (DiscreteOptions)((Object)this.getDefaultOptions());
    private int nextSpanIndex = 1;
    private double t;
    private double tFinal;
    private int[] events;
    private double[] x = new double[0];
    private boolean eventFired = false;
    private double[] eventsBeforeStep;

    @Override
    public SimulatorInfo getInfo() {
        SimulatorInfo info = new SimulatorInfo();
        info.name = "Discrete";
        info.eventsSupport = true;
        return info;
    }

    @Override
    public Object getDefaultOptions() {
        return new DiscreteOptions();
    }

    @Override
    public DiscreteOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Options options) {
        if (!(options instanceof DiscreteOptions)) {
            throw new IllegalArgumentException("Only ESOptions are comaptible with EulerSimple Simulator");
        }
        this.options = (DiscreteOptions)options;
    }

    @Override
    public int[] getEvents() {
        return this.events;
    }

    @Override
    public void init(Model model, double[] initialValues, Span tspan, ResultListener[] listeners, FunctionJobControl jobControl) throws Exception {
        this.odeModel = (OdeModel)model;
        if (!this.odeModel.isInit()) {
            this.odeModel.init();
        }
        this.resultListeners = listeners;
        this.span = tspan;
        this.t = this.span.getTimeStart();
        this.tFinal = this.span.getTimeFinal();
        this.x = StdMet.copyArray(initialValues);
        this.profile.init(this.x, this.t);
        this.nextSpanIndex = 1;
        this.eventsBeforeStep = this.odeModel.checkEvent(this.t, this.x);
        this.events = new int[this.eventsBeforeStep.length];
    }

    @Override
    public boolean doStep() throws Exception {
        if (this.terminated || this.jobControl != null && this.jobControl.getStatus() == 4) {
            return false;
        }
        if (this.eventFired) {
            this.fireSolutionUpdate(this.t, new double[0]);
        }
        this.eventFired = false;
        double nextSpanPoint = this.span.getTime(this.nextSpanIndex);
        ++this.nextSpanIndex;
        this.t = nextSpanPoint;
        double[] eventsNew = this.odeModel.checkEvent(this.t, this.x);
        for (int i = 0; i < this.eventsBeforeStep.length; ++i) {
            if (eventsNew[i] > this.eventsBeforeStep[i]) {
                this.events[i] = 1;
                this.eventFired = true;
                continue;
            }
            this.events[i] = -1;
        }
        this.eventsBeforeStep = eventsNew;
        if (this.eventFired) {
            return false;
        }
        this.fireSolutionUpdate(this.t, new double[0]);
        this.profile.setTime(this.t);
        return this.t < this.tFinal;
    }

    @Override
    public void setInitialValues(double[] x0) throws Exception {
        this.odeModel.setCurrentValues(x0);
        this.x = Arrays.copyOf(this.odeModel.getY(), this.odeModel.getY().length);
    }

    public static class DiscreteOptionsBeanInfo
    extends BeanInfoEx {
        public DiscreteOptionsBeanInfo() {
            super(DiscreteOptions.class, true);
        }

        public void initProperties() throws Exception {
        }
    }

    public static class DiscreteOptions
    extends Options {
    }
}

